# US Realm Person Name (PN.US.FIELDED) - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Realm Person Name (PN.US.FIELDED)**

## Logical Model: US Realm Person Name (PN.US.FIELDED) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:USRealmPersonNamePNUSFIELDED |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.5.1.1 | |

 
The US Realm Clinical Document Person Name datatype flavor is a set of reusable constraints that can be used for Persons. 

**Usages:**

* Use this Logical Model Profile: [Advance Directive Observation](StructureDefinition-AdvanceDirectiveObservation.md), [Care Plan](StructureDefinition-CarePlan.md), [Care Team Member Act](StructureDefinition-CareTeamMemberAct.md), [Drug Monitoring Act](StructureDefinition-DrugMonitoringAct.md)...Show 5 more,[Note Activity](StructureDefinition-NoteActivity.md),[Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md),[Referral Note](StructureDefinition-ReferralNote.md),[Related Person Relationship and Name Participant](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.md)and[US Realm Header](StructureDefinition-USRealmHeader.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/USRealmPersonNamePNUSFIELDED)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-USRealmPersonNamePNUSFIELDED.csv), [Excel](StructureDefinition-USRealmPersonNamePNUSFIELDED.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "USRealmPersonNamePNUSFIELDED",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "name"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.5.1.1"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "USRealmPersonNamePNUSFIELDED",
  "title" : "US Realm Person Name (PN.US.FIELDED)",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The US Realm Clinical Document Person Name datatype flavor is a set of reusable constraints that can be used for Persons.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PN",
        "path" : "PN",
        "constraint" : [
          {
            "key" : "81-9371",
            "severity" : "error",
            "human" : "The content of name **SHALL** be either a conformant Patient Name (PTN.US.FIELDED), or a string (CONF:81-9371).",
            "expression" : "conformsTo('http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPatientNamePTNUSFIELDED') or item.xmlText.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
          },
          {
            "key" : "81-9372",
            "severity" : "error",
            "human" : "The string **SHALL NOT** contain name parts (CONF:81-9372).",
            "expression" : "item.xmlText.exists() implies (item.delimiter | item.family | item.given | item.prefix | item.suffix).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
          }
        ]
      }
    ]
  }
}

```
