# US Realm Header - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Realm Header**

## Logical Model: US Realm Header 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:USRealmHeader |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.1.1:2024-05-01 | |

 
This template defines constraints that represent common administrative and demographic concepts for US Realm CDA documents. Further specification, such as ClinicalDocument/code, are provided in document templates that conform to this template. 
In all C-CDA documents, at least one section SHALL contain clinically relevant information. A document that contains only empty sections is unhelpful to providers and fails to meet the essential purpose of conveying meaningful clinical data. Such documents contribute to inefficiencies and frustration in the healthcare process, as they do not provide the necessary information for informed decision-making. 

**Usages:**

* Derived from this Logical Model Profile: [Care Plan](StructureDefinition-CarePlan.md), [Consultation Note](StructureDefinition-ConsultationNote.md), [Continuity of Care Document (CCD)](StructureDefinition-ContinuityofCareDocumentCCD.md), [Discharge Summary](StructureDefinition-DischargeSummary.md)...Show 8 more,[History and Physical](StructureDefinition-HistoryandPhysical.md),[Operative Note](StructureDefinition-OperativeNote.md),[Procedure Note](StructureDefinition-ProcedureNote.md),[Progress Note](StructureDefinition-ProgressNote.md),[Referral Note](StructureDefinition-ReferralNote.md),[Transfer Summary](StructureDefinition-TransferSummary.md),[US Realm Header for Patient Generated Document](StructureDefinition-USRealmHeaderforPatientGeneratedDocument.md)and[Unstructured Document](StructureDefinition-UnstructuredDocument.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/USRealmHeader)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-USRealmHeader.csv), [Excel](StructureDefinition-USRealmHeader.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "USRealmHeader",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.1.1:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "USRealmHeader",
  "title" : "US Realm Header",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template defines constraints that represent common administrative and demographic concepts for US Realm CDA documents. Further specification, such as ClinicalDocument/code, are provided in document templates that conform to this template.\n\nIn all C-CDA documents, at least one section SHALL contain clinically relevant information. A document that contains only empty sections is unhelpful to providers and fails to meet the essential purpose of conveying meaningful clinical data. Such documents contribute to inefficiencies and frustration in the healthcare process, as they do not provide the necessary information for informed decision-making.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "constraint" : [
          {
            "key" : "4537-6380",
            "severity" : "error",
            "human" : "If setId is present versionNumber **SHALL** be present (CONF:4537-6380).",
            "expression" : "setId.exists() implies versionNumber.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "4537-6387",
            "severity" : "error",
            "human" : "If versionNumber is present setId **SHALL** be present (CONF:4537-6387).",
            "expression" : "versionNumber.exists() implies setId.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "should-legalAuthenticator",
            "severity" : "warning",
            "human" : "SHOULD contain legalAuthenticator",
            "expression" : "legalAuthenticator.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "should-relatedParticipant",
            "severity" : "warning",
            "human" : "Documents SHOULD contain a RelatedPerson participant",
            "expression" : "participant.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/RelatedPersonRelationshipAndNameParticipant').exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.realmCode",
        "path" : "ClinicalDocument.realmCode",
        "comment" : "SHALL contain exactly one [1..1] realmCode=\"US\" (CONF:4537-16791).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.realmCode.code",
        "path" : "ClinicalDocument.realmCode.code",
        "min" : 1,
        "patternCode" : "US"
      },
      {
        "id" : "ClinicalDocument.typeId",
        "path" : "ClinicalDocument.typeId",
        "comment" : "SHALL contain exactly one [1..1] typeId (CONF:4537-5361).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.typeId.root",
        "path" : "ClinicalDocument.typeId.root",
        "comment" : "This typeId SHALL contain exactly one [1..1] @root=\"2.16.840.1.113883.1.3\" (CONF:4537-5250)."
      },
      {
        "id" : "ClinicalDocument.typeId.extension",
        "path" : "ClinicalDocument.typeId.extension",
        "comment" : "This typeId SHALL contain exactly one [1..1] @extension=\"POCD_HD000040\" (CONF:4537-5251)."
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.templateId:us-realm",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "us-realm",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:us-realm.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.1"
      },
      {
        "id" : "ClinicalDocument.templateId:us-realm.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.id",
        "path" : "ClinicalDocument.id",
        "short" : "**SHALL** be a globally unique identifier for the document (CONF:4537-9991).",
        "comment" : "SHALL contain exactly one [1..1] id (CONF:4537-5363)."
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "short" : "**SHALL** specify the particular kind of document (e.g., History and Physical, Discharge Summary, Progress Note) (CONF:4537-9992).",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:4537-5253)."
      },
      {
        "id" : "ClinicalDocument.code.nullFlavor",
        "path" : "ClinicalDocument.code.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "ClinicalDocument.code.code",
        "path" : "ClinicalDocument.code.code",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.code.codeSystem",
        "path" : "ClinicalDocument.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "ClinicalDocument.title",
        "path" : "ClinicalDocument.title",
        "short" : "The title can either be a locally defined name or the displayName corresponding to clinicalDocument/code",
        "comment" : "SHALL contain exactly one [1..1] title (CONF:4537-5254).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.effectiveTime",
        "path" : "ClinicalDocument.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] US Realm Date and Time (Point in Time) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.4) (CONF:4537-5256).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/TS",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTime"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.confidentialityCode.nullFlavor",
        "path" : "ClinicalDocument.confidentialityCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "ClinicalDocument.confidentialityCode.code",
        "path" : "ClinicalDocument.confidentialityCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.16926"
        }
      },
      {
        "id" : "ClinicalDocument.languageCode",
        "path" : "ClinicalDocument.languageCode",
        "comment" : "SHALL contain exactly one [1..1] languageCode, which SHALL be selected from ValueSet AllLanguages https://www.hl7.org/fhir/valueset-all-languages.html (OID 2.16.840.1.113883.4.642.3.21) DYNAMIC.",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.setId",
        "path" : "ClinicalDocument.setId",
        "comment" : "MAY contain zero or one [0..1] setId (CONF:4537-5261).",
        "condition" : ["4537-6380", "4537-6387"]
      },
      {
        "id" : "ClinicalDocument.versionNumber",
        "path" : "ClinicalDocument.versionNumber",
        "comment" : "MAY contain zero or one [0..1] versionNumber (CONF:4537-5264).",
        "condition" : ["4537-6380", "4537-6387"]
      },
      {
        "id" : "ClinicalDocument.recordTarget",
        "path" : "ClinicalDocument.recordTarget",
        "short" : "The recordTarget records the administrative and demographic data of the patient whose health information is described by the clinical document; each recordTarget must contain at least one patientRole element",
        "comment" : "SHALL contain at least one [1..*] recordTarget (CONF:4537-5266)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole",
        "path" : "ClinicalDocument.recordTarget.patientRole",
        "comment" : "Such recordTargets SHALL contain exactly one [1..1] patientRole (CONF:4537-5267)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.id",
        "path" : "ClinicalDocument.recordTarget.patientRole.id",
        "comment" : "This patientRole SHALL contain at least one [1..*] id (CONF:4537-5268)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.addr",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClinicalDocument.recordTarget.patientRole.addr",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Address",
        "comment" : "This patientRole SHALL contain at least one [1..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-5271).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.telecom",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClinicalDocument.recordTarget.patientRole.telecom",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Phone Number / Email",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.telecom.use",
        "path" : "ClinicalDocument.recordTarget.patientRole.telecom.use",
        "comment" : "Such telecoms SHOULD contain zero or one [0..1] @use, which SHALL be selected from ValueSet Telecom Use (US Realm Header) urn:oid:2.16.840.1.113883.11.20.9.20 DYNAMIC (CONF:4537-5375).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.20"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient",
        "comment" : "This patientRole SHALL contain exactly one [1..1] patient (CONF:4537-5283).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "4537-32993",
            "severity" : "error",
            "human" : "If sdtc:deceasedInd=\"true\", then sdtc:deceasedTime **SHALL** be present with either a @value or @nullFlavor=UNK (CONF:4537-32993).",
            "expression" : "sdtcDeceasedInd.exists(value='true') implies sdtcDeceasedTime.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "4537-21000",
            "severity" : "error",
            "human" : "If sdtc:deceasedTime/@value is present, then sdtc:deceasedInd SHALL be present with value=true",
            "expression" : "sdtcDeceasedTime.value.exists() implies sdtcDeceasedInd.exists(value='true')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "should-maritalStatusCode",
            "severity" : "warning",
            "human" : "SHOULD contain maritalStatusCode",
            "expression" : "maritalStatusCode.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "should-us-languageCommunication",
            "severity" : "warning",
            "human" : "SHOULD contain languageCommunication",
            "expression" : "languageCommunication.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.name",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.name",
        "comment" : "This patient SHALL contain at least one [1..*] US Realm Patient Name (PTN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1) (CONF:4537-5284).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPatientNamePTNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.birthTime",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.birthTime",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Date of Birth - **MAY** be precise to the minute (CONF:4537-32418) (For cases where information about newborn's time of birth needs to be captured)",
        "comment" : "This patient SHALL contain exactly one [1..1] birthTime (CONF:4537-5298).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ts-shall-year",
            "severity" : "error",
            "human" : "**SHALL** be precise to at least the year",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 4",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "ts-should-day",
            "severity" : "warning",
            "human" : "**SHOULD** be precise to at least the day",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 10",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcDeceasedInd",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcDeceasedInd",
        "short" : "sdtc:deceasedInd",
        "comment" : "This patient MAY contain zero or one [0..1] sdtc:deceasedInd (CONF:4537-32990)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcDeceasedTime",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
            "valueUri" : "urn:hl7-org:sdtc"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
            "valueString" : "deceasedTime"
          },
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcDeceasedTime",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Date of Death",
        "comment" : "This patient MAY contain zero or one [0..1] sdtc:deceasedTime (CONF:4537-32988).",
        "constraint" : [
          {
            "key" : "should-value-att",
            "severity" : "warning",
            "human" : "SHOULD contain @value",
            "expression" : "value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "ts-shall-year",
            "severity" : "error",
            "human" : "**SHALL** be precise to at least the year",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 4",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "ts-should-day",
            "severity" : "warning",
            "human" : "**SHOULD** be precise to at least the day",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 10",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.maritalStatusCode",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.maritalStatusCode",
        "short" : "SHOULD contain maritalStatusCode",
        "comment" : "This patient SHOULD contain zero or one [0..1] maritalStatusCode, which SHALL be selected from ValueSet Marital Status urn:oid:2.16.840.1.113883.1.11.12212 DYNAMIC (CONF:4537-5303).",
        "condition" : ["should-maritalStatusCode"],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.12212"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.religiousAffiliationCode",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.religiousAffiliationCode",
        "comment" : "This patient MAY contain zero or one [0..1] religiousAffiliationCode, which SHALL be selected from ValueSet Religious Affiliation urn:oid:2.16.840.1.113883.1.11.19185 DYNAMIC (CONF:4537-5317).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.19185"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.raceCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.raceCode",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Race - raceCode SHALL contain only the OMB race category; detailed race values go in translation. Additional race categories are conveyed using sdtc:raceCode, following the same pattern (OMB category in root; details in translation).",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.4.642.2.575"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.raceCode.translation",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.raceCode.translation",
        "constraint" : [
          {
            "key" : "race-not-category",
            "severity" : "error",
            "human" : "Translation SHALL NOT be used to convey additional race categories. Multiple categories must be conveyed in multiple raceCode elements.",
            "expression" : "(code in ('1002-5' | '2028-9' | '2054-5' | '2076-8' | '2106-3' | '2131-1')).not()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.14914"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcRaceCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
            "valueUri" : "urn:hl7-org:sdtc"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
            "valueString" : "raceCode"
          },
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcRaceCode",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Race - The sdtc:raceCode is only used to record additional values when the patient has indicated multiple races or additional race detail beyond the five categories required for Meaningful Use Stage 2. The prefix sdtc: SHALL be bound to the namespace “urn:hl7-org:sdtc”. The use of the namespace provides a necessary extension to CDA R2 for the use of the additional raceCode elements.",
        "constraint" : [
          {
            "key" : "sdtc-race-not-detail",
            "severity" : "error",
            "human" : "When using translation to convey race details, the base code SHALL be a race category.",
            "expression" : "translation.exists(codeSystem = '2.16.840.1.113883.6.238') implies (code in ('1002-5' | '2028-9' | '2054-5' | '2076-8' | '2106-3' | '2131-1'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.25"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcRaceCode.translation",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcRaceCode.translation",
        "constraint" : [
          {
            "key" : "race-not-category",
            "severity" : "error",
            "human" : "Translation SHALL NOT be used to convey additional race categories. Multiple categories must be conveyed in multiple raceCode elements.",
            "expression" : "(code in ('1002-5' | '2028-9' | '2054-5' | '2076-8' | '2106-3' | '2131-1')).not()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.14914"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.ethnicGroupCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.ethnicGroupCode",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Ethnicity",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.4.642.40.2.48.3"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcEthnicGroupCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
            "valueUri" : "urn:hl7-org:sdtc"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
            "valueString" : "ethnicGroupCode"
          },
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.sdtcEthnicGroupCode",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Ethnicity",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.4.642.40.2.48.1"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian",
        "comment" : "This patient MAY contain zero or more [0..*] guardian (CONF:4537-5325).",
        "constraint" : [
          {
            "key" : "should-us-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "should-us-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "should-us-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.code",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.code",
        "comment" : "The guardian, if present, SHOULD contain zero or one [0..1] code, which SHALL be selected from ValueSet Personal And Legal Relationship Role Type urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:4537-5326).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.addr",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.addr",
        "comment" : "The guardian, if present, SHOULD contain zero or more [0..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-5359).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.telecom",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.telecom",
        "comment" : "The guardian, if present, SHOULD contain zero or more [0..*] telecom (CONF:4537-5382).",
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.telecom.use",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.telecom.use",
        "comment" : "The telecom, if present, SHOULD contain zero or one [0..1] @use, which SHALL be selected from ValueSet Telecom Use (US Realm Header) urn:oid:2.16.840.1.113883.11.20.9.20 DYNAMIC (CONF:4537-7993).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.20"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.guardianPerson",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.guardianPerson",
        "comment" : "The guardian, if present, SHALL contain exactly one [1..1] guardianPerson (CONF:4537-5385).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.guardianPerson.name",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.guardian.guardianPerson.name",
        "comment" : "This guardianPerson SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:4537-5386).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace",
        "comment" : "This patient MAY contain zero or one [0..1] birthplace (CONF:4537-5395)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place",
        "comment" : "The birthplace, if present, SHALL contain exactly one [1..1] place (CONF:4537-5396)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place.addr",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place.addr",
        "comment" : "This place SHALL contain exactly one [1..1] addr (CONF:4537-5397).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "4537-5402",
            "severity" : "error",
            "human" : "If country is US, this addr **SHALL** contain exactly one [1..1] state, which **SHALL** be selected from ValueSet US Core USPS State *DYNAMIC* (CONF:4537-5402).",
            "expression" : "nullFlavor.exists() or (item.country.exists() and item.country.xmlText != 'US' and item.country.xmlText != 'USA') or item.state.exists(nullFlavor.exists() or xmlText.memberOf('http://terminology.hl7.org/ValueSet/USPS-State'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "4537-5403",
            "severity" : "warning",
            "human" : "If country is US, this addr **MAY** contain zero or one [0..1] postalCode, which **SHALL** be selected from ValueSet PostalCode urn:oid:2.16.840.1.113883.3.88.12.80.2 *DYNAMIC* (CONF:4537-5403).",
            "expression" : "nullFlavor.exists() or (item.country.exists() and item.country.xmlText != 'US' and item.country.xmlText != 'USA') or item.postalCode.empty() or item.postalCode.exists(nullFlavor.exists() or xmlText.matches('[0-9]{5}(-[0-9]{4})?'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "should-country",
            "severity" : "warning",
            "human" : "SHOULD contain country",
            "expression" : "nullFlavor.exists() or item.country.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place.addr.item.country",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.birthplace.place.addr.item.country",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-Country2"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Preferred Language",
        "constraint" : [
          {
            "key" : "should-proficiencyLevelCode",
            "severity" : "warning",
            "human" : "SHOULD contain proficiencyLevelCode",
            "expression" : "proficiencyLevelCode.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "should-preferenceInd",
            "severity" : "warning",
            "human" : "SHOULD contain preferenceInd",
            "expression" : "preferenceInd.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.languageCode",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.languageCode",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/Languages"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.modeCode",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.modeCode",
        "comment" : "The languageCommunication, if present, MAY contain zero or one [0..1] modeCode, which SHALL be selected from ValueSet LanguageAbilityMode urn:oid:2.16.840.1.113883.1.11.12249 DYNAMIC (CONF:4537-5409).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.12249"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.proficiencyLevelCode",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.proficiencyLevelCode",
        "short" : "SHOULD contain proficiencyLevelCode",
        "comment" : "The languageCommunication, if present, SHOULD contain zero or one [0..1] proficiencyLevelCode, which SHALL be selected from ValueSet LanguageAbilityProficiency urn:oid:2.16.840.1.113883.1.11.12199 DYNAMIC (CONF:4537-9965).",
        "condition" : ["should-proficiencyLevelCode"],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.12199"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.preferenceInd",
        "path" : "ClinicalDocument.recordTarget.patientRole.patient.languageCommunication.preferenceInd",
        "short" : "SHOULD contain preferenceInd",
        "comment" : "The languageCommunication, if present, SHOULD contain zero or one [0..1] preferenceInd (CONF:4537-5414).",
        "condition" : ["should-preferenceInd"]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization",
        "comment" : "This patientRole MAY contain zero or one [0..1] providerOrganization (CONF:4537-5416)."
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.id",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.id",
        "comment" : "The providerOrganization, if present, SHALL contain at least one [1..*] id (CONF:4537-5417).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.id.root",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.id.root",
        "comment" : "Such ids SHOULD contain zero or one [0..1] @root=\"2.16.840.1.113883.4.6\" National Provider Identifier (CONF:4537-16820).",
        "constraint" : [
          {
            "key" : "should-npi",
            "severity" : "warning",
            "human" : "SHOULD be NPI",
            "expression" : "$this = '2.16.840.1.113883.4.6'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.name",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.name",
        "comment" : "The providerOrganization, if present, SHALL contain at least one [1..*] name (CONF:4537-5419).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.telecom",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.telecom",
        "comment" : "The providerOrganization, if present, SHALL contain at least one [1..*] telecom (CONF:4537-5420).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.telecom.use",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.telecom.use",
        "comment" : "Such telecoms SHOULD contain zero or one [0..1] @use, which SHALL be selected from ValueSet Telecom Use (US Realm Header) urn:oid:2.16.840.1.113883.11.20.9.20 DYNAMIC (CONF:4537-7994).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.20"
        }
      },
      {
        "id" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.addr",
        "path" : "ClinicalDocument.recordTarget.patientRole.providerOrganization.addr",
        "comment" : "The providerOrganization, if present, SHALL contain at least one [1..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-5422).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.author",
        "path" : "ClinicalDocument.author",
        "short" : "The author element represents the creator of the clinical document.  The author may be a device or a person.",
        "comment" : "SHALL contain at least one [1..*] author (CONF:4537-5444)."
      },
      {
        "id" : "ClinicalDocument.author.time",
        "path" : "ClinicalDocument.author.time",
        "comment" : "Such authors SHALL contain exactly one [1..1] US Realm Date and Time (Point in Time) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.4) (CONF:4537-5445).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/TS",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTime"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor",
        "path" : "ClinicalDocument.author.assignedAuthor",
        "comment" : "Such authors SHALL contain exactly one [1..1] assignedAuthor (CONF:4537-5448).",
        "constraint" : [
          {
            "key" : "4537-16790",
            "severity" : "error",
            "human" : "There **SHALL** be exactly one assignedAuthor/assignedPerson or exactly one assignedAuthor/assignedAuthoringDevice (CONF:4537-16790).",
            "expression" : "(assignedPerson | assignedAuthoringDevice).count() = 1",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "should-id-npi",
            "severity" : "warning",
            "human" : "SHOULD contain an id with root='2.16.840.1.113883.4.6' (NPI)",
            "expression" : "id.where(root = '2.16.840.1.113883.4.6')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "should-us-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.id",
        "path" : "ClinicalDocument.author.assignedAuthor.id",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "comment" : "This assignedAuthor SHOULD contain zero or one [0..1] id (CONF:4537-32882) such that it, This assignedAuthor SHALL contain at least one [1..*] id (CONF:4537-5449)."
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.id:npi",
        "path" : "ClinicalDocument.author.assignedAuthor.id",
        "sliceName" : "npi",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "should-extension",
            "severity" : "warning",
            "human" : "SHOULD contain extension",
            "expression" : "extension.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.id:npi.nullFlavor",
        "path" : "ClinicalDocument.author.assignedAuthor.id.nullFlavor",
        "short" : "If NPI is unknown, set @nullFlavor to UNK"
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.id:npi.root",
        "path" : "ClinicalDocument.author.assignedAuthor.id.root",
        "comment" : "SHALL contain exactly one [1..1] @root=\"2.16.840.1.113883.4.6\" National Provider Identifier (CONF:4537-32884).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.4.6"
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.id:npi.extension",
        "path" : "ClinicalDocument.author.assignedAuthor.id.extension",
        "comment" : "SHOULD contain zero or one [0..1] @extension (CONF:4537-32885)."
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.code",
        "path" : "ClinicalDocument.author.assignedAuthor.code",
        "short" : "Only if this assignedAuthor is an assignedPerson should the assignedAuthor contain a code.",
        "comment" : "This assignedAuthor SHOULD contain zero or one [0..1] code (CONF:4537-16787)."
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.code.nullFlavor",
        "path" : "ClinicalDocument.author.assignedAuthor.code.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.code.code",
        "path" : "ClinicalDocument.author.assignedAuthor.code.code",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.sdtcSpecialty",
        "path" : "ClinicalDocument.author.assignedAuthor.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.addr",
        "path" : "ClinicalDocument.author.assignedAuthor.addr",
        "comment" : "This assignedAuthor SHALL contain at least one [1..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-5452).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.telecom",
        "path" : "ClinicalDocument.author.assignedAuthor.telecom",
        "comment" : "This assignedAuthor SHALL contain at least one [1..*] telecom (CONF:4537-5428).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.telecom.use",
        "path" : "ClinicalDocument.author.assignedAuthor.telecom.use",
        "comment" : "Such telecoms SHOULD contain zero or one [0..1] @use, which SHALL be selected from ValueSet Telecom Use (US Realm Header) urn:oid:2.16.840.1.113883.11.20.9.20 DYNAMIC (CONF:4537-7995).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.20"
        }
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.assignedPerson",
        "path" : "ClinicalDocument.author.assignedAuthor.assignedPerson",
        "comment" : "MAY contain assignedPerson"
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.assignedPerson.name",
        "path" : "ClinicalDocument.author.assignedAuthor.assignedPerson.name",
        "comment" : "The assignedPerson, if present, SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:4537-16789).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice",
        "path" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice",
        "comment" : "MAY contain assignedAuthoringDevice"
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice.manufacturerModelName",
        "path" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice.manufacturerModelName",
        "comment" : "The assignedAuthoringDevice, if present, SHALL contain exactly one [1..1] manufacturerModelName (CONF:4537-16784).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice.softwareName",
        "path" : "ClinicalDocument.author.assignedAuthor.assignedAuthoringDevice.softwareName",
        "comment" : "The assignedAuthoringDevice, if present, SHALL contain exactly one [1..1] softwareName (CONF:4537-16785).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.dataEnterer",
        "path" : "ClinicalDocument.dataEnterer",
        "short" : "The dataEnterer element represents the person who transferred the content, written or dictated, into the clinical document. To clarify, an author provides the content found within the header or body of a document, subject to their own interpretation; a dataEnterer adds an author's information to the electronic system.",
        "comment" : "MAY contain zero or one [0..1] dataEnterer (CONF:4537-5441)."
      },
      {
        "id" : "ClinicalDocument.dataEnterer.time",
        "path" : "ClinicalDocument.dataEnterer.time",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/TS",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTime"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity",
        "comment" : "The dataEnterer, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:4537-5442)."
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.id",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.id",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4537-5443)."
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.id.root",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.id.root",
        "comment" : "Such ids SHOULD contain zero or one [0..1] @root=\"2.16.840.1.113883.4.6\" National Provider Identifier (CONF:4537-16821).",
        "constraint" : [
          {
            "key" : "should-npi",
            "severity" : "warning",
            "human" : "SHOULD be NPI",
            "expression" : "$this = '2.16.840.1.113883.4.6'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.code",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.code",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:4537-32173).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.sdtcSpecialty",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.addr",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.addr",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-5460).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.telecom",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.telecom",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] telecom (CONF:4537-5466).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.telecom.use",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.telecom.use",
        "comment" : "Such telecoms SHOULD contain zero or one [0..1] @use, which SHALL be selected from ValueSet Telecom Use (US Realm Header) urn:oid:2.16.840.1.113883.11.20.9.20 DYNAMIC (CONF:4537-7996).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.20"
        }
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.assignedPerson",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.assignedPerson",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] assignedPerson (CONF:4537-5469).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.dataEnterer.assignedEntity.assignedPerson.name",
        "path" : "ClinicalDocument.dataEnterer.assignedEntity.assignedPerson.name",
        "comment" : "This assignedPerson SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:4537-5470).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informant",
        "path" : "ClinicalDocument.informant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "exists",
              "path" : "relatedEntity"
            },
            {
              "type" : "exists",
              "path" : "assignedEntity"
            }
          ],
          "rules" : "open"
        },
        "comment" : "MAY contain zero or more [0..*] informant (CONF:4537-31355) such that it"
      },
      {
        "id" : "ClinicalDocument.informant:provider",
        "path" : "ClinicalDocument.informant",
        "sliceName" : "provider",
        "short" : "The informant element describes an information source for any content within the clinical document. This informant is constrained for use when the source of information is an assigned health care provider for the patient.",
        "comment" : "MAY contain zero or more [0..*] informant (CONF:4537-8001) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity",
        "path" : "ClinicalDocument.informant.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:4537-8002).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity.id",
        "path" : "ClinicalDocument.informant.assignedEntity.id",
        "short" : "If assignedEntity/id is a provider then this id, **SHOULD** include zero or one [0..1] id where id/@root =\"2.16.840.1.113883.4.6\" National Provider Identifier (CONF:4537-9946).",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4537-9945)."
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity.code",
        "path" : "ClinicalDocument.informant.assignedEntity.code",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:4537-32174).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity.sdtcSpecialty",
        "path" : "ClinicalDocument.informant.assignedEntity.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity.addr",
        "path" : "ClinicalDocument.informant.assignedEntity.addr",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-8220).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity.assignedPerson",
        "path" : "ClinicalDocument.informant.assignedEntity.assignedPerson",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] assignedPerson (CONF:4537-8221).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.informant:provider.assignedEntity.assignedPerson.name",
        "path" : "ClinicalDocument.informant.assignedEntity.assignedPerson.name",
        "comment" : "This assignedPerson SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:4537-8222).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informant:provider.relatedEntity",
        "path" : "ClinicalDocument.informant.relatedEntity",
        "max" : "0"
      },
      {
        "id" : "ClinicalDocument.informant:non-provider",
        "path" : "ClinicalDocument.informant",
        "sliceName" : "non-provider",
        "short" : "The informant element describes an information source (who is not a provider) for any content within the clinical document. This informant would be used when the source of information has a personal relationship with the patient or is the patient.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ClinicalDocument.informant:non-provider.assignedEntity",
        "path" : "ClinicalDocument.informant.assignedEntity",
        "max" : "0"
      },
      {
        "id" : "ClinicalDocument.informant:non-provider.relatedEntity",
        "path" : "ClinicalDocument.informant.relatedEntity",
        "comment" : "SHALL contain exactly one [1..1] relatedEntity (CONF:4537-31356).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.custodian",
        "path" : "ClinicalDocument.custodian",
        "short" : "The custodian element represents the organization that is in charge of maintaining and is entrusted with the care of the document.\n\n  There is only one custodian per CDA document. Allowing that a CDA document may not represent the original form of the authenticated document, the custodian represents the steward of the original source document. The custodian may be the document originator, a health information exchange, or other responsible party.",
        "comment" : "SHALL contain exactly one [1..1] custodian (CONF:4537-5519)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian",
        "path" : "ClinicalDocument.custodian.assignedCustodian",
        "comment" : "This custodian SHALL contain exactly one [1..1] assignedCustodian (CONF:4537-5520)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization",
        "comment" : "This assignedCustodian SHALL contain exactly one [1..1] representedCustodianOrganization (CONF:4537-5521)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.id",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.id",
        "comment" : "This representedCustodianOrganization SHALL contain at least one [1..*] id (CONF:4537-5522)."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.id.root",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.id.root",
        "comment" : "Such ids SHOULD contain zero or one [0..1] @root=\"2.16.840.1.113883.4.6\" National Provider Identifier (CONF:4537-16822).",
        "constraint" : [
          {
            "key" : "should-npi",
            "severity" : "warning",
            "human" : "SHOULD be NPI",
            "expression" : "$this = '2.16.840.1.113883.4.6'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.name",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.name",
        "comment" : "This representedCustodianOrganization SHALL contain exactly one [1..1] name (CONF:4537-5524).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.telecom",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.telecom",
        "comment" : "This representedCustodianOrganization SHALL contain exactly one [1..1] telecom (CONF:4537-5525).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.telecom.use",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.telecom.use",
        "comment" : "This telecom SHOULD contain zero or one [0..1] @use, which SHALL be selected from ValueSet Telecom Use (US Realm Header) urn:oid:2.16.840.1.113883.11.20.9.20 DYNAMIC (CONF:4537-7998).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.20"
        }
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.sdtcTelecom",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.sdtcTelecom",
        "short" : "The stdc:telecom extension can be used to provide additional telecom elements for the custodian organization."
      },
      {
        "id" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.addr",
        "path" : "ClinicalDocument.custodian.assignedCustodian.representedCustodianOrganization.addr",
        "comment" : "This representedCustodianOrganization SHALL contain exactly one [1..1] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-5559).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informationRecipient",
        "path" : "ClinicalDocument.informationRecipient",
        "short" : "The informationRecipient element records the intended recipient of the information at the time the document was created. In cases where the intended recipient of the document is the patient's health chart, set the receivedOrganization to the scoping organization for that chart.",
        "comment" : "MAY contain zero or more [0..*] informationRecipient (CONF:4537-5565)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "comment" : "The informationRecipient, if present, SHALL contain exactly one [1..1] intendedRecipient (CONF:4537-5566)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.id",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.id",
        "comment" : "This intendedRecipient MAY contain zero or more [0..*] id (CONF:4537-32399)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient",
        "comment" : "This intendedRecipient MAY contain zero or one [0..1] informationRecipient (CONF:4537-5567)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient.name",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.informationRecipient.name",
        "comment" : "The informationRecipient, if present, SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:4537-5568).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization",
        "comment" : "This intendedRecipient MAY contain zero or one [0..1] receivedOrganization (CONF:4537-5577)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization.name",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient.receivedOrganization.name",
        "comment" : "The receivedOrganization, if present, SHALL contain exactly one [1..1] name (CONF:4537-5578).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator",
        "path" : "ClinicalDocument.legalAuthenticator",
        "short" : "The legalAuthenticator identifies the single person legally responsible for the document and must be present if the document has been legally authenticated. A clinical document that does not contain this element has not been legally authenticated. The act of legal authentication requires a certain privilege be granted to the legal authenticator depending upon local policy. Based on local practice, clinical documents may be released before legal authentication.  All clinical documents have the potential for legal authentication, given the appropriate credentials. Local policies MAY choose to delegate the function of legal authentication to a device or system that generates the clinical document. In these cases, the legal authenticator is a person accepting responsibility for the document, not the generating device or system. Note that the legal authenticator, if present, must be a person.",
        "comment" : "SHOULD contain zero or one [0..1] legalAuthenticator (CONF:4537-5579).",
        "condition" : ["should-legalAuthenticator"]
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.time",
        "path" : "ClinicalDocument.legalAuthenticator.time",
        "comment" : "The legalAuthenticator, if present, SHALL contain exactly one [1..1] US Realm Date and Time (Point in Time) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.4) (CONF:4537-5580).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/TS",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTime"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.signatureCode",
        "path" : "ClinicalDocument.legalAuthenticator.signatureCode",
        "comment" : "The legalAuthenticator, if present, SHALL contain exactly one [1..1] signatureCode (CONF:4537-5583)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.signatureCode.code",
        "path" : "ClinicalDocument.legalAuthenticator.signatureCode.code",
        "comment" : "This signatureCode SHALL contain exactly one [1..1] @code=\"S\" (CodeSystem: HL7ParticipationSignature urn:oid:2.16.840.1.113883.5.89 STATIC) (CONF:4537-5584).",
        "min" : 1,
        "patternCode" : "S"
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.sdtcSignatureText",
        "path" : "ClinicalDocument.legalAuthenticator.sdtcSignatureText",
        "short" : "The signature can be represented either inline or by reference according to the ED data type. Typical cases for CDA are:\n1) Electronic signature: this attribute can represent virtually any electronic signature scheme.\n2) Digital signature: this attribute can represent digital signatures by reference to a signature data block that is constructed in accordance to a digital signature standard, such as XML-DSIG, PKCS#7, PGP, etc.\n The sdtc:signatureText extension provides a location in CDA for a textual or multimedia depiction of the signature by which the participant endorses and accepts responsibility for his or her participation in the Act as specified in the Participation.typeCode. Details of what goes in the field are described in the HL7 CDA Digital Signature Standard balloted in Fall 2013.",
        "comment" : "The legalAuthenticator, if present, MAY contain zero or one [0..1] sdtc:signatureText (CONF:4537-30810)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity",
        "comment" : "The legalAuthenticator, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:4537-5585)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.id",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.id",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4537-5586)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.id.root",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.id.root",
        "short" : "MAY contain '2.16.840.1.113883.4.6' (NPI)",
        "comment" : "Such ids MAY contain zero or one [0..1] @root=\"2.16.840.1.113883.4.6\" National Provider Identifier (CONF:4537-16823)."
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.code",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.code",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:4537-17000).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.sdtcSpecialty",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.addr",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.addr",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-5589).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.telecom",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.telecom",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] telecom (CONF:4537-5595).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.telecom.use",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.telecom.use",
        "comment" : "Such telecoms SHOULD contain zero or one [0..1] @use, which SHALL be selected from ValueSet Telecom Use (US Realm Header) urn:oid:2.16.840.1.113883.11.20.9.20 DYNAMIC (CONF:4537-7999).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.20"
        }
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.assignedPerson",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.assignedPerson",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] assignedPerson (CONF:4537-5597).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.legalAuthenticator.assignedEntity.assignedPerson.name",
        "path" : "ClinicalDocument.legalAuthenticator.assignedEntity.assignedPerson.name",
        "comment" : "This assignedPerson SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:4537-5598).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.authenticator",
        "path" : "ClinicalDocument.authenticator",
        "short" : "The authenticator identifies a participant or participants who attest to the accuracy of the information in the document."
      },
      {
        "id" : "ClinicalDocument.authenticator.time",
        "path" : "ClinicalDocument.authenticator.time",
        "comment" : "SHALL contain exactly one [1..1] US Realm Date and Time (Point in Time) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.4) (CONF:4537-5608).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/TS",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTime"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.authenticator.signatureCode",
        "path" : "ClinicalDocument.authenticator.signatureCode",
        "comment" : "SHALL contain exactly one [1..1] signatureCode (CONF:4537-5610)."
      },
      {
        "id" : "ClinicalDocument.authenticator.signatureCode.code",
        "path" : "ClinicalDocument.authenticator.signatureCode.code",
        "comment" : "This signatureCode SHALL contain exactly one [1..1] @code=\"S\" (CodeSystem: HL7ParticipationSignature urn:oid:2.16.840.1.113883.5.89 STATIC) (CONF:4537-5611).",
        "min" : 1,
        "patternCode" : "S"
      },
      {
        "id" : "ClinicalDocument.authenticator.sdtcSignatureText",
        "path" : "ClinicalDocument.authenticator.sdtcSignatureText",
        "short" : "The signature can be represented either inline or by reference according to the ED data type. Typical cases for CDA are:\n1) Electronic signature: this attribute can represent virtually any electronic signature scheme.\n2) Digital signature: this attribute can represent digital signatures by reference to a signature data block that is constructed in accordance to a digital signature standard, such as XML-DSIG, PKCS#7, PGP, etc.\n The sdtc:signatureText extension provides a location in CDA for a textual or multimedia depiction of the signature by which the participant endorses and accepts responsibility for his or her participation in the Act as specified in the Participation.typeCode. Details of what goes in the field are described in the HL7 CDA Digital Signature Standard balloted in Fall of 2013.",
        "comment" : "MAY contain zero or one [0..1] sdtc:signatureText (CONF:4537-30811)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity",
        "path" : "ClinicalDocument.authenticator.assignedEntity",
        "comment" : "SHALL contain exactly one [1..1] assignedEntity (CONF:4537-5612)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.id",
        "path" : "ClinicalDocument.authenticator.assignedEntity.id",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4537-5613)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.id.root",
        "path" : "ClinicalDocument.authenticator.assignedEntity.id.root",
        "comment" : "Such ids SHOULD contain zero or one [0..1] @root=\"2.16.840.1.113883.4.6\" National Provider Identifier  (CONF:4537-16824).",
        "constraint" : [
          {
            "key" : "should-npi",
            "severity" : "warning",
            "human" : "SHOULD be NPI",
            "expression" : "$this = '2.16.840.1.113883.4.6'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.code",
        "path" : "ClinicalDocument.authenticator.assignedEntity.code",
        "comment" : "This assignedEntity MAY contain zero or one [0..1] code (CONF:4537-16825)."
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.code.code",
        "path" : "ClinicalDocument.authenticator.assignedEntity.code.code",
        "comment" : "The code, if present, MAY contain zero or one [0..1] @code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:4537-16826).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.sdtcSpecialty",
        "path" : "ClinicalDocument.authenticator.assignedEntity.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.addr",
        "path" : "ClinicalDocument.authenticator.assignedEntity.addr",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-5616).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.telecom",
        "path" : "ClinicalDocument.authenticator.assignedEntity.telecom",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] telecom (CONF:4537-5622).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-use",
            "severity" : "warning",
            "human" : "SHOULD contain @use",
            "expression" : "nullFlavor.exists() or use.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.telecom.use",
        "path" : "ClinicalDocument.authenticator.assignedEntity.telecom.use",
        "comment" : "Such telecoms SHOULD contain zero or one [0..1] @use, which SHALL be selected from ValueSet Telecom Use (US Realm Header) urn:oid:2.16.840.1.113883.11.20.9.20 DYNAMIC (CONF:4537-8000).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.20"
        }
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.assignedPerson",
        "path" : "ClinicalDocument.authenticator.assignedEntity.assignedPerson",
        "comment" : "This assignedEntity SHALL contain exactly one [1..1] assignedPerson (CONF:4537-5624).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.authenticator.assignedEntity.assignedPerson.name",
        "path" : "ClinicalDocument.authenticator.assignedEntity.assignedPerson.name",
        "comment" : "This assignedPerson SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:4537-5625).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant",
        "path" : "ClinicalDocument.participant",
        "short" : "The participant element identifies supporting entities, including parents, relatives, caregivers, insurance policyholders, guarantors, and others related in some way to the patient. A supporting person or organization is an individual or an organization with a relationship to the patient. A supporting person who is playing multiple roles would be recorded in multiple participants (e.g., emergency contact and next-of-kin).",
        "comment" : "SHOULD contain zero or more [0..*] RelatedPerson participant",
        "constraint" : [
          {
            "key" : "4537-10006",
            "severity" : "error",
            "human" : "**SHALL** contain associatedEntity/associatedPerson *AND/OR* associatedEntity/scopingOrganization (CONF:4537-10006).",
            "expression" : "associatedEntity.associatedPerson.exists() or associatedEntity.scopingOrganization.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          },
          {
            "key" : "4537-10007",
            "severity" : "warning",
            "human" : "When participant/@typeCode is *IND*, associatedEntity/@classCode **SHOULD** be selected from ValueSet 2.16.840.1.113883.11.20.9.33 INDRoleclassCodes *DYNAMIC* (CONF:4537-10007).",
            "expression" : "typeCode = 'IND' implies associatedEntity.classCode.memberOf('http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.33')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant.time",
        "path" : "ClinicalDocument.participant.time",
        "comment" : "MAY contain zero or one [0..1] time (CONF:4537-10004).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/IVL-TS",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf",
        "path" : "ClinicalDocument.inFulfillmentOf",
        "short" : "The inFulfillmentOf element represents orders that are fulfilled by this document such as a radiologists' report of an x-ray.",
        "comment" : "MAY contain zero or more [0..*] inFulfillmentOf (CONF:4537-9952)."
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf.order",
        "path" : "ClinicalDocument.inFulfillmentOf.order",
        "comment" : "The inFulfillmentOf, if present, SHALL contain exactly one [1..1] order (CONF:4537-9953)."
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf.order.id",
        "path" : "ClinicalDocument.inFulfillmentOf.order.id",
        "comment" : "This order SHALL contain at least one [1..*] id (CONF:4537-9954)."
      },
      {
        "id" : "ClinicalDocument.documentationOf",
        "path" : "ClinicalDocument.documentationOf",
        "comment" : "MAY contain zero or more [0..*] documentationOf (CONF:4537-14835)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent",
        "path" : "ClinicalDocument.documentationOf.serviceEvent",
        "short" : "A serviceEvent represents the main act being documented, such as a colonoscopy or a cardiac stress study. In a provision of healthcare serviceEvent, the care providers, PCP, or other longitudinal providers, are recorded within the serviceEvent. If the document is about a single encounter, the providers associated can be recorded in the componentOf/encompassingEncounter template.",
        "comment" : "The documentationOf, if present, SHALL contain exactly one [1..1] serviceEvent (CONF:4537-14836).",
        "constraint" : [
          {
            "key" : "should-us-performer",
            "severity" : "warning",
            "human" : "SHOULD contain performer",
            "expression" : "performer.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime",
        "comment" : "This serviceEvent SHALL contain exactly one [1..1] US Realm Date and Time (Interval) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.3) (CONF:4537-14837).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/IVL-TS",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.low",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.effectiveTime.low",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:4537-14838).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer",
        "short" : "The performer participant represents clinicians who actually and principally carry out the serviceEvent. In a transfer of care this represents the healthcare providers involved in the current or pertinent historical care of the patient. Preferably, the patient's key healthcare care team members would be listed, particularly their primary physician and any active consulting physicians, therapists, and counselors.",
        "comment" : "This serviceEvent SHOULD contain zero or more [0..*] performer (CONF:4537-14839).",
        "condition" : ["should-us-performer"]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.typeCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.typeCode",
        "comment" : "The performer, if present, SHALL contain exactly one [1..1] @typeCode, which SHALL be selected from ValueSet x_ServiceEventPerformer urn:oid:2.16.840.1.113883.1.11.19601 STATIC (CONF:4537-14840).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.19601"
        }
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode",
        "comment" : "The performer, if present, MAY contain zero or one [0..1] functionCode (CONF:4537-16818).",
        "constraint" : [
          {
            "key" : "should-code-attr",
            "severity" : "warning",
            "human" : "SHOULD contain @code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.functionCode.code",
        "comment" : "The functionCode, if present, SHOULD contain zero or one [0..1] @code, which SHOULD be selected from ValueSet Care Team Member Function urn:oid:2.16.840.1.113762.1.4.1099.30 DYNAMIC (CONF:4537-32889).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30"
        }
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.time",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.time",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/IVL-TS",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity",
        "comment" : "The performer, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:4537-14841).",
        "constraint" : [
          {
            "key" : "should-us-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.id",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.id",
        "comment" : "This assignedEntity SHALL contain at least one [1..*] id (CONF:4537-14846)."
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.id.root",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.id.root",
        "comment" : "Such ids SHOULD contain zero or one [0..1] @root=\"2.16.840.1.113883.4.6\" National Provider Identifier (CONF:4537-14847).",
        "constraint" : [
          {
            "key" : "should-npi",
            "severity" : "warning",
            "human" : "SHOULD be NPI",
            "expression" : "$this = '2.16.840.1.113883.4.6'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.code",
        "path" : "ClinicalDocument.documentationOf.serviceEvent.performer.assignedEntity.code",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:4537-14842).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "ClinicalDocument.authorization",
        "path" : "ClinicalDocument.authorization",
        "short" : "The authorization element represents information about the patient's consent. The type of consent is conveyed in consent/code. Consents in the header have been finalized (consent/statusCode must equal Completed) and should be on file. This specification does not address how 'Privacy Consent' is represented, but does not preclude the inclusion of 'Privacy Consent'. The authorization consent is used for referring to consents that are documented elsewhere in the EHR or medical record for a health condition and/or treatment that is described in the CDA document.",
        "comment" : "MAY contain zero or more [0..*] authorization (CONF:4537-16792) such that it"
      },
      {
        "id" : "ClinicalDocument.authorization.consent",
        "path" : "ClinicalDocument.authorization.consent",
        "comment" : "SHALL contain exactly one [1..1] consent (CONF:4537-16793)."
      },
      {
        "id" : "ClinicalDocument.authorization.consent.id",
        "path" : "ClinicalDocument.authorization.consent.id",
        "comment" : "This consent MAY contain zero or more [0..*] id (CONF:4537-16794)."
      },
      {
        "id" : "ClinicalDocument.authorization.consent.code",
        "path" : "ClinicalDocument.authorization.consent.code",
        "short" : "The type of consent (e.g., a consent to perform the related serviceEvent) is conveyed in consent/code.",
        "comment" : "This consent MAY contain zero or one [0..1] code (CONF:4537-16795)."
      },
      {
        "id" : "ClinicalDocument.authorization.consent.statusCode",
        "path" : "ClinicalDocument.authorization.consent.statusCode",
        "comment" : "This consent SHALL contain exactly one [1..1] statusCode (CONF:4537-16797)."
      },
      {
        "id" : "ClinicalDocument.authorization.consent.statusCode.code",
        "path" : "ClinicalDocument.authorization.consent.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:4537-16798)."
      },
      {
        "id" : "ClinicalDocument.componentOf",
        "path" : "ClinicalDocument.componentOf",
        "short" : "The encompassing encounter represents the setting of the clinical encounter during which the document act(s) or ServiceEvent(s) occurred. In order to represent providers associated with a specific encounter, they are recorded within the encompassingEncounter as participants. In a CCD, the encompassingEncounter may be used when documenting a specific encounter and its participants. All relevant encounters in a CCD may be listed in the encounters section.",
        "comment" : "MAY contain zero or one [0..1] componentOf (CONF:4537-9955)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter",
        "comment" : "The componentOf, if present, SHALL contain exactly one [1..1] encompassingEncounter (CONF:4537-9956).",
        "constraint" : [
          {
            "key" : "should-responsibleParty",
            "severity" : "warning",
            "human" : "SHOULD contain responsibleParty",
            "expression" : "responsibleParty.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.id",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.id",
        "comment" : "This encompassingEncounter SHALL contain at least one [1..*] id (CONF:4537-9959).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.code",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.code",
        "comment" : "This encompassingEncounter MAY contain zero or one [0..1] code, which SHOULD be selected from ValueSet Act Encounter Codes urn:oid:2.16.840.1.113762.1.4.1240.5 (CONF:1198-30873).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.5"
        }
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "comment" : "This encompassingEncounter SHALL contain exactly one [1..1] US Realm Date and Time (Interval) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.3) (CONF:4537-9958).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/IVL-TS",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty",
        "comment" : "This encompassingEncounter SHOULD contain zero or one [0..1] responsibleParty (CONF:1198-8391)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty.assignedEntity",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty.assignedEntity",
        "comment" : "The responsibleParty, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:1198-32904).",
        "constraint" : [
          {
            "key" : "1198-32905",
            "severity" : "error",
            "human" : "This assignedEntity SHALL contain an assignedPerson or a representedOrganization or both (CONF:1198-32905).",
            "expression" : "assignedPerson.exists() or representedOrganization.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.location.healthCareFacility.location.addr",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.location.healthCareFacility.location.addr",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Facility Address",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      }
    ]
  }
}

```
