# US Realm Date and Time - Point in Time - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Realm Date and Time - Point in Time**

## Logical Model: US Realm Date and Time - Point in Time 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTime | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:USRealmDateTime |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.5.4 | |

 
The US Realm Clinical Document Date and Time datatype flavor records date and time information. If time is provided, it must include a time zone offset. 
This data type uses the same rules as US Realm Date and Time (Interval), but is used with elements having a datatype of TS. 

**Usages:**

* Use this Logical Model Profile: [US Realm Header](StructureDefinition-USRealmHeader.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/USRealmDateTime)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-USRealmDateTime.csv), [Excel](StructureDefinition-USRealmDateTime.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "USRealmDateTime",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTime",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.5.4"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "USRealmDateTime",
  "title" : "US Realm Date and Time - Point in Time",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The US Realm Clinical Document Date and Time datatype flavor records date and time information. If time is provided, it must include a time zone offset.\n\nThis data type uses the same rules as US Realm Date and Time (Interval), but is used with elements having a datatype of TS.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/TS",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/TS",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "TS",
        "path" : "TS",
        "constraint" : [
          {
            "key" : "ts-shall-day",
            "severity" : "error",
            "human" : "**SHALL** be precise to at least the day",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 10",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTime"
          },
          {
            "key" : "ts-should-minute",
            "severity" : "warning",
            "human" : "**SHOULD** be precise to at least the minute",
            "expression" : "nullFlavor.exists() or value.toString().length() > 10",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTime"
          }
        ]
      },
      {
        "id" : "TS.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format",
            "valueString" : "YYYYMMDDHHMMSS.UUUU[+|-ZZzz]"
          },
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-rules",
            "valueString" : "year-valid:tz-for-time"
          }
        ],
        "path" : "TS.value"
      }
    ]
  }
}

```
