# UDI Organizer - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **UDI Organizer**

## Logical Model: UDI Organizer 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:UDIOrganizer |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.311:2019-06-21 | |

 
This template is nested within an entryRelationship of either a[Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md)or a[Non-Medicinal Supply Activity](StructureDefinition-NonMedicinalSupplyActivity.md). It is used to record all UDI-related templates needed to exchange parsed UDI data elements and their associated information. The Device Identifier template**SHALL**be included. The Lot or Batch Number, Serial Number, Manufacturing Date, Expiration Date, and Distinct Identification Code templates**SHOULD**be included if present in the UDI. Implantable Device Status (urn:hl7ii:2.16.840.1.113883.10.20.22.4.305, 2019-06-21, NCIt: C160939)**MAY**be included in the UDI Organizer if the device is implantable and the information is available. The other listed templates**MAY**be included if available. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required Components**:[DeviceIdentifierObservation](StructureDefinition-DeviceIdentifierObservation.md) 
**Recommended Components**:[DistinctIdentificationCodeObservation](StructureDefinition-DistinctIdentificationCodeObservation.md),[ExpirationDateObservation](StructureDefinition-ExpirationDateObservation.md),[LotOrBatchNumberObservation](StructureDefinition-LotOrBatchNumberObservation.md),[ManufacturingDateObservation](StructureDefinition-ManufacturingDateObservation.md),[SerialNumberObservation](StructureDefinition-SerialNumberObservation.md) 
**Optional Components**:[BrandNameObservation](StructureDefinition-BrandNameObservation.md),[CatalogNumberObservation](StructureDefinition-CatalogNumberObservation.md),[CompanyNameObservation](StructureDefinition-CompanyNameObservation.md),[ImplantableDeviceStatusObservation](StructureDefinition-ImplantableDeviceStatusObservation.md),[LatexSafetyObservation](StructureDefinition-LatexSafetyObservation.md),[MRISafetyObservation](StructureDefinition-MRISafetyObservation.md),[ModelNumberObservation](StructureDefinition-ModelNumberObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Non-Medicinal Supply Activity](StructureDefinition-NonMedicinalSupplyActivity.md) and [Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/UDIOrganizer)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-UDIOrganizer.csv), [Excel](StructureDefinition-UDIOrganizer.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "UDIOrganizer",
  "meta" : {
    "versionId" : "5",
    "lastUpdated" : "2023-07-11T23:41:40.695Z"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "organizer"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.311:2019-06-21"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "UDIOrganizer",
  "title" : "UDI Organizer",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template is nested within an entryRelationship of either a [Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.html) or a [Non-Medicinal Supply Activity](StructureDefinition-NonMedicinalSupplyActivity.html).\nIt is used to record all UDI-related templates needed to exchange parsed UDI data elements and their associated information.\nThe Device Identifier template **SHALL** be included.  The Lot or Batch Number, Serial Number, Manufacturing Date, Expiration Date, and Distinct Identification Code templates **SHOULD** be included if present in the UDI.  Implantable Device Status (urn:hl7ii:2.16.840.1.113883.10.20.22.4.305, 2019-06-21, NCIt: C160939) **MAY** be included in the UDI Organizer if the device is implantable and the information is available. The other listed templates **MAY** be included if available.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required Components**: [DeviceIdentifierObservation](StructureDefinition-DeviceIdentifierObservation.html)\n\n**Recommended Components**: [DistinctIdentificationCodeObservation](StructureDefinition-DistinctIdentificationCodeObservation.html), [ExpirationDateObservation](StructureDefinition-ExpirationDateObservation.html), [LotOrBatchNumberObservation](StructureDefinition-LotOrBatchNumberObservation.html), [ManufacturingDateObservation](StructureDefinition-ManufacturingDateObservation.html), [SerialNumberObservation](StructureDefinition-SerialNumberObservation.html)\n\n**Optional Components**: [BrandNameObservation](StructureDefinition-BrandNameObservation.html), [CatalogNumberObservation](StructureDefinition-CatalogNumberObservation.html), [CompanyNameObservation](StructureDefinition-CompanyNameObservation.html), [ImplantableDeviceStatusObservation](StructureDefinition-ImplantableDeviceStatusObservation.html), [LatexSafetyObservation](StructureDefinition-LatexSafetyObservation.html), [MRISafetyObservation](StructureDefinition-MRISafetyObservation.html), [ModelNumberObservation](StructureDefinition-ModelNumberObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organizer",
        "path" : "Organizer",
        "constraint" : [
          {
            "key" : "should-sdtctext-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "sdtcText.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer"
          },
          {
            "key" : "should-lot-or-batch-number-observation",
            "severity" : "warning",
            "human" : "SHOULD contain Lot Or Batch Number Observation",
            "expression" : "component.where(observation.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/LotOrBatchNumberObservation'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer"
          },
          {
            "key" : "should-serial-number-observation",
            "severity" : "warning",
            "human" : "SHOULD contain Serial Number Observation",
            "expression" : "component.where(observation.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/SerialNumberObservation'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer"
          },
          {
            "key" : "should-manufacturing-date-observation",
            "severity" : "warning",
            "human" : "SHOULD contain Manufacturing Date Observation",
            "expression" : "component.where(observation.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ManufacturingDateObservation'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer"
          },
          {
            "key" : "should-expiration-date-observation",
            "severity" : "warning",
            "human" : "SHOULD contain Expiration Date Observation",
            "expression" : "component.where(observation.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ExpirationDateObservation'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer"
          },
          {
            "key" : "should-distinct-identification-code-observation",
            "severity" : "warning",
            "human" : "SHOULD contain Distinct Identification Code Observation",
            "expression" : "component.where(observation.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/DistinctIdentificationCodeObservation'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.templateId",
        "path" : "Organizer.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Organizer.templateId:UDI-org",
        "path" : "Organizer.templateId",
        "sliceName" : "UDI-org",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.templateId:UDI-org.root",
        "path" : "Organizer.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.311"
      },
      {
        "id" : "Organizer.templateId:UDI-org.extension",
        "path" : "Organizer.templateId.extension",
        "min" : 1,
        "patternString" : "2019-06-21"
      },
      {
        "id" : "Organizer.classCode",
        "path" : "Organizer.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"CLUSTER\" (CONF:4437-3482).",
        "fixedCode" : "CLUSTER"
      },
      {
        "id" : "Organizer.moodCode",
        "path" : "Organizer.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CONF:4437-3483)."
      },
      {
        "id" : "Organizer.id",
        "path" : "Organizer.id",
        "comment" : "SHALL contain exactly one [1..1] id (CONF:4437-3541).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.id.root",
        "path" : "Organizer.id.root",
        "comment" : "This id SHALL contain exactly one [1..1] @root (CONF:4437-3542).",
        "min" : 1
      },
      {
        "id" : "Organizer.code",
        "path" : "Organizer.code",
        "comment" : "MAY contain zero or one [0..1] code (CONF:4437-3481)."
      },
      {
        "id" : "Organizer.code.code",
        "path" : "Organizer.code.code",
        "comment" : "The code, if present, MAY contain zero or one [0..1] @code=\"74711-3\" Unique Device Identifier (CodeSystem: LOINC urn:oid:2.16.840.1.113883.6.1) (CONF:4437-3486).",
        "patternCode" : "74711-3"
      },
      {
        "id" : "Organizer.code.codeSystem",
        "path" : "Organizer.code.codeSystem",
        "comment" : "The code, if present, SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.6.1\" (CONF:4437-3487).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Organizer.sdtcText",
        "path" : "Organizer.sdtcText",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-sdtctext-ref-value"]
      },
      {
        "id" : "Organizer.sdtcText.reference",
        "path" : "Organizer.sdtcText.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/UDIOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.statusCode",
        "path" : "Organizer.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4437-3490)."
      },
      {
        "id" : "Organizer.statusCode.code",
        "path" : "Organizer.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:4437-3543).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Organizer.component",
        "path" : "Organizer.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Organizer.component:deviceIdentifierObservation",
        "path" : "Organizer.component",
        "sliceName" : "deviceIdentifierObservation",
        "short" : "Device Identifier observation component",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:deviceIdentifierObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/DeviceIdentifierObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:lotOrBatchNumberObservation",
        "path" : "Organizer.component",
        "sliceName" : "lotOrBatchNumberObservation",
        "short" : "Lot Or Batch Number observation component",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-lot-or-batch-number-observation"]
      },
      {
        "id" : "Organizer.component:lotOrBatchNumberObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/LotOrBatchNumberObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:serialNumberObservation",
        "path" : "Organizer.component",
        "sliceName" : "serialNumberObservation",
        "short" : "Serial Number observation component",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-serial-number-observation"]
      },
      {
        "id" : "Organizer.component:serialNumberObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SerialNumberObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:manufacturingDateObservation",
        "path" : "Organizer.component",
        "sliceName" : "manufacturingDateObservation",
        "short" : "Manufacturing Date observation component",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-manufacturing-date-observation"]
      },
      {
        "id" : "Organizer.component:manufacturingDateObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ManufacturingDateObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:expirationDateObservation",
        "path" : "Organizer.component",
        "sliceName" : "expirationDateObservation",
        "short" : "Expiration Date observation component",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-expiration-date-observation"]
      },
      {
        "id" : "Organizer.component:expirationDateObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ExpirationDateObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:distinctIdentificationCodeObservation",
        "path" : "Organizer.component",
        "sliceName" : "distinctIdentificationCodeObservation",
        "short" : "Distinct Identification Code observation component",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-distinct-identification-code-observation"]
      },
      {
        "id" : "Organizer.component:distinctIdentificationCodeObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/DistinctIdentificationCodeObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:brandNameObservation",
        "path" : "Organizer.component",
        "sliceName" : "brandNameObservation",
        "short" : "Brand Name observation component",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:brandNameObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/BrandNameObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:modelNumberObservation",
        "path" : "Organizer.component",
        "sliceName" : "modelNumberObservation",
        "short" : "Model Number observation component",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:modelNumberObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ModelNumberObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:companyNameObservation",
        "path" : "Organizer.component",
        "sliceName" : "companyNameObservation",
        "short" : "Company Name observation component",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:companyNameObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CompanyNameObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:catalogNumberObservation",
        "path" : "Organizer.component",
        "sliceName" : "catalogNumberObservation",
        "short" : "Catalog Number observation component",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:catalogNumberObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CatalogNumberObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:latexSafetyObservation",
        "path" : "Organizer.component",
        "sliceName" : "latexSafetyObservation",
        "short" : "Latex Safety observation component",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:latexSafetyObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/LatexSafetyObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:mRISafetyObservation",
        "path" : "Organizer.component",
        "sliceName" : "mRISafetyObservation",
        "short" : "MRI Safety observation component",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:mRISafetyObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MRISafetyObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:implantableDeviceStatusObservation",
        "path" : "Organizer.component",
        "sliceName" : "implantableDeviceStatusObservation",
        "short" : "Implantable Device Status observation component",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organizer.component:implantableDeviceStatusObservation.observation",
        "path" : "Organizer.component.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImplantableDeviceStatusObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
