# Substance or Device Allergy - Intolerance Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Substance or Device Allergy - Intolerance Observation**

## Logical Model: Substance or Device Allergy - Intolerance Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceOrDeviceAllergyIntoleranceObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:SubstanceOrDeviceAllergyIntoleranceObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.24.3.90:2014-06-09 | |

 
This template reflects a discrete observation about a patient's allergy or intolerance to a substance or device. Because it is a discrete observation, it will have a statusCode of "completed". The effectiveTime, also referred to as the 'clinically relevant time' is the time at which the observation holds for the patient. For a provider seeing a patient in the clinic today, observing a history of penicillin allergy that developed five years ago, the effectiveTime is five years ago. 
The effectiveTime of the Substance or Device Allergy - Intolerance Observation is the definitive indication of whether or not the underlying allergy/intolerance is resolved. If known to be resolved, then an effectiveTime/high would be present. If the date of resolution is not known, then effectiveTime/high will be present with a nullFlavor of "UNK". 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AllergyStatusObservation](StructureDefinition-AllergyStatusObservation.md),[CriticalityObservation](StructureDefinition-CriticalityObservation.md),[ReactionObservation](StructureDefinition-ReactionObservation.md),[SeverityObservation](StructureDefinition-SeverityObservation.md) 

**Usages:**

* Derived from this Logical Model Profile: [Allergy - Intolerance Observation](StructureDefinition-AllergyIntoleranceObservation.md)
* Use this Logical Model Profile: [Health Concern Act](StructureDefinition-HealthConcernAct.md) and [Risk Concern Act](StructureDefinition-RiskConcernAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/SubstanceOrDeviceAllergyIntoleranceObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.csv), [Excel](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SubstanceOrDeviceAllergyIntoleranceObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceOrDeviceAllergyIntoleranceObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.24.3.90:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "SubstanceOrDeviceAllergyIntoleranceObservation",
  "title" : "Substance or Device Allergy - Intolerance Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template reflects a discrete observation about a patient's allergy or intolerance to a substance or device. Because it is a discrete observation, it will have a statusCode of \"completed\". The effectiveTime, also referred to as the 'clinically relevant time' is the time at which the observation holds for the patient. For a provider seeing a patient in the clinic today, observing a history of penicillin allergy that developed five years ago, the effectiveTime is five years ago. \n\nThe effectiveTime of the Substance or Device Allergy - Intolerance Observation is the definitive indication of whether or not the underlying allergy/intolerance is resolved. If known to be resolved, then an effectiveTime/high would be present. If the date of resolution is not known, then effectiveTime/high will be present with a nullFlavor of \"UNK\".\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AllergyStatusObservation](StructureDefinition-AllergyStatusObservation.html), [CriticalityObservation](StructureDefinition-CriticalityObservation.html), [ReactionObservation](StructureDefinition-ReactionObservation.html), [SeverityObservation](StructureDefinition-SeverityObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceOrDeviceAllergyIntoleranceObservation"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceOrDeviceAllergyIntoleranceObservation"
          },
          {
            "key" : "should-not-severity",
            "severity" : "warning",
            "human" : "Allergy SHOULD NOT include severity. Severity belongs at reaction level, while Criticality is used at the allergy level.",
            "expression" : "entryRelationship.observation.where(code.code = 'SEV' and code.codeSystem = '2.16.840.1.113883.5.4').empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceOrDeviceAllergyIntoleranceObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:substance-device-allergy-intolerance-obs",
        "path" : "Observation.templateId",
        "sliceName" : "substance-device-allergy-intolerance-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:substance-device-allergy-intolerance-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.24.3.90"
      },
      {
        "id" : "Observation.templateId:substance-device-allergy-intolerance-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" Observation (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1098-16303).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1098-16304).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-16307).",
        "min" : 1
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1098-16345)."
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"ASSERTION\" Assertion (CONF:1098-16346).",
        "min" : 1,
        "patternCode" : "ASSERTION"
      },
      {
        "id" : "Observation.code.codeSystem",
        "path" : "Observation.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.5.4\" (CodeSystem: HL7ActCode urn:oid:2.16.840.1.113883.5.4) (CONF:1098-32171).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.5.4"
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceOrDeviceAllergyIntoleranceObservation"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-16308).",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-26354).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "short" : "The effectiveTime/low (a.k.a. \"onset date\") asserts when the allergy/intolerance became clinically active. The effectiveTime/high (a.k.a. \"resolution date\") asserts when the allergy/intolerance became clinically resolved. If the allergy/intolerance is known to be resolved, but the date of resolution is not known, then the high element SHALL be present, and the nullFlavor attribute SHALL be set to 'UNK'.",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1098-16309).",
        "min" : 1
      },
      {
        "id" : "Observation.effectiveTime.low",
        "path" : "Observation.effectiveTime.low",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:1098-31536).",
        "min" : 1
      },
      {
        "id" : "Observation.effectiveTime.high",
        "path" : "Observation.effectiveTime.high",
        "comment" : "This effectiveTime MAY contain zero or one [0..1] high (CONF:1098-31537)."
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "comment" : "SHALL contain exactly one [1..1] value with @xsi:type=\"CD\" (CONF:1098-16312).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ]
      },
      {
        "id" : "Observation.value.nullFlavor",
        "path" : "Observation.value.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Observation.value.code",
        "path" : "Observation.value.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.3221.6.2"
        }
      },
      {
        "id" : "Observation.author",
        "path" : "Observation.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1098-31144).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Observation.participant",
        "path" : "Observation.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHOULD contain zero or more [0..*] participant (CONF:1098-16318) such that it"
      },
      {
        "id" : "Observation.participant:consumable",
        "path" : "Observation.participant",
        "sliceName" : "consumable",
        "short" : "participant",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.participant:consumable.typeCode",
        "path" : "Observation.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"CSM\" Consumable (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:1098-16319).",
        "fixedCode" : "CSM"
      },
      {
        "id" : "Observation.participant:consumable.participantRole",
        "path" : "Observation.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:1098-16320)."
      },
      {
        "id" : "Observation.participant:consumable.participantRole.classCode",
        "path" : "Observation.participant.participantRole.classCode",
        "comment" : "This participantRole SHALL contain exactly one [1..1] @classCode=\"MANU\" Manufactured Product (CodeSystem: HL7RoleClass urn:oid:2.16.840.1.113883.5.110 STATIC) (CONF:1098-16321).",
        "min" : 1,
        "fixedCode" : "MANU"
      },
      {
        "id" : "Observation.participant:consumable.participantRole.playingEntity",
        "path" : "Observation.participant.participantRole.playingEntity",
        "comment" : "This participantRole SHALL contain exactly one [1..1] playingEntity (CONF:1098-16322).",
        "min" : 1
      },
      {
        "id" : "Observation.participant:consumable.participantRole.playingEntity.classCode",
        "path" : "Observation.participant.participantRole.playingEntity.classCode",
        "comment" : "This playingEntity SHALL contain exactly one [1..1] @classCode=\"MMAT\" Manufactured Material (CodeSystem: HL7EntityClass urn:oid:2.16.840.1.113883.5.41 STATIC) (CONF:1098-16323).",
        "min" : 1,
        "fixedCode" : "MMAT"
      },
      {
        "id" : "Observation.participant:consumable.participantRole.playingEntity.code",
        "path" : "Observation.participant.participantRole.playingEntity.code",
        "comment" : "This playingEntity SHALL contain exactly one [1..1] code, which MAY be selected from ValueSet Substance Reactant for Intolerance urn:oid:2.16.840.1.113762.1.4.1010.1 DYNAMIC (CONF:1098-16324).",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.1"
        }
      },
      {
        "id" : "Observation.entryRelationship",
        "path" : "Observation.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHOULD contain zero or one [0..1] entryRelationship (CONF:1098-32935) such that it"
      },
      {
        "id" : "Observation.entryRelationship:status",
        "path" : "Observation.entryRelationship",
        "sliceName" : "status",
        "short" : "entryRelationship",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1098-16333) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.entryRelationship:status.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1098-16335).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Observation.entryRelationship:status.inversionInd",
        "path" : "Observation.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" True (CONF:1098-16334).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Observation.entryRelationship:status.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Allergy Status Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.28:2019-06-20) (CONF:1098-16336).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AllergyStatusObservation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:reaction",
        "path" : "Observation.entryRelationship",
        "sliceName" : "reaction",
        "short" : "entryRelationship",
        "comment" : "SHOULD contain zero or more [0..*] entryRelationship (CONF:1098-16337) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.entryRelationship:reaction.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"MFST\" Is Manifestation of (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1098-16339).",
        "fixedCode" : "MFST"
      },
      {
        "id" : "Observation.entryRelationship:reaction.inversionInd",
        "path" : "Observation.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" True (CONF:1098-16338).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Observation.entryRelationship:reaction.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Reaction Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.9:2014-06-09) (CONF:1098-16340).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReactionObservation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:severity",
        "path" : "Observation.entryRelationship",
        "sliceName" : "severity",
        "short" : "SHOULD NOT contain severity at the allergy level; severity belongs at the reaction level.",
        "comment" : "SHOULD NOT contain zero or one [0..1] entryRelationship (CONF:1098-16341) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-not-severity"]
      },
      {
        "id" : "Observation.entryRelationship:severity.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has Subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1098-16342).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Observation.entryRelationship:severity.inversionInd",
        "path" : "Observation.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" True (CONF:1098-16343).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Observation.entryRelationship:severity.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Severity Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.8:2014-06-09) (CONF:1098-16344).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SeverityObservation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:criticality",
        "path" : "Observation.entryRelationship",
        "sliceName" : "criticality",
        "short" : "entryRelationship",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.entryRelationship:criticality.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has Subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32936).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Observation.entryRelationship:criticality.inversionInd",
        "path" : "Observation.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" True (CONF:1098-32937).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Observation.entryRelationship:criticality.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Criticality Observation  (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.145) (CONF:1098-32938).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CriticalityObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
