# Social History Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Social History Observation**

## Logical Model: Social History Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:SocialHistoryObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.38:2022-06-01 | |

 
This template represents a patient's job (occupation and industry), lifestyle, and environmental health risk factors. Demographic data (e.g., marital status, race, ethnicity, religious affiliation) are captured in the header. Though tobacco use and exposure may be represented with a Social History Observation, it is recommended to use the Current Smoking Status template or the Tobacco Use template instead, to represent smoking or tobacco habits. There are supplemental templates and guidance for observations of[Occupational Data for Health](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=522),[nutrition](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=478)and[pregnancy](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=494)that could be captured in the Social History Observation, and implementers may want to consider using those more specific templates in the Social History section. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.md),[EntryReference](StructureDefinition-EntryReference.md) 

**Usages:**

* Derived from this Logical Model Profile: [Basic Industry Observation](StructureDefinition-BasicIndustryObservation.md), [Basic Occupation Observation](StructureDefinition-BasicOccupationObservation.md) and [Tribal Affiliation Observation](StructureDefinition-TribalAffiliationObservation.md)
* Use this Logical Model Profile: [Health Concern Act](StructureDefinition-HealthConcernAct.md), [Risk Concern Act](StructureDefinition-RiskConcernAct.md) and [Social History Section](StructureDefinition-SocialHistorySection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/SocialHistoryObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-SocialHistoryObservation.csv), [Excel](StructureDefinition-SocialHistoryObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SocialHistoryObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.38:2022-06-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "SocialHistoryObservation",
  "title" : "Social History Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents a patient's job (occupation and industry), lifestyle, and environmental health risk factors. Demographic data (e.g., marital status, race, ethnicity, religious affiliation) are captured in the header. Though tobacco use and exposure may be represented with a Social History Observation, it is recommended to use the Current Smoking Status template or the Tobacco Use template instead, to represent smoking or tobacco habits.\nThere are supplemental templates and guidance for observations of [Occupational Data for Health](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=522), [nutrition](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=478) and [pregnancy](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=494) that could be captured in the Social History Observation, and implementers may want to consider using those more specific templates in the Social History section.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.html), [EntryReference](StructureDefinition-EntryReference.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation"
          },
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation"
          },
          {
            "key" : "category-social-history",
            "severity" : "error",
            "human" : "If category is present, then there shall be a category with code 'social-history'.",
            "expression" : "sdtcCategory.empty() or sdtcCategory.exists(code = 'social-history' and codeSystem = '2.16.840.1.113883.4.642.1.1125')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation"
          },
          {
            "key" : "4515-8555",
            "severity" : "error",
            "human" : "If Observation/value is a physical quantity (xsi:type=\"PQ\"): This value SHALL contain exactly one [1..1] @unit, which SHOULD be selected from ValueSet UnitsOfMeasureCaseSensitive urn:oid:2.16.840.1.113883.1.11.12839 DYNAMIC. Note: Base CDA requires that all @unit values SHALL be drawn from UCUM.",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation"
          },
          {
            "key" : "should-value",
            "severity" : "warning",
            "human" : "SHOULD contain value",
            "expression" : "value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation"
          },
          {
            "key" : "should-sh-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:social-history-obs",
        "path" : "Observation.templateId",
        "sliceName" : "social-history-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:social-history-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.38"
      },
      {
        "id" : "Observation.templateId:social-history-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2022-06-01"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" Observation (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4515-8548).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:4515-8549).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:4515-8551).",
        "min" : 1
      },
      {
        "id" : "Observation.sdtcCategory",
        "path" : "Observation.sdtcCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "codeSystem"
            }
          ],
          "rules" : "open"
        },
        "short" : "Category is optional, but if present it SHALL contain a category with code=social-history.",
        "condition" : ["should-sdtcCategory", "category-social-history"]
      },
      {
        "id" : "Observation.sdtcCategory:social-history",
        "path" : "Observation.sdtcCategory",
        "sliceName" : "social-history",
        "short" : "Social History",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.sdtcCategory:social-history.code",
        "path" : "Observation.sdtcCategory.code",
        "min" : 1,
        "patternCode" : "social-history"
      },
      {
        "id" : "Observation.sdtcCategory:social-history.codeSystem",
        "path" : "Observation.sdtcCategory.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.4.642.1.1125"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "constraint" : [
          {
            "key" : "4515-32956",
            "severity" : "warning",
            "human" : "If @codeSystem is not LOINC, then this code **SHALL** contain at least one [1..*] translation, which **SHOULD** be selected from CodeSystem LOINC (urn:oid:2.16.840.1.113883.6.1) (CONF:4515-32956).",
            "expression" : "codeSystem = '2.16.840.1.113883.6.1' or translation.where(codeSystem = '2.16.840.1.113883.6.1').exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.28"
        }
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4515-8553).",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:4515-19117).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:4515-31868).",
        "min" : 1
      },
      {
        "id" : "Observation.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.value",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "𝗨𝗦𝗖𝗗𝗜: Alcohol Use, Substance Use, SDOH Problems/Health Concerns",
        "comment" : "SHOULD contain zero or one [0..1] value (CONF:4515-8559).",
        "max" : "1",
        "condition" : ["should-value"]
      },
      {
        "id" : "Observation.value:physical-quantity",
        "path" : "Observation.value",
        "sliceName" : "physical-quantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PQ"
          }
        ]
      },
      {
        "id" : "Observation.value:physical-quantity.unit",
        "path" : "Observation.value.unit",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-UnitsOfMeasureCaseSensitive"
        }
      },
      {
        "id" : "Observation.value:coded",
        "path" : "Observation.value",
        "sliceName" : "coded",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "binding" : {
          "strength" : "example",
          "description" : "See additional binding",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1196.788",
              "documentation" : "If the Social History Observation is a Social Determinant of Health Observation, the observation/value code **SHOULD** be selected from ValueSet [Social Determinant of Health Conditions 2.16.840.1.113762.1.4.1196.788](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.788/expansion) **DYNAMIC** (CONF:4515-32957).",
              "shortDoco" : "Social Determinant of Health Observations"
            }
          ]
        }
      },
      {
        "id" : "Observation.author",
        "path" : "Observation.author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:4515-31869).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-sh-author"]
      },
      {
        "id" : "Observation.entryRelationship",
        "path" : "Observation.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-32969) such that it"
      },
      {
        "id" : "Observation.entryRelationship:supportingObs",
        "path" : "Observation.entryRelationship",
        "sliceName" : "supportingObs",
        "short" : "When an Assessment Scale Observation is contained in a Social History Observation instance that is a Social Determinant of Health Social History Observation, that Assessment Scale Observation MAY contain Assessment Scale Supporting Observations that contain LOINC question and answer pairs from SDOH screening instruments.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-32958) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.entryRelationship:supportingObs.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SPRT\" Has support (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-32960).",
        "fixedCode" : "SPRT"
      },
      {
        "id" : "Observation.entryRelationship:supportingObs.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Assessment Scale Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.69) (CONF:4515-32959).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:entryReference",
        "path" : "Observation.entryRelationship",
        "sliceName" : "entryReference",
        "short" : "When an Entry Reference is contained in a Social History Template instance that is a Social Determinant of Health Social History, that Entry Reference **MAY** reference an Assessment Scale Observation elsewhere in the document that represent LOINC question and answer pairs from SDOH screening instruments.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.entryRelationship:entryReference.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SPRT\" Has support (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-32971).",
        "fixedCode" : "SPRT"
      },
      {
        "id" : "Observation.entryRelationship:entryReference.act",
        "path" : "Observation.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:4515-32970).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      }
    ]
  }
}

```
