# Service Delivery Location - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Service Delivery Location**

## Logical Model: Service Delivery Location 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ServiceDeliveryLocation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ServiceDeliveryLocation |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.32 | |

 
This clinical statement represents the physical place of available services or resources. It is the location of a service event where an act, observation or procedure took or can place. 
The ASTP/ONC U.S. Core Data for Interoperability (USCDI) specifies that Encounter Location must be represented using either the National Healthcare Safety Network (NHSN) Healthcare Facility Patient Care Location (HSLOC) codes or SNOMED CT location type codes. 
The HealthcareServiceLocation value set, bound to ParticipantRole.code, includes concepts from HSLOC, SNOMED CT, and CMS Place of Service (POS) codes to support a variety of implementation contexts. 
To conform with USCDI requirements, certifying systems shall support either HSLOC codes or SNOMED CT codes. Inclusion of CMS POS codes is optional and may be used to meet billing or administrative needs. 

**Usages:**

* Use this Logical Model Profile: [Encounter Activity](StructureDefinition-EncounterActivity.md), [Planned Encounter](StructureDefinition-PlannedEncounter.md) and [Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ServiceDeliveryLocation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ServiceDeliveryLocation.csv), [Excel](StructureDefinition-ServiceDeliveryLocation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ServiceDeliveryLocation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "participantRole"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ServiceDeliveryLocation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.32"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ServiceDeliveryLocation",
  "title" : "Service Delivery Location",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This clinical statement represents the physical place of available services or resources. It is the location of a service event where an act, observation or procedure took or can place.\n\nThe ASTP/ONC U.S. Core Data for Interoperability (USCDI) specifies that Encounter Location must be represented using either the National Healthcare Safety Network (NHSN) Healthcare Facility Patient Care Location (HSLOC) codes or SNOMED CT location type codes.\n\nThe HealthcareServiceLocation value set, bound to ParticipantRole.code, includes concepts from HSLOC, SNOMED CT, and CMS Place of Service (POS) codes to support a variety of implementation contexts.\n\nTo conform with USCDI requirements, certifying systems shall support either HSLOC codes or SNOMED CT codes. Inclusion of CMS POS codes is optional and may be used to meet billing or administrative needs.\n",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ParticipantRole",
        "path" : "ParticipantRole",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ServiceDeliveryLocation"
          },
          {
            "key" : "should-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ServiceDeliveryLocation"
          }
        ]
      },
      {
        "id" : "ParticipantRole.templateId",
        "path" : "ParticipantRole.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ParticipantRole.templateId:service-delivery-loc",
        "path" : "ParticipantRole.templateId",
        "sliceName" : "service-delivery-loc",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ParticipantRole.templateId:service-delivery-loc.root",
        "path" : "ParticipantRole.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.32"
      },
      {
        "id" : "ParticipantRole.templateId:service-delivery-loc.extension",
        "path" : "ParticipantRole.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "ParticipantRole.classCode",
        "path" : "ParticipantRole.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"SDLOC\" (CodeSystem: HL7RoleCode urn:oid:2.16.840.1.113883.5.111 STATIC) (CONF:81-7758).",
        "min" : 1,
        "fixedCode" : "SDLOC"
      },
      {
        "id" : "ParticipantRole.id",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ParticipantRole.id",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "short" : "𝗨𝗦𝗖𝗗𝗜: Facility Identifier",
        "comment" : "Systems SHALL support National Provider Identifier (NPI) for organizations and SHOULD support Clinical Laboratory Improvement Amendments (CLIA) for laboratories and the National Association of Insurance Commissioners NAIC Company code (sometimes called “NAIC Number” or “cocode”) for payers."
      },
      {
        "id" : "ParticipantRole.id:NPI",
        "path" : "ParticipantRole.id",
        "sliceName" : "NPI",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ParticipantRole.id:NPI.root",
        "path" : "ParticipantRole.id.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.4.6"
      },
      {
        "id" : "ParticipantRole.id:CLIA",
        "path" : "ParticipantRole.id",
        "sliceName" : "CLIA",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ParticipantRole.id:CLIA.root",
        "path" : "ParticipantRole.id.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.4.7"
      },
      {
        "id" : "ParticipantRole.id:NAIC",
        "path" : "ParticipantRole.id",
        "sliceName" : "NAIC",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "ParticipantRole.id:NAIC.root",
        "path" : "ParticipantRole.id.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.300"
      },
      {
        "id" : "ParticipantRole.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ParticipantRole.code",
        "min" : 1,
        "constraint" : [
          {
            "key" : "shall-use-one-binding",
            "severity" : "error",
            "human" : "The code shall belong to one of the value sets.",
            "expression" : "code.exists() implies (code.memberOf('http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.20275') or code.memberOf('http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.26') or code.memberOf('http://hl7.org/cda/us/ccda/ValueSet/CMSPlaceOfServiceCodes'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ServiceDeliveryLocation"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "𝗨𝗦𝗖𝗗𝗜: Facility Type",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.31",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://terminology.hl7.org/ValueSet/CMSPlaceOfServiceCodes",
              "documentation" : "Not required for USCDI certification",
              "shortDoco" : "CMS Place of Service"
            }
          ]
        }
      },
      {
        "id" : "ParticipantRole.addr",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ParticipantRole.addr",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Facility Address",
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "ParticipantRole.telecom",
        "path" : "ParticipantRole.telecom",
        "comment" : "SHOULD contain zero or more [0..*] telecom (CONF:81-7761)."
      },
      {
        "id" : "ParticipantRole.playingEntity",
        "path" : "ParticipantRole.playingEntity",
        "comment" : "MAY contain zero or one [0..1] playingEntity (CONF:81-7762).",
        "min" : 1
      },
      {
        "id" : "ParticipantRole.playingEntity.classCode",
        "path" : "ParticipantRole.playingEntity.classCode",
        "comment" : "The playingEntity, if present, SHALL contain exactly one [1..1] @classCode=\"PLC\" (CodeSystem: HL7EntityClass urn:oid:2.16.840.1.113883.5.41 STATIC) (CONF:81-7763).",
        "min" : 1,
        "fixedCode" : "PLC"
      },
      {
        "id" : "ParticipantRole.playingEntity.name",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ParticipantRole.playingEntity.name",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Facility Name",
        "min" : 1,
        "max" : "1"
      }
    ]
  }
}

```
