# Serial Number Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Serial Number Observation**

## Logical Model: Serial Number Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/SerialNumberObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:SerialNumberObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.319:2019-06-21 | |

 
This template is intended to be used in addition to the Product Instance template to exchange the Serial Number of the device. The serial number is parsed from the UDI value, if present. 

**Usages:**

* Use this Logical Model Profile: [UDI Organizer](StructureDefinition-UDIOrganizer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/SerialNumberObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-SerialNumberObservation.csv), [Excel](StructureDefinition-SerialNumberObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SerialNumberObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/SerialNumberObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.319:2019-06-21"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "SerialNumberObservation",
  "title" : "Serial Number Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template is intended to be used in addition to the Product Instance template to exchange the Serial Number of the device.  The serial number is parsed from the UDI value, if present.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SerialNumberObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:serial-num-obs",
        "path" : "Observation.templateId",
        "sliceName" : "serial-num-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:serial-num-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.319"
      },
      {
        "id" : "Observation.templateId:serial-num-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2019-06-21"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Code for \"Serial Number\"",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:4437-3374)."
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"C101671\" Serial Number  (CodeSystem: NCI Thesaurus (NCIt) urn:oid:2.16.840.1.113883.3.26.1.1 STATIC) (CONF:4437-3378).",
        "min" : 1,
        "patternCode" : "C101671"
      },
      {
        "id" : "Observation.code.codeSystem",
        "path" : "Observation.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.3.26.1.1\" (CONF:4437-3369).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.3.26.1.1"
      },
      {
        "id" : "Observation.code.codeSystemName",
        "path" : "Observation.code.codeSystemName",
        "short" : "MAY be set to 'NCI Thesaurus",
        "comment" : "This code MAY contain zero or one [0..1] @codeSystemName=\"NCI Thesaurus\" (CONF:4437-3370)."
      },
      {
        "id" : "Observation.code.displayName",
        "path" : "Observation.code.displayName",
        "short" : "MAY be set to 'Serial Number'",
        "comment" : "This code MAY contain zero or one [0..1] @displayName=\"Serial Number\" (CONF:4437-3379)."
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SerialNumberObservation"
          }
        ]
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "comment" : "SHALL contain exactly one [1..1] value with @xsi:type=\"ED\" (CONF:4437-3372).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ED"
          }
        ]
      }
    ]
  }
}

```
