# Sensory Status - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sensory Status**

## Logical Model: Sensory Status 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/SensoryStatus | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:SensoryStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.127 | |

 
This template represents a patient's sensory or speech ability. It may contain an assessment scale observations related to the sensory or speech ability. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Functional Status Section](StructureDefinition-FunctionalStatusSection.md), [Health Concern Act](StructureDefinition-HealthConcernAct.md) and [Risk Concern Act](StructureDefinition-RiskConcernAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/SensoryStatus)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-SensoryStatus.csv), [Excel](StructureDefinition-SensoryStatus.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SensoryStatus",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/SensoryStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.127"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "SensoryStatus",
  "title" : "Sensory Status",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents a patient's sensory or speech ability. It may contain an assessment scale observations related to the sensory or speech ability.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SensoryStatus"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SensoryStatus"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:sensory-status",
        "path" : "Observation.templateId",
        "sliceName" : "sensory-status",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:sensory-status.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.127"
      },
      {
        "id" : "Observation.templateId:sensory-status.extension",
        "path" : "Observation.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1098-31017).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1098-31018).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "comment" : "SHALL contain exactly one [1..1] code, which SHOULD be selected from ValueSet Sensory Status Problem Type urn:oid:2.16.840.1.113883.11.20.9.50 DYNAMIC (CONF:1098-27962).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.50"
        }
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/SensoryStatus"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-31437).",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-31438).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1098-31441).",
        "min" : 1
      },
      {
        "id" : "Observation.effectiveTime.low",
        "path" : "Observation.effectiveTime.low",
        "short" : "The effectiveTime/low (a.k.a. \"onset date\") asserts when the condition became biologically active.",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:1098-32630).",
        "min" : 1
      },
      {
        "id" : "Observation.effectiveTime.high",
        "path" : "Observation.effectiveTime.high",
        "short" : "The effectiveTime/high (a.k.a. \"resolution date\") asserts when the condition became biologically resolved.",
        "comment" : "This effectiveTime MAY contain zero or one [0..1] high (CONF:1098-32631)."
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "comment" : "SHALL contain exactly one [1..1] value with @xsi:type=\"CD\", where the code SHOULD be selected from ValueSet Mental and Functional Status Response urn:oid:2.16.840.1.113883.11.20.9.44 DYNAMIC (CONF:1098-27974).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.44"
        }
      },
      {
        "id" : "Observation.author",
        "path" : "Observation.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1098-31439).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Observation.entryRelationship",
        "path" : "Observation.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.entryRelationship:assessmentScaleObservation",
        "path" : "Observation.entryRelationship",
        "sliceName" : "assessmentScaleObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-27984) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.entryRelationship:assessmentScaleObservation.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SPRT\" has support (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1098-27985).",
        "fixedCode" : "SPRT"
      },
      {
        "id" : "Observation.entryRelationship:assessmentScaleObservation.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Assessment Scale Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.69) (CONF:1098-27986).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
