# Risk Concern Act - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risk Concern Act**

## Logical Model: Risk Concern Act 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/RiskConcernAct | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:RiskConcernAct |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.136:2015-08-01 | |

 
This template represents a risk concern. 
It is a wrapper for a single risk concern which may be derived from a variety of sources within an EHR (such as Problem List, Family History, Social History, Social Worker Note, etc.). 
A Risk Concern Act represents a health concern that is a risk. A risk is a clinical or socioeconomic condition that the patient does not currently have, but the probability of developing that condition rises to the level of concern such that an intervention and/or monitoring is needed. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AllergyIntoleranceObservation](StructureDefinition-AllergyIntoleranceObservation.md),[AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.md),[CaregiverCharacteristics](StructureDefinition-CaregiverCharacteristics.md),[CharacteristicsofHomeEnvironment](StructureDefinition-CharacteristicsofHomeEnvironment.md),[CulturalandReligiousObservation](StructureDefinition-CulturalandReligiousObservation.md),[EncounterDiagnosis](StructureDefinition-EncounterDiagnosis.md),[EntryReference](StructureDefinition-EntryReference.md),[FamilyHistoryOrganizer](StructureDefinition-FamilyHistoryOrganizer.md),[FunctionalStatusObservation](StructureDefinition-FunctionalStatusObservation.md),[HospitalAdmissionDiagnosis](StructureDefinition-HospitalAdmissionDiagnosis.md),[LongitudinalCareWoundObservation](StructureDefinition-LongitudinalCareWoundObservation.md),[MentalStatusObservation](StructureDefinition-MentalStatusObservation.md),[NutritionAssessment](StructureDefinition-NutritionAssessment.md),[NutritionalStatusObservation](StructureDefinition-NutritionalStatusObservation.md),[PostprocedureDiagnosis](StructureDefinition-PostprocedureDiagnosis.md),[PregnancyStatusObservation](StructureDefinition-PregnancyStatusObservation.md),[PreoperativeDiagnosis](StructureDefinition-PreoperativeDiagnosis.md),[PriorityPreference](StructureDefinition-PriorityPreference.md),[ProblemConcernAct](StructureDefinition-ProblemConcernAct.md),[ProblemObservation](StructureDefinition-ProblemObservation.md),[ReactionObservation](StructureDefinition-ReactionObservation.md),[ResultObservation](StructureDefinition-ResultObservation.md),[ResultOrganizer](StructureDefinition-ResultOrganizer.md),[SelfCareActivitiesADLandIADL](StructureDefinition-SelfCareActivitiesADLandIADL.md),[SensoryStatus](StructureDefinition-SensoryStatus.md),[SmokingStatus](StructureDefinition-SmokingStatus.md),[SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.md),[SubstanceOrDeviceAllergyIntoleranceObservation](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.md),[VitalSignObservation](StructureDefinition-VitalSignObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Health Concerns Section](StructureDefinition-HealthConcernsSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/RiskConcernAct)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-RiskConcernAct.csv), [Excel](StructureDefinition-RiskConcernAct.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RiskConcernAct",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/RiskConcernAct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.136:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "RiskConcernAct",
  "title" : "Risk Concern Act",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents a risk concern. \n\nIt is a wrapper for a single risk concern which may be derived from a variety of sources within an EHR (such as Problem List, Family History, Social History, Social Worker Note, etc.). \n\nA Risk Concern Act represents a health concern that is a risk. A risk is a clinical or socioeconomic condition that the patient does not currently have, but the probability of developing that condition rises to the level of concern such that an intervention and/or monitoring is needed.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AllergyIntoleranceObservation](StructureDefinition-AllergyIntoleranceObservation.html), [AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.html), [CaregiverCharacteristics](StructureDefinition-CaregiverCharacteristics.html), [CharacteristicsofHomeEnvironment](StructureDefinition-CharacteristicsofHomeEnvironment.html), [CulturalandReligiousObservation](StructureDefinition-CulturalandReligiousObservation.html), [EncounterDiagnosis](StructureDefinition-EncounterDiagnosis.html), [EntryReference](StructureDefinition-EntryReference.html), [FamilyHistoryOrganizer](StructureDefinition-FamilyHistoryOrganizer.html), [FunctionalStatusObservation](StructureDefinition-FunctionalStatusObservation.html), [HospitalAdmissionDiagnosis](StructureDefinition-HospitalAdmissionDiagnosis.html), [LongitudinalCareWoundObservation](StructureDefinition-LongitudinalCareWoundObservation.html), [MentalStatusObservation](StructureDefinition-MentalStatusObservation.html), [NutritionAssessment](StructureDefinition-NutritionAssessment.html), [NutritionalStatusObservation](StructureDefinition-NutritionalStatusObservation.html), [PostprocedureDiagnosis](StructureDefinition-PostprocedureDiagnosis.html), [PregnancyStatusObservation](StructureDefinition-PregnancyStatusObservation.html), [PreoperativeDiagnosis](StructureDefinition-PreoperativeDiagnosis.html), [PriorityPreference](StructureDefinition-PriorityPreference.html), [ProblemConcernAct](StructureDefinition-ProblemConcernAct.html), [ProblemObservation](StructureDefinition-ProblemObservation.html), [ReactionObservation](StructureDefinition-ReactionObservation.html), [ResultObservation](StructureDefinition-ResultObservation.html), [ResultOrganizer](StructureDefinition-ResultOrganizer.html), [SelfCareActivitiesADLandIADL](StructureDefinition-SelfCareActivitiesADLandIADL.html), [SensoryStatus](StructureDefinition-SensoryStatus.html), [SmokingStatus](StructureDefinition-SmokingStatus.html), [SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.html), [SubstanceOrDeviceAllergyIntoleranceObservation](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.html), [VitalSignObservation](StructureDefinition-VitalSignObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/RiskConcernAct"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/RiskConcernAct"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:risk-concern-act",
        "path" : "Act.templateId",
        "sliceName" : "risk-concern-act",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:risk-concern-act.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.136"
      },
      {
        "id" : "Act.templateId:risk-concern-act.extension",
        "path" : "Act.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1198-32220).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1198-32221).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1198-32223).",
        "min" : 1
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "short" : "At risk - finding",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1198-32305)."
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "min" : 1,
        "patternCode" : "281694009"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "short" : "SNOMED CT",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.96"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/RiskConcernAct"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1198-32225).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.nullFlavor",
        "path" : "Act.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.19"
        }
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "comment" : "MAY contain zero or one [0..1] effectiveTime (CONF:1198-32226)."
      },
      {
        "id" : "Act.author",
        "path" : "Act.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1198-32300).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            },
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "organizer"
            }
          ],
          "rules" : "open"
        },
        "short" : "Where a Health Concern needs to reference another entry already described in the CDA document instance, rather than repeating the full content of the entry, the Entry Reference template may be used to reference this entry."
      },
      {
        "id" : "Act.entryRelationship:problemObservation1",
        "path" : "Act.entryRelationship",
        "sliceName" : "problemObservation1",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32179) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:problemObservation1.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32227).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:problemObservation1.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Problem Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.4:2015-08-01) (CONF:1198-32219).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:allergy-IntoleranceObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "allergy-IntoleranceObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32181) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:allergy-IntoleranceObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32228).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:allergy-IntoleranceObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Allergy - Intolerance Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.7:2014-06-09) (CONF:1198-32229).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AllergyIntoleranceObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:entryReferenceRefr",
        "path" : "Act.entryRelationship",
        "sliceName" : "entryReferenceRefr",
        "short" : "The following entryRelationship represents the relationship between two Health Concern Acts where there is a general relationship between the source and the target (Health Concern RELATES TO Health Concern). It can also represent the relationship between a Health Concern and another entry already described in the CDA document instance. The Entry Reference template is used here because the target entry will be defined elsewhere and thus a reference to that instance is all that is required.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32182) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:entryReferenceRefr.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32230).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:entryReferenceRefr.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:1198-32231).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:entryReferenceComp",
        "path" : "Act.entryRelationship",
        "sliceName" : "entryReferenceComp",
        "short" : "The following entryRelationship represents the relationship between two Health Concern Acts where the target is a component of the source (Health Concern HAS COMPONENT Health Concern). The Enry Reference template is used here because the target Health Concern Act will be defined elsewhere in the Health Concerns Section and thus a reference to that template is all that is required.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32183) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:entryReferenceComp.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32232).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Act.entryRelationship:entryReferenceComp.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:1198-32233).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:assessmentScaleObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "assessmentScaleObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32184) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:assessmentScaleObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32234).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:assessmentScaleObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Assessment Scale Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.69) (CONF:1198-32235).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:mentalStatusObservation1",
        "path" : "Act.entryRelationship",
        "sliceName" : "mentalStatusObservation1",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32185) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:mentalStatusObservation1.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32236).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:mentalStatusObservation1.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Mental Status Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.74:2015-08-01) (CONF:1198-32237).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:self-CareActivitiesADLandIADL",
        "path" : "Act.entryRelationship",
        "sliceName" : "self-CareActivitiesADLandIADL",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32186) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:self-CareActivitiesADLandIADL.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32238).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:self-CareActivitiesADLandIADL.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Self-Care Activities (ADL and IADL) (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.128) (CONF:1198-32239).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SelfCareActivitiesADLandIADL"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:mentalStatusObservation2",
        "path" : "Act.entryRelationship",
        "sliceName" : "mentalStatusObservation2",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32188) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:mentalStatusObservation2.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32242).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:mentalStatusObservation2.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Mental Status Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.74:2015-08-01) (CONF:1198-32243).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:smokingStatus",
        "path" : "Act.entryRelationship",
        "sliceName" : "smokingStatus",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32189) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:smokingStatus.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32244).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:smokingStatus.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Smoking Status (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.511:2024-05-01) (CONF:1198-32245).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SmokingStatus"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:encounterDiagnosis",
        "path" : "Act.entryRelationship",
        "sliceName" : "encounterDiagnosis",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32190) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:encounterDiagnosis.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32246).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:encounterDiagnosis.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Encounter Diagnosis (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.80:2015-08-01) (CONF:1198-32247).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterDiagnosis"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:entryRelationship11",
        "path" : "Act.entryRelationship",
        "sliceName" : "entryRelationship11",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32191) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:entryRelationship11.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers To (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32248).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:entryRelationship11.organizer",
        "path" : "Act.entryRelationship.organizer",
        "comment" : "SHALL contain exactly one [1..1] Family History Organizer (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.45:2015-08-01) (CONF:1198-32249).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryOrganizer"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:functionalStatusObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "functionalStatusObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32192) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:functionalStatusObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32250).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:functionalStatusObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Functional Status Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.67:2014-06-09) (CONF:1198-32251).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:hospitalAdmissionDiagnosis",
        "path" : "Act.entryRelationship",
        "sliceName" : "hospitalAdmissionDiagnosis",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32193) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:hospitalAdmissionDiagnosis.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32252).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:hospitalAdmissionDiagnosis.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Hospital Admission Diagnosis (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.34:2015-08-01) (CONF:1198-32253).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalAdmissionDiagnosis"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:nutritionAssessment",
        "path" : "Act.entryRelationship",
        "sliceName" : "nutritionAssessment",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32195) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:nutritionAssessment.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32256).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:nutritionAssessment.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Nutrition Assessment (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.138) (CONF:1198-32257).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionAssessment"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:postprocedureDiagnosis",
        "path" : "Act.entryRelationship",
        "sliceName" : "postprocedureDiagnosis",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32197) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:postprocedureDiagnosis.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32260).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:postprocedureDiagnosis.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Postprocedure Diagnosis (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.51:2015-08-01) (CONF:1198-32261).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PostprocedureDiagnosis"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:pregnancyStatusObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "pregnancyStatusObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32198) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:pregnancyStatusObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32262).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:pregnancyStatusObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Pregnancy Status Observation (identifier: urn:oid:2.16.840.1.113883.10.20.15.3.8) (CONF:1198-32263).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PregnancyStatusObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:preoperativeDiagnosis",
        "path" : "Act.entryRelationship",
        "sliceName" : "preoperativeDiagnosis",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32199) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:preoperativeDiagnosis.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32264).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:preoperativeDiagnosis.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Preoperative Diagnosis (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.65:2015-08-01) (CONF:1198-32265).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosis"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:reactionObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "reactionObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32200) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:reactionObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32266).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:reactionObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Reaction Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.9:2014-06-09) (CONF:1198-32267).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReactionObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:resultObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "resultObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32201) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:resultObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32268).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:resultObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Result Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.2:2015-08-01) (CONF:1198-32269).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:sensoryStatus",
        "path" : "Act.entryRelationship",
        "sliceName" : "sensoryStatus",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32202) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:sensoryStatus.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32270).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:sensoryStatus.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Sensory Status (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.127) (CONF:1198-32271).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SensoryStatus"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:socialHistoryObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "socialHistoryObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32203) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:socialHistoryObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32272).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:socialHistoryObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Social History Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.38:2015-08-01) (CONF:1198-32273).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:substanceorDeviceAllergy-IntoleranceObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "substanceorDeviceAllergy-IntoleranceObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32204) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:substanceorDeviceAllergy-IntoleranceObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32958).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:substanceorDeviceAllergy-IntoleranceObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Substance or Device Allergy - Intolerance Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.24.3.90:2014-06-09) (CONF:1198-32275).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceOrDeviceAllergyIntoleranceObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:vitalSignObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "vitalSignObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32206) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:vitalSignObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32278).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:vitalSignObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Vital Sign Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.27:2014-06-09) (CONF:1198-32279).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:longitudinalCareWoundObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "longitudinalCareWoundObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32207) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:longitudinalCareWoundObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32280).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:longitudinalCareWoundObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Longitudinal Care Wound Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.114:2015-08-01) (CONF:1198-32281).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/LongitudinalCareWoundObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:problemObservation2",
        "path" : "Act.entryRelationship",
        "sliceName" : "problemObservation2",
        "short" : "The following entryRelationship represents the relationship Health Concern HAS SUPPORT Observation.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32208) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:problemObservation2.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SPRT\" Has support (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32282).",
        "fixedCode" : "SPRT"
      },
      {
        "id" : "Act.entryRelationship:problemObservation2.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Problem Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.4:2015-08-01) (CONF:1198-32283).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:caregiverCharacteristics",
        "path" : "Act.entryRelationship",
        "sliceName" : "caregiverCharacteristics",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32209) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:caregiverCharacteristics.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32284).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:caregiverCharacteristics.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Caregiver Characteristics (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.72) (CONF:1198-32285).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CaregiverCharacteristics"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:culturalandReligiousObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "culturalandReligiousObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32210) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:culturalandReligiousObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32286).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:culturalandReligiousObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Cultural and Religious Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.111) (CONF:1198-32287).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CulturalandReligiousObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:characteristicsofHomeEnvironment",
        "path" : "Act.entryRelationship",
        "sliceName" : "characteristicsofHomeEnvironment",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32211) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:characteristicsofHomeEnvironment.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32288).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:characteristicsofHomeEnvironment.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Characteristics of Home Environment (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.109) (CONF:1198-32289).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/CharacteristicsofHomeEnvironment"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:nutritionalStatusObservation",
        "path" : "Act.entryRelationship",
        "sliceName" : "nutritionalStatusObservation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32212) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:nutritionalStatusObservation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32290).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:nutritionalStatusObservation.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Nutritional Status Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.124) (CONF:1198-32291).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionalStatusObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:resultOrganizer",
        "path" : "Act.entryRelationship",
        "sliceName" : "resultOrganizer",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32213) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:resultOrganizer.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32292).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:resultOrganizer.organizer",
        "path" : "Act.entryRelationship.organizer",
        "comment" : "SHALL contain exactly one [1..1] Result Organizer (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.1:2015-08-01) (CONF:1198-32293).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ResultOrganizer"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:priorityPreference1",
        "path" : "Act.entryRelationship",
        "sliceName" : "priorityPreference1",
        "short" : "The following entryRelationship represents the priority that the patient puts on the health concern.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32214) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:priorityPreference1.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32294).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:priorityPreference1.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Priority Preference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.143) (CONF:1198-32295).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PriorityPreference"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:priorityPreference2",
        "path" : "Act.entryRelationship",
        "sliceName" : "priorityPreference2",
        "short" : "The following entryRelationship represents the priority that the provider puts on the health concern.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32215) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:priorityPreference2.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32296).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:priorityPreference2.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Priority Preference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.143) (CONF:1198-32297).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PriorityPreference"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:problemConcernAct",
        "path" : "Act.entryRelationship",
        "sliceName" : "problemConcernAct",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32216) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:problemConcernAct.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32298).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:problemConcernAct.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Problem Concern Act (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.3:2015-08-01) (CONF:1198-32299).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemConcernAct"
            ]
          }
        ]
      },
      {
        "id" : "Act.reference",
        "path" : "Act.reference",
        "comment" : "MAY contain zero or more [0..*] reference (CONF:1198-32769)."
      },
      {
        "id" : "Act.reference.typeCode",
        "path" : "Act.reference.typeCode",
        "comment" : "The reference, if present, SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32908).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.reference.externalDocument",
        "path" : "Act.reference.externalDocument",
        "comment" : "The reference, if present, SHALL contain exactly one [1..1] External Document Reference (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.115:2014-06-09) (CONF:1198-32909).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ExternalDocument",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ExternalDocumentReference"
            ]
          }
        ]
      }
    ]
  }
}

```
