# Related Person Relationship and Name Participant - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Related Person Relationship and Name Participant**

## Logical Model: Related Person Relationship and Name Participant 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/RelatedPersonRelationshipAndNameParticipant | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:RelatedPersonRelationshipAndNameParticipant |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.5.8:2023-05-01 | |

 
This template represents a generic participant person that has a relationship to the patient. (e.g., parent, next-of-kin, neighbor). The related person's name is required and it is recommended that the person's contact information is present. The more specific CDA participant of Guardian (recordTarget/patientRole/patient/guardian) can be used to represent a legally responsible guardian of the patient within the header. This template may be used to represent a person with any relationship to the patient within the header, or at the entry level when pertinent to a particular clinical statement. 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/RelatedPersonRelationshipAndNameParticipant)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.csv), [Excel](StructureDefinition-RelatedPersonRelationshipAndNameParticipant.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RelatedPersonRelationshipAndNameParticipant",
  "meta" : {
    "versionId" : "4",
    "lastUpdated" : "2023-07-11T23:42:06.321Z"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "participant"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/RelatedPersonRelationshipAndNameParticipant",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.5.8:2023-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "RelatedPersonRelationshipAndNameParticipant",
  "title" : "Related Person Relationship and Name Participant",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents a generic participant person that has a relationship to the patient. (e.g., parent, next-of-kin, neighbor). The related person's name is required and it is recommended that the person's contact information is present. The more specific CDA participant of Guardian (recordTarget/patientRole/patient/guardian) can be used to represent a legally responsible guardian of the patient within the header. This template may be used to represent a person with any relationship to the patient within the header, or at the entry level when pertinent to a particular clinical statement.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Participant1",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Participant1",
        "path" : "Participant1"
      },
      {
        "id" : "Participant1.templateId",
        "path" : "Participant1.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Participant1.templateId:related-person",
        "path" : "Participant1.templateId",
        "sliceName" : "related-person",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Participant1.templateId:related-person.root",
        "path" : "Participant1.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.5.8"
      },
      {
        "id" : "Participant1.templateId:related-person.extension",
        "path" : "Participant1.templateId.extension",
        "min" : 1,
        "patternString" : "2023-05-01"
      },
      {
        "id" : "Participant1.typeCode",
        "path" : "Participant1.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"IND\" Indirect (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90) (CONF:4537-32982).",
        "fixedCode" : "IND"
      },
      {
        "id" : "Participant1.associatedEntity",
        "path" : "Participant1.associatedEntity",
        "comment" : "SHALL contain exactly one [1..1] associatedEntity (CONF:4537-32978).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/RelatedPersonRelationshipAndNameParticipant"
          },
          {
            "key" : "should-telecom",
            "severity" : "warning",
            "human" : "SHOULD contain telecom",
            "expression" : "telecom.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/RelatedPersonRelationshipAndNameParticipant"
          }
        ]
      },
      {
        "id" : "Participant1.associatedEntity.classCode",
        "path" : "Participant1.associatedEntity.classCode",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] code, which SHALL be selected from ValueSet Personal And Legal Relationship Role Type  2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:4537-32985)."
      },
      {
        "id" : "Participant1.associatedEntity.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Participant1.associatedEntity.code",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Related Person's Relationship - This associatedEntity/code represents the person's relationship to the patient.",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] code, which SHALL be selected from ValueSet Personal And Legal Relationship Role Type urn:oid:2.16.840.1.113883.11.20.12.1 DYNAMIC (CONF:4537-32985).",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.12.1"
        }
      },
      {
        "id" : "Participant1.associatedEntity.sdtcSpecialty",
        "path" : "Participant1.associatedEntity.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "Participant1.associatedEntity.addr",
        "path" : "Participant1.associatedEntity.addr",
        "comment" : "This associatedEntity SHOULD contain zero or more [0..*] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-32979).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Participant1.associatedEntity.telecom",
        "path" : "Participant1.associatedEntity.telecom",
        "comment" : "This associatedEntity SHOULD contain zero or more [0..*] telecom (CONF:4537-32986)."
      },
      {
        "id" : "Participant1.associatedEntity.associatedPerson",
        "path" : "Participant1.associatedEntity.associatedPerson",
        "short" : "The associatedPerson represents the name and contact information of the related person",
        "comment" : "This associatedEntity SHALL contain exactly one [1..1] associatedPerson (CONF:4537-32980).",
        "min" : 1
      },
      {
        "id" : "Participant1.associatedEntity.associatedPerson.name",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Participant1.associatedEntity.associatedPerson.name",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Related Person's Name",
        "comment" : "This associatedPerson SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:4537-32987).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      }
    ]
  }
}

```
