# Product Instance - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Product Instance**

## Logical Model: Product Instance 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ProductInstance | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ProductInstance |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.37 | |

 
This clinical statement represents a particular device that was placed in a patient or used as part of a procedure or other act. This provides a record of the identifier and other details about the given product that was used. For example, it is important to have a record that indicates not just that a hip prostheses was placed in a patient but that it was a particular hip prostheses number with a unique identifier. 
The FDA Amendments Act specifies the creation of a Unique Device Identification (UDI) System that requires the label of devices to bear a unique identifier that will standardize device identification and identify the device through distribution and use. 
The FDA permits an issuing agency to designate that their Device Identifier (DI) + Production Identifier (PI) format qualifies as a UDI through a process of accreditation. Currently, there are three FDA-accredited issuing agencies that are allowed to call their format a UDI. These organizations are GS1, HIBCC, and ICCBBA. For additional information on technical formats that qualify as UDI from each of the issuing agencies see the UDI Appendix. 
When communicating only the issuing agency device identifier (i.e., subcomponent of the UDI), the use of the issuing agency OID is appropriate. However, when communicating the unique device identifier (DI + PI), the FDA OID (2.16.840.1.113883.3.3719) must be used. When sending a UDI, populate the participantRole/id/@root with the FDA OID (2.16.840.1.113883.3.3719) and participantRole/id/@extension with the UDI. 
When sending a DI, populate the participantRole/id/@root with the appropriate assigning agency OID and participantRole/id/@extension with the DI. The scopingEntity/id should correspond to FDA or the appropriate issuing agency. 

**Usages:**

* Use this Logical Model Profile: [Non-Medicinal Supply Activity](StructureDefinition-NonMedicinalSupplyActivity.md), [Planned Supply](StructureDefinition-PlannedSupply.md) and [Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ProductInstance)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ProductInstance.csv), [Excel](StructureDefinition-ProductInstance.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ProductInstance",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "participantRole"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProductInstance",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.37"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ProductInstance",
  "title" : "Product Instance",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This clinical statement represents a particular device that was placed in a patient or used as part of a procedure or other act. This provides a record of the identifier and other details about the given product that was used. For example, it is important to have a record that indicates not just that a hip prostheses was placed in a patient but that it was a particular hip prostheses number with a unique identifier.\n\nThe FDA Amendments Act specifies the creation of a Unique Device Identification (UDI) System that requires the label of devices to bear a unique identifier that will standardize device identification and identify the device through distribution and use. \n\nThe FDA permits an issuing agency to designate that their Device Identifier (DI) + Production Identifier (PI) format qualifies as a UDI through a process of accreditation. Currently, there are three FDA-accredited issuing agencies that are allowed to call their format a UDI. These organizations are GS1, HIBCC, and ICCBBA. For additional information on technical formats that qualify as UDI from each of the issuing agencies see the UDI Appendix.\n\nWhen communicating only the issuing agency device identifier (i.e., subcomponent of the UDI), the use of the issuing agency OID is appropriate. However, when communicating the unique device identifier (DI + PI), the FDA OID (2.16.840.1.113883.3.3719) must be used. \nWhen sending a UDI, populate the participantRole/id/@root with the FDA OID (2.16.840.1.113883.3.3719) and participantRole/id/@extension with the UDI.\n\nWhen sending a DI, populate the participantRole/id/@root with the appropriate assigning agency OID and participantRole/id/@extension with the DI.\nThe scopingEntity/id should correspond to FDA or the appropriate issuing agency.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ParticipantRole.templateId",
        "path" : "ParticipantRole.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ParticipantRole.templateId:product-instance",
        "path" : "ParticipantRole.templateId",
        "sliceName" : "product-instance",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ParticipantRole.templateId:product-instance.root",
        "path" : "ParticipantRole.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.37"
      },
      {
        "id" : "ParticipantRole.templateId:product-instance.extension",
        "path" : "ParticipantRole.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "ParticipantRole.classCode",
        "path" : "ParticipantRole.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"MANU\" Manufactured Product (CodeSystem: HL7RoleClass urn:oid:2.16.840.1.113883.5.110 STATIC) (CONF:81-7900).",
        "min" : 1,
        "fixedCode" : "MANU"
      },
      {
        "id" : "ParticipantRole.id",
        "path" : "ParticipantRole.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:81-7902).",
        "min" : 1
      },
      {
        "id" : "ParticipantRole.playingDevice",
        "path" : "ParticipantRole.playingDevice",
        "comment" : "SHALL contain exactly one [1..1] playingDevice (CONF:81-7903).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProductInstance"
          }
        ]
      },
      {
        "id" : "ParticipantRole.playingDevice.code",
        "path" : "ParticipantRole.playingDevice.code",
        "comment" : "This playingDevice SHOULD contain zero or one [0..1] code, which SHOULD be selected from ValueSet Device Type urn:oid:2.16.840.1.113762.1.4.1267.36 DYNAMIC.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.36"
        }
      },
      {
        "id" : "ParticipantRole.scopingEntity",
        "path" : "ParticipantRole.scopingEntity",
        "comment" : "SHALL contain exactly one [1..1] scopingEntity (CONF:81-7905).",
        "min" : 1
      },
      {
        "id" : "ParticipantRole.scopingEntity.id",
        "path" : "ParticipantRole.scopingEntity.id",
        "comment" : "This scopingEntity SHALL contain at least one [1..*] id (CONF:81-7908).",
        "min" : 1
      }
    ]
  }
}

```
