# Problem Concern Act - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Problem Concern Act**

## Logical Model: Problem Concern Act 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ProblemConcernAct | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ProblemConcernAct |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.3:2024-05-01 | |

 
This template reflects an ongoing concern on behalf of the provider that placed the concern on a patient's problem list. So long as the underlying condition is of concern to the provider (i.e., as long as the condition, whether active or resolved, is of ongoing concern and interest to the provider), the statusCode is "active". Only when the underlying condition is no longer of concern is the statusCode set to "completed". The effectiveTime reflects the time that the underlying condition was felt to be a concern; it may or may not correspond to the effectiveTime of the condition (e.g., even five years later, the clinician may remain concerned about a prior heart attack). 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required EntryRelationships**:[ProblemObservation](StructureDefinition-ProblemObservation.md) 
**Optional EntryRelationships**:[PriorityPreference](StructureDefinition-PriorityPreference.md) 

### Problem Concern Act Timing and Status

The statusCode of the Problem Concern Act is the definitive indication of the status of the concern, whereas the effectiveTime of the nested Problem Observation is the definitive indication of whether or not the underlying condition is resolved.

The effectiveTime/low of the Problem Concern Act asserts when the concern became active. The effectiveTime/high asserts when the concern was completed (e.g., when the clinician deemed there is no longer any need to track the underlying condition).

Problem Concern Act Timing Detail


A Problem Concern Act SHALL contain one Problem Observation (templateId 2.16.840.1.113883.10.20.22.4.4). The Problem Observation is a discrete observation of a condition, and therefore will have a statusCode of "completed". For instance, a Concern may contain a Problem Observation of "chest pain" that is still ongoing:

* Problem Concern 1 — Problem Observation: Chest Pain (effectiveTime.high is empty) Or a Concern may contain a Problem Observation of "chest pain" that is still worrisome but the problem happened in the past:
* Problem Concern 1 — Problem Observation: Chest Pain (effectiveTime.high is present and in the past) Many systems display the nested Problem Observation with the most recent author time stamp, and provide a mechanism for viewing prior observations.

**Usages:**

* Use this Logical Model Profile: [Problem Section](StructureDefinition-ProblemSection.md) and [Risk Concern Act](StructureDefinition-RiskConcernAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ProblemConcernAct)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ProblemConcernAct.csv), [Excel](StructureDefinition-ProblemConcernAct.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ProblemConcernAct",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemConcernAct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.3:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ProblemConcernAct",
  "title" : "Problem Concern Act",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template reflects an ongoing concern on behalf of the provider that placed the concern on a patient's problem list. So long as the underlying condition is of concern to the provider (i.e., as long as the condition, whether active or resolved, is of ongoing concern and interest to the provider), the statusCode is \"active\". Only when the underlying condition is no longer of concern is the statusCode set to \"completed\". The effectiveTime reflects the time that the underlying condition was felt to be a concern; it may or may not correspond to the effectiveTime of the condition (e.g., even five years later, the clinician may remain concerned about a prior heart attack).\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required EntryRelationships**: [ProblemObservation](StructureDefinition-ProblemObservation.html)\n\n**Optional EntryRelationships**: [PriorityPreference](StructureDefinition-PriorityPreference.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemConcernAct"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemConcernAct"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:problem-concern-act",
        "path" : "Act.templateId",
        "sliceName" : "problem-concern-act",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:problem-concern-act.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.3"
      },
      {
        "id" : "Act.templateId:problem-concern-act.extension",
        "path" : "Act.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" Act (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1198-9024).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1198-9025).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1198-9026).",
        "min" : 1
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1198-9027)."
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"CONC\" Concern (CONF:1198-19184).",
        "min" : 1,
        "patternCode" : "CONC"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.5.6\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1198-32168).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.5.6"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemConcernAct"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "short" : "The statusCode of the Problem Concern Act is the definitive indication of the status of the concern, whereas the effectiveTime of the nested Problem Observation is the definitive indication of whether or not the underlying condition is resolved.",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1198-9029).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.nullFlavor",
        "path" : "Act.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.19"
        }
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1198-9030).",
        "min" : 1
      },
      {
        "id" : "Act.effectiveTime.low",
        "path" : "Act.effectiveTime.low",
        "short" : "The effectiveTime/low of the Problem Concern Act asserts when the concern became active.",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:1198-9032).",
        "min" : 1
      },
      {
        "id" : "Act.effectiveTime.high",
        "path" : "Act.effectiveTime.high",
        "short" : "The effectiveTime/high asserts when the concern was completed (e.g., when the clinician deemed there is no longer any need to track the underlying condition).",
        "comment" : "This effectiveTime MAY contain zero or one [0..1] high (CONF:1198-9033)."
      },
      {
        "id" : "Act.author",
        "path" : "Act.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1198-31146).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "short" : "The following entryRelationship represents the importance of the concern to a provider.",
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:problem",
        "path" : "Act.entryRelationship",
        "sliceName" : "problem",
        "comment" : "SHALL contain exactly one [1..1] entryRelationship (CONF:1198-9034) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.entryRelationship:problem.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-9035).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Act.entryRelationship:problem.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Problem Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.4:2015-08-01) (CONF:1198-15980).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:priority",
        "path" : "Act.entryRelationship",
        "sliceName" : "priority",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-31638) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:priority.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31639).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:priority.observation",
        "path" : "Act.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Priority Preference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.143) (CONF:1198-31640).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PriorityPreference"
            ]
          }
        ]
      }
    ]
  }
}

```
