# Preoperative Diagnosis Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Preoperative Diagnosis Section**

## Logical Model: Preoperative Diagnosis Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosisSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PreoperativeDiagnosisSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.34:2015-08-01 | |

 
The Preoperative Diagnosis Section records the surgical diagnoses assigned to the patient before the surgical procedure which are the reason for the surgery. The preoperative diagnosis is, in the surgeon's opinion, the diagnosis that will be confirmed during surgery. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Recommended Entries**:[PreoperativeDiagnosis](StructureDefinition-PreoperativeDiagnosis.md) 

**Usages:**

* Use this Logical Model Profile: [Operative Note](StructureDefinition-OperativeNote.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PreoperativeDiagnosisSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PreoperativeDiagnosisSection.csv), [Excel](StructureDefinition-PreoperativeDiagnosisSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PreoperativeDiagnosisSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosisSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.34:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PreoperativeDiagnosisSection",
  "title" : "Preoperative Diagnosis Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Preoperative Diagnosis Section records the surgical diagnoses assigned to the patient before the surgical procedure which are the reason for the surgery. The preoperative diagnosis is, in the surgeon's opinion, the diagnosis that will be confirmed during surgery.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Recommended Entries**: [PreoperativeDiagnosis](StructureDefinition-PreoperativeDiagnosis.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "should-preop-dx",
            "severity" : "warning",
            "human" : "SHOULD contain Preoperative Diagnosis",
            "expression" : "entry.where(act.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosis'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosisSection"
          }
        ]
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.34"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Surgical operation note preoperative diagnosis Narrative",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "10219-4"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Section.entry:preopDiagnosis",
        "path" : "Section.entry",
        "sliceName" : "preopDiagnosis",
        "comment" : "SHOULD contain zero or one [0..1] entry (CONF:1198-10096) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-preop-dx"]
      },
      {
        "id" : "Section.entry:preopDiagnosis.act",
        "path" : "Section.entry.act",
        "comment" : "SHALL contain exactly one [1..1] Preoperative Diagnosis (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.65:2015-08-01) (CONF:1198-15504).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosis"
            ]
          }
        ]
      }
    ]
  }
}

```
