# Precondition for Substance Administration - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Precondition for Substance Administration**

## Logical Model: Precondition for Substance Administration 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PreconditionforSubstanceAdministration | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PreconditionforSubstanceAdministration |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.25:2014-06-09 | |

 
A criterion for administration can be used to record that the medication is to be administered only when the associated criteria are met. 

**Usages:**

* Use this Logical Model Profile: [Immunization Activity](StructureDefinition-ImmunizationActivity.md), [Medication Activity](StructureDefinition-MedicationActivity.md), [Planned Immunization Activity](StructureDefinition-PlannedImmunizationActivity.md) and [Planned Medication Activity](StructureDefinition-PlannedMedicationActivity.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PreconditionforSubstanceAdministration)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PreconditionforSubstanceAdministration.csv), [Excel](StructureDefinition-PreconditionforSubstanceAdministration.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PreconditionforSubstanceAdministration",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "criterion"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PreconditionforSubstanceAdministration",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.25:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PreconditionforSubstanceAdministration",
  "title" : "Precondition for Substance Administration",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "A criterion for administration can be used to record that the medication is to be administered only when the associated criteria are met.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Criterion",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Criterion",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Criterion.templateId",
        "path" : "Criterion.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Criterion.templateId:precondition-substance-admin",
        "path" : "Criterion.templateId",
        "sliceName" : "precondition-substance-admin",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Criterion.templateId:precondition-substance-admin.root",
        "path" : "Criterion.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.25"
      },
      {
        "id" : "Criterion.templateId:precondition-substance-admin.extension",
        "path" : "Criterion.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "Criterion.code",
        "path" : "Criterion.code",
        "comment" : "SHALL contain exactly one [1..1] code with @xsi:type=\"CD\" (CONF:1098-32396).",
        "min" : 1
      },
      {
        "id" : "Criterion.code.code",
        "path" : "Criterion.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"ASSERTION\" Assertion (CONF:1098-32397).",
        "min" : 1,
        "patternCode" : "ASSERTION"
      },
      {
        "id" : "Criterion.code.codeSystem",
        "path" : "Criterion.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.5.4\" (CodeSystem: HL7ActCode urn:oid:2.16.840.1.113883.5.4) (CONF:1098-32398).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.5.4"
      },
      {
        "id" : "Criterion.value",
        "path" : "Criterion.value",
        "comment" : "SHALL contain exactly one [1..1] value with @xsi:type=\"CD\", where the code SHALL be selected from ValueSet US Core Condition Codes.",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-condition-code"
        }
      }
    ]
  }
}

```
