# Plan of Treatment Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Plan of Treatment Section**

## Logical Model: Plan of Treatment Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PlanofTreatmentSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.10:2014-06-09 | |

 
This section captures planned, pending, active, or completed orders, interventions, encounters, services, and procedures relevant to a patient’s care. It may also include or reference existing problems or conditions that inform ongoing care planning. While entries typically represent prospective or in-progress actions (as indicated by their @moodCode), completed activities of clinical significance may be included to maintain continuity and context. The section may contain information about ongoing or anticipated care, clinical reminders, and overarching goals, along with the patient’s values, beliefs, preferences, and care expectations that shape care decisions. Examples include reminders for preventive services, values such as quality of life over longevity, beliefs such as refusal of blood transfusions, or preferences regarding care modalities or provider characteristics. 
Previously defined entry templates remain valid for compatibility. The Care Plan Act entry template provides a structured way to represent a snapshot of a dynamic, consensus-driven care plan that captures prioritized concerns, goals, and planned interventions. This entry reflects the current state of the care plan as managed in the source system and supports exchange across systems for coordinated, longitudinal care. 
When additional context appears in the section narrative (section.text) but not in discrete entries, it is recommended to encapsulate the text in a Note Activity to support ingestion and preserve meaning. 

**Usages:**

* Use this Logical Model Profile: [Consultation Note](StructureDefinition-ConsultationNote.md), [Continuity of Care Document (CCD)](StructureDefinition-ContinuityofCareDocumentCCD.md), [Discharge Summary](StructureDefinition-DischargeSummary.md), [History and Physical](StructureDefinition-HistoryandPhysical.md)...Show 5 more,[Operative Note](StructureDefinition-OperativeNote.md),[Procedure Note](StructureDefinition-ProcedureNote.md),[Progress Note](StructureDefinition-ProgressNote.md),[Referral Note](StructureDefinition-ReferralNote.md)and[Transfer Summary](StructureDefinition-TransferSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PlanofTreatmentSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PlanofTreatmentSection.csv), [Excel](StructureDefinition-PlanofTreatmentSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlanofTreatmentSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.10:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PlanofTreatmentSection",
  "title" : "Plan of Treatment Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This section captures planned, pending, active, or completed orders, interventions, encounters, services, and procedures relevant to a patient’s care. It may also include or reference existing problems or conditions that inform ongoing care planning. While entries typically represent prospective or in-progress actions (as indicated by their @moodCode), completed activities of clinical significance may be included to maintain continuity and context. The section may contain information about ongoing or anticipated care, clinical reminders, and overarching goals, along with the patient’s values, beliefs, preferences, and care expectations that shape care decisions. Examples include reminders for preventive services, values such as quality of life over longevity, beliefs such as refusal of blood transfusions, or preferences regarding care modalities or provider characteristics.\n\nPreviously defined entry templates remain valid for compatibility. The Care Plan Act entry template provides a structured way to represent a snapshot of a dynamic, consensus-driven care plan that captures prioritized concerns, goals, and planned interventions. This entry reflects the current state of the care plan as managed in the source system and supports exchange across systems for coordinated, longitudinal care.\n\nWhen additional context appears in the section narrative (section.text) but not in discrete entries, it is recommended to encapsulate the text in a Note Activity to support ingestion and preserve meaning.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.10"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Plan of care note",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "18776-5"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "encounter"
            },
            {
              "type" : "profile",
              "path" : "procedure"
            },
            {
              "type" : "profile",
              "path" : "substanceAdministration"
            },
            {
              "type" : "profile",
              "path" : "supply"
            },
            {
              "type" : "profile",
              "path" : "act"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Section.entry:carePlanAct",
        "path" : "Section.entry",
        "sliceName" : "carePlanAct",
        "short" : "Represents a snapshot in time of a care plan. Related resources may be embedded directly or referenced via EntryReference (e.g. for systems who wish to continue including entries directly in the Plan of Treatment section).",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:carePlanAct.act",
        "path" : "Section.entry.act",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/CarePlanAct"]
          }
        ]
      },
      {
        "id" : "Section.entry:goal",
        "path" : "Section.entry",
        "sliceName" : "goal",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1098-32887) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:goal.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Goal Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.121) (CONF:1098-32888).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/GoalObservation"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:handoffCommParticipants",
        "path" : "Section.entry",
        "sliceName" : "handoffCommParticipants",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1098-29621) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:handoffCommParticipants.act",
        "path" : "Section.entry.act",
        "comment" : "SHALL contain exactly one [1..1] Handoff Communication Participants (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.141) (CONF:1098-30868).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HandoffCommunicationParticipants"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:instruction",
        "path" : "Section.entry",
        "sliceName" : "instruction",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1098-14695) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:instruction.observation",
        "path" : "Section.entry.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:nutrition",
        "path" : "Section.entry",
        "sliceName" : "nutrition",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1098-31841) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:nutrition.act",
        "path" : "Section.entry.act",
        "comment" : "SHALL contain exactly one [1..1] Nutrition Recommendation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.130) (CONF:1098-31864).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionRecommendation"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:plannedEnc",
        "path" : "Section.entry",
        "sliceName" : "plannedEnc",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1098-8805) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:plannedEnc.encounter",
        "path" : "Section.entry.encounter",
        "comment" : "SHALL contain exactly one [1..1] Planned Encounter (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.40:2014-06-09) (CONF:1098-30472).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Encounter",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:plannedImmunization",
        "path" : "Section.entry",
        "sliceName" : "plannedImmunization",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1098-32353) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:plannedImmunization.substanceAdministration",
        "path" : "Section.entry.substanceAdministration",
        "comment" : "SHALL contain exactly one [1..1] Planned Immunization Activity (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.120) (CONF:1098-32354).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedImmunizationActivity"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:plannedMed",
        "path" : "Section.entry",
        "sliceName" : "plannedMed",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1098-8811) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:plannedMed.substanceAdministration",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Section.entry.substanceAdministration",
        "short" : "𝗨𝗦𝗖𝗗𝗜: MedicationOrder",
        "comment" : "SHALL contain exactly one [1..1] Planned Medication Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.42:2014-06-09) (CONF:1098-30475).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedMedicationActivity"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:plannedProc",
        "path" : "Section.entry",
        "sliceName" : "plannedProc",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1098-8809) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:plannedProc.procedure",
        "path" : "Section.entry.procedure",
        "comment" : "SHALL contain exactly one [1..1] Planned Procedure (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.41:2014-06-09) (CONF:1098-30474).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:plannedSupply",
        "path" : "Section.entry",
        "sliceName" : "plannedSupply",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1098-8813) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:plannedSupply.supply",
        "path" : "Section.entry.supply",
        "comment" : "SHALL contain exactly one [1..1] Planned Supply (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.43:2014-06-09) (CONF:1098-30476).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:notes",
        "path" : "Section.entry",
        "sliceName" : "notes",
        "comment" : "MAY contain zero or more [0..*] entry such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:notes.act",
        "path" : "Section.entry.act",
        "comment" : "SHALL contain exactly one [1..1] Notes Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.202,2016-11-01).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
            ]
          }
        ]
      }
    ]
  }
}

```
