# Planned Intervention Act - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Planned Intervention Act**

## Logical Model: Planned Intervention Act 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PlannedInterventionAct |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.146:2015-08-01 | |

 
This template represents a Planned Intervention Act. It is a wrapper for planned intervention-type activities considered to be parts of the same intervention. For example, an activity such as "elevate head of bed" combined with "provide humidified O2 per nasal cannula" may be the interventions planned for a health concern of "respiratory insufficiency" in order to attempt to achieve a goal of "pulse oximetry greater than 92%". These intervention activities may be newly described or derived from a variety of sources within an EHR. 
Interventions are actions taken to increase the likelihood of achieving the patient's or providers' goals. An Intervention Act should contain a reference to a Goal Observation representing the reason for the intervention. 
Planned Intervention Acts can be related to each other or to Intervention Acts. (E.g., a Planned Intervention Act with moodCode of INT could be related to a series of Intervention Acts with moodCode of EVN, each having an effectiveTime containing the time of the intervention.) 
All interventions referenced in a Planned Intervention Act must have moodCodes indicating that that are planned (have not yet occurred). 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required EntryRelationships**:[EntryReference](StructureDefinition-EntryReference.md) 
**Optional EntryRelationships**:[ImmunizationActivity](StructureDefinition-ImmunizationActivity.md),[InstructionObservation](StructureDefinition-InstructionObservation.md),[MedicationActivity](StructureDefinition-MedicationActivity.md),[NonMedicinalSupplyActivity](StructureDefinition-NonMedicinalSupplyActivity.md),[NutritionRecommendation](StructureDefinition-NutritionRecommendation.md),[PlannedEncounter](StructureDefinition-PlannedEncounter.md),[PlannedImmunizationActivity](StructureDefinition-PlannedImmunizationActivity.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md),[PlannedProcedure](StructureDefinition-PlannedProcedure.md),[PlannedSupply](StructureDefinition-PlannedSupply.md) 

**Usages:**

* Use this Logical Model Profile: [Activities Section](StructureDefinition-ActivitiesSection.md), [Care Plan Act](StructureDefinition-CarePlanAct.md) and [Intervention Act](StructureDefinition-InterventionAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PlannedInterventionAct)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PlannedInterventionAct.csv), [Excel](StructureDefinition-PlannedInterventionAct.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlannedInterventionAct",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.146:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PlannedInterventionAct",
  "title" : "Planned Intervention Act",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents a Planned Intervention Act. It is a wrapper for planned intervention-type activities considered to be parts of the same intervention. For example, an activity such as \"elevate head of bed\" combined with \"provide humidified O2 per nasal cannula\" may be the interventions planned for a health concern of \"respiratory insufficiency\" in order to attempt to achieve a goal of \"pulse oximetry greater than 92%\". These intervention activities may be newly described or derived from a variety of sources within an EHR.\n\nInterventions are actions taken to increase the likelihood of achieving the patient's or providers' goals. An Intervention Act should contain a reference to a Goal Observation representing the reason for the intervention.\n\nPlanned Intervention Acts can be related to each other or to Intervention Acts. (E.g., a Planned Intervention Act with moodCode of INT could be related to a series of Intervention Acts with moodCode of EVN, each having an effectiveTime containing the time of the intervention.) \n\nAll interventions referenced in a Planned Intervention Act must have moodCodes indicating that that are planned (have not yet occurred).\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required EntryRelationships**: [EntryReference](StructureDefinition-EntryReference.html)\n\n**Optional EntryRelationships**: [ImmunizationActivity](StructureDefinition-ImmunizationActivity.html), [InstructionObservation](StructureDefinition-InstructionObservation.html), [MedicationActivity](StructureDefinition-MedicationActivity.html), [NonMedicinalSupplyActivity](StructureDefinition-NonMedicinalSupplyActivity.html), [NutritionRecommendation](StructureDefinition-NutritionRecommendation.html), [PlannedEncounter](StructureDefinition-PlannedEncounter.html), [PlannedImmunizationActivity](StructureDefinition-PlannedImmunizationActivity.html), [PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.html), [PlannedProcedure](StructureDefinition-PlannedProcedure.html), [PlannedSupply](StructureDefinition-PlannedSupply.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct"
          },
          {
            "key" : "should-effectiveTime",
            "severity" : "warning",
            "human" : "SHOULD contain effectiveTime",
            "expression" : "effectiveTime.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:planned-intervention-act",
        "path" : "Act.templateId",
        "sliceName" : "planned-intervention-act",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:planned-intervention-act.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.146"
      },
      {
        "id" : "Act.templateId:planned-intervention-act.extension",
        "path" : "Act.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1198-32678).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode, which SHALL be selected from ValueSet Planned Intervention moodCode urn:oid:2.16.840.1.113883.11.20.9.54 DYNAMIC (CONF:1198-32679).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.54"
        }
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1198-32681).",
        "min" : 1
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1198-32654)."
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"362956003\" procedure / intervention (navigational concept) (CONF:1198-32682).",
        "min" : 1,
        "patternCode" : "362956003"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.6.96\" (CodeSystem: SNOMED CT urn:oid:2.16.840.1.113883.6.96) (CONF:1198-32683).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.96"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1198-32655).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"active\" Active (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:1198-32684).",
        "min" : 1,
        "fixedCode" : "active"
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "short" : "SHOULD contain effectiveTime",
        "comment" : "SHOULD contain zero or one [0..1] effectiveTime (CONF:1198-32723).",
        "condition" : ["should-effectiveTime"]
      },
      {
        "id" : "Act.author",
        "path" : "Act.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1198-32719).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "substanceAdministration"
            },
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "procedure"
            },
            {
              "type" : "profile",
              "path" : "encounter"
            },
            {
              "type" : "profile",
              "path" : "supply"
            },
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:reason",
        "path" : "Act.entryRelationship",
        "sliceName" : "reason",
        "short" : "An Intervention Act SHALL reference a Goal Observation. Because the Goal Observation is already described in the CDA document instance's Goals section, rather than repeating the full content of the Goal Observation, the Entry Reference template can be used to reference this entry. The following entryRelationship represents an Entry Reference to Goal Observation.",
        "comment" : "SHALL contain at least one [1..*] entryRelationship (CONF:1198-32673) such that it",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:reason.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32720).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "Act.entryRelationship:reason.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:1198-32721).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ],
        "constraint" : [
          {
            "key" : "entry-ref-goal",
            "severity" : "error",
            "human" : "This entryReference template **SHALL** reference an instance of a Goal Observation template.",
            "expression" : "%resource.descendants().ofType(CDA.Observation).where(templateId.exists($this.root = '2.16.840.1.113883.10.20.22.4.121' and $this.extension = '2022-06-01') and id.exists($this.root = %context.id.first().root and $this.extension ~ %context.id.first().extension))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:immunizationActivity",
        "path" : "Act.entryRelationship",
        "sliceName" : "immunizationActivity",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32656) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:immunizationActivity.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32686).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:immunizationActivity.substanceAdministration",
        "path" : "Act.entryRelationship.substanceAdministration",
        "comment" : "SHALL contain exactly one [1..1] Immunization Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.52:2015-08-01) (CONF:1198-32687).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:medicationActivity",
        "path" : "Act.entryRelationship",
        "sliceName" : "medicationActivity",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32657) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:medicationActivity.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32688).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:medicationActivity.substanceAdministration",
        "path" : "Act.entryRelationship.substanceAdministration",
        "comment" : "SHALL contain exactly one [1..1] Medication Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.16:2014-06-09) (CONF:1198-32689).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:instruction",
        "path" : "Act.entryRelationship",
        "sliceName" : "instruction",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32663) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:instruction.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32957).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:instruction.observation",
        "path" : "Act.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:nonMedSupply",
        "path" : "Act.entryRelationship",
        "sliceName" : "nonMedSupply",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32664) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:nonMedSupply.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32702).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:nonMedSupply.supply",
        "path" : "Act.entryRelationship.supply",
        "comment" : "SHALL contain exactly one [1..1] Non-Medicinal Supply Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.50:2014-06-09) (CONF:1198-32703).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NonMedicinalSupplyActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:plannedEncounter",
        "path" : "Act.entryRelationship",
        "sliceName" : "plannedEncounter",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32666) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plannedEncounter.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32706).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plannedEncounter.encounter",
        "path" : "Act.entryRelationship.encounter",
        "comment" : "SHALL contain exactly one [1..1] Planned Encounter (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.40:2014-06-09) (CONF:1198-32707).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Encounter",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:plannedProcedure",
        "path" : "Act.entryRelationship",
        "sliceName" : "plannedProcedure",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32668) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plannedProcedure.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32710).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plannedProcedure.procedure",
        "path" : "Act.entryRelationship.procedure",
        "comment" : "SHALL contain exactly one [1..1] Planned Procedure (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.41:2014-06-09) (CONF:1198-32711).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:plannedMedicationActivity",
        "path" : "Act.entryRelationship",
        "sliceName" : "plannedMedicationActivity",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32669) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plannedMedicationActivity.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32712).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plannedMedicationActivity.substanceAdministration",
        "path" : "Act.entryRelationship.substanceAdministration",
        "comment" : "SHALL contain exactly one [1..1] Planned Medication Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.42:2014-06-09) (CONF:1198-32713).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedMedicationActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:plannedSupply",
        "path" : "Act.entryRelationship",
        "sliceName" : "plannedSupply",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32670) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plannedSupply.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32714).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plannedSupply.supply",
        "path" : "Act.entryRelationship.supply",
        "comment" : "SHALL contain exactly one [1..1] Planned Supply (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.43:2014-06-09) (CONF:1198-32715).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:nutritionRecommendation",
        "path" : "Act.entryRelationship",
        "sliceName" : "nutritionRecommendation",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32671) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:nutritionRecommendation.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:nutritionRecommendation.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Nutrition Recommendation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.130) (CONF:1198-32716).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionRecommendation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:entryReference",
        "path" : "Act.entryRelationship",
        "sliceName" : "entryReference",
        "short" : "Where an Intervention needs to reference another entry already described in the CDA document instance, rather than repeating the full content of the entry, the Entry Reference template may be used to reference this entry.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32672) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:entryReference.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32717).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:entryReference.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:1198-32718).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:plannedImmunizationActivity",
        "path" : "Act.entryRelationship",
        "sliceName" : "plannedImmunizationActivity",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-32676) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plannedImmunizationActivity.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32728).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plannedImmunizationActivity.substanceAdministration",
        "path" : "Act.entryRelationship.substanceAdministration",
        "comment" : "SHALL contain exactly one [1..1] Planned Immunization Activity (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.120) (CONF:1198-32729).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedImmunizationActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.reference",
        "path" : "Act.reference",
        "comment" : "MAY contain zero or more [0..*] reference (CONF:1198-32766)."
      },
      {
        "id" : "Act.reference.typeCode",
        "path" : "Act.reference.typeCode",
        "comment" : "The reference, if present, SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-32767).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.reference.externalDocument",
        "path" : "Act.reference.externalDocument",
        "comment" : "The reference, if present, SHALL contain exactly one [1..1] External Document Reference (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.115:2014-06-09) (CONF:1198-32768).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ExternalDocument",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ExternalDocumentReference"
            ]
          }
        ]
      }
    ]
  }
}

```
