# Planned Immunization Activity - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Planned Immunization Activity**

## Logical Model: Planned Immunization Activity 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PlannedImmunizationActivity | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PlannedImmunizationActivity |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.120 | |

 
This template represents planned immunizations. Planned Immunization Activity is very similar to Planned Medication Activity with some key differences, for example, the drug code system is constrained to CVX codes. The priority of the immunization activity to the patient and provider is communicated through Priority Preference. The effectiveTime indicates the time when the immunization activity is intended to take place and authorTime indicates when the documentation of the plan occurred. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[Indication](StructureDefinition-Indication.md),[InstructionObservation](StructureDefinition-InstructionObservation.md),[PriorityPreference](StructureDefinition-PriorityPreference.md) 

**Usages:**

* Use this Logical Model Profile: [Planned Intervention Act](StructureDefinition-PlannedInterventionAct.md) and [Plan of Treatment Section](StructureDefinition-PlanofTreatmentSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PlannedImmunizationActivity)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PlannedImmunizationActivity.csv), [Excel](StructureDefinition-PlannedImmunizationActivity.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlannedImmunizationActivity",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "substanceAdministration"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedImmunizationActivity",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.120"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PlannedImmunizationActivity",
  "title" : "Planned Immunization Activity",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents planned immunizations. Planned Immunization Activity is very similar to Planned Medication Activity with some key differences, for example, the drug code system is constrained to CVX codes. \nThe priority of the immunization activity to the patient and provider is communicated through Priority Preference. The effectiveTime indicates the time when the immunization activity is intended to take place and authorTime indicates when the documentation of the plan occurred.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [Indication](StructureDefinition-Indication.html), [InstructionObservation](StructureDefinition-InstructionObservation.html), [PriorityPreference](StructureDefinition-PriorityPreference.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "SubstanceAdministration",
        "path" : "SubstanceAdministration",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedImmunizationActivity"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.templateId",
        "path" : "SubstanceAdministration.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.templateId:planned-immunization-activity",
        "path" : "SubstanceAdministration.templateId",
        "sliceName" : "planned-immunization-activity",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.templateId:planned-immunization-activity.root",
        "path" : "SubstanceAdministration.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.120"
      },
      {
        "id" : "SubstanceAdministration.templateId:planned-immunization-activity.extension",
        "path" : "SubstanceAdministration.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "SubstanceAdministration.classCode",
        "path" : "SubstanceAdministration.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"SBADM\" (CONF:1098-32091)."
      },
      {
        "id" : "SubstanceAdministration.moodCode",
        "path" : "SubstanceAdministration.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode, which SHALL be selected from ValueSet Planned moodCode (SubstanceAdministration/Supply) urn:oid:2.16.840.1.113883.11.20.9.24 STATIC 2014-09-01 (CONF:1098-32097).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.24"
        }
      },
      {
        "id" : "SubstanceAdministration.id",
        "path" : "SubstanceAdministration.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-32100).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.text",
        "path" : "SubstanceAdministration.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "SubstanceAdministration.text.reference",
        "path" : "SubstanceAdministration.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedImmunizationActivity"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.statusCode",
        "path" : "SubstanceAdministration.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-32101).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.statusCode.code",
        "path" : "SubstanceAdministration.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"active\" Active (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-32102).",
        "min" : 1,
        "fixedCode" : "active"
      },
      {
        "id" : "SubstanceAdministration.effectiveTime",
        "path" : "SubstanceAdministration.effectiveTime",
        "short" : "The effectiveTime in a planned immunization activity represents the time that the immunization activity should occur.",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1098-32103).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.repeatNumber",
        "path" : "SubstanceAdministration.repeatNumber",
        "short" : "In a Planned Immunization Activity, repeatNumber defines the number of allowed administrations. For example, a repeatNumber of \"3\" means that the substance can be administered up to 3 times.",
        "comment" : "MAY contain zero or one [0..1] repeatNumber (CONF:1098-32126)."
      },
      {
        "id" : "SubstanceAdministration.routeCode",
        "path" : "SubstanceAdministration.routeCode",
        "comment" : "MAY contain zero or one [0..1] routeCode, which SHALL be selected from ValueSet SPL Drug Route of Administration Terminology urn:oid:2.16.840.1.113883.3.88.12.3221.8.7 DYNAMIC (CONF:1098-32127).",
        "constraint" : [
          {
            "key" : "should-translation",
            "severity" : "warning",
            "human" : "SHOULD contain translation",
            "expression" : "translation.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedImmunizationActivity"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.3221.8.7"
        }
      },
      {
        "id" : "SubstanceAdministration.routeCode.translation",
        "path" : "SubstanceAdministration.routeCode.translation",
        "comment" : "The routeCode, if present, SHOULD contain zero or more [0..*] translation, which SHOULD be selected from ValueSet Medication Route urn:oid:2.16.840.1.113762.1.4.1099.12 DYNAMIC (CONF:1098-32951).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.12"
        }
      },
      {
        "id" : "SubstanceAdministration.approachSiteCode",
        "path" : "SubstanceAdministration.approachSiteCode",
        "comment" : "MAY contain zero or more [0..*] approachSiteCode, which SHALL be selected from ValueSet Body Site Value Set urn:oid:2.16.840.1.113883.3.88.12.3221.8.9 DYNAMIC (CONF:1098-32128).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.3221.8.9"
        }
      },
      {
        "id" : "SubstanceAdministration.doseQuantity",
        "path" : "SubstanceAdministration.doseQuantity",
        "comment" : "MAY contain zero or one [0..1] doseQuantity (CONF:1098-32129).",
        "constraint" : [
          {
            "key" : "should-unit",
            "severity" : "warning",
            "human" : "SHOULD contain @unit",
            "expression" : "nullFlavor.exists() or unit.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedImmunizationActivity"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.doseQuantity.unit",
        "path" : "SubstanceAdministration.doseQuantity.unit",
        "short" : "NOTE: The base CDA R2.0 standard requires @unit to be drawn from UCUM, and best practice is to use case sensitive UCUM units",
        "comment" : "The doseQuantity, if present, SHOULD contain zero or one [0..1] @unit, which SHOULD be selected from ValueSet UnitsOfMeasureCaseSensitive urn:oid:2.16.840.1.113883.1.11.12839 DYNAMIC (CONF:1098-32130).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-UnitsOfMeasureCaseSensitive"
        }
      },
      {
        "id" : "SubstanceAdministration.consumable",
        "path" : "SubstanceAdministration.consumable",
        "comment" : "SHALL contain exactly one [1..1] consumable (CONF:1098-32131)."
      },
      {
        "id" : "SubstanceAdministration.consumable.manufacturedProduct",
        "path" : "SubstanceAdministration.consumable.manufacturedProduct",
        "comment" : "This consumable SHALL contain exactly one [1..1] Immunization Medication Information (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.54:2014-06-09) (CONF:1098-32132).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ManufacturedProduct",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationMedicationInformation"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.performer",
        "path" : "SubstanceAdministration.performer",
        "short" : "The clinician who is expected to perform the planned immunization activity could be identified using substanceAdministration/performer.",
        "comment" : "MAY contain zero or more [0..*] performer (CONF:1098-32104)."
      },
      {
        "id" : "SubstanceAdministration.author",
        "path" : "SubstanceAdministration.author",
        "short" : "The author in a planned immunization activity represents the clinician who is requesting or planning the immunization activity.",
        "comment" : "MAY contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1098-32105).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship",
        "path" : "SubstanceAdministration.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "act"
            }
          ],
          "rules" : "open"
        },
        "short" : "The following entryRelationship captures any instructions associated with the planned immunization activity."
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:priorityPreference",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "priorityPreference",
        "short" : "The following entryRelationship represents the priority that a patient or a provider places on the immunization activity.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-32108) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:priorityPreference.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32109).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:priorityPreference.observation",
        "path" : "SubstanceAdministration.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Priority Preference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.143) (CONF:1098-32110).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PriorityPreference"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "indication",
        "short" : "The following entryRelationship represents the indication for the immunization activity.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-32114) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" Has Reason (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32115).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication.observation",
        "path" : "SubstanceAdministration.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Indication (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.19:2014-06-09) (CONF:1098-32116).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/Indication"]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:instruction",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "instruction",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-32117) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:instruction.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" Has Subject (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32118).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:instruction.observation",
        "path" : "SubstanceAdministration.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.precondition",
        "path" : "SubstanceAdministration.precondition",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "criterion"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "SubstanceAdministration.precondition:pronditionForSubstanceAdmin",
        "path" : "SubstanceAdministration.precondition",
        "sliceName" : "pronditionForSubstanceAdmin",
        "comment" : "MAY contain zero or more [0..*] precondition (CONF:1098-32123) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.precondition:pronditionForSubstanceAdmin.typeCode",
        "path" : "SubstanceAdministration.precondition.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"PRCN\" Precondition (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32124).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.precondition:pronditionForSubstanceAdmin.criterion",
        "path" : "SubstanceAdministration.precondition.criterion",
        "comment" : "SHALL contain exactly one [1..1] Precondition for Substance Administration (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.25:2014-06-09) (CONF:1098-32125).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Criterion",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PreconditionforSubstanceAdministration"
            ]
          }
        ]
      }
    ]
  }
}

```
