# Planned Coverage - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Planned Coverage**

## Logical Model: Planned Coverage 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/PlannedCoverage | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:PlannedCoverage |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.129:2024-05-01 | |

 
This template represents the insurance coverage intended to cover an act or procedure. 

**Usages:**

* Use this Logical Model Profile: [Planned Procedure](StructureDefinition-PlannedProcedure.md) and [Planned Supply](StructureDefinition-PlannedSupply.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/PlannedCoverage)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-PlannedCoverage.csv), [Excel](StructureDefinition-PlannedCoverage.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlannedCoverage",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedCoverage",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.129:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "PlannedCoverage",
  "title" : "Planned Coverage",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents the insurance coverage intended to cover an act or procedure.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedCoverage"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:planned-coverage",
        "path" : "Act.templateId",
        "sliceName" : "planned-coverage",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:planned-coverage.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.129"
      },
      {
        "id" : "Act.templateId:planned-coverage.extension",
        "path" : "Act.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" act (CodeSystem: HL7ActCode urn:oid:2.16.840.1.113883.5.4) (CONF:1098-31945).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"INT\" Intent (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1098-31946).",
        "fixedCode" : "INT"
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-31950).",
        "min" : 1
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "short" : "Payment sources",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1098-31951)."
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "min" : 1,
        "patternCode" : "52556-8"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedCoverage"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-31954).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"active\" Active (CodeSystem: HL7ActCode urn:oid:2.16.840.1.113883.5.4) (CONF:1098-31955).",
        "min" : 1,
        "fixedCode" : "active"
      },
      {
        "id" : "Act.author",
        "path" : "Act.author",
        "comment" : "MAY contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1098-32178).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "exists",
              "path" : "act"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:entryRelationship1",
        "path" : "Act.entryRelationship",
        "sliceName" : "entryRelationship1",
        "comment" : "SHALL contain exactly one [1..1] entryRelationship (CONF:1098-31967) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.entryRelationship:entryRelationship1.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" has component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-31968).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Act.entryRelationship:entryRelationship1.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] act (CONF:1098-31969).",
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:entryRelationship1.act.classCode",
        "path" : "Act.entryRelationship.act.classCode",
        "comment" : "This act SHALL contain exactly one [1..1] @classCode=\"ACT\" ACT (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1098-31970).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.entryRelationship:entryRelationship1.act.moodCode",
        "path" : "Act.entryRelationship.act.moodCode",
        "comment" : "This act SHALL contain exactly one [1..1] @moodCode=\"INT\" intent (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1098-31971).",
        "fixedCode" : "INT"
      },
      {
        "id" : "Act.entryRelationship:entryRelationship1.act.id",
        "path" : "Act.entryRelationship.act.id",
        "short" : "These act/identifiers are unique identifiers for the policy or program providing the coverage.",
        "comment" : "This act SHALL contain at least one [1..*] id (CONF:1098-31972).",
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:entryRelationship1.act.code",
        "path" : "Act.entryRelationship.act.code",
        "comment" : "This act SHALL contain exactly one [1..1] code, which SHALL be selected from ValueSet Payer urn:oid:2.16.840.1.114222.4.11.3591 DYNAMIC (CONF:1098-31973).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591"
        }
      },
      {
        "id" : "Act.entryRelationship:entryRelationship1.act.statusCode",
        "path" : "Act.entryRelationship.act.statusCode",
        "comment" : "This act SHALL contain exactly one [1..1] statusCode (CONF:1098-31974).",
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:entryRelationship1.act.statusCode.code",
        "path" : "Act.entryRelationship.act.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"active\" Active (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-31975).",
        "min" : 1,
        "fixedCode" : "active"
      }
    ]
  }
}

```
