# Nutrition Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nutrition Section**

## Logical Model: Nutrition Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:NutritionSection |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.2.57 | |

 
The Nutrition Section represents diet and nutrition information including special diet requirements and restrictions (e.g., texture modified diet, liquids only, enteral feeding). It also represents the overall nutritional status of the patient and nutrition assessment findings. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Recommended Entries**:[NutritionalStatusObservation](StructureDefinition-NutritionalStatusObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Consultation Note](StructureDefinition-ConsultationNote.md), [Continuity of Care Document (CCD)](StructureDefinition-ContinuityofCareDocumentCCD.md), [Discharge Summary](StructureDefinition-DischargeSummary.md), [Progress Note](StructureDefinition-ProgressNote.md)...Show 2 more,[Referral Note](StructureDefinition-ReferralNote.md)and[Transfer Summary](StructureDefinition-TransferSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/NutritionSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-NutritionSection.csv), [Excel](StructureDefinition-NutritionSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "NutritionSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.2.57"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "NutritionSection",
  "title" : "Nutrition Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Nutrition Section represents diet and nutrition information including special diet requirements and restrictions (e.g., texture modified diet, liquids only, enteral feeding). It also represents the overall nutritional status of the patient and nutrition assessment findings.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Recommended Entries**: [NutritionalStatusObservation](StructureDefinition-NutritionalStatusObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "should-nutritional-status-obs",
            "severity" : "warning",
            "human" : "SHOULD contain Nutritional Status Observation",
            "expression" : "entry.where(observation.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/NutritionalStatusObservation'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection"
          }
        ]
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.57"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Diet and nutrition Narrative",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "61144-2"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Section.entry:nutritionalStatus",
        "path" : "Section.entry",
        "sliceName" : "nutritionalStatus",
        "comment" : "SHOULD contain zero or more [0..*] entry (CONF:1098-30321) such that it",
        "min" : 0,
        "max" : "*",
        "condition" : ["should-nutritional-status-obs"]
      },
      {
        "id" : "Section.entry:nutritionalStatus.observation",
        "path" : "Section.entry.observation",
        "comment" : "SHALL contain exactly one [1..1] Nutritional Status Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.124) (CONF:1098-30322).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionalStatusObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
