# Nutrition Recommendation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nutrition Recommendation**

## Logical Model: Nutrition Recommendation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/NutritionRecommendation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:NutritionRecommendation |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.130 | |

 
This template represents nutrition regimens (e.g., fluid restrictions, calorie minimum), interventions (e.g., NPO, nutritional supplements), and procedures (e.g., G-Tube by bolus, TPN by central line). It may also depict the need for nutrition education. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[PlannedEncounter](StructureDefinition-PlannedEncounter.md),[PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.md),[PlannedProcedure](StructureDefinition-PlannedProcedure.md),[PlannedSupply](StructureDefinition-PlannedSupply.md) 

**Usages:**

* Use this Logical Model Profile: [Intervention Act](StructureDefinition-InterventionAct.md), [Planned Intervention Act](StructureDefinition-PlannedInterventionAct.md) and [Plan of Treatment Section](StructureDefinition-PlanofTreatmentSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/NutritionRecommendation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-NutritionRecommendation.csv), [Excel](StructureDefinition-NutritionRecommendation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "NutritionRecommendation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionRecommendation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.130"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "NutritionRecommendation",
  "title" : "Nutrition Recommendation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents nutrition regimens (e.g., fluid restrictions, calorie minimum), interventions (e.g., NPO, nutritional supplements), and procedures (e.g., G-Tube by bolus, TPN by central line). It may also depict the need for nutrition education.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [PlannedEncounter](StructureDefinition-PlannedEncounter.html), [PlannedMedicationActivity](StructureDefinition-PlannedMedicationActivity.html), [PlannedProcedure](StructureDefinition-PlannedProcedure.html), [PlannedSupply](StructureDefinition-PlannedSupply.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionRecommendation"
          },
          {
            "key" : "should-effectiveTime",
            "severity" : "warning",
            "human" : "SHOULD contain effectiveTime",
            "expression" : "effectiveTime.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionRecommendation"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:nutrition-rec",
        "path" : "Act.templateId",
        "sliceName" : "nutrition-rec",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:nutrition-rec.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.130"
      },
      {
        "id" : "Act.templateId:nutrition-rec.extension",
        "path" : "Act.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" act (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1098-30385).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode, which SHALL be selected from ValueSet Planned moodCode (Act/Encounter/Procedure) urn:oid:2.16.840.1.113883.11.20.9.23 STATIC 2014-09-01 (CONF:1098-30386).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.23"
        }
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "comment" : "SHALL contain exactly one [1..1] code, which SHOULD be selected from ValueSet Nutrition Recommendation Grouping urn:oid:2.16.840.1.113762.1.4.1095.65.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1095.65"
        }
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionRecommendation"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-31697).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"active\" Active (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-31698).",
        "min" : 1,
        "fixedCode" : "active"
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "short" : "The effectiveTime indicates the time when the activity is intended to take place.",
        "comment" : "SHOULD contain zero or one [0..1] effectiveTime (CONF:1098-31699).",
        "condition" : ["should-effectiveTime"]
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "encounter"
            },
            {
              "type" : "profile",
              "path" : "substanceAdministration"
            },
            {
              "type" : "profile",
              "path" : "supply"
            },
            {
              "type" : "profile",
              "path" : "procedure"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Act.entryRelationship:plannedEncounter",
        "path" : "Act.entryRelationship",
        "sliceName" : "plannedEncounter",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-32382) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plannedEncounter.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32928).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plannedEncounter.encounter",
        "path" : "Act.entryRelationship.encounter",
        "comment" : "SHALL contain exactly one [1..1] Planned Encounter (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.40:2014-06-09) (CONF:1098-32383).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Encounter",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedEncounter"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:plannedMedActivity",
        "path" : "Act.entryRelationship",
        "sliceName" : "plannedMedActivity",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-32384) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plannedMedActivity.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32929).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plannedMedActivity.substanceAdministration",
        "path" : "Act.entryRelationship.substanceAdministration",
        "comment" : "SHALL contain exactly one [1..1] Planned Medication Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.42:2014-06-09) (CONF:1098-32385).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedMedicationActivity"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:plannedProc",
        "path" : "Act.entryRelationship",
        "sliceName" : "plannedProc",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-32388) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plannedProc.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32931).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plannedProc.procedure",
        "path" : "Act.entryRelationship.procedure",
        "comment" : "SHALL contain exactly one [1..1] Planned Procedure (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.41:2014-06-09) (CONF:1098-32389).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Procedure",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedProcedure"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:plannedSupply",
        "path" : "Act.entryRelationship",
        "sliceName" : "plannedSupply",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-32390) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:plannedSupply.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32932).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:plannedSupply.supply",
        "path" : "Act.entryRelationship.supply",
        "comment" : "SHALL contain exactly one [1..1] Planned Supply (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.43:2014-06-09) (CONF:1098-32391).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedSupply"
            ]
          }
        ]
      }
    ]
  }
}

```
