# Notes Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Notes Section**

## Logical Model: Notes Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/NotesSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:NotesSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.65:2026-05-01 | |

 
The Notes Section allow for inclusion of clinical documentation which does not fit precisely within any other C-CDA section. Multiple Notes sections may be included in a document provided they each include different types of note content as indicated by a different section.code. The Notes Section SHOULD NOT be used in place of a more specific C-CDA section. For example, notes about procedure should be placed within the Procedures Section, not a Notes Section. When a Notes Section is present, Note Activity entries contain structured information about the note information allowing it to be more machine processable. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required Entries**:[NoteActivity](StructureDefinition-NoteActivity.md) 

**Usages:**

* Use this Logical Model Profile: [Progress Note](StructureDefinition-ProgressNote.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/NotesSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-NotesSection.csv), [Excel](StructureDefinition-NotesSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "NotesSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/NotesSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.65:2026-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "NotesSection",
  "title" : "Notes Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Notes Section allow for inclusion of clinical documentation which does not fit precisely within any other C-CDA section. Multiple Notes sections may be included in a document provided they each include different types of note content as indicated by a different section.code.\nThe Notes Section SHOULD NOT be used in place of a more specific C-CDA section. For example, notes about procedure should be placed within the Procedures Section, not a Notes Section.\nWhen a Notes Section is present, Note Activity entries contain structured information about the note information allowing it to be more machine processable. \n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required Entries**: [NoteActivity](StructureDefinition-NoteActivity.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "shall-note-activity",
            "severity" : "error",
            "human" : "If section/@nullFlavor is not present, SHALL contain at least one Note Activity",
            "expression" : "nullFlavor.exists() or entry.where(act.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity')).exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NotesSection"
          }
        ]
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.65"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2026-05-01"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-documentreference-type",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-clinical-note-type",
              "documentation" : "If this is a Clinical Note, then this value set **SHOULD** be used.",
              "shortDoco" : "Clinical Note Type"
            }
          ]
        }
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "short" : "This title should reflect the kind of notes included in this section, corresponding to the code.",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "short" : "The narrative SHOULD contain human-readable representations using standard CDA narrative markup of each note to ensure widest compatibility with receivers.\n\nWhile allowed by CDA, the use of renderMultiMedia elements, which contain a referencedObject attribute pointing to an observationMedia or regionOfInterest element in the discrete entries, is discouraged in Note Sections because rendering support for these elements is not widespread.",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHALL contain at least one [1..*] entry (CONF:3250-16904) such that it"
      },
      {
        "id" : "Section.entry:note",
        "path" : "Section.entry",
        "sliceName" : "note",
        "short" : "If section/@nullFlavor is not present:",
        "min" : 0,
        "max" : "*",
        "condition" : ["shall-note-activity"]
      },
      {
        "id" : "Section.entry:note.act",
        "path" : "Section.entry.act",
        "comment" : "SHALL contain exactly one [1..1] Note Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.202:2016-11-01) (CONF:3250-16905).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
            ]
          }
        ]
      }
    ]
  }
}

```
