# Note Activity - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Note Activity**

## Logical Model: Note Activity 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:NoteActivity |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.202:2026-05-01 | |

 
The Note Activity represents a clinical note. Notes require authorship, authentication, timing information, and references to other discrete data such as encounters. Similar to the Comment Activity, the Note Activity permits a more specific code to characterize the type of information available in the note. The Note Activity template SHOULD NOT be used in place of a more specific C-CDA entry. Note information included needs to be relevant and pertinent to the information being communicated in the document. When the note information augments data represented in a more specific entry template, the Note Activity can be used in an entryRelationship to the associated standard C-CDA entry. For example, a Procedure Note added as an entryRelationship to a Procedure Activity Procedure entry). The Note Activity template can be used as a standalone entry within a standard C-CDA section (e.g., a note about various procedures which have occurred during a visit as an entry in the Procedures Section) when it does not augment another standard entry. It may also be used to provide additional data about the source of a currently narrative-only section, such as Hospital Course. Finally, if the type of data in the note is not known or no single C-CDA section is appropriate enough, the Note Activity should be placed in a Notes Section. (e.g., a free-text consultation note or a note which includes subjective, objective, assessment, and plan information combined). An alternative is to place the Note Activity as an entryRelationship to an Encounter Activity entry in the Encounters Section, but implementers may wish to group notes categorically into a separate location in CDA documents rather than overloading the Encounters Section. 
The narrative Clinical Notes required in USCDI, along with their associated LOINC codes, are outlined below. These note types are included in the[US Core Clinical Note Type value set](http://hl7.org/fhir/us/core/STU8/ValueSet-us-core-clinical-note-type.html), which is bound to Act.code. 
* Consultation Note (LOINC: 11488-4)
* Discharge Summary (LOINC: 18842-5)
* History & Physical Note (LOINC: 34117-2)
* Procedures Note (LOINC: 28570-0)
* Progress Note (LOINC: 11506-3)
* Surgical Operation Note (Operative Note) (LOINC: 11504-8)
* Emergency Department Note (LOINC: 34111-5)
 

**Usages:**

* Use this Logical Model Profile: [Assessment Section](StructureDefinition-AssessmentSection.md), [Assessment and Plan Section](StructureDefinition-AssessmentandPlanSection.md), [Care Team Member Act](StructureDefinition-CareTeamMemberAct.md), [Care Team Organizer](StructureDefinition-CareTeamOrganizer.md)...Show 2 more,[Notes Section](StructureDefinition-NotesSection.md)and[Plan of Treatment Section](StructureDefinition-PlanofTreatmentSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/NoteActivity)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-NoteActivity.csv), [Excel](StructureDefinition-NoteActivity.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "NoteActivity",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.202:2026-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "NoteActivity",
  "title" : "Note Activity",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Note Activity represents a clinical note. Notes require authorship, authentication, timing information, and references to other discrete data such as encounters. Similar to the Comment Activity, the Note Activity permits a more specific code to characterize the type of information available in the note. The Note Activity template SHOULD NOT be used in place of a more specific C-CDA entry. Note information included needs to be relevant and pertinent to the information being communicated in the document.\nWhen the note information augments data represented in a more specific entry template, the Note Activity can be used in an entryRelationship to the associated standard C-CDA entry. For example, a Procedure Note added as an entryRelationship to a Procedure Activity Procedure entry). \nThe Note Activity template can be used as a standalone entry within a standard C-CDA section (e.g., a note about various procedures which have occurred during a visit as an entry in the Procedures Section) when it does not augment another standard entry. It may also be used to provide additional data about the source of a currently narrative-only section, such as Hospital Course.\nFinally, if the type of data in the note is not known or no single C-CDA section is appropriate enough, the Note Activity should be placed in a Notes Section. (e.g., a free-text consultation note or a note which includes subjective, objective, assessment, and plan information combined).\nAn alternative is to place the Note Activity as an entryRelationship to an Encounter Activity entry in the Encounters Section, but implementers may wish to group notes categorically into a separate location in CDA documents rather than overloading the Encounters Section.\n\nThe narrative Clinical Notes required in USCDI, along with their associated LOINC codes, are outlined below. These note types are included in the [US Core Clinical Note Type value set](http://hl7.org/fhir/us/core/STU8/ValueSet-us-core-clinical-note-type.html), which is bound to Act.code.\n\n* Consultation Note (LOINC: 11488-4)\n* Discharge Summary (LOINC: 18842-5)\n* History & Physical Note (LOINC: 34117-2)\n* Procedures Note (LOINC: 28570-0)\n* Progress Note (LOINC: 11506-3)\n* Surgical Operation Note (Operative Note) (LOINC: 11504-8)\n* Emergency Department Note (LOINC: 34111-5)\n",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:note-activity",
        "path" : "Act.templateId",
        "sliceName" : "note-activity",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:note-activity.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.202"
      },
      {
        "id" : "Act.templateId:note-activity.extension",
        "path" : "Act.templateId.extension",
        "min" : 1,
        "patternString" : "2026-05-01"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" Act (CONF:3250-16899).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CONF:3250-16900).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-documentreference-type",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-clinical-note-type",
              "documentation" : "If this is a Clinical Note, then this value set **SHOULD** be used.",
              "shortDoco" : "Clinical Note Type"
            }
          ]
        }
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "comment" : "SHALL contain exactly one [1..1] text (CONF:3250-16896).",
        "min" : 1,
        "condition" : ["should-text-ref-value"],
        "constraint" : [
          {
            "key" : "3250-16912",
            "severity" : "error",
            "human" : "If @mediaType is present, the text SHALL contain exactly one [1..1] @representation=\"B64\" and mixed content corresponding to the contents of the note (CONF:3250-16912).",
            "expression" : "mediaType.exists() implies (representation = 'B64' and xmlText.exists())",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
          }
        ]
      },
      {
        "id" : "Act.text.mediaType",
        "path" : "Act.text.mediaType",
        "short" : "If the note was originally in another format, such as RTF, this element may also contain the base-64-encoded raw data of the note in addition to a reference to the narrative.",
        "comment" : "This text MAY contain zero or one [0..1] @mediaType, which SHOULD be selected from ValueSet SupportedFileFormats urn:oid:2.16.840.1.113883.11.20.7.1 DYNAMIC (CONF:3250-16906).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.7.1"
        }
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "comment" : "This text SHALL contain exactly one [1..1] reference (CONF:3250-16897).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
          }
        ]
      },
      {
        "id" : "Act.text.reference.nullFlavor",
        "path" : "Act.text.reference.nullFlavor",
        "short" : "The note activity must reference human-readable content in the narrative, so this reference must not be null.",
        "comment" : "This reference SHALL NOT contain [0..0] @nullFlavor (CONF:3250-16920).",
        "max" : "0"
      },
      {
        "id" : "Act.text.reference.value",
        "path" : "Act.text.reference.value",
        "comment" : "This reference SHALL contain exactly one [1..1] @value (CONF:3250-16898).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "short" : "Indicates the status of the note. The most common statusCode is completed indicating the note is signed and finalized.",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:3250-16916).",
        "min" : 1
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "short" : "The effectiveTime represents the clinically relevant time of the note. The precise timestamp of creation / updating should be conveyed in author/time.",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:3250-16903).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-value-att",
            "severity" : "warning",
            "human" : "SHOULD contain @value",
            "expression" : "value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
          }
        ]
      },
      {
        "id" : "Act.effectiveTime.value",
        "path" : "Act.effectiveTime.value",
        "comment" : "This effectiveTime SHOULD contain zero or one [0..1] @value (CONF:3250-16917)."
      },
      {
        "id" : "Act.author",
        "path" : "Act.author",
        "short" : "Represents the person(s) who wrote the note.",
        "comment" : "SHALL contain at least one [1..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:3250-16913).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ]
      },
      {
        "id" : "Act.participant",
        "path" : "Act.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "comment" : "MAY contain zero or more [0..*] participant (CONF:3250-16923) such that it"
      },
      {
        "id" : "Act.participant:legalAuthenticator",
        "path" : "Act.participant",
        "sliceName" : "legalAuthenticator",
        "short" : "Represents the person(s) legally responsible for the contents of the note.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.participant:legalAuthenticator.typeCode",
        "path" : "Act.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"LA\" Legal Authenticator (CONF:3250-16925).",
        "fixedCode" : "LA"
      },
      {
        "id" : "Act.participant:legalAuthenticator.time",
        "path" : "Act.participant.time",
        "short" : "Indicates the time of signing the note.",
        "comment" : "SHALL contain exactly one [1..1] US Realm Date and Time (Interval) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.3) (CONF:3250-16926).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/IVL-TS",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmDateTimeInterval"
            ]
          }
        ]
      },
      {
        "id" : "Act.participant:legalAuthenticator.participantRole",
        "path" : "Act.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:3250-16924).",
        "constraint" : [
          {
            "key" : "3250-16930",
            "severity" : "error",
            "human" : "If no id matches an author or participant elsewhere in the document, then playingEntity SHALL be present (CONF:3250-16930).",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
          }
        ]
      },
      {
        "id" : "Act.participant:legalAuthenticator.participantRole.id",
        "path" : "Act.participant.participantRole.id",
        "short" : "This may be the ID of the note author. If so, no additional information in this participant is required.",
        "comment" : "This participantRole SHALL contain at least one [1..*] id (CONF:3250-16927).",
        "min" : 1
      },
      {
        "id" : "Act.participant:legalAuthenticator.participantRole.sdtcSpecialty",
        "path" : "Act.participant.participantRole.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "Act.participant:legalAuthenticator.participantRole.playingEntity",
        "path" : "Act.participant.participantRole.playingEntity",
        "comment" : "This participantRole MAY contain zero or one [0..1] playingEntity (CONF:3250-16928)."
      },
      {
        "id" : "Act.participant:legalAuthenticator.participantRole.playingEntity.name",
        "path" : "Act.participant.participantRole.playingEntity.name",
        "comment" : "The playingEntity, if present, SHALL contain at least one [1..*] US Realm Person Name (PN.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.1.1) (CONF:3250-16929).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PN",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmPersonNamePNUSFIELDED"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "exists",
              "path" : "encounter"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHOULD contain zero or more [0..*] entryRelationship (CONF:3250-16907) such that it"
      },
      {
        "id" : "Act.entryRelationship:encounter",
        "path" : "Act.entryRelationship",
        "sliceName" : "encounter",
        "short" : "Links the note to an encounter. If the Note Activity is present within a document containing an encompassingEncounter, then this entryRelationship is optional and the note is associated with the encounter represented by the encompassingEncounter.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:encounter.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" (CONF:3250-16921).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Act.entryRelationship:encounter.inversionInd",
        "path" : "Act.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" (CONF:3250-16922).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Act.entryRelationship:encounter.negationInd",
        "path" : "Act.entryRelationship.negationInd",
        "short" : "To communicate that the note is not associated with any encounter, this entryRelationship MAY be included with @negationInd=\"true\" and encounter/id/@nullFlavor=\"NA\". The negationInd + encounter indicate this note is not associated with any encounter.",
        "comment" : "MAY contain zero or one [0..1] @negationInd (CONF:3250-16931)."
      },
      {
        "id" : "Act.entryRelationship:encounter.encounter",
        "path" : "Act.entryRelationship.encounter",
        "comment" : "SHALL contain exactly one [1..1] encounter (CONF:3250-16908).",
        "min" : 1
      },
      {
        "id" : "Act.entryRelationship:encounter.encounter.id",
        "path" : "Act.entryRelationship.encounter.id",
        "comment" : "This encounter SHALL contain at least one [1..*] id (CONF:3250-16909).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "3250-16914",
            "severity" : "error",
            "human" : "If the id does not match an encounter/id from the Encounters Section or encompassingEncounter within the same document and the id does not contain @nullFlavor=\"NA\", then this entry SHALL conform to the Encounter Activity (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.49:2015-08-01) (CONF:3250-16914).",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
          }
        ]
      },
      {
        "id" : "Act.reference",
        "path" : "Act.reference",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "exists",
              "path" : "externalDocument"
            }
          ],
          "rules" : "open"
        },
        "comment" : "MAY contain zero or more [0..*] reference (CONF:3250-16910) such that it"
      },
      {
        "id" : "Act.reference:externalDocument",
        "path" : "Act.reference",
        "sliceName" : "externalDocument",
        "short" : "Represents an unstructured C-CDA document containing the original contents of the note in the original format.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.reference:externalDocument.externalDocument",
        "path" : "Act.reference.externalDocument",
        "comment" : "SHALL contain exactly one [1..1] externalDocument (CONF:3250-16911).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/NoteActivity"
          }
        ]
      },
      {
        "id" : "Act.reference:externalDocument.externalDocument.id",
        "path" : "Act.reference.externalDocument.id",
        "comment" : "This externalDocument SHALL contain exactly one [1..1] id (CONF:3250-16915).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.reference:externalDocument.externalDocument.code",
        "path" : "Act.reference.externalDocument.code",
        "comment" : "This externalDocument SHOULD contain zero or one [0..1] code (CONF:3250-16918)."
      }
    ]
  }
}

```
