# Medication Supply Order - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication Supply Order**

## Logical Model: Medication Supply Order 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/MedicationSupplyOrder | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:MedicationSupplyOrder |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.17:2014-06-09 | |

 
This template records the intent to supply a patient with medications. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[InstructionObservation](StructureDefinition-InstructionObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Immunization Activity](StructureDefinition-ImmunizationActivity.md), [Medication Activity](StructureDefinition-MedicationActivity.md) and [Medication Dispense](StructureDefinition-MedicationDispense.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/MedicationSupplyOrder)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationSupplyOrder.csv), [Excel](StructureDefinition-MedicationSupplyOrder.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationSupplyOrder",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "supply"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationSupplyOrder",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.17:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "MedicationSupplyOrder",
  "title" : "Medication Supply Order",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template records the intent to supply a patient with medications.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [InstructionObservation](StructureDefinition-InstructionObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Supply",
        "path" : "Supply",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationSupplyOrder"
          },
          {
            "key" : "should-repeatNumber",
            "severity" : "warning",
            "human" : "SHOULD contain repeatNumber",
            "expression" : "repeatNumber.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationSupplyOrder"
          },
          {
            "key" : "should-quantity",
            "severity" : "warning",
            "human" : "SHOULD contain quantity",
            "expression" : "quantity.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationSupplyOrder"
          }
        ]
      },
      {
        "id" : "Supply.templateId",
        "path" : "Supply.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Supply.templateId:med-supplyOrder",
        "path" : "Supply.templateId",
        "sliceName" : "med-supplyOrder",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Supply.templateId:med-supplyOrder.root",
        "path" : "Supply.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.17"
      },
      {
        "id" : "Supply.templateId:med-supplyOrder.extension",
        "path" : "Supply.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "Supply.classCode",
        "path" : "Supply.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"SPLY\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1098-7427)."
      },
      {
        "id" : "Supply.moodCode",
        "path" : "Supply.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"INT\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1098-7428).",
        "fixedCode" : "INT"
      },
      {
        "id" : "Supply.id",
        "path" : "Supply.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-7430).",
        "min" : 1
      },
      {
        "id" : "Supply.text",
        "path" : "Supply.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Supply.text.reference",
        "path" : "Supply.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationSupplyOrder"
          }
        ]
      },
      {
        "id" : "Supply.statusCode",
        "path" : "Supply.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-7432).",
        "min" : 1
      },
      {
        "id" : "Supply.statusCode.nullFlavor",
        "path" : "Supply.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Supply.statusCode.code",
        "path" : "Supply.statusCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActStatus"
        }
      },
      {
        "id" : "Supply.effectiveTime",
        "path" : "Supply.effectiveTime",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "exists",
              "path" : "high"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Supply.effectiveTime:when",
        "path" : "Supply.effectiveTime",
        "sliceName" : "when",
        "comment" : "SHOULD contain zero or one [0..1] effectiveTime (CONF:1098-15143) such that it",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/IVL-TS"
          }
        ]
      },
      {
        "id" : "Supply.effectiveTime:when.high",
        "path" : "Supply.effectiveTime.high",
        "comment" : "SHALL contain exactly one [1..1] high (CONF:1098-15144).",
        "min" : 1
      },
      {
        "id" : "Supply.repeatNumber",
        "path" : "Supply.repeatNumber",
        "short" : "In \"INT\" (intent) mood, the repeatNumber defines the number of allowed supplies. For example, a repeatNumber of \"3\" means that the substance can be supplied up to 3 times.",
        "comment" : "SHOULD contain zero or one [0..1] repeatNumber (CONF:1098-7434).",
        "condition" : ["should-repeatNumber"]
      },
      {
        "id" : "Supply.quantity",
        "path" : "Supply.quantity",
        "short" : "SHOULD contain quantity",
        "comment" : "SHOULD contain zero or one [0..1] quantity (CONF:1098-7436).",
        "condition" : ["should-quantity"]
      },
      {
        "id" : "Supply.product",
        "path" : "Supply.product",
        "comment" : "MAY contain zero or one [0..1] product (CONF:1098-7439)."
      },
      {
        "id" : "Supply.product.manufacturedProduct",
        "path" : "Supply.product.manufacturedProduct",
        "comment" : "The product, if present, SHALL contain exactly one [1..1] Medication Information (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.23:2014-06-09) (CONF:1098-16093).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ManufacturedProduct",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationInformation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationMedicationInformation"
            ]
          }
        ]
      },
      {
        "id" : "Supply.author",
        "path" : "Supply.author",
        "comment" : "MAY contain zero or one [0..1] author (CONF:1098-7438).",
        "max" : "1"
      },
      {
        "id" : "Supply.entryRelationship",
        "path" : "Supply.entryRelationship",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1098-7442).",
        "max" : "1"
      },
      {
        "id" : "Supply.entryRelationship.typeCode",
        "path" : "Supply.entryRelationship.typeCode",
        "comment" : "The entryRelationship, if present, SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1098-7444).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "Supply.entryRelationship.inversionInd",
        "path" : "Supply.entryRelationship.inversionInd",
        "comment" : "The entryRelationship, if present, SHALL contain exactly one [1..1] @inversionInd=\"true\" True (CONF:1098-7445).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Supply.entryRelationship.observation",
        "path" : "Supply.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
