# Medication Information - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication Information**

## Logical Model: Medication Information 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/MedicationInformation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:MedicationInformation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.23:2014-06-09 | |

 
A medication should be recorded as a pre-coordinated ingredient + strength + dose form (e.g., "metoprolol 25mg tablet", "amoxicillin 400mg/5mL suspension") where possible. This includes RxNorm codes whose Term Type is SCD (semantic clinical drug), SBD (semantic brand drug), GPCK (generic pack), BPCK (brand pack). 
The dose (doseQuantity) represents how many of the consumables are to be administered at each administration event. As a result, the dose is always relative to the consumable and the interval of administration. Thus, a patient consuming a single "metoprolol 25mg tablet" per administration will have a doseQuantity of "1", whereas a patient consuming "metoprolol Oral Product" (RxCUI 1163523) will have a dose of "25 mg". 

**Usages:**

* Use this Logical Model Profile: [Medication Activity](StructureDefinition-MedicationActivity.md), [Medication Dispense](StructureDefinition-MedicationDispense.md), [Medication Supply Order](StructureDefinition-MedicationSupplyOrder.md), [Planned Medication Activity](StructureDefinition-PlannedMedicationActivity.md) and [Planned Supply](StructureDefinition-PlannedSupply.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/MedicationInformation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationInformation.csv), [Excel](StructureDefinition-MedicationInformation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationInformation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "manufacturedProduct"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationInformation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.23:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "MedicationInformation",
  "title" : "Medication Information",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "A medication should be recorded as a pre-coordinated ingredient + strength + dose form (e.g., \"metoprolol 25mg tablet\", \"amoxicillin 400mg/5mL suspension\") where possible. This includes RxNorm codes whose Term Type is SCD (semantic clinical drug), SBD (semantic brand drug), GPCK (generic pack), BPCK (brand pack).\n\nThe dose (doseQuantity) represents how many of the consumables are to be administered at each administration event. As a result, the dose is always relative to the consumable and the interval of administration. Thus, a patient consuming a single \"metoprolol 25mg tablet\" per administration will have a doseQuantity of \"1\", whereas a patient consuming \"metoprolol Oral Product\" (RxCUI 1163523) will have a dose of \"25 mg\".",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ManufacturedProduct",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/ManufacturedProduct",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ManufacturedProduct.templateId",
        "path" : "ManufacturedProduct.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ManufacturedProduct.templateId:med-information",
        "path" : "ManufacturedProduct.templateId",
        "sliceName" : "med-information",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ManufacturedProduct.templateId:med-information.root",
        "path" : "ManufacturedProduct.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.23"
      },
      {
        "id" : "ManufacturedProduct.templateId:med-information.extension",
        "path" : "ManufacturedProduct.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "ManufacturedProduct.classCode",
        "path" : "ManufacturedProduct.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"MANU\" (CodeSystem: HL7RoleClass urn:oid:2.16.840.1.113883.5.110 STATIC) (CONF:1098-7408).",
        "min" : 1
      },
      {
        "id" : "ManufacturedProduct.id",
        "path" : "ManufacturedProduct.id",
        "comment" : "MAY contain zero or more [0..*] id (CONF:1098-7410)."
      },
      {
        "id" : "ManufacturedProduct.manufacturedMaterial",
        "path" : "ManufacturedProduct.manufacturedMaterial",
        "short" : "A medication should be recorded as a pre-coordinated ingredient + strength + dose form (e.g., “metoprolol 25mg tablet”, “amoxicillin 400mg/5mL suspension”) where possible. This includes RxNorm codes whose Term Type is SCD (semantic clinical drug), SBD (semantic brand drug), GPCK (generic pack), BPCK (brand pack).",
        "comment" : "SHALL contain exactly one [1..1] manufacturedMaterial (CONF:1098-7411).",
        "min" : 1
      },
      {
        "id" : "ManufacturedProduct.manufacturedMaterial.code",
        "path" : "ManufacturedProduct.manufacturedMaterial.code",
        "comment" : "This manufacturedMaterial SHALL contain exactly one [1..1] code, which SHALL be selected from ValueSet Medication Clinical Drug urn:oid:2.16.840.1.113762.1.4.1010.4 DYNAMIC (CONF:1098-7412).",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4"
        }
      },
      {
        "id" : "ManufacturedProduct.manufacturedMaterial.code.translation",
        "path" : "ManufacturedProduct.manufacturedMaterial.code.translation",
        "short" : "Translations may also be sent with NDC codes (Codesystem urn:oid:2.16.840.1.113883.6.69).",
        "comment" : "This code MAY contain zero or more [0..*] translation, which SHALL be selected from ValueSet Clinical Substance urn:oid:2.16.840.1.113762.1.4.1010.2 DYNAMIC (CONF:1098-31884).  This code MAY contain zero or more [0..*] translation, which SHALL be selected from CodeSystem NDC urn:oid:2.16.840.1.113883.6.69.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.2"
        }
      },
      {
        "id" : "ManufacturedProduct.manufacturerOrganization",
        "path" : "ManufacturedProduct.manufacturerOrganization",
        "comment" : "MAY contain zero or one [0..1] manufacturerOrganization (CONF:1098-7416)."
      }
    ]
  }
}

```
