# Medication Dispense - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication Dispense**

## Logical Model: Medication Dispense 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:MedicationDispense |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.18:2023-05-01 | |

 
This template records the act of supplying medications (i.e., dispensing). The moodCode equaling "EVN" (Event), signals that the "supply" has occurred and thus has been dispensed. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[MedicationSupplyOrder](StructureDefinition-MedicationSupplyOrder.md) 

**Usages:**

* Use this Logical Model Profile: [Immunization Activity](StructureDefinition-ImmunizationActivity.md) and [Medication Activity](StructureDefinition-MedicationActivity.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/MedicationDispense)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationDispense.csv), [Excel](StructureDefinition-MedicationDispense.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationDispense",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "supply"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.18:2023-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "MedicationDispense",
  "title" : "Medication Dispense",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template records the act of supplying medications (i.e., dispensing). The moodCode equaling \"EVN\" (Event), signals that the \"supply\" has occurred and thus has been dispensed.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [MedicationSupplyOrder](StructureDefinition-MedicationSupplyOrder.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Supply",
        "path" : "Supply",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense"
          },
          {
            "key" : "should-effectiveTime",
            "severity" : "warning",
            "human" : "SHOULD contain effectiveTime",
            "expression" : "effectiveTime.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense"
          },
          {
            "key" : "should-repeatNumber",
            "severity" : "warning",
            "human" : "SHOULD contain repeatNumber",
            "expression" : "repeatNumber.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense"
          },
          {
            "key" : "should-quantity",
            "severity" : "warning",
            "human" : "SHOULD contain quantity",
            "expression" : "quantity.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense"
          }
        ]
      },
      {
        "id" : "Supply.templateId",
        "path" : "Supply.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Supply.templateId:med-dispense",
        "path" : "Supply.templateId",
        "sliceName" : "med-dispense",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Supply.templateId:med-dispense.root",
        "path" : "Supply.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.18"
      },
      {
        "id" : "Supply.templateId:med-dispense.extension",
        "path" : "Supply.templateId.extension",
        "min" : 1,
        "patternString" : "2023-05-01"
      },
      {
        "id" : "Supply.classCode",
        "path" : "Supply.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"SPLY\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4537-7451)."
      },
      {
        "id" : "Supply.moodCode",
        "path" : "Supply.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:4537-7452).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Supply.id",
        "path" : "Supply.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:4537-7454).",
        "min" : 1
      },
      {
        "id" : "Supply.code",
        "path" : "Supply.code",
        "short" : "The CDA base standard limits codes that can be used at CDA supply.statusCode which do not represent typical medication dispense statuses. In order to provide correct domain vocabulary and align with FHIR, CDA supply.statusCode is fixed to completed and the FHIR MedicationDispense status value set is used at supply.code.",
        "comment" : "SHALL contain exactly one [1..1] code, which SHALL be selected from ValueSet MedicationDispense Status Codes urn:oid:2.16.840.1.113883.4.642.3.1312 DYNAMIC (CONF:4537-32974).",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationdispense-status"
        }
      },
      {
        "id" : "Supply.text",
        "path" : "Supply.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Supply.text.reference",
        "path" : "Supply.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense"
          }
        ]
      },
      {
        "id" : "Supply.statusCode",
        "path" : "Supply.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4537-7455).",
        "min" : 1
      },
      {
        "id" : "Supply.statusCode.code",
        "path" : "Supply.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:4537-32361).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Supply.effectiveTime",
        "path" : "Supply.effectiveTime",
        "short" : "SHOULD contain effectiveTime",
        "comment" : "SHOULD contain zero or one [0..1] effectiveTime (CONF:4537-7456).",
        "max" : "1",
        "condition" : ["should-effectiveTime"]
      },
      {
        "id" : "Supply.repeatNumber",
        "path" : "Supply.repeatNumber",
        "short" : "In \"EVN\" (event) mood, the repeatNumber is the number of dispenses. For example, a repeatNumber of \"3\" indicates the third dispense.",
        "comment" : "SHOULD contain zero or one [0..1] repeatNumber (CONF:4537-7457).",
        "condition" : ["should-repeatNumber"]
      },
      {
        "id" : "Supply.quantity",
        "path" : "Supply.quantity",
        "short" : "SHOULD contain quantity",
        "comment" : "SHOULD contain zero or one [0..1] quantity (CONF:4537-7458).",
        "condition" : ["should-quantity"]
      },
      {
        "id" : "Supply.product",
        "path" : "Supply.product",
        "min" : 1
      },
      {
        "id" : "Supply.product.manufacturedProduct",
        "path" : "Supply.product.manufacturedProduct",
        "comment" : "The product, if present, SHALL contain exactly one [1..1] Medication Information (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.23:2014-06-09) (CONF:4537-15607).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ManufacturedProduct",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationInformation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationMedicationInformation"
            ]
          }
        ]
      },
      {
        "id" : "Supply.performer",
        "path" : "Supply.performer",
        "comment" : "MAY contain zero or one [0..1] performer (CONF:4537-7461).",
        "max" : "1"
      },
      {
        "id" : "Supply.performer.assignedEntity",
        "path" : "Supply.performer.assignedEntity",
        "comment" : "The performer, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:4537-7467).",
        "constraint" : [
          {
            "key" : "should-addr",
            "severity" : "warning",
            "human" : "SHOULD contain addr",
            "expression" : "addr.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense"
          }
        ]
      },
      {
        "id" : "Supply.performer.assignedEntity.addr",
        "path" : "Supply.performer.assignedEntity.addr",
        "comment" : "This assignedEntity SHOULD contain zero or one [0..1] US Realm Address (AD.US.FIELDED) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.2) (CONF:4537-7468).",
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Supply.entryRelationship",
        "path" : "Supply.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "supply"
            },
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:4537-7473) such that it"
      },
      {
        "id" : "Supply.entryRelationship:entryRelationship1",
        "path" : "Supply.entryRelationship",
        "sliceName" : "entryRelationship1",
        "short" : "entryRelationship",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Supply.entryRelationship:entryRelationship1.typeCode",
        "path" : "Supply.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:4537-7474).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Supply.entryRelationship:entryRelationship1.supply",
        "path" : "Supply.entryRelationship.supply",
        "comment" : "SHALL contain exactly one [1..1] Medication Supply Order (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.17:2014-06-09) (CONF:4537-15606).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationSupplyOrder"
            ]
          }
        ]
      }
    ]
  }
}

```
