# Medication Activity - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication Activity**

## Logical Model: Medication Activity 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:MedicationActivity |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.16:2014-06-09 | |

 
A Medication Activity describes substance administrations that have actually occurred (e.g., pills ingested or injections given) or are intended to occur (e.g., "take 2 tablets twice a day for the next 10 days"). Medication activities in "INT" mood are reflections of what a clinician intends a patient to be taking. For example, a clinician may intend that a patient be administered Lisinopril 20 mg PO for blood pressure control. If what was actually administered was Lisinopril 10 mg., then the Medication activities in the "EVN" mood would reflect actual use. 
A moodCode of INT is allowed, but it is recommended that the Planned Medication Activity template be used for moodCodes other than EVN if the document type contains a section that includes Planned Medication Activity (for example a Care Plan document with Plan of Treatment, Intervention, or Goal sections). 
At a minimum, a Medication Activity shall include an effectiveTime indicating the duration of the administration (or single-administration timestamp). Ambulatory medication lists generally provide a summary of use for a given medication over time - a medication activity in event mood with the duration reflecting when the medication started and stopped. Ongoing medications will not have a stop date (or will have a stop date with a suitable NULL value). Ambulatory medication lists will generally also have a frequency (e.g., a medication is being taken twice a day). Inpatient medications generally record each administration as a separate act. 
The dose (doseQuantity) represents how many of the consumables are to be administered at each administration event. As a result, the dose is always relative to the consumable and the interval of administration. Thus, a patient consuming a single "metoprolol 25mg tablet" per administration will have a doseQuantity of "1", whereas a patient consuming "metoprolol Oral Product" (RxCUI 1163523) will have a dose of "25 mg". 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[DrugMonitoringAct](StructureDefinition-DrugMonitoringAct.md),[Indication](StructureDefinition-Indication.md),[InstructionObservation](StructureDefinition-InstructionObservation.md),[MedicationAdherence](StructureDefinition-MedicationAdherence.md),[MedicationDispense](StructureDefinition-MedicationDispense.md),[MedicationFreeTextSig](StructureDefinition-MedicationFreeTextSig.md),[MedicationSupplyOrder](StructureDefinition-MedicationSupplyOrder.md),[ReactionObservation](StructureDefinition-ReactionObservation.md),[SubstanceAdministeredAct](StructureDefinition-SubstanceAdministeredAct.md) 

**Usages:**

* Use this Logical Model Profile: [Admission Medication](StructureDefinition-AdmissionMedication.md), [Anesthesia Section](StructureDefinition-AnesthesiaSection.md), [Discharge Medication](StructureDefinition-DischargeMedication.md), [Intervention Act](StructureDefinition-InterventionAct.md)...Show 5 more,[Medications Administered Section](StructureDefinition-MedicationsAdministeredSection.md),[Medications Section](StructureDefinition-MedicationsSection.md),[Planned Intervention Act](StructureDefinition-PlannedInterventionAct.md),[Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md)and[Reaction Observation](StructureDefinition-ReactionObservation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/MedicationActivity)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationActivity.csv), [Excel](StructureDefinition-MedicationActivity.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationActivity",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "substanceAdministration"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.16:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "MedicationActivity",
  "title" : "Medication Activity",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "A Medication Activity describes substance administrations that have actually occurred (e.g., pills ingested or injections given) or are intended to occur (e.g., \"take 2 tablets twice a day for the next 10 days\"). Medication activities in \"INT\" mood are reflections of what a clinician intends a patient to be taking. For example, a clinician may intend that a patient be administered Lisinopril 20 mg PO for blood pressure control. If what was actually administered was Lisinopril 10 mg., then the Medication activities in the \"EVN\" mood would reflect actual use.\n\nA moodCode of INT is allowed, but it is recommended that the Planned Medication Activity template be used for moodCodes other than EVN if the document type contains a section that includes Planned Medication Activity (for example a Care Plan document with Plan of Treatment, Intervention, or Goal sections).\n\nAt a minimum, a Medication Activity shall include an effectiveTime indicating the duration of the administration (or single-administration timestamp). Ambulatory medication lists generally provide a summary of use for a given medication over time - a medication activity in event mood with the duration reflecting when the medication started and stopped. Ongoing medications will not have a stop date (or will have a stop date with a suitable NULL value). Ambulatory medication lists will generally also have a frequency (e.g., a medication is being taken twice a day). Inpatient medications generally record each administration as a separate act.\n\nThe dose (doseQuantity) represents how many of the consumables are to be administered at each administration event. As a result, the dose is always relative to the consumable and the interval of administration. Thus, a patient consuming a single \"metoprolol 25mg tablet\" per administration will have a doseQuantity of \"1\", whereas a patient consuming \"metoprolol Oral Product\" (RxCUI 1163523) will have a dose of \"25 mg\".\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [DrugMonitoringAct](StructureDefinition-DrugMonitoringAct.html), [Indication](StructureDefinition-Indication.html), [InstructionObservation](StructureDefinition-InstructionObservation.html), [MedicationAdherence](StructureDefinition-MedicationAdherence.html), [MedicationDispense](StructureDefinition-MedicationDispense.html), [MedicationFreeTextSig](StructureDefinition-MedicationFreeTextSig.html), [MedicationSupplyOrder](StructureDefinition-MedicationSupplyOrder.html), [ReactionObservation](StructureDefinition-ReactionObservation.html), [SubstanceAdministeredAct](StructureDefinition-SubstanceAdministeredAct.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "SubstanceAdministration",
        "path" : "SubstanceAdministration",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          },
          {
            "key" : "1098-7513",
            "severity" : "warning",
            "human" : "SHOULD contain zero or one [0..1] effectiveTime (CONF:1098-7513) such that it **SHALL** contain exactly one [1..1] @xsi:type=\"PIVL_TS\" or \"EIVL_TS\" (CONF:1098-28499).",
            "expression" : "effectiveTime.ofType(CDA.PIVL_TS).exists() or effectiveTime.ofType(CDA.EIVL_TS).exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          },
          {
            "key" : "should-routeCode",
            "severity" : "warning",
            "human" : "SHOULD contain routeCode",
            "expression" : "routeCode.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          },
          {
            "key" : "dose-unit-or-admin-unit",
            "severity" : "error",
            "human" : "If doseQuantity/@unit is present, then administrationUnitCode SHALL NOT be present.",
            "expression" : "doseQuantity.unit.exists() implies administrationUnitCode.empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.templateId",
        "path" : "SubstanceAdministration.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.templateId:medication-activity",
        "path" : "SubstanceAdministration.templateId",
        "sliceName" : "medication-activity",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.templateId:medication-activity.root",
        "path" : "SubstanceAdministration.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.16"
      },
      {
        "id" : "SubstanceAdministration.templateId:medication-activity.extension",
        "path" : "SubstanceAdministration.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "SubstanceAdministration.classCode",
        "path" : "SubstanceAdministration.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"SBADM\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1098-7496)."
      },
      {
        "id" : "SubstanceAdministration.moodCode",
        "path" : "SubstanceAdministration.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode, which SHALL be selected from ValueSet MoodCodeEvnInt urn:oid:2.16.840.1.113883.11.20.9.18 STATIC 2011-04-03 (CONF:1098-7497).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.18"
        }
      },
      {
        "id" : "SubstanceAdministration.id",
        "path" : "SubstanceAdministration.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-7500).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.code",
        "path" : "SubstanceAdministration.code",
        "short" : "SubstanceAdministration.code is an optional field. Per HL7 Pharmacy Committee, \"this is intended to further specify the nature of the substance administration act. To date the committee has made no use of this attribute\". Because the type of substance administration is generally implicit in the routeCode, in the consumable participant, etc., the field is generally not used, and there is no defined value set.",
        "comment" : "MAY contain zero or one [0..1] code (CONF:1098-7506)."
      },
      {
        "id" : "SubstanceAdministration.text",
        "path" : "SubstanceAdministration.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "SubstanceAdministration.text.reference",
        "path" : "SubstanceAdministration.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.statusCode",
        "path" : "SubstanceAdministration.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-7507).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.statusCode.code",
        "path" : "SubstanceAdministration.statusCode.code",
        "short" : "The substance administration effectiveTime field can repeat, in order to represent varying levels of complex dosing. effectiveTime can be used to represent the duration of administration (e.g., \"10 days\"), the frequency of administration (e.g., \"every 8 hours\"), and more. Here, we require that there SHALL be an effectiveTime documentation of the duration (or single-administration timestamp), and that there SHOULD be an effectiveTime documentation of the frequency. Other timing nuances, supported by the base CDA R2 standard, may also be included.",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code, which SHALL be selected from ValueSet Medication Status urn:oid:2.16.840.1.113762.1.4.1099.11 DYNAMIC (CONF:1098-32360).",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.11"
        }
      },
      {
        "id" : "SubstanceAdministration.effectiveTime",
        "path" : "SubstanceAdministration.effectiveTime",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.effectiveTime:duration",
        "path" : "SubstanceAdministration.effectiveTime",
        "sliceName" : "duration",
        "short" : "The substance administration effectiveTime field can repeat, in order to represent varying levels of complex dosing. effectiveTime can be used to represent the duration of administration (e.g., \"10 days\"), the frequency of administration (e.g., \"every 8 hours\"), and more. Here, we require that there **SHALL** be an effectiveTime documentation of the duration (or single-administration timestamp), and that there **SHOULD** be an effectiveTime documentation of the frequency. Other timing nuances, supported by the base CDA R2 standard, may also be included. Note: This effectiveTime represents either the time the medication was started and stopped or the single-administration timestamp.",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1098-7508) such that it",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/IVL-TS"
          }
        ],
        "constraint" : [
          {
            "key" : "1098-32890",
            "severity" : "error",
            "human" : "This effectiveTime **SHALL** contain either a low or a @value but not both (CONF:1098-32890).",
            "expression" : "(value.exists() or low.exists()) and ((value.exists() and low.exists()).not())",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          },
          {
            "key" : "should-value-att",
            "severity" : "warning",
            "human" : "SHOULD contain @value",
            "expression" : "value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          },
          {
            "key" : "should-low",
            "severity" : "warning",
            "human" : "SHOULD contain low",
            "expression" : "low.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.effectiveTime:duration.value",
        "path" : "SubstanceAdministration.effectiveTime.value",
        "short" : "indicates a single-administration timestamp",
        "comment" : "SHOULD contain zero or one [0..1] @value (CONF:1098-32775)."
      },
      {
        "id" : "SubstanceAdministration.effectiveTime:duration.low",
        "path" : "SubstanceAdministration.effectiveTime.low",
        "short" : "indicates when medication started",
        "comment" : "SHOULD contain zero or one [0..1] low (CONF:1098-32776)."
      },
      {
        "id" : "SubstanceAdministration.effectiveTime:duration.high",
        "path" : "SubstanceAdministration.effectiveTime.high",
        "short" : "indicates when medication stopped",
        "comment" : "MAY contain zero or one [0..1] high (CONF:1098-32777)."
      },
      {
        "id" : "SubstanceAdministration.effectiveTime:periodicFrequency",
        "path" : "SubstanceAdministration.effectiveTime",
        "sliceName" : "periodicFrequency",
        "short" : "This effectiveTime represents a periodic medication frequency (e.g., administration times per day).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/PIVL-TS"
          }
        ],
        "condition" : ["1098-7513"]
      },
      {
        "id" : "SubstanceAdministration.effectiveTime:periodicFrequency.operator",
        "path" : "SubstanceAdministration.effectiveTime.operator",
        "comment" : "SHALL contain exactly one [1..1] @operator=\"A\" (CONF:1098-9106).",
        "min" : 1,
        "patternCode" : "A"
      },
      {
        "id" : "SubstanceAdministration.effectiveTime:eventFrequency",
        "path" : "SubstanceAdministration.effectiveTime",
        "sliceName" : "eventFrequency",
        "short" : "This effectiveTime represents an event-based medication frequency (e.g., administration at bedtime).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/EIVL-TS"
          }
        ],
        "condition" : ["1098-7513"]
      },
      {
        "id" : "SubstanceAdministration.effectiveTime:eventFrequency.operator",
        "path" : "SubstanceAdministration.effectiveTime.operator",
        "comment" : "SHALL contain exactly one [1..1] @operator=\"A\" (CONF:1098-9106).",
        "min" : 1,
        "patternCode" : "A"
      },
      {
        "id" : "SubstanceAdministration.repeatNumber",
        "path" : "SubstanceAdministration.repeatNumber",
        "short" : "In \"INT\" (intent) mood, the repeatNumber defines the number of allowed administrations. For example, a repeatNumber of \"3\" means that the substance can be administered up to 3 times. In \"EVN\" (event) mood, the repeatNumber is the number of occurrences. For example, a repeatNumber of \"3\" in a substance administration event means that the current administration is the 3rd in a series.",
        "comment" : "MAY contain zero or one [0..1] repeatNumber (CONF:1098-7555)."
      },
      {
        "id" : "SubstanceAdministration.routeCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "SubstanceAdministration.routeCode",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Route Code - SPL",
        "comment" : "SHOULD contain zero or one [0..1] routeCode, which SHALL be selected from ValueSet SPL Drug Route of Administration Terminology urn:oid:2.16.840.1.113883.3.88.12.3221.8.7 DYNAMIC (CONF:1098-7514).",
        "condition" : ["should-routeCode"],
        "constraint" : [
          {
            "key" : "should-translation",
            "severity" : "warning",
            "human" : "SHOULD contain translation",
            "expression" : "translation.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.3221.8.7"
        }
      },
      {
        "id" : "SubstanceAdministration.routeCode.translation",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "SubstanceAdministration.routeCode.translation",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Route Code - SNOMED",
        "comment" : "The routeCode, if present, SHOULD contain zero or more [0..*] translation, which SHALL be selected from ValueSet Medication Route urn:oid:2.16.840.1.113762.1.4.1099.12 DYNAMIC (CONF:1098-32950).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.12"
        }
      },
      {
        "id" : "SubstanceAdministration.approachSiteCode",
        "path" : "SubstanceAdministration.approachSiteCode",
        "comment" : "MAY contain zero or one [0..1] approachSiteCode, where the code SHALL be selected from ValueSet Body Site Value Set urn:oid:2.16.840.1.113883.3.88.12.3221.8.9 DYNAMIC (CONF:1098-7515).",
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.3221.8.9"
        }
      },
      {
        "id" : "SubstanceAdministration.doseQuantity",
        "path" : "SubstanceAdministration.doseQuantity",
        "short" : "If the consumable code is not pre-coordinated (e.g., is \"simply metoprolol Oral Product\" (RxCUI 1163523), then doseQuantity must represent a physical quantity with @unit, e.g., \"25\" and \"mg\", specifying the amount of product given per administration (CONF:1098-16879).&#10;If the consumable code is a pre-coordinated unit dose (e.g., \"metoprolol 25mg tablet\") then doseQuantity is a unitless number that indicates the number of products given per administration (e.g., \"2\", meaning 2 x \"metoprolol 25mg tablet\" per administration) (CONF:1098-16878).",
        "comment" : "SHALL contain exactly one [1..1] doseQuantity (CONF:1098-7516).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-unit",
            "severity" : "warning",
            "human" : "SHOULD contain @unit",
            "expression" : "nullFlavor.exists() or unit.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationActivity"
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.doseQuantity.unit",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "SubstanceAdministration.doseQuantity.unit",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Dose Unit of Measure. NOTE: The base CDA R2.0 standard requires @unit to be drawn from UCUM, and best practice is to use case sensitive UCUM units",
        "definition" : "NOTE: The base CDA R2.0 standard requires @unit to be drawn from UCUM, and best practice is to use case sensitive UCUM units",
        "comment" : "This doseQuantity SHOULD contain zero or one [0..1] @unit, which SHOULD be selected from ValueSet UnitsOfMeasureCaseSensitive urn:oid:2.16.840.1.113883.1.11.12839 DYNAMIC (CONF:1098-7526).",
        "condition" : ["dose-unit-or-admin-unit"],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-UnitsOfMeasureCaseSensitive"
        }
      },
      {
        "id" : "SubstanceAdministration.rateQuantity",
        "path" : "SubstanceAdministration.rateQuantity",
        "comment" : "MAY contain zero or one [0..1] rateQuantity (CONF:1098-7517)."
      },
      {
        "id" : "SubstanceAdministration.rateQuantity.unit",
        "path" : "SubstanceAdministration.rateQuantity.unit",
        "short" : "NOTE: The base CDA R2.0 standard requires @unit to be drawn from UCUM, and best practice is to use case sensitive UCUM units",
        "comment" : "The rateQuantity, if present, SHALL contain exactly one [1..1] @unit, which SHALL be selected from ValueSet UnitsOfMeasureCaseSensitive urn:oid:2.16.840.1.113883.1.11.12839 DYNAMIC (CONF:1098-7525).",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-UnitsOfMeasureCaseSensitive"
        }
      },
      {
        "id" : "SubstanceAdministration.maxDoseQuantity",
        "path" : "SubstanceAdministration.maxDoseQuantity",
        "comment" : "MAY contain zero or one [0..1] maxDoseQuantity (CONF:1098-7518)."
      },
      {
        "id" : "SubstanceAdministration.administrationUnitCode",
        "path" : "SubstanceAdministration.administrationUnitCode",
        "short" : "administrationUnitCode@code describes the units of medication administration for an item using a code that is pre-coordinated to include a physical unit form (ointment, powder, solution, etc.) which differs from the units used in administering the consumable (capful, spray, drop, etc.). For example when recording medication administrations, 'metric drop (C48491)'' would be appropriate to accompany the RxNorm code of 198283 (Timolol 0.25% Ophthalmic Solution) where the number of drops would be specified in doseQuantity@value.",
        "comment" : "MAY contain zero or one [0..1] administrationUnitCode, which SHALL be selected from ValueSet AdministrationUnitDoseForm urn:oid:2.16.840.1.113762.1.4.1021.30 DYNAMIC (CONF:1098-7519).",
        "condition" : ["dose-unit-or-admin-unit"],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.30"
        }
      },
      {
        "id" : "SubstanceAdministration.consumable",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "SubstanceAdministration.consumable",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Medications",
        "comment" : "This consumable SHALL contain exactly one [1..1] Medication Information (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.23:2014-06-09) (CONF:1098-16085)."
      },
      {
        "id" : "SubstanceAdministration.consumable.manufacturedProduct",
        "path" : "SubstanceAdministration.consumable.manufacturedProduct",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ManufacturedProduct",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationInformation"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.performer",
        "path" : "SubstanceAdministration.performer",
        "comment" : "MAY contain zero or one [0..1] performer (CONF:1098-7522).",
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.author",
        "path" : "SubstanceAdministration.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1098-31150).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "SubstanceAdministration.participant",
        "path" : "SubstanceAdministration.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "SubstanceAdministration.participant:drugVehicle",
        "path" : "SubstanceAdministration.participant",
        "sliceName" : "drugVehicle",
        "comment" : "MAY contain zero or more [0..*] participant (CONF:1098-7523) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.participant:drugVehicle.typeCode",
        "path" : "SubstanceAdministration.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"CSM\" (CodeSystem: HL7ParticipationType urn:oid:2.16.840.1.113883.5.90 STATIC) (CONF:1098-7524).",
        "fixedCode" : "CSM"
      },
      {
        "id" : "SubstanceAdministration.participant:drugVehicle.participantRole",
        "path" : "SubstanceAdministration.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] Drug Vehicle (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.24) (CONF:1098-16086).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/DrugVehicle"]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship",
        "path" : "SubstanceAdministration.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "substanceAdministration"
            },
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "supply"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "indication",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Indication",
        "comment" : "SHALL contain exactly one [1..1] Indication (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.19:2014-06-09) (CONF:1098-16087).",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"RSON\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1098-7537).",
        "fixedCode" : "RSON"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:indication.observation",
        "path" : "SubstanceAdministration.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : ["http://hl7.org/cda/us/ccda/StructureDefinition/Indication"]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:instruction",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "instruction",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1098-7539) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:instruction.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"SUBJ\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1098-7540).",
        "fixedCode" : "SUBJ"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:instruction.inversionInd",
        "path" : "SubstanceAdministration.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" True (CONF:1098-7542).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:instruction.observation",
        "path" : "SubstanceAdministration.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionObservation"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:supplyOrder",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "supplyOrder",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1098-7543) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:supplyOrder.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1098-7547).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:supplyOrder.supply",
        "path" : "SubstanceAdministration.entryRelationship.supply",
        "comment" : "SHALL contain exactly one [1..1] Medication Supply Order (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.17:2014-06-09) (CONF:1098-16089).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationSupplyOrder"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:medicationDispense",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "medicationDispense",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-7549) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:medicationDispense.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1098-7553).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:medicationDispense.supply",
        "path" : "SubstanceAdministration.entryRelationship.supply",
        "comment" : "SHALL contain exactly one [1..1] Medication Dispense (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.18:2014-06-09) (CONF:1098-16090).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Supply",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationDispense"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:reaction",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "reaction",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-7552) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:reaction.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"CAUS\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1098-7544).",
        "fixedCode" : "CAUS"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:reaction.observation",
        "path" : "SubstanceAdministration.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Reaction Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.9:2014-06-09) (CONF:1098-16091).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReactionObservation"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:drugMonitoring",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "drugMonitoring",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1098-30820) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:drugMonitoring.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has component (CONF:1098-30821).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:drugMonitoring.act",
        "path" : "SubstanceAdministration.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Drug Monitoring Act (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.123) (CONF:1098-30822).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/DrugMonitoringAct"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:substanceAdministered",
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "substanceAdministered",
        "short" : "The following entryRelationship is used to indicate a given medication's order in a series. The nested Substance Administered Act identifies an administration in the series. The entryRelationship/sequenceNumber shows the order of this particular administration in that series.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-31515) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:substanceAdministered.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-31516).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:substanceAdministered.inversionInd",
        "path" : "SubstanceAdministration.entryRelationship.inversionInd",
        "comment" : "SHALL contain exactly one [1..1] @inversionInd=\"true\" (CONF:1098-31517).",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:substanceAdministered.sequenceNumber",
        "path" : "SubstanceAdministration.entryRelationship.sequenceNumber",
        "comment" : "MAY contain zero or one [0..1] sequenceNumber (CONF:1098-31518)."
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:substanceAdministered.act",
        "path" : "SubstanceAdministration.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Substance Administered Act (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.118) (CONF:1098-31519).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceAdministeredAct"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:adherence",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "adherence",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Medication Adherence",
        "comment" : "MAY contain zero or more [0..*] entryRelationship such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:adherence.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:adherence.observation",
        "path" : "SubstanceAdministration.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Medication Adherence (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.508).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationAdherence"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:signature",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "SubstanceAdministration.entryRelationship",
        "sliceName" : "signature",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Medication Instructions",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1098-32907) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:signature.typeCode",
        "path" : "SubstanceAdministration.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1098-32908).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "SubstanceAdministration.entryRelationship:signature.substanceAdministration",
        "path" : "SubstanceAdministration.entryRelationship.substanceAdministration",
        "comment" : "SHALL contain exactly one [1..1] Medication Free Text Sig (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.147) (CONF:1098-32909).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/SubstanceAdministration",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationFreeTextSig"
            ]
          }
        ]
      },
      {
        "id" : "SubstanceAdministration.precondition",
        "path" : "SubstanceAdministration.precondition",
        "comment" : "MAY contain zero or more [0..*] precondition (CONF:1098-31520)."
      },
      {
        "id" : "SubstanceAdministration.precondition.typeCode",
        "path" : "SubstanceAdministration.precondition.typeCode",
        "comment" : "The precondition, if present, SHALL contain exactly one [1..1] @typeCode=\"PRCN\" (CONF:1098-31882).",
        "min" : 1
      },
      {
        "id" : "SubstanceAdministration.precondition.criterion",
        "path" : "SubstanceAdministration.precondition.criterion",
        "comment" : "The precondition, if present, SHALL contain exactly one [1..1] Precondition for Substance Administration (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.25:2014-06-09) (CONF:1098-31883).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Criterion",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PreconditionforSubstanceAdministration"
            ]
          }
        ]
      }
    ]
  }
}

```
