# Longitudinal Care Wound Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Longitudinal Care Wound Observation**

## Logical Model: Longitudinal Care Wound Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/LongitudinalCareWoundObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:LongitudinalCareWoundObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.114:2015-08-01 | |

 
This template represents acquired or surgical wounds and is not intended to encompass all wound types. The template applies to wounds such as pressure ulcers, surgical incisions, and deep tissue injury wounds. Information in this template may include information about the wound measurements characteristics. 

**Usages:**

* Use this Logical Model Profile: [Health Concern Act](StructureDefinition-HealthConcernAct.md), [Physical Exam Section](StructureDefinition-PhysicalExamSection.md) and [Risk Concern Act](StructureDefinition-RiskConcernAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/LongitudinalCareWoundObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-LongitudinalCareWoundObservation.csv), [Excel](StructureDefinition-LongitudinalCareWoundObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LongitudinalCareWoundObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/LongitudinalCareWoundObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.114:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "LongitudinalCareWoundObservation",
  "title" : "Longitudinal Care Wound Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents acquired or surgical wounds and is not intended to encompass all wound types. The template applies to wounds such as pressure ulcers, surgical incisions, and deep tissue injury wounds. Information in this template may include information about the wound measurements characteristics.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "min" : 2
      },
      {
        "id" : "Observation.templateId:Longitudinal-care-wound-obs",
        "path" : "Observation.templateId",
        "sliceName" : "Longitudinal-care-wound-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:Longitudinal-care-wound-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.114"
      },
      {
        "id" : "Observation.templateId:Longitudinal-care-wound-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1198-31012)."
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1198-31013)."
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1198-29476)."
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"ASSERTION\" assertion (CONF:1198-29477).",
        "min" : 1,
        "patternCode" : "ASSERTION"
      },
      {
        "id" : "Observation.code.codeSystem",
        "path" : "Observation.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.5.4\" (CodeSystem: HL7ActCode urn:oid:2.16.840.1.113883.5.4) (CONF:1198-31010).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.5.4"
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "comment" : "SHALL contain exactly one [1..1] value with @xsi:type=\"CD\", where the code SHOULD be selected from ValueSet Wound Type urn:oid:2.16.840.1.113883.1.11.20.2.6 DYNAMIC (CONF:1198-29485).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.20.2.6"
        }
      },
      {
        "id" : "Observation.targetSiteCode",
        "path" : "Observation.targetSiteCode",
        "comment" : "SHOULD contain zero or one [0..1] targetSiteCode, which SHOULD be selected from ValueSet Body Site Value Set urn:oid:2.16.840.1.113883.3.88.12.3221.8.9 DYNAMIC (CONF:1198-29488) such that it",
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.3221.8.9"
        }
      },
      {
        "id" : "Observation.targetSiteCode.qualifier",
        "path" : "Observation.targetSiteCode.qualifier",
        "short" : "If targetSite/qualifierCode name/value pairs are used, care must be taken to avoid conflict with the SNOMED-CT body structure code used in observation/value.  SNOMED-CT body structure codes are often pre-coordinated with laterality.",
        "comment" : "MAY contain zero or more [0..*] qualifier (CONF:1198-29490)."
      },
      {
        "id" : "Observation.targetSiteCode.qualifier.name",
        "path" : "Observation.targetSiteCode.qualifier.name",
        "comment" : "The qualifier, if present, SHALL contain exactly one [1..1] name (CONF:1198-29491).",
        "min" : 1
      },
      {
        "id" : "Observation.targetSiteCode.qualifier.name.code",
        "path" : "Observation.targetSiteCode.qualifier.name.code",
        "comment" : "This name SHALL contain exactly one [1..1] @code=\"272741003\" laterality (CONF:1198-29492).",
        "min" : 1,
        "patternCode" : "272741003"
      },
      {
        "id" : "Observation.targetSiteCode.qualifier.name.codeSystem",
        "path" : "Observation.targetSiteCode.qualifier.name.codeSystem",
        "comment" : "This name SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.6.96\" (CodeSystem: SNOMED CT urn:oid:2.16.840.1.113883.6.96) (CONF:1198-31524).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.96"
      },
      {
        "id" : "Observation.targetSiteCode.qualifier.value",
        "path" : "Observation.targetSiteCode.qualifier.value",
        "comment" : "The qualifier, if present, SHALL contain exactly one [1..1] value (CONF:1198-29493).",
        "min" : 1
      },
      {
        "id" : "Observation.targetSiteCode.qualifier.value.nullFlavor",
        "path" : "Observation.targetSiteCode.qualifier.value.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Observation.targetSiteCode.qualifier.value.code",
        "path" : "Observation.targetSiteCode.qualifier.value.code",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.37"
        }
      },
      {
        "id" : "Observation.author",
        "path" : "Observation.author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1198-31542)."
      },
      {
        "id" : "Observation.entryRelationship",
        "path" : "Observation.entryRelationship",
        "short" : "When the wound observed is a type of pressure ulcer, then this template SHOULD contain an entry for the Highest Pressure Ulcer Stage."
      },
      {
        "id" : "Observation.entryRelationship:woundMeasurementObservation",
        "path" : "Observation.entryRelationship",
        "sliceName" : "woundMeasurementObservation",
        "comment" : "SHOULD contain zero or more [0..*] entryRelationship (CONF:1198-29495) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.entryRelationship:woundMeasurementObservation.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002 STATIC) (CONF:1198-29496).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Observation.entryRelationship:woundMeasurementObservation.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Wound Measurement Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.133) (CONF:1198-29497).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/WoundMeasurementObservation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:woundCharacteristic",
        "path" : "Observation.entryRelationship",
        "sliceName" : "woundCharacteristic",
        "comment" : "SHOULD contain zero or more [0..*] entryRelationship (CONF:1198-29503) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.entryRelationship:woundCharacteristic.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" (CONF:1198-29504).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Observation.entryRelationship:woundCharacteristic.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Wound Characteristic (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.134) (CONF:1198-29505).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/WoundCharacteristic"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:numberofPressureUlcersObservation",
        "path" : "Observation.entryRelationship",
        "sliceName" : "numberofPressureUlcersObservation",
        "short" : "When the wound observed is a type of pressure ulcer, then this template SHOULD contain an entry for the Number of Pressure Ulcers.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:1198-31890) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.entryRelationship:numberofPressureUlcersObservation.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31891).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Observation.entryRelationship:numberofPressureUlcersObservation.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Number of Pressure Ulcers Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.76:2015-08-01) (CONF:1198-31892).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NumberofPressureUlcersObservation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.entryRelationship:highestPressureUlcerStage",
        "path" : "Observation.entryRelationship",
        "sliceName" : "highestPressureUlcerStage",
        "comment" : "MAY contain zero or one [0..1] entryRelationship (CONF:1198-31893) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.entryRelationship:highestPressureUlcerStage.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:1198-31894).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Observation.entryRelationship:highestPressureUlcerStage.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Highest Pressure Ulcer Stage (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.77) (CONF:1198-31919).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HighestPressureUlcerStage"
            ]
          }
        ]
      }
    ]
  }
}

```
