# Immunization Medication Information - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Immunization Medication Information**

## Logical Model: Immunization Medication Information 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationMedicationInformation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ImmunizationMedicationInformation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.54:2014-06-09 | |

 
The Immunization Medication Information represents product information about the immunization substance. The vaccine manufacturer and vaccine lot number are typically recorded in the medical record and should be included if known. 

**Usages:**

* Use this Logical Model Profile: [Immunization Activity](StructureDefinition-ImmunizationActivity.md), [Medication Dispense](StructureDefinition-MedicationDispense.md), [Medication Supply Order](StructureDefinition-MedicationSupplyOrder.md), [Planned Immunization Activity](StructureDefinition-PlannedImmunizationActivity.md) and [Planned Supply](StructureDefinition-PlannedSupply.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ImmunizationMedicationInformation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ImmunizationMedicationInformation.csv), [Excel](StructureDefinition-ImmunizationMedicationInformation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ImmunizationMedicationInformation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "manufacturedProduct"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationMedicationInformation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.54:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ImmunizationMedicationInformation",
  "title" : "Immunization Medication Information",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Immunization Medication Information represents product information about the immunization substance. The vaccine manufacturer and vaccine lot number are typically recorded in the medical record and should be included if known.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ManufacturedProduct",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/ManufacturedProduct",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ManufacturedProduct",
        "path" : "ManufacturedProduct",
        "constraint" : [
          {
            "key" : "should-manufacturerOrganization",
            "severity" : "warning",
            "human" : "SHOULD contain manufacturerOrganization",
            "expression" : "manufacturerOrganization.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationMedicationInformation"
          }
        ]
      },
      {
        "id" : "ManufacturedProduct.templateId",
        "path" : "ManufacturedProduct.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ManufacturedProduct.templateId:immunization-med-info",
        "path" : "ManufacturedProduct.templateId",
        "sliceName" : "immunization-med-info",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ManufacturedProduct.templateId:immunization-med-info.root",
        "path" : "ManufacturedProduct.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.54"
      },
      {
        "id" : "ManufacturedProduct.templateId:immunization-med-info.extension",
        "path" : "ManufacturedProduct.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "ManufacturedProduct.classCode",
        "path" : "ManufacturedProduct.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"MANU\" (CodeSystem: HL7RoleClass urn:oid:2.16.840.1.113883.5.110 STATIC) (CONF:1098-9002).",
        "min" : 1
      },
      {
        "id" : "ManufacturedProduct.id",
        "path" : "ManufacturedProduct.id",
        "comment" : "MAY contain zero or more [0..*] id (CONF:1098-9005)."
      },
      {
        "id" : "ManufacturedProduct.manufacturedMaterial",
        "path" : "ManufacturedProduct.manufacturedMaterial",
        "comment" : "SHALL contain exactly one [1..1] manufacturedMaterial (CONF:1098-9006).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "should-lotNumberText",
            "severity" : "warning",
            "human" : "SHOULD contain lotNumberText",
            "expression" : "lotNumberText.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationMedicationInformation"
          }
        ]
      },
      {
        "id" : "ManufacturedProduct.manufacturedMaterial.code",
        "path" : "ManufacturedProduct.manufacturedMaterial.code",
        "comment" : "This manufacturedMaterial SHALL contain exactly one [1..1] code, which SHALL be selected from ValueSet CVX Vaccines Administered Vaccine Set urn:oid:2.16.840.1.113762.1.4.1010.6 DYNAMIC (CONF:1098-9007).",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.6"
        }
      },
      {
        "id" : "ManufacturedProduct.manufacturedMaterial.lotNumberText",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "ManufacturedProduct.manufacturedMaterial.lotNumberText",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Lot Number Text - lotNumberText should be included if known. It may not be known for historical immunizations, planned immunizations, or refused/deferred immunizations.",
        "comment" : "This manufacturedMaterial SHOULD contain zero or one [0..1] lotNumberText (CONF:1098-9014)."
      },
      {
        "id" : "ManufacturedProduct.manufacturedMaterial.sdtcExpirationTime",
        "path" : "ManufacturedProduct.manufacturedMaterial.sdtcExpirationTime",
        "short" : "Can be used to express the expiration date of the vaccine product"
      },
      {
        "id" : "ManufacturedProduct.manufacturerOrganization",
        "path" : "ManufacturedProduct.manufacturerOrganization",
        "comment" : "SHOULD contain zero or one [0..1] manufacturerOrganization (CONF:1098-9012)."
      }
    ]
  }
}

```
