# History and Physical - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **History and Physical**

## Logical Model: History and Physical 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:HistoryandPhysical |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.1.3:2024-05-01 | |

 
A History and Physical (H&P) note is a medical report that documents the current and past conditions of the patient. It contains essential information that helps determine an individual's health status.
The first portion of the report is a current collection of organized information unique to an individual. This is typically supplied by the patient or the caregiver, concerning the current medical problem or the reason for the patient encounter. This information is followed by a description of any past or ongoing medical issues, including current medications and allergies. Information is also obtained about the patient's lifestyle, habits, and diseases among family members. The next portion of the report contains information obtained by physically examining the patient and gathering diagnostic information in the form of laboratory tests, imaging, or other diagnostic procedures. The report ends with the clinician's assessment of the patient's situation and the intended plan to address those issues. A History and Physical Examination is required upon hospital admission as well as before operative procedures. An initial evaluation in an ambulatory setting is often documented in the form of an H&P note. 

#### Document Sections

 
Although document templates may contain any section, the following sections are specifically called out by this template: 
**Required Sections** 
* [ChiefComplaintandReasonforVisitSection](StructureDefinition-ChiefComplaintandReasonforVisitSection.md) or both [ChiefComplaintSection](StructureDefinition-ChiefComplaintSection.md) and [ReasonforVisitSection](StructureDefinition-ReasonforVisitSection.md)
* [AssessmentandPlanSection](StructureDefinition-AssessmentandPlanSection.md) or both [AssessmentSection](StructureDefinition-AssessmentSection.md) and [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.md)
* [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.md)
* [FamilyHistorySection](StructureDefinition-FamilyHistorySection.md)
* [GeneralStatusSection](StructureDefinition-GeneralStatusSection.md)
* [PastMedicalHistory](StructureDefinition-PastMedicalHistory.md)
* [MedicationsSection](StructureDefinition-MedicationsSection.md)
* [PhysicalExamSection](StructureDefinition-PhysicalExamSection.md)
* [ResultsSection](StructureDefinition-ResultsSection.md)
* [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.md)
* [SocialHistorySection](StructureDefinition-SocialHistorySection.md)
* [VitalSignsSection](StructureDefinition-VitalSignsSection.md)
 
**Recommended Sections** 
* [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.md)
 
**Additional Sections** 
* [ImmunizationsSection](StructureDefinition-ImmunizationsSection.md)
* [InstructionsSection](StructureDefinition-InstructionsSection.md)
* [ProblemSection](StructureDefinition-ProblemSection.md)
* [ProceduresSection](StructureDefinition-ProceduresSection.md)
* [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.md)
 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/HistoryandPhysical)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-HistoryandPhysical.csv), [Excel](StructureDefinition-HistoryandPhysical.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HistoryandPhysical",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.1.3:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "HistoryandPhysical",
  "title" : "History and Physical",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "A History and Physical (H&P) note is a medical report that documents the current and past conditions of the patient. It contains essential information that helps determine an individual's health status.  \nThe first portion of the report is a current collection of organized information unique to an individual. This is typically supplied by the patient or the caregiver, concerning the current medical problem or the reason for the patient encounter. This information is followed by a description of any past or ongoing medical issues, including current medications and allergies. Information is also obtained about the patient's lifestyle, habits, and diseases among family members.\nThe next portion of the report contains information obtained by physically examining the patient and gathering diagnostic information in the form of laboratory tests, imaging, or other diagnostic procedures. \nThe report ends with the clinician's assessment of the patient's situation and the intended plan to address those issues. \nA History and Physical Examination is required upon hospital admission as well as before operative procedures. An initial evaluation in an ambulatory setting is often documented in the form of an H&P note.\n\n#### Document Sections\nAlthough document templates may contain any section, the following sections are specifically called out by this template:\n\n**Required Sections**\n- [ChiefComplaintandReasonforVisitSection](StructureDefinition-ChiefComplaintandReasonforVisitSection.html) or both [ChiefComplaintSection](StructureDefinition-ChiefComplaintSection.html) and [ReasonforVisitSection](StructureDefinition-ReasonforVisitSection.html)\n- [AssessmentandPlanSection](StructureDefinition-AssessmentandPlanSection.html) or both [AssessmentSection](StructureDefinition-AssessmentSection.html) and [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.html)\n- [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.html)\n- [FamilyHistorySection](StructureDefinition-FamilyHistorySection.html)\n- [GeneralStatusSection](StructureDefinition-GeneralStatusSection.html)\n- [PastMedicalHistory](StructureDefinition-PastMedicalHistory.html)\n- [MedicationsSection](StructureDefinition-MedicationsSection.html)\n- [PhysicalExamSection](StructureDefinition-PhysicalExamSection.html)\n- [ResultsSection](StructureDefinition-ResultsSection.html)\n- [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.html)\n- [SocialHistorySection](StructureDefinition-SocialHistorySection.html)\n- [VitalSignsSection](StructureDefinition-VitalSignsSection.html)\n\n**Recommended Sections**\n- [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.html)\n\n**Additional Sections**\n- [ImmunizationsSection](StructureDefinition-ImmunizationsSection.html)\n- [InstructionsSection](StructureDefinition-InstructionsSection.html)\n- [ProblemSection](StructureDefinition-ProblemSection.html)\n- [ProceduresSection](StructureDefinition-ProceduresSection.html)\n- [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "constraint" : [
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
          },
          {
            "key" : "category-34117-2",
            "severity" : "error",
            "human" : "If category is present, then there shall be a category with LOINC code '34117-2'.",
            "expression" : "sdtcCategory.empty() or sdtcCategory.exists(code = '34117-2' and codeSystem = '2.16.840.1.113883.6.1')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:history-physical",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "history-physical",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:history-physical.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.3"
      },
      {
        "id" : "ClinicalDocument.templateId:history-physical.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory",
        "path" : "ClinicalDocument.sdtcCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "codeSystem"
            }
          ],
          "rules" : "open"
        },
        "short" : "Used to categorize the document as a History and Physical. If present, there SHALL be a category of 34117-2 (History and physical note).",
        "condition" : ["should-sdtcCategory", "category-34117-2"]
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType",
        "path" : "ClinicalDocument.sdtcCategory",
        "sliceName" : "documentType",
        "short" : "History and physical note",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.code",
        "path" : "ClinicalDocument.sdtcCategory.code",
        "min" : 1,
        "patternCode" : "34117-2"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.codeSystem",
        "path" : "ClinicalDocument.sdtcCategory.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "short" : "The H&P Note recommends use of a single document type code, 34117-2 \"History and physical note\", with further specification provided by author or performer, setting, or specialty. When pre-coordinated codes are used, any coded values describing the author or performer of the service act or the practice setting must be consistent with the LOINC document type.",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1198-17185).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.20.22"
        }
      },
      {
        "id" : "ClinicalDocument.informationRecipient",
        "path" : "ClinicalDocument.informationRecipient",
        "comment" : "MAY contain zero or more [0..*] informationRecipient (CONF:1198-32482)."
      },
      {
        "id" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "path" : "ClinicalDocument.informationRecipient.intendedRecipient",
        "comment" : "The informationRecipient, if present, SHALL contain exactly one [1..1] intendedRecipient (CONF:1198-32483)."
      },
      {
        "id" : "ClinicalDocument.participant",
        "path" : "ClinicalDocument.participant",
        "short" : "The participant element in the H&P header follows the General Header Constraints for participants. H&P Note does not specify any use for functionCode for participants. Local policies will determine how this element should be used in implementations.",
        "comment" : "MAY contain zero or more [0..*] participant (CONF:1198-8286).",
        "constraint" : [
          {
            "key" : "1198-8333",
            "severity" : "warning",
            "human" : "When participant/@typeCode is IND, associatedEntity/@classCode **SHALL** be selected from ValueSet 2.16.840.1.113883.11.20.9.33 INDRoleclassCodes *STATIC* 2011-09-30 (CONF:1198-8333).\nA special class of participant is the supporting person or organization:  an individual or an organization that has a relationship to the patient, including  parents, relatives, caregivers, insurance policyholders, and guarantors. In the case of a supporting person who is also an emergency contact or next-of-kin, a participant element should be present for each role recorded.",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.inFulfillmentOf",
        "path" : "ClinicalDocument.inFulfillmentOf",
        "short" : "inFulfillmentOf elements describe the prior orders that are fulfilled (in whole or part) by the service events described in this document. For example, the prior order might be a referral and the H&P Note may be in partial fulfillment of that referral.",
        "comment" : "MAY contain zero or more [0..*] inFulfillmentOf (CONF:1198-8336)."
      },
      {
        "id" : "ClinicalDocument.componentOf",
        "path" : "ClinicalDocument.componentOf",
        "short" : "The H&P Note is always associated with an encounter.",
        "comment" : "SHALL contain exactly one [1..1] componentOf (CONF:1198-8338).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter",
        "comment" : "This componentOf SHALL contain exactly one [1..1] encompassingEncounter (CONF:1198-8339)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.id",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.id",
        "comment" : "This encompassingEncounter SHALL contain at least one [1..*] id (CONF:1198-8340)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "short" : "The effectiveTime represents the time interval or point in time in which the encounter took place.",
        "comment" : "This encompassingEncounter SHALL contain exactly one [1..1] US Realm Date and Time (Interval) (identifier: urn:oid:2.16.840.1.113883.10.20.22.5.3) (CONF:1198-8341)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty",
        "short" : "The responsibleParty element records only the party responsible for the encounter, not necessarily the entire episode of care.",
        "comment" : "This encompassingEncounter MAY contain zero or one [0..1] responsibleParty (CONF:1198-8345).",
        "constraint" : [
          {
            "key" : "1198-8348",
            "severity" : "error",
            "human" : "The responsibleParty element, if present, **SHALL** contain an assignedEntity element, which **SHALL** contain an assignedPerson element, a representedOrganization element, or both (CONF:1198-8348).",
            "expression" : "assignedEntity.assignedPerson.exists() or assignedEntity.representedOrganization.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant",
        "short" : "The encounterParticipant elements represent only those participants in the encounter, not necessarily the entire episode of care.",
        "comment" : "This encompassingEncounter MAY contain zero or more [0..*] encounterParticipant (CONF:1198-8342).",
        "constraint" : [
          {
            "key" : "1198-8343",
            "severity" : "error",
            "human" : "An encounterParticipant element, if present, SHALL contain an assignedEntity element, which SHALL contain an assignedPerson element, a representedOrganization element, or both (CONF:1198-8343).",
            "expression" : "assignedEntity.assignedPerson.exists() or assignedEntity.representedOrganization.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.location",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.location",
        "comment" : "This encompassingEncounter MAY contain zero or one [0..1] location (CONF:1198-8344)."
      },
      {
        "id" : "ClinicalDocument.component",
        "path" : "ClinicalDocument.component",
        "comment" : "SHALL contain exactly one [1..1] component (CONF:1198-8349)."
      },
      {
        "id" : "ClinicalDocument.component.structuredBody",
        "path" : "ClinicalDocument.component.structuredBody",
        "short" : "In this template (templateId 2.16.840.1.113883.10.20.22.1.3.2), coded entries are optional.",
        "comment" : "This component SHALL contain exactly one [1..1] structuredBody (CONF:1198-30570).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "ccrfv-or-cc-or-rfv",
            "severity" : "error",
            "human" : "This structuredBody **SHALL** contain a Chief Complaint and Reason for Visit Section (2.16.840.1.113883.10.20.22.2.13) or a Chief Complaint Section (1.3.6.1.4.1.19376.1.5.3.1.1.13.2.1) or a Reason for Visit Section (2.16.840.1.113883.10.20.22.2.12).",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintandReasonforVisitSection').exists() or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintSection').exists() or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection').exists()).exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
          },
          {
            "key" : "ap-or-a-and-p",
            "severity" : "error",
            "human" : "**SHALL** include an Assessment and Plan Section, or both an Assessment Section and a Plan of Treatment Section.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection')).exists() or (component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection')).count() = 2)",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
          },
          {
            "key" : "ap-combo",
            "severity" : "error",
            "human" : "This structuredBody **SHALL NOT** contain an Assessment and Plan Section (2.16.840.1.113883.10.20.22.2.9:2014-06-09) when either an Assessment Section (2.16.840.1.113883.10.20.22.2.8) or a Plan of Treatment Section (2.16.840.1.113883.10.20.22.2.10:2014-06-09) is present.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection')).exists() implies component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection')).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
          },
          {
            "key" : "cc-rfv-combo",
            "severity" : "error",
            "human" : "This structuredBody **SHALL NOT** contain a Chief Complaint and Reason for Visit Section (2.16.840.1.113883.10.20.22.2.13) when either a Chief Complaint Section (1.3.6.1.4.1.19376.1.5.3.1.1.13.2.1) or a Reason for Visit Section (2.16.840.1.113883.10.20.22.2.12) is present.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintandReasonforVisitSection')).exists() implies component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection')).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
          },
          {
            "key" : "should-section-hpi",
            "severity" : "warning",
            "human" : "SHOULD contain a History of Present Illness Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/HistoryofPresentIllnessSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryandPhysical"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "section"
            }
          ],
          "rules" : "open"
        },
        "min" : 12
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "allergies",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30571).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Allergies and Intolerances Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.6.1:2024-05-01) (CONF:1198-30572).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AllergiesAndIntolerancesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "assessment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30573) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Assessment Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.8) (CONF:1198-30574).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "planOfTreatment",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30575) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Plan of Treatment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.10:2014-06-09) (CONF:1198-30576).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessmentAndPlan",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "assessmentAndPlan",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30577) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ap-or-a-and-p", "ap-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:assessmentAndPlan.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Assessment and Plan Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.9:2014-06-09) (CONF:1198-30578).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentandPlanSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaint",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "chiefComplaint",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30579) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ccrfv-or-cc-or-rfv", "cc-rfv-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaint.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Chief Complaint Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.1.13.2.1) (CONF:1198-30580).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaintRFV",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "chiefComplaintRFV",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30581) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ccrfv-or-cc-or-rfv", "cc-rfv-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaintRFV.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Chief Complaint and Reason for Visit Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.13) (CONF:1198-30582).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintandReasonforVisitSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "familyHistory",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30583) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Family History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.15:2024-05-01) (CONF:1198-30584).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:generalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "generalStatus",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30585) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:generalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] General Status Section (identifier: urn:oid:2.16.840.1.113883.10.20.2.5) (CONF:1198-30586).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/GeneralStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:pastMedicalHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "pastMedicalHistory",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30587) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:pastMedicalHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Past Medical History (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.20:2024-05-01) (CONF:1198-30588).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PastMedicalHistory"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:historyPresentIllness",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "historyPresentIllness",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-30589) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-hpi"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:historyPresentIllness.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] History of Present Illness Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.4) (CONF:1198-30590).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryofPresentIllnessSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunizations",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "immunizations",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30591) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunizations.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Immunizations Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.2.1:2024-05-01) (CONF:1198-30592).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:instructions",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "instructions",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30593) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:instructions.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Instructions Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.45:2014-06-09) (CONF:1198-31385).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InstructionsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "medications",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30595) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:medications.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Medications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.1.1:2014-06-09) (CONF:1198-30596).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/MedicationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:physicalExam",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "physicalExam",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30597) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:physicalExam.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Physical Exam Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.2.10:2024-05-01) (CONF:1198-30598).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PhysicalExamSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problems",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "problems",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30599) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problems.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Problem Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.5.1:2024-05-01) (CONF:1198-30600).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "procedures",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30601) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedures Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.7.1:2014-06-09) (CONF:1198-30602).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForVisit",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reasonForVisit",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30603) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["ccrfv-or-cc-or-rfv", "cc-rfv-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForVisit.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Reason for Visit Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.12) (CONF:1198-30604).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "results",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30605) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Results Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.3.1:2024-05-01) (CONF:1198-30606).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ResultsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reviewOfSystems",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30607) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Review of Systems Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.18) (CONF:1198-30608).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReviewofSystemsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "socialHistory",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30609) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Social History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.17:2024-05-01) (CONF:1198-30610).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "vitalSigns",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30611) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Vital Signs Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.4.1:2024-05-01) (CONF:1198-30612).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "advDirectives",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28942) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Advance Directives Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.21.1:2024-05-01).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
            ]
          }
        ]
      }
    ]
  }
}

```
