# Health Concern Act - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Concern Act**

## Logical Model: Health Concern Act 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernAct | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:HealthConcernAct |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.132:2022-06-01 | |

 
This template represents a health concern. 
It is a wrapper for a single health concern which may be derived from a variety of sources within an EHR (such as Problem List, Family History, Social History, Social Worker Note, etc.). 
A Health Concern Act is used to track non-optimal physical or psychological situations drawing the patient to the healthcare system. These may be from the perspective of the care team or from the perspective of the patient. When the underlying condition is of concern (i.e., as long as the condition, whether active or resolved, is of ongoing concern and interest), the statusCode is active. Only when the underlying condition is no longer of concern is the statusCode set to completed. The effectiveTime reflects the time that the underlying condition was felt to be a concern; it may or may not correspond to the effectiveTime of the condition (e.g., even five years later, a prior heart attack may remain a concern). Health concerns require intervention(s) to increase the likelihood of achieving the goals of care for the patient and they specify the condition oriented reasons for creating the plan. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AllergyIntoleranceObservation](StructureDefinition-AllergyIntoleranceObservation.md),[AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.md),[CaregiverCharacteristics](StructureDefinition-CaregiverCharacteristics.md),[CharacteristicsofHomeEnvironment](StructureDefinition-CharacteristicsofHomeEnvironment.md),[CulturalandReligiousObservation](StructureDefinition-CulturalandReligiousObservation.md),[EncounterDiagnosis](StructureDefinition-EncounterDiagnosis.md),[EntryReference](StructureDefinition-EntryReference.md),[FamilyHistoryOrganizer](StructureDefinition-FamilyHistoryOrganizer.md),[FunctionalStatusObservation](StructureDefinition-FunctionalStatusObservation.md),[HospitalAdmissionDiagnosis](StructureDefinition-HospitalAdmissionDiagnosis.md),[LongitudinalCareWoundObservation](StructureDefinition-LongitudinalCareWoundObservation.md),[MentalStatusObservation](StructureDefinition-MentalStatusObservation.md),[NutritionAssessment](StructureDefinition-NutritionAssessment.md),[NutritionalStatusObservation](StructureDefinition-NutritionalStatusObservation.md),[PostprocedureDiagnosis](StructureDefinition-PostprocedureDiagnosis.md),[PregnancyStatusObservation](StructureDefinition-PregnancyStatusObservation.md),[PreoperativeDiagnosis](StructureDefinition-PreoperativeDiagnosis.md),[PriorityPreference](StructureDefinition-PriorityPreference.md),[ProblemObservation](StructureDefinition-ProblemObservation.md),[ReactionObservation](StructureDefinition-ReactionObservation.md),[ResultObservation](StructureDefinition-ResultObservation.md),[ResultOrganizer](StructureDefinition-ResultOrganizer.md),[SelfCareActivitiesADLandIADL](StructureDefinition-SelfCareActivitiesADLandIADL.md),[SensoryStatus](StructureDefinition-SensoryStatus.md),[SmokingStatusMeaningfulUse](StructureDefinition-SmokingStatusMeaningfulUse.md),[SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.md),[SubstanceOrDeviceAllergyIntoleranceObservation](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.md),[TobaccoUse](StructureDefinition-TobaccoUse.md),[VitalSignObservation](StructureDefinition-VitalSignObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Health Concerns Section](StructureDefinition-HealthConcernsSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/HealthConcernAct)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-HealthConcernAct.csv), [Excel](StructureDefinition-HealthConcernAct.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HealthConcernAct",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernAct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.132:2022-06-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "HealthConcernAct",
  "title" : "Health Concern Act",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents a health concern. \n\nIt is a wrapper for a single health concern which may be derived from a variety of sources within an EHR (such as Problem List, Family History, Social History, Social Worker Note, etc.). \n\nA Health Concern Act is used to track non-optimal physical or psychological situations drawing the patient to the healthcare system. These may be from the perspective of the care team or from the perspective of the patient. \nWhen the underlying condition is of concern (i.e., as long as the condition, whether active or resolved, is of ongoing concern and interest), the statusCode is active. Only when the underlying condition is no longer of concern is the statusCode set to completed. The effectiveTime reflects the time that the underlying condition was felt to be a concern; it may or may not correspond to the effectiveTime of the condition (e.g., even five years later, a prior heart attack may remain a concern).\nHealth concerns require intervention(s) to increase the likelihood of achieving the goals of care for the patient and they specify the condition oriented reasons for creating the plan.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AllergyIntoleranceObservation](StructureDefinition-AllergyIntoleranceObservation.html), [AssessmentScaleObservation](StructureDefinition-AssessmentScaleObservation.html), [CaregiverCharacteristics](StructureDefinition-CaregiverCharacteristics.html), [CharacteristicsofHomeEnvironment](StructureDefinition-CharacteristicsofHomeEnvironment.html), [CulturalandReligiousObservation](StructureDefinition-CulturalandReligiousObservation.html), [EncounterDiagnosis](StructureDefinition-EncounterDiagnosis.html), [EntryReference](StructureDefinition-EntryReference.html), [FamilyHistoryOrganizer](StructureDefinition-FamilyHistoryOrganizer.html), [FunctionalStatusObservation](StructureDefinition-FunctionalStatusObservation.html), [HospitalAdmissionDiagnosis](StructureDefinition-HospitalAdmissionDiagnosis.html), [LongitudinalCareWoundObservation](StructureDefinition-LongitudinalCareWoundObservation.html), [MentalStatusObservation](StructureDefinition-MentalStatusObservation.html), [NutritionAssessment](StructureDefinition-NutritionAssessment.html), [NutritionalStatusObservation](StructureDefinition-NutritionalStatusObservation.html), [PostprocedureDiagnosis](StructureDefinition-PostprocedureDiagnosis.html), [PregnancyStatusObservation](StructureDefinition-PregnancyStatusObservation.html), [PreoperativeDiagnosis](StructureDefinition-PreoperativeDiagnosis.html), [PriorityPreference](StructureDefinition-PriorityPreference.html), [ProblemObservation](StructureDefinition-ProblemObservation.html), [ReactionObservation](StructureDefinition-ReactionObservation.html), [ResultObservation](StructureDefinition-ResultObservation.html), [ResultOrganizer](StructureDefinition-ResultOrganizer.html), [SelfCareActivitiesADLandIADL](StructureDefinition-SelfCareActivitiesADLandIADL.html), [SensoryStatus](StructureDefinition-SensoryStatus.html), [SmokingStatusMeaningfulUse](StructureDefinition-SmokingStatusMeaningfulUse.html), [SocialHistoryObservation](StructureDefinition-SocialHistoryObservation.html), [SubstanceOrDeviceAllergyIntoleranceObservation](StructureDefinition-SubstanceOrDeviceAllergyIntoleranceObservation.html), [TobaccoUse](StructureDefinition-TobaccoUse.html), [VitalSignObservation](StructureDefinition-VitalSignObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernAct"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernAct"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:health-concern-act",
        "path" : "Act.templateId",
        "sliceName" : "health-concern-act",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:health-concern-act.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.132"
      },
      {
        "id" : "Act.templateId:health-concern-act.extension",
        "path" : "Act.templateId.extension",
        "min" : 1,
        "patternString" : "2022-06-01"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:4515-30750).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:4515-30751).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.id",
        "path" : "Act.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:4515-30754).",
        "min" : 1
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "short" : "Health concerns Document",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:4515-32310)."
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "min" : 1,
        "patternCode" : "75310-3"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernAct"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4515-30758).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.nullFlavor",
        "path" : "Act.statusCode.nullFlavor",
        "max" : "0"
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.19"
        }
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "comment" : "MAY contain zero or one [0..1] effectiveTime (CONF:4515-30759)."
      },
      {
        "id" : "Act.author",
        "path" : "Act.author",
        "short" : "A health concern may be a patient or provider concern. If the author is set to the recordTarget (patient), this is a patient concern. If the author is set to a provider, this is a provider concern. If both patient and provider are set as authors, this is a concern of both the patient and the provider.",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:4515-31546).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            },
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "organizer"
            },
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "short" : "When this Health Concern Act is a Social Determinant of Health Health Concern it **SHOULD** contain zero or more [0..*] entryRelationship subentries such that it contains an observation with an observation/value selected from ValueSet [Social Determinant of Health Conditions 2.16.840.1.113762.1.4.1196.788](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.788/expansion) **DYNAMIC** (CONF:4515-32962).",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-31549) such that it"
      },
      {
        "id" : "Act.entryRelationship:observations",
        "path" : "Act.entryRelationship",
        "sliceName" : "observations",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:observations.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:observations.observation",
        "path" : "Act.entryRelationship.observation",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/AllergyIntoleranceObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/SelfCareActivitiesADLandIADL",
              "http://hl7.org/cda/us/ccda/StructureDefinition/MentalStatusObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/SmokingStatusMeaningfulUse",
              "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionAssessment",
              "http://hl7.org/cda/us/ccda/StructureDefinition/PregnancyStatusObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReactionObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/ResultObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/SensoryStatus",
              "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/SubstanceOrDeviceAllergyIntoleranceObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/TobaccoUse",
              "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/LongitudinalCareWoundObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/CaregiverCharacteristics",
              "http://hl7.org/cda/us/ccda/StructureDefinition/CulturalandReligiousObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/CharacteristicsofHomeEnvironment",
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionalStatusObservation",
              "http://hl7.org/cda/us/ccda/StructureDefinition/PriorityPreference"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:acts",
        "path" : "Act.entryRelationship",
        "sliceName" : "acts",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:acts.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:acts.act",
        "path" : "Act.entryRelationship.act",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EncounterDiagnosis",
              "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalAdmissionDiagnosis",
              "http://hl7.org/cda/us/ccda/StructureDefinition/PostprocedureDiagnosis",
              "http://hl7.org/cda/us/ccda/StructureDefinition/PreoperativeDiagnosis"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:organizers",
        "path" : "Act.entryRelationship",
        "sliceName" : "organizers",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:organizers.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:organizers.organizer",
        "path" : "Act.entryRelationship.organizer",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistoryOrganizer",
              "http://hl7.org/cda/us/ccda/StructureDefinition/ResultOrganizer"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:related-entries",
        "path" : "Act.entryRelationship",
        "sliceName" : "related-entries",
        "short" : "Where a Health Concern needs to reference another entry already described in the CDA document instance, rather than repeating the full content of the entry, the Entry Reference template may be used to reference this entry. This may also be used to refer to other Health Concern Acts where there is a general relationship between the source and the target (Health Concern REFERS TO Health Concern). For example, a patient has 2 health concerns identified in a CARE Plan: Failure to Thrive and Poor Feeding; while it could be that one may have caused the other, at the time of care planning and documentation it is not necessary, nor desirable to have to assert what caused what. The Entry Reference template is used here because the target Health Concern Act will be defined elsewhere in the Health Concerns Section and thus a reference to that template is all that is required.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-31157) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Act.entryRelationship:related-entries.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-31158).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.entryRelationship:related-entries.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:4515-32106).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:component-health-concern-acts",
        "path" : "Act.entryRelationship",
        "sliceName" : "component-health-concern-acts",
        "short" : "The following entryRelationship represents the relationship between two Health Concern Acts where the target is a component of the source (Health Concern HAS COMPONENT Health Concern). For example, a patient has an Impaired Mobility Health Concern. There may then be the need to document several component health concerns, such as \"Unable to Transfer Bed to Chair\",\"Unable to Rise from Commode\", \"Short of Breath Walking with Walker\". The Entry Reference template is used here because the target Health Concern Act will be defined elsewhere in the Health Concerns Section and thus a reference to that template is all that is required.",
        "comment" : "MAY contain zero or more [0..*] entryRelationship (CONF:4515-31160) such that it",
        "min" : 0,
        "max" : "*",
        "constraint" : [
          {
            "key" : "4515-32745",
            "severity" : "error",
            "human" : "The Entry Reference template **SHALL** contain an id that references a Health Concern Act (CONF:4515-32745).",
            "expression" : "%resource.descendants().ofType(CDA.Act).where(templateId.exists($this.root = '2.16.840.1.113883.10.20.22.4.132' and $this.extension = '2022-06-01') and id.exists($this.root = %context.act.id.first().root and $this.extension ~ %context.act.id.first().extension))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HealthConcernAct"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:component-health-concern-acts.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" Has component (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-31161).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Act.entryRelationship:component-health-concern-acts.act",
        "path" : "Act.entryRelationship.act",
        "comment" : "SHALL contain exactly one [1..1] Entry Reference (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.122) (CONF:4515-32107).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ]
      },
      {
        "id" : "Act.reference",
        "path" : "Act.reference",
        "short" : "Where it is necessary to reference an external clinical document such as a Referral document, Discharge Summary document etc., the External Document Reference template can be used to reference this document.  However, if this Care Plan document is replacing or appending another Care Plan document in the same set, that relationship is set in the header, using ClinicalDocument/relatedDocument.",
        "comment" : "MAY contain zero or more [0..*] reference (CONF:4515-32757)."
      },
      {
        "id" : "Act.reference.typeCode",
        "path" : "Act.reference.typeCode",
        "comment" : "The reference, if present, SHALL contain exactly one [1..1] @typeCode=\"REFR\" Refers to (CodeSystem: HL7ActRelationshipType urn:oid:2.16.840.1.113883.5.1002) (CONF:4515-32758).",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Act.reference.externalDocument",
        "path" : "Act.reference.externalDocument",
        "comment" : "The reference, if present, SHALL contain exactly one [1..1] External Document Reference (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.115:2014-06-09) (CONF:4515-32759).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/ExternalDocument",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ExternalDocumentReference"
            ]
          }
        ]
      }
    ]
  }
}

```
