# Handoff Communication Participants - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Handoff Communication Participants**

## Logical Model: Handoff Communication Participants 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/HandoffCommunicationParticipants | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:HandoffCommunicationParticipants |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.141 | |

 
This template represents the sender (author) and receivers (participants) of a handoff communication in a plan of treatment. It does not convey details about the communication. The "handoff" process involves senders, those transmitting the patient's information and releasing the care of that patient to the next clinician, and receivers, those who accept the patient information and care of that patient. 

**Usages:**

* Use this Logical Model Profile: [Activities Section](StructureDefinition-ActivitiesSection.md), [Intervention Act](StructureDefinition-InterventionAct.md) and [Plan of Treatment Section](StructureDefinition-PlanofTreatmentSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/HandoffCommunicationParticipants)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-HandoffCommunicationParticipants.csv), [Excel](StructureDefinition-HandoffCommunicationParticipants.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HandoffCommunicationParticipants",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/HandoffCommunicationParticipants",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.141"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "HandoffCommunicationParticipants",
  "title" : "Handoff Communication Participants",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents the sender (author) and receivers (participants) of a handoff communication in a plan of treatment. It does not convey details about the communication. The \"handoff\" process involves senders, those transmitting the patient's information and releasing the care of that patient to the next clinician, and receivers, those who accept the patient information and care of that patient.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HandoffCommunicationParticipants"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:handoff-comm-participants",
        "path" : "Act.templateId",
        "sliceName" : "handoff-comm-participants",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:handoff-comm-participants.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.141"
      },
      {
        "id" : "Act.templateId:handoff-comm-participants.extension",
        "path" : "Act.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" Act (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:1098-30832).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1098-30833).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1098-30836)."
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"432138007\" handoff communication (procedure) (CONF:1098-30837).",
        "min" : 1,
        "patternCode" : "432138007"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.6.96\" (CodeSystem: SNOMED CT urn:oid:2.16.840.1.113883.6.96) (CONF:1098-30838).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.96"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HandoffCommunicationParticipants"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-31668).",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-31669).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "short" : "The effective time is the time when the handoff process took place between the sender and receiver of the patient information. This could be the time the information was transmitted, released, or verbally communicated to the next clinician.",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:1098-31670).",
        "min" : 1
      },
      {
        "id" : "Act.author",
        "path" : "Act.author",
        "short" : "The Author Participant contains the sender's contact information and is a resource for the Information Recipient for any follow-up questions.",
        "comment" : "SHALL contain at least one [1..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1098-31672).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ]
      },
      {
        "id" : "Act.participant",
        "path" : "Act.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "short" : "Documentation of the Information Recipient's name and address verifies that the information was exchanged.",
        "min" : 1
      },
      {
        "id" : "Act.participant:infoRecipient",
        "path" : "Act.participant",
        "sliceName" : "infoRecipient",
        "comment" : "SHALL contain at least one [1..*] participant (CONF:1098-31673) such that it",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Act.participant:infoRecipient.typeCode",
        "path" : "Act.participant.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"IRCP\" Information Recipient (CodeSystem: HL7RoleClass urn:oid:2.16.840.1.113883.5.110) (CONF:1098-31674).",
        "fixedCode" : "IRCP"
      },
      {
        "id" : "Act.participant:infoRecipient.participantRole",
        "path" : "Act.participant.participantRole",
        "comment" : "SHALL contain exactly one [1..1] participantRole (CONF:1098-31675).",
        "constraint" : [
          {
            "key" : "should-code",
            "severity" : "warning",
            "human" : "SHOULD contain code",
            "expression" : "code.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/HandoffCommunicationParticipants"
          }
        ]
      },
      {
        "id" : "Act.participant:infoRecipient.participantRole.id",
        "path" : "Act.participant.participantRole.id",
        "comment" : "This participantRole SHALL contain at least one [1..*] id (CONF:1098-32422).",
        "min" : 1
      },
      {
        "id" : "Act.participant:infoRecipient.participantRole.code",
        "path" : "Act.participant.participantRole.code",
        "comment" : "This participantRole SHOULD contain zero or one [0..1] code, which SHOULD be selected from ValueSet Healthcare Provider Taxonomy urn:oid:2.16.840.1.114222.4.11.1066 DYNAMIC (CONF:1098-31676).",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "Act.participant:infoRecipient.participantRole.sdtcSpecialty",
        "path" : "Act.participant.participantRole.sdtcSpecialty",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "Act.participant:infoRecipient.participantRole.addr",
        "path" : "Act.participant.participantRole.addr",
        "comment" : "This participantRole SHALL contain at least one [1..*] addr (CONF:1098-32392).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/AD",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmAddress"
            ]
          }
        ]
      },
      {
        "id" : "Act.participant:infoRecipient.participantRole.playingEntity",
        "path" : "Act.participant.participantRole.playingEntity",
        "comment" : "This participantRole MAY contain zero or one [0..1] playingEntity (CONF:1098-32393)."
      },
      {
        "id" : "Act.participant:infoRecipient.participantRole.playingEntity.name",
        "path" : "Act.participant.participantRole.playingEntity.name",
        "comment" : "The playingEntity, if present, SHALL contain at least one [1..*] name (CONF:1098-32394).",
        "min" : 1
      }
    ]
  }
}

```
