# Functional Status Organizer - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Functional Status Organizer**

## Logical Model: Functional Status Organizer 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusOrganizer | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:FunctionalStatusOrganizer |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.66:2014-06-09 | |

 
This template groups related functional status observations into categories (e.g., mobility, self-care). 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required Components**:[FunctionalStatusObservation](StructureDefinition-FunctionalStatusObservation.md),[SelfCareActivitiesADLandIADL](StructureDefinition-SelfCareActivitiesADLandIADL.md) 

**Usages:**

* Use this Logical Model Profile: [Functional Status Section](StructureDefinition-FunctionalStatusSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/FunctionalStatusOrganizer)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-FunctionalStatusOrganizer.csv), [Excel](StructureDefinition-FunctionalStatusOrganizer.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "FunctionalStatusOrganizer",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "organizer"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusOrganizer",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.66:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "FunctionalStatusOrganizer",
  "title" : "Functional Status Organizer",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template groups related functional status observations into categories (e.g., mobility, self-care).\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required Components**: [FunctionalStatusObservation](StructureDefinition-FunctionalStatusObservation.html), [SelfCareActivitiesADLandIADL](StructureDefinition-SelfCareActivitiesADLandIADL.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organizer",
        "path" : "Organizer",
        "constraint" : [
          {
            "key" : "should-sdtctext-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "sdtcText.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusOrganizer"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.templateId",
        "path" : "Organizer.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Organizer.templateId:functional-status-org",
        "path" : "Organizer.templateId",
        "sliceName" : "functional-status-org",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.templateId:functional-status-org.root",
        "path" : "Organizer.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.66"
      },
      {
        "id" : "Organizer.templateId:functional-status-org.extension",
        "path" : "Organizer.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "Organizer.classCode",
        "path" : "Organizer.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"CLUSTER\" Cluster (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1098-14355).",
        "fixedCode" : "CLUSTER"
      },
      {
        "id" : "Organizer.moodCode",
        "path" : "Organizer.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1098-14357)."
      },
      {
        "id" : "Organizer.id",
        "path" : "Organizer.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1098-14363).",
        "min" : 1
      },
      {
        "id" : "Organizer.code",
        "path" : "Organizer.code",
        "short" : "The code selected should indicate the category that groups the contained functional status evaluation observations (e.g., mobility, self-care, communication).",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1098-14364).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "1098-31417",
            "severity" : "warning",
            "human" : "**SHOULD** be selected from ICF (codeSystem 2.16.840.1.113883.6.254) *OR* LOINC (2.16.840.1.113883.6.1) (CONF:1098-31417).",
            "expression" : "codeSystem = '2.16.840.1.113883.6.254' or codeSystem = '2.16.840.1.113883.6.1'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.sdtcText",
        "path" : "Organizer.sdtcText",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-sdtctext-ref-value"]
      },
      {
        "id" : "Organizer.sdtcText.reference",
        "path" : "Organizer.sdtcText.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.statusCode",
        "path" : "Organizer.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1098-14358)."
      },
      {
        "id" : "Organizer.statusCode.code",
        "path" : "Organizer.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1098-31434).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Organizer.author",
        "path" : "Organizer.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1098-31585).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Organizer.component",
        "path" : "Organizer.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Organizer.component:functionalStatus",
        "path" : "Organizer.component",
        "sliceName" : "functionalStatus",
        "comment" : "SHALL contain at least one [1..*] component (CONF:1098-14359) such that it",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Organizer.component:functionalStatus.observation",
        "path" : "Organizer.component.observation",
        "comment" : "SHALL contain exactly one [1..1] Functional Status Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.67:2014-06-09) (CONF:1098-14368).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusObservation"
            ]
          }
        ]
      },
      {
        "id" : "Organizer.component:selfCare",
        "path" : "Organizer.component",
        "sliceName" : "selfCare",
        "comment" : "SHALL contain at least one [1..*] component (CONF:1098-31432) such that it",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Organizer.component:selfCare.observation",
        "path" : "Organizer.component.observation",
        "comment" : "SHALL contain exactly one [1..1] Self-Care Activities (ADL and IADL) (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.128) (CONF:1098-31433).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SelfCareActivitiesADLandIADL"
            ]
          }
        ]
      }
    ]
  }
}

```
