# External Document Reference - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **External Document Reference**

## Logical Model: External Document Reference 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ExternalDocumentReference | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ExternalDocumentReference |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.115:2014-06-09 | |

 
Where it is necessary to reference an external clinical document, the External Document Reference template can be used to reference this external document. However, if the containing document is appending to or replacing another document in the same set, that relationship is set in the header, using ClinicalDocument/relatedDocument. 

**Usages:**

* Use this Logical Model Profile: [Goal Observation](StructureDefinition-GoalObservation.md), [Health Concern Act](StructureDefinition-HealthConcernAct.md), [Intervention Act](StructureDefinition-InterventionAct.md), [Outcome Observation](StructureDefinition-OutcomeObservation.md)...Show 2 more,[Planned Intervention Act](StructureDefinition-PlannedInterventionAct.md)and[Risk Concern Act](StructureDefinition-RiskConcernAct.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ExternalDocumentReference)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ExternalDocumentReference.csv), [Excel](StructureDefinition-ExternalDocumentReference.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ExternalDocumentReference",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "externalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ExternalDocumentReference",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.115:2014-06-09"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ExternalDocumentReference",
  "title" : "External Document Reference",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "Where it is necessary to reference an external clinical document, the External Document Reference template can be used to reference this external document. However, if the containing document is appending to or replacing another document in the same set, that relationship is set in the header, using ClinicalDocument/relatedDocument.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ExternalDocument",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/ExternalDocument",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ExternalDocument",
        "path" : "ExternalDocument",
        "constraint" : [
          {
            "key" : "should-setId",
            "severity" : "warning",
            "human" : "SHOULD contain setId",
            "expression" : "setId.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ExternalDocumentReference"
          },
          {
            "key" : "should-versionNumber",
            "severity" : "warning",
            "human" : "SHOULD contain versionNumber",
            "expression" : "versionNumber.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ExternalDocumentReference"
          }
        ]
      },
      {
        "id" : "ExternalDocument.templateId",
        "path" : "ExternalDocument.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ExternalDocument.templateId:external-doc-ref",
        "path" : "ExternalDocument.templateId",
        "sliceName" : "external-doc-ref",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ExternalDocument.templateId:external-doc-ref.root",
        "path" : "ExternalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.115"
      },
      {
        "id" : "ExternalDocument.templateId:external-doc-ref.extension",
        "path" : "ExternalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2014-06-09"
      },
      {
        "id" : "ExternalDocument.classCode",
        "path" : "ExternalDocument.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"DOCCLIN\" Clinical Document (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1098-31931).",
        "min" : 1,
        "fixedCode" : "DOCCLIN"
      },
      {
        "id" : "ExternalDocument.moodCode",
        "path" : "ExternalDocument.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:1098-31932).",
        "min" : 1
      },
      {
        "id" : "ExternalDocument.id",
        "path" : "ExternalDocument.id",
        "comment" : "SHALL contain exactly one [1..1] id (CONF:1098-32751).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ExternalDocument.code",
        "path" : "ExternalDocument.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1098-31933).",
        "min" : 1
      },
      {
        "id" : "ExternalDocument.setId",
        "path" : "ExternalDocument.setId",
        "short" : "SHOULD contain setId",
        "comment" : "SHOULD contain zero or one [0..1] setId (CONF:1098-32752).",
        "condition" : ["should-setId"]
      },
      {
        "id" : "ExternalDocument.versionNumber",
        "path" : "ExternalDocument.versionNumber",
        "short" : "SHOULD contain versionNumber",
        "comment" : "SHOULD contain zero or one [0..1] versionNumber (CONF:1098-32753).",
        "condition" : ["should-versionNumber"]
      }
    ]
  }
}

```
