# Drug Vehicle - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Drug Vehicle**

## Logical Model: Drug Vehicle 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/DrugVehicle | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:DrugVehicle |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.24 | |

 
This template represents the vehicle (e.g., saline, dextrose) for administering a medication. 

**Usages:**

* Use this Logical Model Profile: [Immunization Activity](StructureDefinition-ImmunizationActivity.md) and [Medication Activity](StructureDefinition-MedicationActivity.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/DrugVehicle)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-DrugVehicle.csv), [Excel](StructureDefinition-DrugVehicle.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DrugVehicle",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "participantRole"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/DrugVehicle",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.24"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "DrugVehicle",
  "title" : "Drug Vehicle",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents the vehicle (e.g., saline, dextrose) for administering a medication.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/ParticipantRole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ParticipantRole.templateId",
        "path" : "ParticipantRole.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ParticipantRole.templateId:drug-vehicle",
        "path" : "ParticipantRole.templateId",
        "sliceName" : "drug-vehicle",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ParticipantRole.templateId:drug-vehicle.root",
        "path" : "ParticipantRole.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.24"
      },
      {
        "id" : "ParticipantRole.templateId:drug-vehicle.extension",
        "path" : "ParticipantRole.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "ParticipantRole.classCode",
        "path" : "ParticipantRole.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"MANU\" (CodeSystem: HL7RoleClass urn:oid:2.16.840.1.113883.5.110 STATIC) (CONF:81-7490).",
        "min" : 1,
        "fixedCode" : "MANU"
      },
      {
        "id" : "ParticipantRole.code",
        "path" : "ParticipantRole.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:81-19137).",
        "min" : 1
      },
      {
        "id" : "ParticipantRole.code.code",
        "path" : "ParticipantRole.code.code",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"412307009\" Drug Vehicle (CONF:81-19138).",
        "min" : 1,
        "patternCode" : "412307009"
      },
      {
        "id" : "ParticipantRole.code.codeSystem",
        "path" : "ParticipantRole.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.6.96\" (CodeSystem: SNOMED CT urn:oid:2.16.840.1.113883.6.96) (CONF:81-26502).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.96"
      },
      {
        "id" : "ParticipantRole.playingEntity",
        "path" : "ParticipantRole.playingEntity",
        "comment" : "SHALL contain exactly one [1..1] playingEntity (CONF:81-7492).",
        "min" : 1
      },
      {
        "id" : "ParticipantRole.playingEntity.code",
        "path" : "ParticipantRole.playingEntity.code",
        "short" : "This playingEntity/code is used to supply a coded term for the drug vehicle.",
        "comment" : "This playingEntity SHALL contain exactly one [1..1] code (CONF:81-7493).",
        "min" : 1
      },
      {
        "id" : "ParticipantRole.playingEntity.name",
        "path" : "ParticipantRole.playingEntity.name",
        "short" : "This playingEntity/name MAY be used for the vehicle name in text, such as Normal Saline (CONF:81-10087).",
        "comment" : "This playingEntity MAY contain zero or one [0..1] name (CONF:81-7494).",
        "max" : "1"
      }
    ]
  }
}

```
