# Discharge Summary - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Discharge Summary**

## Logical Model: Discharge Summary 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary | *Version*:5.0.0-ballot |
| Active as of 2025-12-12 | *Computable Name*:DischargeSummary |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.1.8:2024-05-01 | |

 
The Discharge Summary is a document which synopsizes a patient's admission to a hospital, LTPAC provider, or other setting. It provides information for the continuation of care following discharge. The Joint Commission requires the following information to be included in the Discharge Summary (http://www.jointcommission.org/): 
* The reason for hospitalization (the admission)
* The procedures performed, as applicable
* The care, treatment, and services provided
* The patients condition and disposition at discharge
* Information provided to the patient and family
* Provisions for follow-up care
 
The best practice for a Discharge Summary is to include the discharge disposition in the display of the header. 

#### Document Sections

 
Although document templates may contain any section, the following sections are specifically called out by this template: 
**Required Sections** 
* [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.md)
* [HospitalCourseSection](StructureDefinition-HospitalCourseSection.md)
* [DischargeDiagnosisSection](StructureDefinition-DischargeDiagnosisSection.md)
* [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.md)
* [HospitalConsultationsSection](StructureDefinition-HospitalConsultationsSection.md)
* [ProceduresSection](StructureDefinition-ProceduresSection.md)
* [ResultsSection](StructureDefinition-ResultsSection.md)
 
**Recommended Sections** 
* [DischargeMedicationsSection](StructureDefinition-DischargeMedicationsSection.md)
 
**Additional Sections** 
* [ChiefComplaintSection](StructureDefinition-ChiefComplaintSection.md)
* [ChiefComplaintandReasonforVisitSection](StructureDefinition-ChiefComplaintandReasonforVisitSection.md)
* [NutritionSection](StructureDefinition-NutritionSection.md)
* [FamilyHistorySection](StructureDefinition-FamilyHistorySection.md)
* [FunctionalStatusSection](StructureDefinition-FunctionalStatusSection.md)
* [PastMedicalHistory](StructureDefinition-PastMedicalHistory.md)
* [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.md)
* [AdmissionDiagnosisSection](StructureDefinition-AdmissionDiagnosisSection.md)
* [AdmissionMedicationsSectionEntriesOptional](StructureDefinition-AdmissionMedicationsSectionEntriesOptional.md)
* [HospitalDischargeInstructionsSection](StructureDefinition-HospitalDischargeInstructionsSection.md)
* [HospitalDischargePhysicalSection](StructureDefinition-HospitalDischargePhysicalSection.md)
* [HospitalDischargeStudiesSummarySection](StructureDefinition-HospitalDischargeStudiesSummarySection.md)
* [ImmunizationsSection](StructureDefinition-ImmunizationsSection.md)
* [ProblemSection](StructureDefinition-ProblemSection.md)
* [ReasonforVisitSection](StructureDefinition-ReasonforVisitSection.md)
* [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.md)
* [SocialHistorySection](StructureDefinition-SocialHistorySection.md)
* [VitalSignsSection](StructureDefinition-VitalSignsSection.md)
* [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.md)
 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/DischargeSummary)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-DischargeSummary.csv), [Excel](StructureDefinition-DischargeSummary.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DischargeSummary",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.1.8:2024-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "DischargeSummary",
  "title" : "Discharge Summary",
  "status" : "active",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Discharge Summary is a document which synopsizes a patient's admission to a hospital, LTPAC provider, or other setting. It provides information for the continuation of care following discharge. The Joint Commission requires the following information to be included in the Discharge Summary (http://www.jointcommission.org/):\n*  The reason for hospitalization (the admission)\n*  The procedures performed, as applicable\n*  The care, treatment, and services provided\n*  The patients condition and disposition at discharge\n*  Information provided to the patient and family\n*  Provisions for follow-up care\n\nThe best practice for a Discharge Summary is to include the discharge disposition in the display of the header.\n\n#### Document Sections\nAlthough document templates may contain any section, the following sections are specifically called out by this template:\n\n**Required Sections**\n- [AllergiesAndIntolerancesSection](StructureDefinition-AllergiesAndIntolerancesSection.html)\n- [HospitalCourseSection](StructureDefinition-HospitalCourseSection.html)\n- [DischargeDiagnosisSection](StructureDefinition-DischargeDiagnosisSection.html)\n- [PlanofTreatmentSection](StructureDefinition-PlanofTreatmentSection.html)\n- [HospitalConsultationsSection](StructureDefinition-HospitalConsultationsSection.html)\n- [ProceduresSection](StructureDefinition-ProceduresSection.html)\n- [ResultsSection](StructureDefinition-ResultsSection.html)\n\n**Recommended Sections**\n- [DischargeMedicationsSection](StructureDefinition-DischargeMedicationsSection.html)\n\n**Additional Sections**\n- [ChiefComplaintSection](StructureDefinition-ChiefComplaintSection.html)\n- [ChiefComplaintandReasonforVisitSection](StructureDefinition-ChiefComplaintandReasonforVisitSection.html)\n- [NutritionSection](StructureDefinition-NutritionSection.html)\n- [FamilyHistorySection](StructureDefinition-FamilyHistorySection.html)\n- [FunctionalStatusSection](StructureDefinition-FunctionalStatusSection.html)\n- [PastMedicalHistory](StructureDefinition-PastMedicalHistory.html)\n- [HistoryofPresentIllnessSection](StructureDefinition-HistoryofPresentIllnessSection.html)\n- [AdmissionDiagnosisSection](StructureDefinition-AdmissionDiagnosisSection.html)\n- [AdmissionMedicationsSectionEntriesOptional](StructureDefinition-AdmissionMedicationsSectionEntriesOptional.html)\n- [HospitalDischargeInstructionsSection](StructureDefinition-HospitalDischargeInstructionsSection.html)\n- [HospitalDischargePhysicalSection](StructureDefinition-HospitalDischargePhysicalSection.html)\n- [HospitalDischargeStudiesSummarySection](StructureDefinition-HospitalDischargeStudiesSummarySection.html)\n- [ImmunizationsSection](StructureDefinition-ImmunizationsSection.html)\n- [ProblemSection](StructureDefinition-ProblemSection.html)\n- [ReasonforVisitSection](StructureDefinition-ReasonforVisitSection.html)\n- [ReviewofSystemsSection](StructureDefinition-ReviewofSystemsSection.html)\n- [SocialHistorySection](StructureDefinition-SocialHistorySection.html)\n- [VitalSignsSection](StructureDefinition-VitalSignsSection.html)\n- [AdvanceDirectivesSection](StructureDefinition-AdvanceDirectivesSection.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/USRealmHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalDocument",
        "path" : "ClinicalDocument",
        "constraint" : [
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary"
          },
          {
            "key" : "category-18842-5",
            "severity" : "error",
            "human" : "If category is present, then there shall be a category with LOINC code '18842-5'.",
            "expression" : "sdtcCategory.empty() or sdtcCategory.exists(code = '18842-5' and codeSystem = '2.16.840.1.113883.6.1')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.templateId",
        "path" : "ClinicalDocument.templateId",
        "min" : 2
      },
      {
        "id" : "ClinicalDocument.templateId:discharge-summary",
        "path" : "ClinicalDocument.templateId",
        "sliceName" : "discharge-summary",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.templateId:discharge-summary.root",
        "path" : "ClinicalDocument.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.1.8"
      },
      {
        "id" : "ClinicalDocument.templateId:discharge-summary.extension",
        "path" : "ClinicalDocument.templateId.extension",
        "min" : 1,
        "patternString" : "2024-05-01"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory",
        "path" : "ClinicalDocument.sdtcCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "codeSystem"
            }
          ],
          "rules" : "open"
        },
        "short" : "Used to categorize the document as a Discharge Summary. If present, there SHALL be a category of 18842-5 (Discharge summary).",
        "condition" : ["should-sdtcCategory", "category-18842-5"]
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType",
        "path" : "ClinicalDocument.sdtcCategory",
        "sliceName" : "documentType",
        "short" : "Discharge summary",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.code",
        "path" : "ClinicalDocument.sdtcCategory.code",
        "min" : 1,
        "patternCode" : "18842-5"
      },
      {
        "id" : "ClinicalDocument.sdtcCategory:documentType.codeSystem",
        "path" : "ClinicalDocument.sdtcCategory.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "ClinicalDocument.code",
        "path" : "ClinicalDocument.code",
        "short" : "The Discharge Summary recommends use of a single document type code, 18842-5 \"Discharge summary\", with further specification provided by author or performer, setting, or specialty. When pre-coordinated codes are used, any coded values describing the author or performer of the service act or the practice setting must be consistent with the LOINC document type.",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:1198-17178).",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.4.1"
        }
      },
      {
        "id" : "ClinicalDocument.participant",
        "path" : "ClinicalDocument.participant",
        "short" : "The participant element in the Discharge Summary header follows the General Header Constraints for participants. Discharge Summary does not specify any use for functionCode for participants. Local policies will determine how this element should be used in implementations.",
        "comment" : "MAY contain zero or more [0..*] participant (CONF:1198-8467).",
        "constraint" : [
          {
            "key" : "1198-8469",
            "severity" : "error",
            "human" : "When participant/@typeCode is IND, associatedEntity/@classCode **SHALL** be selected from ValueSet 2.16.840.1.113883.11.20.9.33 INDRoleclassCodes STATIC 2011-09-30 (CONF:1198-8469).",
            "expression" : "typeCode = 'IND' implies associatedEntity.classCode.memberOf('http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.33')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.participant.associatedEntity.classCode",
        "path" : "ClinicalDocument.participant.associatedEntity.classCode",
        "binding" : {
          "strength" : "required",
          "description" : "See additional bindings",
          "valueSet" : "http://hl7.org/cda/stds/core/ValueSet/CDARoleClassAssociative",
          "additional" : [
            {
              "purpose" : "preferred",
              "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.33",
              "documentation" : "When participant/@typeCode is IND, associatedEntity/@classCode **SHALL** be selected from ValueSet 2.16.840.1.113883.11.20.9.33 INDRoleclassCodes STATIC 2011-09-30 (CONF:1198-8469).",
              "shortDoco" : "When typeCode=IND"
            }
          ]
        }
      },
      {
        "id" : "ClinicalDocument.componentOf",
        "path" : "ClinicalDocument.componentOf",
        "short" : "The Discharge Summary is always associated with a Hospital Admission using the encompassingEncounter element in the header.",
        "comment" : "SHALL contain exactly one [1..1] componentOf (CONF:1198-8471).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter",
        "comment" : "This componentOf SHALL contain exactly one [1..1] encompassingEncounter (CONF:1198-8472)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime",
        "comment" : "This encompassingEncounter SHALL contain exactly one [1..1] effectiveTime (CONF:1198-32611)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime.low",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime.low",
        "short" : "The admission date is recorded in the componentOf/encompassingEncounter/effectiveTime/low.",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] low (CONF:1198-8473).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime.high",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.effectiveTime.high",
        "short" : "The discharge date is recorded in the componentOf/encompassingEncounter/effectiveTime/high.",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] high (CONF:1198-8475).",
        "min" : 1
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.dischargeDispositionCode",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.dischargeDispositionCode",
        "short" : "The dischargeDispositionCode records the disposition of the patient at time of discharge. Access to the National Uniform Billing Committee (NUBC) code system requires a membership. The following conformance statement aligns with HITSP C80 requirements. \n\nThe dischargeDispositionCode, @displayName, or NUBC UB-04 Print Name, must be displayed when the document is rendered.",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-USEncounterDischargeDisposition"
        }
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty",
        "short" : "The responsibleParty element represents only the party responsible for the encounter, not necessarily the entire episode of care.",
        "comment" : "This encompassingEncounter MAY contain zero or one [0..1] responsibleParty (CONF:1198-8479)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty.assignedEntity",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.responsibleParty.assignedEntity",
        "comment" : "The responsibleParty, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:1198-32613).",
        "constraint" : [
          {
            "key" : "1198-32898",
            "severity" : "error",
            "human" : "This assignedEntity **SHALL** contain an assignedPerson or a representedOrganization or both (CONF:1198-32898).",
            "expression" : "assignedPerson.exists() or representedOrganization.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant",
        "short" : "The encounterParticipant element represents persons who participated in the encounter and not necessarily the entire episode of care.",
        "comment" : "This encompassingEncounter MAY contain zero or more [0..*] encounterParticipant (CONF:1198-8478)."
      },
      {
        "id" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant.assignedEntity",
        "path" : "ClinicalDocument.componentOf.encompassingEncounter.encounterParticipant.assignedEntity",
        "comment" : "The encounterParticipant, if present, SHALL contain exactly one [1..1] assignedEntity (CONF:1198-32615).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "1198-32899",
            "severity" : "error",
            "human" : "This assignedEntity **SHALL** contain an assignedPerson or a representedOrganization or both (CONF:1198-32899).",
            "expression" : "assignedPerson.exists() or representedOrganization.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component",
        "path" : "ClinicalDocument.component",
        "comment" : "SHALL contain exactly one [1..1] component (CONF:1198-9539)."
      },
      {
        "id" : "ClinicalDocument.component.structuredBody",
        "path" : "ClinicalDocument.component.structuredBody",
        "short" : "In this template (templateId 2.16.840.1.113883.10.20.22.1.8.2), coded entries are optional.",
        "comment" : "This component SHALL contain exactly one [1..1] structuredBody (CONF:1198-30518).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "cc-rfv-combo",
            "severity" : "error",
            "human" : "This structuredBody **SHALL NOT** contain a Chief Complaint and Reason for Visit Section (2.16.840.1.113883.10.20.22.2.13) when either a Chief Complaint Section (1.3.6.1.4.1.19376.1.5.3.1.1.13.2.1) or a Reason for Visit Section (2.16.840.1.113883.10.20.22.2.12) is present.",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintandReasonforVisitSection')).exists() implies component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintSection') or section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection')).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary"
          },
          {
            "key" : "should-section-discharge-meds",
            "severity" : "warning",
            "human" : "SHOULD contain a Discharge Medications Section",
            "expression" : "component.where(section.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/DischargeMedicationsSection'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeSummary"
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "section"
            }
          ],
          "rules" : "open"
        },
        "min" : 7
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "allergies",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30519).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:allergies.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "This component SHALL contain exactly one [1..1] Allergies and Intolerances Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.6.1:2024-05-01) (CONF:1198-30520).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AllergiesAndIntolerancesSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:hospitalCourse",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "hospitalCourse",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30521) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:hospitalCourse.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Hospital Course Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.5) (CONF:1198-30522).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalCourseSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargeDx",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "dischargeDx",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30523) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargeDx.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Discharge Diagnosis Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.24:2024-05-01) (CONF:1198-30524).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeDiagnosisSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargeMeds",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "dischargeMeds",
        "comment" : "This structuredBody SHOULD contain zero or one [0..1] component (CONF:1198-30525) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["should-section-discharge-meds"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargeMeds.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Discharge Medications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.11.1:2024-05-01) (CONF:1198-30526).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/DischargeMedicationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "planOfTreatment",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30527) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:planOfTreatment.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Plan of Treatment Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.10:2014-06-09) (CONF:1198-30528).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlanofTreatmentSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaint",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "chiefComplaint",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30529) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["cc-rfv-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaint.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Chief Complaint Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.1.13.2.1) (CONF:1198-30530).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaintRFV",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "chiefComplaintRFV",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30531) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["cc-rfv-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:chiefComplaintRFV.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Chief Complaint and Reason for Visit Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.13) (CONF:1198-30532).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ChiefComplaintandReasonforVisitSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:nutrition",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "nutrition",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30533) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:nutrition.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Nutrition Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.57) (CONF:1198-30534).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/NutritionSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "familyHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30535) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:familyHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Family History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.15:2024-05-01) (CONF:1198-30536).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FamilyHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:functionalStatus",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "functionalStatus",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30537) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:functionalStatus.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Functional Status Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.14:2014-06-09) (CONF:1198-30538).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/FunctionalStatusSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:pastMedicalHistory",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "pastMedicalHistory",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30539) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:pastMedicalHistory.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Past Medical History (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.20:2024-05-01) (CONF:1198-30540).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PastMedicalHistory"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:hpi",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "hpi",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30541) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:hpi.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] History of Present Illness Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.4) (CONF:1198-30542).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HistoryofPresentIllnessSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:admissionDx",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "admissionDx",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30543) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:admissionDx.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Admission Diagnosis Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.43:2024-05-01) (CONF:1198-30544).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdmissionDiagnosisSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:admissionMeds",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "admissionMeds",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30545) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:admissionMeds.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Admission Medications Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.44.1:2024-05-01) (CONF:1198-30546).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdmissionMedicationsSectionEntriesOptional"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:hospitalConsults",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "hospitalConsults",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30523) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:hospitalConsults.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Hospital Consultations Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.42) (CONF:1198-30548).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalConsultationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargeInstructions",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "dischargeInstructions",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30549) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargeInstructions.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Hospital Discharge Instructions Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.41) (CONF:1198-30550).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargeInstructionsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargePhysical",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "dischargePhysical",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30551) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargePhysical.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Hospital Discharge Physical Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.26) (CONF:1198-30552).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargePhysicalSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargeStudies",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "dischargeStudies",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30553) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:dischargeStudies.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Hospital Discharge Studies Summary Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.16) (CONF:1198-30554).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HospitalDischargeStudiesSummarySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunization",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "immunization",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30555) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:immunization.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Immunizations Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.2.1:2024-05-01) (CONF:1198-30556).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ImmunizationsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problems",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "problems",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30557) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:problems.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Problem Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.5.1:2024-05-01) (CONF:1198-30558).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "procedures",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30523) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:procedures.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Procedures Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.7.1:2014-06-09) (CONF:1198-30560).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProceduresSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForVisit",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reasonForVisit",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30561) such that it",
        "min" : 0,
        "max" : "1",
        "condition" : ["cc-rfv-combo"]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reasonForVisit.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Reason for Visit Section (identifier: urn:oid:2.16.840.1.113883.10.20.22.2.12) (CONF:1198-30562).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReasonforVisitSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "reviewOfSystems",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30563) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:reviewOfSystems.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Review of Systems Section (identifier: urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.18) (CONF:1198-30564).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ReviewofSystemsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHist",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "socialHist",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30565) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:socialHist.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Social History Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.17:2024-05-01) (CONF:1198-30566).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistorySection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "vitalSigns",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-30567) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:vitalSigns.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Vital Signs Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.4.1:2024-05-01) (CONF:1198-30568).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/VitalSignsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "results",
        "comment" : "This structuredBody SHALL contain exactly one [1..1] component (CONF:1198-30559) such that it",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:results.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Results Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.3.1:2014-06-09) (CONF:1198-30560).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ResultsSection"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives",
        "path" : "ClinicalDocument.component.structuredBody.component",
        "sliceName" : "advDirectives",
        "comment" : "This structuredBody MAY contain zero or one [0..1] component (CONF:1198-28942) such that it",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalDocument.component.structuredBody.component:advDirectives.section",
        "path" : "ClinicalDocument.component.structuredBody.component.section",
        "comment" : "SHALL contain exactly one [1..1] Advance Directives Section (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.2.21.1:2024-05-01).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
            ]
          }
        ]
      }
    ]
  }
}

```
