# Date of Diagnosis Act - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Date of Diagnosis Act**

## Logical Model: Date of Diagnosis Act 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/DateOfDiagnosisAct | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:DateOfDiagnosisAct |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.502:2022-06-01 | |

 
This template represents the earliest date of diagnosis, which is the date of first determination by a qualified professional of the presence of a problem or condition affecting a patient. An encounter diagnosis date may be different than this Date of Diagnosis. 
The date of diagnosis is usually not the same date as the date of condition onset. A patient may have a condition for some time before it is formally diagnosed. 

**Usages:**

* Use this Logical Model Profile: [Problem Observation](StructureDefinition-ProblemObservation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/DateOfDiagnosisAct)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-DateOfDiagnosisAct.csv), [Excel](StructureDefinition-DateOfDiagnosisAct.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DateOfDiagnosisAct",
  "meta" : {
    "versionId" : "4",
    "lastUpdated" : "2023-07-11T23:41:51.895Z"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/DateOfDiagnosisAct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.502:2022-06-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "DateOfDiagnosisAct",
  "title" : "Date of Diagnosis Act",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents the earliest date of diagnosis, which is the date of first determination by a qualified professional of the presence of a problem or condition affecting a patient. An encounter diagnosis date may be different than this Date of Diagnosis.\n\nThe date of diagnosis is usually not the same date as the date of condition onset. A patient may have a condition for some time before it is formally diagnosed.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/DateOfDiagnosisAct"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:date-of-diagnosis-act",
        "path" : "Act.templateId",
        "sliceName" : "date-of-diagnosis-act",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:date-of-diagnosis-act.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.502"
      },
      {
        "id" : "Act.templateId:date-of-diagnosis-act.extension",
        "path" : "Act.templateId.extension",
        "min" : 1,
        "patternString" : "2022-06-01"
      },
      {
        "id" : "Act.classCode",
        "path" : "Act.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"ACT\" Act (CodeSystem: HL7ActCode urn:oid:2.16.840.1.113883.5.4) (CONF:4515-33010).",
        "fixedCode" : "ACT"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:4515-33011).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:4515-33001)."
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "comment" : "This code SHALL contain zero or one [0..1] @code=\"77975-1\" Earliest date of diagnosis (CONF:4515-33004).",
        "patternCode" : "77975-1"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "comment" : "This code SHALL contain exactly one [1..1] @codeSystem=\"2.16.840.1.113883.6.1\" LOINC (CONF:4515-33005).",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/DateOfDiagnosisAct"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "min" : 1
      },
      {
        "id" : "Act.statusCode.code",
        "path" : "Act.statusCode.code",
        "comment" : "SHALL contain exactly one [1..1] statusCode=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:4515-33006).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Act.effectiveTime",
        "path" : "Act.effectiveTime",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:4515-33007).",
        "min" : 1,
        "constraint" : [
          {
            "key" : "value-only",
            "severity" : "error",
            "human" : "Interval fields SHALL NOT be present",
            "expression" : "(low | high | width | center).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/DateOfDiagnosisAct"
          },
          {
            "key" : "ts-shall-year",
            "severity" : "error",
            "human" : "**SHALL** be precise to at least the year",
            "expression" : "nullFlavor.exists() or value.toString().length() >= 4",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/DateOfDiagnosisAct"
          }
        ]
      },
      {
        "id" : "Act.effectiveTime.value",
        "path" : "Act.effectiveTime.value",
        "short" : "value should be used instead of low/high",
        "comment" : "This effectiveTime SHALL contain exactly one [1..1] @value (CONF:4515-33008).",
        "min" : 1
      }
    ]
  }
}

```
