# Caregiver Characteristics - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Caregiver Characteristics**

## Logical Model: Caregiver Characteristics 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/CaregiverCharacteristics | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:CaregiverCharacteristics |
| *Other Identifiers:*OID:2.16.840.1.113883.10.20.22.4.72 | |

 
This clinical statement represents a caregiver's willingness to provide care and the abilities of that caregiver to provide assistance to a patient in relation to a specific need. 

**Usages:**

* Use this Logical Model Profile: [Functional Status Observation](StructureDefinition-FunctionalStatusObservation.md), [Functional Status Section](StructureDefinition-FunctionalStatusSection.md), [Health Concern Act](StructureDefinition-HealthConcernAct.md), [Risk Concern Act](StructureDefinition-RiskConcernAct.md) and [Social History Section](StructureDefinition-SocialHistorySection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/CaregiverCharacteristics)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-CaregiverCharacteristics.csv), [Excel](StructureDefinition-CaregiverCharacteristics.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CaregiverCharacteristics",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/CaregiverCharacteristics",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.10.20.22.4.72"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "CaregiverCharacteristics",
  "title" : "Caregiver Characteristics",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This clinical statement represents a caregiver's willingness to provide care and the abilities of that caregiver to provide assistance to a patient in relation to a specific need.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CaregiverCharacteristics"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:caregiver-characteristics",
        "path" : "Observation.templateId",
        "sliceName" : "caregiver-characteristics",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:caregiver-characteristics.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.72"
      },
      {
        "id" : "Observation.templateId:caregiver-characteristics.extension",
        "path" : "Observation.templateId.extension",
        "max" : "0"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:81-14219).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:81-14220).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:81-14223).",
        "min" : 1
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "This code MAY be drawn from LOINC (CodeSystem: LOINC 2.16.840.1.113883.6.1)  or MAY be bound to ASSERTION (CodeSystem: ActCode 2.16.840.1.113883.5.4 STATIC) (CONF:81-26513).",
        "comment" : "SHALL contain exactly one [1..1] code (CONF:81-14230)."
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CaregiverCharacteristics"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:81-14233).",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:81-19090).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "comment" : "SHALL contain exactly one [1..1] value with @xsi:type=\"CD\" (CONF:81-14599).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "constraint" : [
          {
            "key" : "81-14600",
            "severity" : "error",
            "human" : "The code **SHALL** be selected from LOINC (codeSystem: 2.16.840.1.113883.6.1) or SNOMED CT (CodeSystem: 2.16.840.1.113883.6.96) (CONF:81-14600).",
            "expression" : "codeSystem = '2.16.840.1.113883.6.1' or codeSystem = '2.16.840.1.113883.6.96'",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CaregiverCharacteristics"
          }
        ]
      },
      {
        "id" : "Observation.participant",
        "path" : "Observation.participant",
        "comment" : "SHALL contain at least one [1..*] participant (CONF:81-14227).",
        "min" : 1
      },
      {
        "id" : "Observation.participant.typeCode",
        "path" : "Observation.participant.typeCode",
        "comment" : "Such participants SHALL contain exactly one [1..1] @typeCode=\"IND\" (CONF:81-26451).",
        "fixedCode" : "IND"
      },
      {
        "id" : "Observation.participant.time",
        "path" : "Observation.participant.time",
        "comment" : "Such participants MAY contain zero or one [0..1] time (CONF:81-14830)."
      },
      {
        "id" : "Observation.participant.time.low",
        "path" : "Observation.participant.time.low",
        "comment" : "The time, if present, SHALL contain exactly one [1..1] low (CONF:81-14831).",
        "min" : 1
      },
      {
        "id" : "Observation.participant.time.high",
        "path" : "Observation.participant.time.high",
        "comment" : "The time, if present, MAY contain zero or one [0..1] high (CONF:81-14832)."
      },
      {
        "id" : "Observation.participant.participantRole",
        "path" : "Observation.participant.participantRole",
        "comment" : "Such participants SHALL contain exactly one [1..1] participantRole (CONF:81-14228)."
      },
      {
        "id" : "Observation.participant.participantRole.classCode",
        "path" : "Observation.participant.participantRole.classCode",
        "comment" : "This participantRole SHALL contain exactly one [1..1] @classCode=\"CAREGIVER\" (CONF:81-14229).",
        "min" : 1,
        "fixedCode" : "CAREGIVER"
      }
    ]
  }
}

```
