# Care Plan Act - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Care Plan Act**

## Logical Model: Care Plan Act 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/CarePlanAct | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:CarePlanAct |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.518:2026-05-01 | |

 
The Care Plan Act represents a snapshot in time of a dynamic, consensus-driven plan that has captured a patient's and care team members' prioritized concerns, goals, and planned interventions. It reflects the state of the care plan as managed within a source system and may be exchanged to support care coordination across systems and settings. 
The Care Plan Act identifies the authoring individual or organization (act.author), which aligns with the FHIR CarePlan.contributor, and records the set of health concerns or conditions being addressed. 
**To meet USCDI requirements, at least one entryRelationship:addresses element referencing an Indication, Problem Observation, or Observation is required.** 
The Care Plan Act may integrate multiple condition- or discipline-specific plans of care and serves to align activities and responsibilities among participants.**Supporting entryRelationship templates such as Goal, Intervention Act, Planned Intervention Act, and Act are available for systems capable of representing structured care plans, but their use is optional and not required for USCDI compliance.** 
This entry conveys an instance of the evolving Care Plan at a specific point in time and does not represent a dynamically updated plan. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[Act](https://hl7.org/cda/stds/core/StructureDefinition-Act.html),[EntryReference](StructureDefinition-EntryReference.md),[GoalObservation](StructureDefinition-GoalObservation.md),[Indication](StructureDefinition-Indication.md),[InterventionAct](StructureDefinition-InterventionAct.md),[Observation](https://hl7.org/cda/stds/core/StructureDefinition-Observation.html),[PlannedInterventionAct](StructureDefinition-PlannedInterventionAct.md),[ProblemObservation](StructureDefinition-ProblemObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Plan of Treatment Section](StructureDefinition-PlanofTreatmentSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/CarePlanAct)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-CarePlanAct.csv), [Excel](StructureDefinition-CarePlanAct.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CarePlanAct",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "act"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlanAct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.518:2026-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "CarePlanAct",
  "title" : "Care Plan Act",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Care Plan Act represents a snapshot in time of a dynamic, consensus-driven plan that has captured a patient's and care team members' prioritized concerns, goals, and planned interventions. It reflects the state of the care plan as managed within a source system and may be exchanged to support care coordination across systems and settings.\n\nThe Care Plan Act identifies the authoring individual or organization (act.author), which aligns with the FHIR CarePlan.contributor, and records the set of health concerns or conditions being addressed.\n\n**To meet USCDI requirements, at least one entryRelationship:addresses element referencing an Indication, Problem Observation, or Observation is required.**\n\nThe Care Plan Act may integrate multiple condition- or discipline-specific plans of care and serves to align activities and responsibilities among participants. *Supporting entryRelationship templates such as Goal, Intervention Act, Planned Intervention Act, and Act are available for systems capable of representing structured care plans, but their use is optional and not required for USCDI compliance.*\n\nThis entry conveys an instance of the evolving Care Plan at a specific point in time and does not represent a dynamically updated plan.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [Act](https://hl7.org/cda/stds/core/StructureDefinition-Act.html), [EntryReference](StructureDefinition-EntryReference.html), [GoalObservation](StructureDefinition-GoalObservation.html), [Indication](StructureDefinition-Indication.html), [InterventionAct](StructureDefinition-InterventionAct.html), [Observation](https://hl7.org/cda/stds/core/StructureDefinition-Observation.html), [PlannedInterventionAct](StructureDefinition-PlannedInterventionAct.html), [ProblemObservation](StructureDefinition-ProblemObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "CarePlanActToUsCoreCarePlan",
      "uri" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careplan",
      "name" : "FHIR US Core"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Act",
        "path" : "Act",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlanAct"
          }
        ],
        "mapping" : [
          {
            "identity" : "CarePlanActToUsCoreCarePlan",
            "map" : "CarePlan"
          }
        ]
      },
      {
        "id" : "Act.templateId",
        "path" : "Act.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Act.templateId:care-plan-act",
        "path" : "Act.templateId",
        "sliceName" : "care-plan-act",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Act.templateId:care-plan-act.root",
        "path" : "Act.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.518"
      },
      {
        "id" : "Act.templateId:care-plan-act.extension",
        "path" : "Act.templateId.extension",
        "min" : 1,
        "patternString" : "2026-05-01"
      },
      {
        "id" : "Act.moodCode",
        "path" : "Act.moodCode",
        "short" : "CarePlan.intent",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.37"
        },
        "mapping" : [
          {
            "identity" : "CarePlanActToUsCoreCarePlan",
            "map" : "CarePlan.intent"
          }
        ]
      },
      {
        "id" : "Act.code",
        "path" : "Act.code",
        "short" : "Plan of care note"
      },
      {
        "id" : "Act.code.code",
        "path" : "Act.code.code",
        "min" : 1,
        "patternCode" : "18776-5"
      },
      {
        "id" : "Act.code.codeSystem",
        "path" : "Act.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Act.code.translation",
        "path" : "Act.code.translation",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/care-plan-category"
        },
        "mapping" : [
          {
            "identity" : "CarePlanActToUsCoreCarePlan",
            "map" : "CarePlan.category"
          }
        ]
      },
      {
        "id" : "Act.text",
        "path" : "Act.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Act.text.reference",
        "path" : "Act.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlanAct"
          }
        ]
      },
      {
        "id" : "Act.statusCode",
        "path" : "Act.statusCode",
        "short" : "CarePlan.status",
        "min" : 1,
        "mapping" : [
          {
            "identity" : "CarePlanActToUsCoreCarePlan",
            "map" : "CarePlan.status"
          }
        ]
      },
      {
        "id" : "Act.author",
        "path" : "Act.author",
        "short" : "CarePlan.contributor",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "mapping" : [
          {
            "identity" : "CarePlanActToUsCoreCarePlan",
            "map" : "CarePlan.contributor"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship",
        "path" : "Act.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "short" : "Entries can be embedded directly or referenced via EntryReference. Use the @typeCode attribute to distinguish the type of relationship."
      },
      {
        "id" : "Act.entryRelationship:addresses",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Act.entryRelationship",
        "sliceName" : "addresses",
        "short" : "𝗨𝗦𝗖𝗗𝗜: CarePlan.addresses",
        "min" : 0,
        "max" : "*",
        "constraint" : [
          {
            "key" : "act-or-observation",
            "severity" : "error",
            "human" : "Either act or observation SHALL be present but not both.",
            "expression" : "act.exists() or observation.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlanAct"
          }
        ],
        "mapping" : [
          {
            "identity" : "CarePlanActToUsCoreCarePlan",
            "map" : "CarePlan.addresses"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:addresses.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "patternCode" : "RSON"
      },
      {
        "id" : "Act.entryRelationship:addresses.act",
        "path" : "Act.entryRelationship.act",
        "short" : "References an Indication, Problem Observation, or other Problem described elsewhere in the document.",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference",
              "http://hl7.org/cda/stds/core/StructureDefinition/Act"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:addresses.observation",
        "path" : "Act.entryRelationship.observation",
        "short" : "Directly-embedded Problem or Indication observation. Use EntryReference to reference an existing problem observation or indication described elsewhere in the document.",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/Indication",
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProblemObservation",
              "http://hl7.org/cda/stds/core/StructureDefinition/Observation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:goal",
        "path" : "Act.entryRelationship",
        "sliceName" : "goal",
        "short" : "Desired outcome of the plan (CarePlan.goal). Can embed a Goal Observation directly or use the EntryReference template to reference a Goal Observation described elsewhere in the document.",
        "min" : 0,
        "max" : "*",
        "constraint" : [
          {
            "key" : "act-or-observation",
            "severity" : "error",
            "human" : "Either act or observation SHALL be present but not both.",
            "expression" : "act.exists() or observation.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlanAct"
          }
        ],
        "mapping" : [
          {
            "identity" : "CarePlanActToUsCoreCarePlan",
            "map" : "CarePlan.goal"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:goal.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "patternCode" : "GEVL"
      },
      {
        "id" : "Act.entryRelationship:goal.act",
        "path" : "Act.entryRelationship.act",
        "short" : "Use to reference a Goal Observation elsewhere",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/EntryReference"
            ]
          }
        ],
        "constraint" : [
          {
            "key" : "entry-ref-goal",
            "severity" : "error",
            "human" : "This entryReference template **SHALL** reference an instance of a Goal Observation template.",
            "expression" : "%resource.descendants().ofType(CDA.Observation).where(templateId.exists($this.root = '2.16.840.1.113883.10.20.22.4.121' and $this.extension = '2022-06-01') and id.exists($this.root = %context.id.first().root and $this.extension ~ %context.id.first().extension))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/CarePlanAct"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:goal.observation",
        "path" : "Act.entryRelationship.observation",
        "short" : "Use to embed a Goal Observation directly",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/GoalObservation"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:supportingInfo",
        "path" : "Act.entryRelationship",
        "sliceName" : "supportingInfo",
        "short" : "Information considered as part of the plan (CarePlan.supportingInfo)",
        "min" : 0,
        "max" : "*",
        "mapping" : [
          {
            "identity" : "CarePlanActToUsCoreCarePlan",
            "map" : "CarePlan.supportingInfo"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:supportingInfo.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "patternCode" : "SPRT"
      },
      {
        "id" : "Act.entryRelationship:activity",
        "path" : "Act.entryRelationship",
        "sliceName" : "activity",
        "short" : "Activity to occur as part of plan (CarePlan.activity). Common examples include the Intervention Act and Planned Intervention Act, but any entry may be considered an activity of the care plan.",
        "min" : 0,
        "max" : "*",
        "mapping" : [
          {
            "identity" : "CarePlanActToUsCoreCarePlan",
            "map" : "CarePlan.activity"
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:activity.typeCode",
        "path" : "Act.entryRelationship.typeCode",
        "patternCode" : "COMP"
      },
      {
        "id" : "Act.entryRelationship:activity.act",
        "path" : "Act.entryRelationship.act",
        "short" : "A care plan may have multiple COMP entryRelationships, but each entryRelationship may only have a single act/encounter/observation/supply or other clinical statement.",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct",
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct",
              "http://hl7.org/cda/stds/core/StructureDefinition/Act"
            ]
          }
        ]
      },
      {
        "id" : "Act.entryRelationship:activity.encounter",
        "path" : "Act.entryRelationship.encounter",
        "short" : "A care plan may have multiple COMP entryRelationships, but each entryRelationship may only have a single act/encounter/observation/supply or other clinical statement."
      },
      {
        "id" : "Act.entryRelationship:activity.observation",
        "path" : "Act.entryRelationship.observation",
        "short" : "A care plan may have multiple COMP entryRelationships, but each entryRelationship may only have a single act/encounter/observation/supply or other clinical statement."
      },
      {
        "id" : "Act.entryRelationship:activity.supply",
        "path" : "Act.entryRelationship.supply",
        "short" : "A care plan may have multiple COMP entryRelationships, but each entryRelationship may only have a single act/encounter/observation/supply or other clinical statement."
      }
    ]
  }
}

```
