# Basic Industry Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Basic Industry Observation**

## Logical Model: Basic Industry Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/BasicIndustryObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:BasicIndustryObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.504:2023-05-01 | |

 
This template represents a simple observation about the type of business that compensates for work or assigns work to an unpaid worker or volunteer (e.g., US Army, cement manufacturing, children and youth services). Multiple occupation industry observation instances in a single document or derived from multiple documents, represent a basic historical industry record. 
Implementers should use the Basic Industry Observation template for conveying Industry in support of USCDI. It is recommended systems include the Basic Industry Observation in the Social History section. Implementers wishing to convey more advanced Industry detail may consider using[HL7 CDA R2 Implementation Guide: C-CDA R2.1 Supplemental Templates for Occupational Data for Health](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=522)in addition to this Observation. 

**Usages:**

* Use this Logical Model Profile: [Basic Occupation Observation](StructureDefinition-BasicOccupationObservation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/BasicIndustryObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-BasicIndustryObservation.csv), [Excel](StructureDefinition-BasicIndustryObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BasicIndustryObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/BasicIndustryObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.504:2023-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "BasicIndustryObservation",
  "title" : "Basic Industry Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents a simple observation about the type of business that compensates for work or assigns work to an unpaid worker or volunteer (e.g., US Army, cement manufacturing, children and youth services). Multiple occupation industry observation instances in a single document or derived from multiple documents, represent a basic historical industry record.\n\n Implementers should use the Basic Industry Observation template for conveying Industry in support of USCDI. It is recommended systems include the Basic Industry Observation in the Social History section.  Implementers wishing to convey more advanced Industry detail may consider using  [HL7 CDA R2 Implementation Guide: C-CDA R2.1 Supplemental Templates for Occupational Data for Health](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=522) in addition to this Observation.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/us/ccda/StructureDefinition/SocialHistoryObservation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "min" : 2
      },
      {
        "id" : "Observation.templateId:basic-industry-obs",
        "path" : "Observation.templateId",
        "sliceName" : "basic-industry-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:basic-industry-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.504"
      },
      {
        "id" : "Observation.templateId:basic-industry-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2023-05-01"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:4537-33018)."
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001) (CONF:4537-33019)."
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "History of Occupation industry",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"86188-0\" History of Occupation Industry (CONF:4537-33015)."
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "min" : 1,
        "patternCode" : "86188-0"
      },
      {
        "id" : "Observation.code.codeSystem",
        "path" : "Observation.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4537-33011)."
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:4537-33017)."
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "min" : 1
      },
      {
        "id" : "Observation.value:physical-quantity",
        "path" : "Observation.value",
        "sliceName" : "physical-quantity",
        "max" : "0"
      },
      {
        "id" : "Observation.value:coded",
        "path" : "Observation.value",
        "sliceName" : "coded",
        "comment" : "SHALL contain exactly one [1..1] value with @xsi:type=\"CD\", which SHALL be selected from ValueSet Industry NAICS Detail (ODH) urn:oid:2.16.840.1.114222.4.11.7900 DYNAMIC (CONF:4537-33022).",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://phinvads.cdc.gov/fhir/ValueSet/2.16.840.1.114222.4.11.7900"
        }
      }
    ]
  }
}

```
