# Assessment Scale Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Assessment Scale Observation**

## Logical Model: Assessment Scale Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:AssessmentScaleObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.69:2022-06-01 | |

 
An assessment scale is a collection of observations that together can yield a calculated or non-calculated summary evaluation of a one or more conditions. Examples include the Braden Scale (assesses pressure ulcer risk), APACHE Score (estimates mortality in critically ill patients), Mini-Mental Status Exam (assesses cognitive function), APGAR Score (assesses the health of a newborn), Glasgow Coma Scale (assesses coma and impaired consciousness), and WE CARE (Well Child Care, Evaluation, Community Resources, Advocacy, Referral, Education - a clinic-based screening and referral system developed for pediatric settings). 
When an Assessment Scale Observation is contained in a Problem Observation, a Social History Observation or a Procedure instance that is Social Determinant of Health focused, that Assessment scale**MAY**contain assessment scale observations that represent question and answer pairs from SDOH screening instruments that are represented in LOINC. Note that guidance on the use of LOINC in assessment scales already exists in Assessment Scale Observation constraints and Assessment Scale Supporting Observations constraints. 
The Observation value is used to record a calculated score using an integer. A LOINC answer concept is used when the assessment is non-calculated result. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AssessmentScaleSupportingObservation](StructureDefinition-AssessmentScaleSupportingObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Disability Status Observation](StructureDefinition-DisabilityStatusObservation.md), [Functional Status Observation](StructureDefinition-FunctionalStatusObservation.md), [Functional Status Section](StructureDefinition-FunctionalStatusSection.md), [Health Concern Act](StructureDefinition-HealthConcernAct.md)...Show 8 more,[Mental Status Observation](StructureDefinition-MentalStatusObservation.md),[Mental Status Section](StructureDefinition-MentalStatusSection.md),[Planned Procedure](StructureDefinition-PlannedProcedure.md),[Problem Observation](StructureDefinition-ProblemObservation.md),[Procedure Activity Procedure](StructureDefinition-ProcedureActivityProcedure.md),[Risk Concern Act](StructureDefinition-RiskConcernAct.md),[Sensory Status](StructureDefinition-SensoryStatus.md)and[Social History Observation](StructureDefinition-SocialHistoryObservation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/AssessmentScaleObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-AssessmentScaleObservation.csv), [Excel](StructureDefinition-AssessmentScaleObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AssessmentScaleObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.69:2022-06-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "AssessmentScaleObservation",
  "title" : "Assessment Scale Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "An assessment scale is a collection of observations that together can yield a calculated or non-calculated summary evaluation of a one or more conditions. Examples include the Braden Scale (assesses pressure ulcer risk), APACHE Score (estimates mortality in critically ill patients), Mini-Mental Status Exam (assesses cognitive function), APGAR Score (assesses the health of a newborn), Glasgow Coma Scale (assesses coma and impaired consciousness), and WE CARE (Well Child Care, Evaluation, Community Resources, Advocacy, Referral, Education - a clinic-based screening and referral system developed for pediatric settings).\n\nWhen an Assessment Scale Observation is contained in a Problem Observation, a Social History Observation or a Procedure instance that is Social Determinant of Health focused, that Assessment scale **MAY** contain assessment scale observations that represent question and answer pairs from SDOH screening instruments that are represented in LOINC. Note that guidance on the use of LOINC in assessment scales already exists in Assessment Scale Observation constraints and Assessment Scale Supporting Observations constraints.\n\nThe Observation value is used to record a calculated score using an integer. A LOINC answer concept is used when the assessment is non-calculated result.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AssessmentScaleSupportingObservation](StructureDefinition-AssessmentScaleSupportingObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
          },
          {
            "key" : "should-sdtcCategory",
            "severity" : "warning",
            "human" : "SHOULD contain sdtcCategory",
            "expression" : "sdtcCategory.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
          },
          {
            "key" : "category-survey",
            "severity" : "error",
            "human" : "If category is present, then there shall be a category with code 'survey'.",
            "expression" : "sdtcCategory.empty() or sdtcCategory.exists(code = 'survey' and codeSystem = '2.16.840.1.113883.4.642.1.1125')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:assessment-scale-obs",
        "path" : "Observation.templateId",
        "sliceName" : "assessment-scale-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:assessment-scale-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.69"
      },
      {
        "id" : "Observation.templateId:assessment-scale-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2022-06-01"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC) (CONF:4515-14434).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:4515-14435).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:4515-14438).",
        "min" : 1
      },
      {
        "id" : "Observation.sdtcCategory",
        "path" : "Observation.sdtcCategory",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "codeSystem"
            }
          ],
          "rules" : "open"
        },
        "short" : "Category is optional, but if present it SHALL contain a category with code=survey.",
        "condition" : ["should-sdtcCategory", "category-survey"]
      },
      {
        "id" : "Observation.sdtcCategory:survey",
        "path" : "Observation.sdtcCategory",
        "sliceName" : "survey",
        "short" : "Survey",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.sdtcCategory:survey.code",
        "path" : "Observation.sdtcCategory.code",
        "min" : 1,
        "patternCode" : "survey"
      },
      {
        "id" : "Observation.sdtcCategory:survey.codeSystem",
        "path" : "Observation.sdtcCategory.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.4.642.1.1125"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "For Social Determinant of Health Assessments",
        "comment" : "SHOULD contain zero or many [0..*] translations.",
        "constraint" : [
          {
            "key" : "should-translation",
            "severity" : "warning",
            "human" : "SHOULD contain translation",
            "expression" : "translation.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.13"
        }
      },
      {
        "id" : "Observation.code.translation",
        "path" : "Observation.code.translation",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.206"
        }
      },
      {
        "id" : "Observation.derivationExpr",
        "path" : "Observation.derivationExpr",
        "short" : "Such derivation expression can contain a text calculation of how the components total up to the summed score",
        "comment" : "MAY contain zero or one [0..1] derivationExpr (CONF:4515-14637)."
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:4515-14444).",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC) (CONF:4515-19088).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "short" : "Represents clinically effective time of the measurement, which may be when the measurement was performed (e.g., a BP measurement), or may be when sample was taken (and measured some time afterwards)",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime (CONF:4515-14445).",
        "min" : 1
      },
      {
        "id" : "Observation.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.value",
        "short" : "This is intended to hold the overall assessment score.  This could be calculated from the contained Assessment Scale Supporting Observations",
        "comment" : "SHALL contain exactly one [1..1] value (CONF:4515-14450).",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.interpretationCode",
        "path" : "Observation.interpretationCode",
        "comment" : "MAY contain zero or more [0..*] interpretationCode (CONF:4515-14459)."
      },
      {
        "id" : "Observation.interpretationCode.translation",
        "path" : "Observation.interpretationCode.translation",
        "comment" : "The interpretationCode, if present, MAY contain zero or more [0..*] translation (CONF:4515-14888)."
      },
      {
        "id" : "Observation.author",
        "path" : "Observation.author",
        "comment" : "MAY contain zero or more [0..*] author (CONF:4515-14460)."
      },
      {
        "id" : "Observation.entryRelationship",
        "path" : "Observation.entryRelationship",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "value",
              "path" : "typeCode"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHOULD contain zero or more [0..*] entryRelationship (CONF:4515-14451) such that it"
      },
      {
        "id" : "Observation.entryRelationship:supportingObs",
        "path" : "Observation.entryRelationship",
        "sliceName" : "supportingObs",
        "short" : "entryRelationship",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.entryRelationship:supportingObs.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "comment" : "SHALL contain exactly one [1..1] @typeCode=\"COMP\" has component (CONF:4515-16741).",
        "fixedCode" : "COMP"
      },
      {
        "id" : "Observation.entryRelationship:supportingObs.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Assessment Scale Supporting Observation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.86) (CONF:4515-16742).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleSupportingObservation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "short" : "The referenceRange/observationRange/text, if present, MAY contain a description of the scale (e.g., for a Pain Scale 1 to 10: 1 to 3 = little pain, 4 to 7 = moderate pain, 8 to 10 = severe pain)",
        "comment" : "MAY contain zero or more [0..*] referenceRange (CONF:4515-16799)."
      },
      {
        "id" : "Observation.referenceRange.observationRange",
        "path" : "Observation.referenceRange.observationRange",
        "comment" : "The referenceRange, if present, SHALL contain exactly one [1..1] observationRange (CONF:4515-16800).",
        "constraint" : [
          {
            "key" : "should-text",
            "severity" : "warning",
            "human" : "SHOULD contain text",
            "expression" : "text.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
          },
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
          }
        ]
      },
      {
        "id" : "Observation.referenceRange.observationRange.text",
        "path" : "Observation.referenceRange.observationRange.text",
        "short" : "The text may contain a description of the scale (e.g., for a Pain Scale 1 to 10:  1 to 3 = little pain, 4 to 7= moderate pain, 8 to 10 = severe pain)",
        "comment" : "This observationRange SHOULD contain zero or one [0..1] text (CONF:4515-16801).",
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.referenceRange.observationRange.text.reference",
        "path" : "Observation.referenceRange.observationRange.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AssessmentScaleObservation"
          }
        ]
      }
    ]
  }
}

```
