# Advance Directives Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Advance Directives Section**

## Logical Model: Advance Directives Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:AdvanceDirectivesSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.2.21.1:2022-02-14 | |

 
This section contains details about the patient’s advance healthcare directives, including references to supporting documents such as Living Wills, Healthcare Power of Attorney, Personal Advance Care Plans, DNR Orders, and Portable Medical Orders. Each type of advance directive document is represented by an individual Advance Directive Observation within a single Advance Directive Existence Observation. Each Advance Directive Observation specifies the type of advance directive and provides a unique reference for the document. Additionally, the Advance Directive Observation may include information about the document’s author and any individuals who verified the information with the patient or their healthcare agent. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required Entries**:[AdvanceDirectiveExistenceObservation](StructureDefinition-AdvanceDirectiveExistenceObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Care Plan](StructureDefinition-CarePlan.md), [Consultation Note](StructureDefinition-ConsultationNote.md), [Continuity of Care Document (CCD)](StructureDefinition-ContinuityofCareDocumentCCD.md), [Discharge Summary](StructureDefinition-DischargeSummary.md)...Show 6 more,[History and Physical](StructureDefinition-HistoryandPhysical.md),[Operative Note](StructureDefinition-OperativeNote.md),[Procedure Note](StructureDefinition-ProcedureNote.md),[Progress Note](StructureDefinition-ProgressNote.md),[Referral Note](StructureDefinition-ReferralNote.md)and[Transfer Summary](StructureDefinition-TransferSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/AdvanceDirectivesSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-AdvanceDirectivesSection.csv), [Excel](StructureDefinition-AdvanceDirectivesSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AdvanceDirectivesSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.2.21.1:2022-02-14"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "AdvanceDirectivesSection",
  "title" : "Advance Directives Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This section contains details about the patient’s advance healthcare directives, including references to supporting documents such as Living Wills, Healthcare Power of Attorney, Personal Advance Care Plans, DNR Orders, and Portable Medical Orders. Each type of advance directive document is represented by an individual Advance Directive Observation within a single Advance Directive Existence Observation. Each Advance Directive Observation specifies the type of advance directive and provides a unique reference for the document. Additionally, the Advance Directive Observation may include information about the document’s author and any individuals who verified the information with the patient or their healthcare agent.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required Entries**: [AdvanceDirectiveExistenceObservation](StructureDefinition-AdvanceDirectiveExistenceObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "shall-adv-directive-existence",
            "severity" : "error",
            "human" : "If section/@nullFlavor is not present, SHALL contain at least one Advance Directive Existence Observation",
            "expression" : "nullFlavor.exists() or entry.where(observation.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveExistenceObservation')).exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectivesSection"
          }
        ]
      },
      {
        "id" : "Section.nullFlavor",
        "path" : "Section.nullFlavor",
        "short" : "If a required section contains no information, the @nullFlavor MAY be set to NI"
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.2.21.1"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2022-02-14"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Advance directives",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "42348-3"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            },
            {
              "type" : "profile",
              "path" : "organizer"
            }
          ],
          "rules" : "open"
        },
        "comment" : "SHALL contain at least one [1..*] entry (CONF:1198-30235) such that it"
      },
      {
        "id" : "Section.entry:AdvDirExistanceObservation",
        "path" : "Section.entry",
        "sliceName" : "AdvDirExistanceObservation",
        "comment" : "MAY contain zero or more [0..*] entry such that it",
        "min" : 0,
        "max" : "*",
        "condition" : ["shall-adv-directive-existence"]
      },
      {
        "id" : "Section.entry:AdvDirExistanceObservation.observation",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "Section.entry.observation",
        "short" : "𝗨𝗦𝗖𝗗𝗜: Advance Directive Existence Observation",
        "comment" : "SHALL contain exactly one [1..1] Advance Directive Existence Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.513:2025-05-01).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveExistenceObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
