# Advance Directive Organizer - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Advance Directive Organizer**

## Logical Model: Advance Directive Organizer 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveOrganizer | *Version*:5.0.0-ballot |
| Retired as of 2025-12-12 | *Computable Name*:AdvanceDirectiveOrganizer |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.108:2022-02-14 | |

 
The Advance Directive Organizer includes information about who verified the content available in each advance healthcare directive source document or other verified source documentation. When documenting the existence of advance healthcare directive document(s), the organizer contains an observation which includes information about the kind of advance healthcare directive source document (e.g., Living Will, Personal Advance Care Plan, Portable Medical Order). This observation provides identifier references to the external source advance healthcare directive document. 
If a person has appointed healthcare agent(s), the organizer includes the current healthcare agent(s) information, and a reference to the external document which contains the healthcare agent appointment decisions. Additional observations summarizing the type of content included in the advance directive source documents also can be included. Treatment Intervention Preferences, Care Experience Preferences, Upon Death Preferencesand Personal Health Goals may be considered relevant by the organization rendering care services to the patient and included in the organizer as well although duplicating information is discouraged. 
When the existing advance healthcare directive document is a portable medical order, Advance Directive Observations are used to summarize the types of portable orders in the verified document. This provides new summary “structured data” for portable medical orders that often are still exchanged as scanned images. 
Provenance information such as author, performer, informant and participant can be used with the Organizer to minimize redundancy on each component Observation. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Required Components**:[AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md) 

**Usages:**

* This Logical Model Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/AdvanceDirectiveOrganizer)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-AdvanceDirectiveOrganizer.csv), [Excel](StructureDefinition-AdvanceDirectiveOrganizer.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AdvanceDirectiveOrganizer",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "organizer"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveOrganizer",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.108:2022-02-14"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "AdvanceDirectiveOrganizer",
  "title" : "Advance Directive Organizer (deprecated)",
  "status" : "retired",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "The Advance Directive Organizer includes information about who verified the content available in each advance healthcare directive source document or other verified source documentation. \nWhen documenting the existence of advance healthcare directive document(s), the organizer contains an observation which includes information about the kind of advance healthcare directive source document (e.g., Living Will, Personal Advance Care Plan, Portable Medical Order).  This observation provides identifier references to the external source advance healthcare directive document.\n\nIf a person has appointed healthcare agent(s), the organizer includes the current healthcare agent(s) information, and a reference to the external document which contains the healthcare agent appointment decisions. \nAdditional observations summarizing the type of content included in the advance directive source documents also can be included. Treatment Intervention Preferences, Care Experience Preferences, Upon Death Preferencesand Personal Health Goals may be considered relevant by the organization rendering care services to the patient and  included in the organizer as well although duplicating information is discouraged.\n\nWhen the existing advance healthcare directive document is a portable medical order, Advance Directive Observations are used to summarize the types of portable orders in the verified document. This provides new summary “structured data” for portable medical orders that often are still exchanged as scanned images.\n\nProvenance information such as author, performer, informant and participant can be used with the Organizer to minimize redundancy on each component Observation.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Required Components**: [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Organizer",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organizer",
        "path" : "Organizer",
        "constraint" : [
          {
            "key" : "should-sdtctext-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "sdtcText.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveOrganizer"
          },
          {
            "key" : "should-author",
            "severity" : "warning",
            "human" : "SHOULD contain author",
            "expression" : "author.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveOrganizer"
          },
          {
            "key" : "should-informant",
            "severity" : "warning",
            "human" : "SHOULD contain informant",
            "expression" : "informant.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveOrganizer"
          },
          {
            "key" : "should-participant",
            "severity" : "warning",
            "human" : "SHOULD contain participant",
            "expression" : "participant.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.templateId",
        "path" : "Organizer.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Organizer.templateId:advance-directive-org",
        "path" : "Organizer.templateId",
        "sliceName" : "advance-directive-org",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Organizer.templateId:advance-directive-org.root",
        "path" : "Organizer.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.108"
      },
      {
        "id" : "Organizer.templateId:advance-directive-org.extension",
        "path" : "Organizer.templateId.extension",
        "min" : 1,
        "patternString" : "2022-02-14"
      },
      {
        "id" : "Organizer.classCode",
        "path" : "Organizer.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"CLUSTER\" Cluster (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6) (CONF:1198-28410).",
        "fixedCode" : "CLUSTER"
      },
      {
        "id" : "Organizer.moodCode",
        "path" : "Organizer.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC) (CONF:1198-28411)."
      },
      {
        "id" : "Organizer.id",
        "path" : "Organizer.id",
        "comment" : "SHALL contain at least one [1..*] id (CONF:1198-28414).",
        "min" : 1
      },
      {
        "id" : "Organizer.code",
        "path" : "Organizer.code",
        "short" : "Advance directive/living will completed",
        "comment" : "This code SHALL contain exactly one [1..1] @code=\"45473-6\" Advance directive - living will  (CONF:1198-31230).",
        "min" : 1
      },
      {
        "id" : "Organizer.code.code",
        "path" : "Organizer.code.code",
        "min" : 1,
        "patternCode" : "45473-6"
      },
      {
        "id" : "Organizer.code.codeSystem",
        "path" : "Organizer.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Organizer.sdtcText",
        "path" : "Organizer.sdtcText",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "condition" : ["should-sdtctext-ref-value"]
      },
      {
        "id" : "Organizer.sdtcText.reference",
        "path" : "Organizer.sdtcText.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveOrganizer"
          }
        ]
      },
      {
        "id" : "Organizer.statusCode",
        "path" : "Organizer.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode (CONF:1198-28418)."
      },
      {
        "id" : "Organizer.statusCode.code",
        "path" : "Organizer.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14) (CONF:1198-31346).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Organizer.author",
        "path" : "Organizer.author",
        "short" : "SHOULD contain author",
        "comment" : "SHOULD contain zero or more [0..*] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119) (CONF:1198-32407).",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AuthorParticipation"
            ]
          }
        ],
        "condition" : ["should-author"]
      },
      {
        "id" : "Organizer.informant",
        "path" : "Organizer.informant",
        "short" : "SHOULD contain informant",
        "condition" : ["should-informant"]
      },
      {
        "id" : "Organizer.participant",
        "path" : "Organizer.participant",
        "short" : "SHOULD contain participant",
        "condition" : ["should-participant"]
      },
      {
        "id" : "Organizer.component",
        "path" : "Organizer.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "observation"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Organizer.component:advDirObs",
        "path" : "Organizer.component",
        "sliceName" : "advDirObs",
        "comment" : "SHALL contain at least one [1..*] component (CONF:1198-28420) such that it",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Organizer.component:advDirObs.observation",
        "path" : "Organizer.component.observation",
        "comment" : "SHALL contain exactly one [1..1] Advance Directive Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.48:2022-02-14) (CONF:1198-28421).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
