# Advance Directive Existence Observation - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Advance Directive Existence Observation**

## Logical Model: Advance Directive Existence Observation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveExistenceObservation | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:AdvanceDirectiveExistenceObservation |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.22.4.513:2025-05-01 | |

 
This observation represents a simple observation indicating whether a person has any advance directive documents. When documents are available, a system can nest the needed references to the advance directive documents inside this Advance Directive Existence Observation. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Optional EntryRelationships**:[AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.md) 

**Usages:**

* Use this Logical Model Profile: [Advance Directives Section](StructureDefinition-AdvanceDirectivesSection.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/AdvanceDirectiveExistenceObservation)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-AdvanceDirectiveExistenceObservation.csv), [Excel](StructureDefinition-AdvanceDirectiveExistenceObservation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AdvanceDirectiveExistenceObservation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveExistenceObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.22.4.513:2025-05-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "AdvanceDirectiveExistenceObservation",
  "title" : "Advance Directive Existence Observation",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This observation represents a simple observation indicating whether a person has any advance directive documents. When documents are available, a system can nest the needed references to the advance directive documents inside this Advance Directive Existence Observation.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Optional EntryRelationships**: [AdvanceDirectiveObservation](StructureDefinition-AdvanceDirectiveObservation.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "should-text-ref-value",
            "severity" : "warning",
            "human" : "SHOULD contain text/reference/@value",
            "expression" : "text.reference.value.exists()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveExistenceObservation"
          },
          {
            "key" : "no-obs-if-existence-false",
            "severity" : "error",
            "human" : "If Advance Directive Observation entries are be present, then the observation value must be 'Yes'.",
            "expression" : "(entryRelationship.observation.where(templateId.where(root='2.16.840.1.113883.10.20.22.4.48').count() > 0).count() > 0) implies (value.code = '373066001')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveExistenceObservation"
          }
        ]
      },
      {
        "id" : "Observation.templateId",
        "path" : "Observation.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.templateId:advance-directive-exist-obs",
        "path" : "Observation.templateId",
        "sliceName" : "advance-directive-exist-obs",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.templateId:advance-directive-exist-obs.root",
        "path" : "Observation.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.22.4.513"
      },
      {
        "id" : "Observation.templateId:advance-directive-exist-obs.extension",
        "path" : "Observation.templateId.extension",
        "min" : 1,
        "patternString" : "2025-05-01"
      },
      {
        "id" : "Observation.classCode",
        "path" : "Observation.classCode",
        "comment" : "SHALL contain exactly one [1..1] @classCode=\"OBS\" Observation (CodeSystem: HL7ActClass urn:oid:2.16.840.1.113883.5.6 STATIC).",
        "fixedCode" : "OBS"
      },
      {
        "id" : "Observation.moodCode",
        "path" : "Observation.moodCode",
        "comment" : "SHALL contain exactly one [1..1] @moodCode=\"EVN\" Event (CodeSystem: HL7ActMood urn:oid:2.16.840.1.113883.5.1001 STATIC).",
        "fixedCode" : "EVN"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "comment" : "SHALL contain at least one [1..*] id.",
        "min" : 1
      },
      {
        "id" : "Observation.sdtcCategory",
        "path" : "Observation.sdtcCategory",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.69.4"
        }
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Advance directive/living will completed"
      },
      {
        "id" : "Observation.code.code",
        "path" : "Observation.code.code",
        "min" : 1,
        "patternCode" : "45473-6"
      },
      {
        "id" : "Observation.code.codeSystem",
        "path" : "Observation.code.codeSystem",
        "short" : "LOINC",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Observation.text",
        "path" : "Observation.text",
        "short" : "SHOULD reference the portion of section narrative text corresponding to this entry",
        "min" : 1,
        "condition" : ["should-text-ref-value"]
      },
      {
        "id" : "Observation.text.reference",
        "path" : "Observation.text.reference",
        "constraint" : [
          {
            "key" : "value-starts-octothorpe",
            "severity" : "error",
            "human" : "If reference/@value is present, it SHALL begin with a '#' and SHALL point to its corresponding narrative",
            "expression" : "value.exists() implies value.startsWith('#')",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveExistenceObservation"
          }
        ]
      },
      {
        "id" : "Observation.statusCode",
        "path" : "Observation.statusCode",
        "comment" : "SHALL contain exactly one [1..1] statusCode.",
        "min" : 1
      },
      {
        "id" : "Observation.statusCode.code",
        "path" : "Observation.statusCode.code",
        "comment" : "This statusCode SHALL contain exactly one [1..1] @code=\"completed\" Completed (CodeSystem: HL7ActStatus urn:oid:2.16.840.1.113883.5.14 STATIC).",
        "min" : 1,
        "fixedCode" : "completed"
      },
      {
        "id" : "Observation.effectiveTime",
        "path" : "Observation.effectiveTime",
        "short" : "Note: This template represents a \"snapshot in time\" observation. As a result, the effectiveTime is constrained to just a time stamp.",
        "comment" : "SHALL contain exactly one [1..1] effectiveTime.",
        "min" : 1,
        "constraint" : [
          {
            "key" : "value-only",
            "severity" : "error",
            "human" : "Interval fields SHALL NOT be present",
            "expression" : "(low | high | width | center).empty()",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveExistenceObservation"
          }
        ]
      },
      {
        "id" : "Observation.effectiveTime.value",
        "path" : "Observation.effectiveTime.value",
        "short" : "value should be used instead of low/high"
      },
      {
        "id" : "Observation.value",
        "path" : "Observation.value",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/CD"
          }
        ],
        "condition" : ["no-obs-if-existence-false"],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1267.16"
        }
      },
      {
        "id" : "Observation.author",
        "path" : "Observation.author",
        "comment" : "SHALL contain exactly [1..1] Author Participation (identifier: urn:oid:2.16.840.1.113883.10.20.22.4.119).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Author",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/ProvenanceAuthorParticipation"
            ]
          }
        ]
      },
      {
        "id" : "Observation.informant",
        "path" : "Observation.informant",
        "short" : "MAY contain zero or one [0..1] informant",
        "max" : "1"
      },
      {
        "id" : "Observation.entryRelationship",
        "path" : "Observation.entryRelationship",
        "comment" : "MAY contain zero or more [0..*] entryRelationship.",
        "condition" : ["no-obs-if-existence-false"]
      },
      {
        "id" : "Observation.entryRelationship.typeCode",
        "path" : "Observation.entryRelationship.typeCode",
        "fixedCode" : "REFR"
      },
      {
        "id" : "Observation.entryRelationship.observation",
        "path" : "Observation.entryRelationship.observation",
        "comment" : "SHALL contain exactly one [1..1] Advance Directive Observation (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.48:2025-05-01).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Observation",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/AdvanceDirectiveObservation"
            ]
          }
        ]
      }
    ]
  }
}

```
