# Activities Section - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Activities Section**

## Logical Model: Activities Section 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda/StructureDefinition/ActivitiesSection | *Version*:5.0.0-ballot |
| Draft as of 2025-12-12 | *Computable Name*:ActivitiesSection |
| *Other Identifiers:*urn:ietf:rfc:3986#Uniform Resource Identifier (URI)#urn:hl7ii:2.16.840.1.113883.10.20.21.2.3:2015-08-01 | |

 
This template represents Activities. Activities are actions taken to maximize the prospects of the goals of care for the patient, including the removal of barriers to success. Activities can be planned, ordered, historical, etc. 
Activities include actions that may be ongoing (e.g., maintenance medications that the patient is taking, or monitoring the patient's health status or the status of an intervention). 
Instructions are nested within interventions and may include self-care instructions. Instructions are information or directions to the patient and other providers including how to care for the individual's condition, what to do at home, when to call for help, any additional appointments, testing, and changes to the medication list or medication instructions, clinical guidelines and a summary of best practice. 
Instructions are information or directions to the patient. Use the Instructions Section when instructions are included as part of a document that is not a Care Plan. Use the Activities Section, containing the Intervention Act containing the Instruction entry, when instructions are part of a structured care plan. 

#### Templates Used

 
Although open templates may contain any valid CDA content, the following templates are specifically called out by this template: 
**Recommended Entries**:[InterventionAct](StructureDefinition-InterventionAct.md),[PlannedInterventionAct](StructureDefinition-PlannedInterventionAct.md) 
**Optional Entries**:[HandoffCommunicationParticipants](StructureDefinition-HandoffCommunicationParticipants.md) 

**Usages:**

* Use this Logical Model Profile: [Care Plan](StructureDefinition-CarePlan.md) and [Progress Note](StructureDefinition-ProgressNote.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.cda.us.ccda|current/StructureDefinition/ActivitiesSection)

**Changes since version 4.0.0:**

* New Content

### Formal Views of Template Content

 [Description of Template, Differentials, Snapshots and how the different presentations work](http://hl7.org/fhir/R5/profiling.html#presentation). 

 

Other representations of profile: [CSV](StructureDefinition-ActivitiesSection.csv), [Excel](StructureDefinition-ActivitiesSection.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ActivitiesSection",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-target",
      "_valueBoolean" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "not-applicable"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace",
      "valueUri" : "urn:hl7-org:v3"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/xml-name",
      "valueString" : "section"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/logical-container",
      "valueUri" : "http://hl7.org/cda/stds/core/StructureDefinition/ClinicalDocument"
    },
    {
      "url" : "http://hl7.org/fhir/tools/StructureDefinition/type-profile-style",
      "valueCode" : "cda"
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda/StructureDefinition/ActivitiesSection",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:hl7ii:2.16.840.1.113883.10.20.21.2.3:2015-08-01"
    }
  ],
  "version" : "5.0.0-ballot",
  "name" : "ActivitiesSection",
  "title" : "Activities Section",
  "status" : "draft",
  "date" : "2025-12-12T18:56:41+00:00",
  "publisher" : "Health Level Seven",
  "contact" : [
    {
      "name" : "HL7 International - Structured Documents",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/structure"
        }
      ]
    }
  ],
  "description" : "This template represents Activities. Activities are actions taken to maximize the prospects of the goals of care for the patient, including the removal of barriers to success. Activities can be planned, ordered, historical, etc.\n\nActivities include actions that may be ongoing (e.g., maintenance medications that the patient is taking, or monitoring the patient's health status or the status of an intervention). \n\nInstructions are nested within interventions and may include self-care instructions. Instructions are information or directions to the patient and other providers including how to care for the individual's condition, what to do at home, when to call for help, any additional appointments, testing, and changes to the medication list or medication instructions, clinical guidelines and a summary of best practice.\n\nInstructions are information or directions to the patient. Use the Instructions Section when instructions are included as part of a document that is not a Care Plan. Use the Activities Section, containing the Intervention Act containing the Instruction entry, when instructions are part of a structured care plan.\n\n#### Templates Used\nAlthough open templates may contain any valid CDA content, the following templates are specifically called out by this template:\n\n**Recommended Entries**: [InterventionAct](StructureDefinition-InterventionAct.html), [PlannedInterventionAct](StructureDefinition-PlannedInterventionAct.html)\n\n**Optional Entries**: [HandoffCommunicationParticipants](StructureDefinition-HandoffCommunicationParticipants.html)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "baseDefinition" : "http://hl7.org/cda/stds/core/StructureDefinition/Section",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Section",
        "path" : "Section",
        "constraint" : [
          {
            "key" : "should-intervention-act",
            "severity" : "warning",
            "human" : "SHOULD contain Intervention Act",
            "expression" : "entry.where(act.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ActivitiesSection"
          },
          {
            "key" : "should-planned-intervention-act",
            "severity" : "warning",
            "human" : "SHOULD contain Planned Intervention Act",
            "expression" : "entry.where(act.hasTemplateIdOf('http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct'))",
            "source" : "http://hl7.org/cda/us/ccda/StructureDefinition/ActivitiesSection"
          }
        ]
      },
      {
        "id" : "Section.templateId",
        "path" : "Section.templateId",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "root"
            },
            {
              "type" : "value",
              "path" : "extension"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Section.templateId:section",
        "path" : "Section.templateId",
        "sliceName" : "section",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Section.templateId:section.root",
        "path" : "Section.templateId.root",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.10.20.21.2.3"
      },
      {
        "id" : "Section.templateId:section.extension",
        "path" : "Section.templateId.extension",
        "min" : 1,
        "patternString" : "2015-08-01"
      },
      {
        "id" : "Section.code",
        "path" : "Section.code",
        "short" : "Interventions Narrative",
        "min" : 1
      },
      {
        "id" : "Section.code.code",
        "path" : "Section.code.code",
        "min" : 1,
        "patternCode" : "62387-6"
      },
      {
        "id" : "Section.code.codeSystem",
        "path" : "Section.code.codeSystem",
        "min" : 1,
        "patternString" : "2.16.840.1.113883.6.1"
      },
      {
        "id" : "Section.title",
        "path" : "Section.title",
        "min" : 1
      },
      {
        "id" : "Section.text",
        "path" : "Section.text",
        "min" : 1
      },
      {
        "id" : "Section.entry",
        "path" : "Section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "act"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Section.entry:intervention",
        "path" : "Section.entry",
        "sliceName" : "intervention",
        "comment" : "SHOULD contain zero or more [0..*] entry (CONF:1198-30996) such that it",
        "min" : 0,
        "max" : "*",
        "condition" : ["should-intervention-act"]
      },
      {
        "id" : "Section.entry:intervention.act",
        "path" : "Section.entry.act",
        "comment" : "The entry, if present, SHALL contain exactly one [1..1] Intervention Act (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.131:2015-08-01) (CONF:1198-30997).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/InterventionAct"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:plannedIntervention",
        "path" : "Section.entry",
        "sliceName" : "plannedIntervention",
        "comment" : "SHOULD contain zero or more [0..*] entry (CONF:1198-32730) such that it",
        "min" : 0,
        "max" : "*",
        "condition" : ["should-planned-intervention-act"]
      },
      {
        "id" : "Section.entry:plannedIntervention.act",
        "path" : "Section.entry.act",
        "comment" : "The entry, if present, SHALL contain exactly one [1..1] Planned Intervention Act (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.146:2015-08-01) (CONF:1198-32731).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/PlannedInterventionAct"
            ]
          }
        ]
      },
      {
        "id" : "Section.entry:handoffCommParticipants",
        "path" : "Section.entry",
        "sliceName" : "handoffCommParticipants",
        "comment" : "MAY contain zero or more [0..*] entry (CONF:1198-32402) such that it",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Section.entry:handoffCommParticipants.act",
        "path" : "Section.entry.act",
        "comment" : "The entry, if present, SHALL contain exactly one [1..1] Intervention Act (identifier: urn:hl7ii:2.16.840.1.113883.10.20.22.4.141) (CONF:1198-32403).",
        "min" : 1,
        "type" : [
          {
            "code" : "http://hl7.org/cda/stds/core/StructureDefinition/Act",
            "profile" : [
              "http://hl7.org/cda/us/ccda/StructureDefinition/HandoffCommunicationParticipants"
            ]
          }
        ]
      }
    ]
  }
}

```
