# Procedure Note Complete Header Example - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Procedure Note Complete Header Example**

## Example Binary: Procedure Note Complete Header Example

This content is an example of the [Procedure Note](StructureDefinition-ProcedureNote.md) Logical Model and is not a FHIR Resource

```

<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<?xml-stylesheet type="text/xsl" href="CDA.xsl"?>
<!--
 Title:        Procedure Note
 Based on:     C-CDA_R2_Procedure_Note.xml
 
 Updated for C-CDA R3.0 with a focus on header elements
  - required/suggested sections are populated with nullFlavor="NI"
	  to demonstrate WHICH sections should be included, but they
		all contain "No information" as this is an example of the header
  
 ********************************************************
 Disclaimer: This sample file contains representative data elements to represent a Procedure Note. 
 The file depicts a fictional character's health data. Any resemblance to a real person is coincidental. 
 To illustrate as many data elements as possible, the clinical scenario may not be plausible. 
 The data in this sample file is not intended to represent real patients, people or clinical events. 
 This sample is designed to be used in conjunction with the C-CDA Clinical Notes Implementation Guide.
 ********************************************************
 -->
<ClinicalDocument xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="urn:hl7-org:v3" xmlns:cda="urn:hl7-org:v3" xmlns:sdtc="urn:hl7-org:sdtc">
	<!-- ** CDA Header ** -->
	<realmCode code="US"/>
	<typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
	<!-- US Realm Header Template -->
	<templateId root="2.16.840.1.113883.10.20.22.1.1" extension="2024-05-01"/>
	<!-- Procedure Note Template -->
	<templateId root="2.16.840.1.113883.10.20.22.1.6" extension="2024-05-01"/>
	<id extension="TT988" root="2.16.840.1.113883.19.5.99999.1"/>
	<sdtc:category code="28570-0" displayName="Procedure note" codeSystem="2.16.840.1.113883.6.1"/>
	<code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="28570-0" displayName="Procedure Note"/>
	<title>Community Health and Hospitals: Procedure Note</title>
	<effectiveTime value="201209161911-0400"/>
	<confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>
	<languageCode code="en-US"/>
	<setId extension="sTT988" root="2.16.840.1.113883.19.5.99999.19"/>
	<versionNumber value="1"/>
	<recordTarget>
		<patientRole>
			<!-- Fake ID using HL7 example OID. -->
			<id extension="998991" root="2.16.840.1.113883.19.5.99999.2"/>
			<!-- Fake Social Security Number using the actual SSN OID. -->
			<id extension="111-00-2330" root="2.16.840.1.113883.4.1"/>
			<!-- HP is "primary home" from codeSystem 2.16.840.1.113883.5.1119 -->
			<addr use="HP">
				<streetAddressLine>1357 Amber Drive</streetAddressLine>
				<city>Beaverton</city>
				<state>OR</state>
				<postalCode>97867</postalCode>
				<!-- US is "United States" from ISO 3166-1 Country Codes: 1.0.3166.1 -->
				<country>US</country>
			</addr>
			<!-- HP is "primary home" from HL7 AddressUse 2.16.840.1.113883.5.1119 -->
			<telecom value="tel:(816)276-6909" use="HP"/>
			<patient>
				<!-- L is "Legal" from HL7 EntityNameUse 2.16.840.1.113883.5.45 -->
				<name use="L">
					<given>Isabella</given>
					<family>Jones</family>
				</name>
				<administrativeGenderCode code="F" codeSystem="2.16.840.1.113883.5.1" displayName="Female"/>
				<birthTime value="20050501"/>
				<maritalStatusCode code="M" displayName="Married" codeSystem="2.16.840.1.113883.5.2" codeSystemName="MaritalStatusCode"/>
				<religiousAffiliationCode code="1013" displayName="Christian (non-Catholic, non-specific)" codeSystemName="HL7 Religious Affiliation" codeSystem="2.16.840.1.113883.5.1076"/>
				<raceCode code="1002-5" displayName="American Indian or Alaska Native" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<sdtc:raceCode code="1966-1" displayName="Aleut" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<ethnicGroupCode code="2186-5" displayName="Not Hispanic or Latino" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<guardian>
					<code code="GRPRN" displayName="Grandparent" codeSystem="2.16.840.1.113883.5.111" codeSystemName="HL7 Role code"/>
					<!-- HP is "primary home" from codeSystem 2.16.840.1.113883.5.1119 -->
					<addr use="HP">
						<streetAddressLine>1357 Amber Drive</streetAddressLine>
						<city>Beaverton</city>
						<state>OR</state>
						<postalCode>97867</postalCode>
						<!-- US is "United States" from ISO 3166-1 Country Codes: 1.0.3166.1 -->
						<country>US</country>
					</addr>
					<telecom value="tel:(816)276-6909" use="HP"/>
					<guardianPerson>
						<name>
							<given>Ralph</given>
							<family>Jones</family>
						</name>
					</guardianPerson>
				</guardian>
				<birthplace>
					<place>
						<addr>
							<city>Beaverton</city>
							<state>OR</state>
							<postalCode>97867</postalCode>
							<country>US</country>
						</addr>
					</place>
				</birthplace>
				<languageCommunication>
					<languageCode code="en"/>
					<modeCode code="ESP" displayName="Expressed spoken" codeSystem="2.16.840.1.113883.5.60" codeSystemName="LanguageAbilityMode"/>
					<proficiencyLevelCode code="G" displayName="Good" codeSystem="2.16.840.1.113883.5.61" codeSystemName="LanguageAbilityProficiency"/>
					<preferenceInd value="true"/>
				</languageCommunication>
			</patient>
			<providerOrganization>
				<!-- Organizations SHOULD have an NPI; this is a real root; fake extension-->
				<id root="2.16.840.1.113883.4.6" extension="111122223333"/>
				<name>Community Health and Hospitals</name>
				<telecom use="WP" value="tel:555-555-5000"/>
				<addr use="WP">
					<streetAddressLine>1001 Village Avenue</streetAddressLine>
					<city>Portland</city>
					<state>OR</state>
					<postalCode>99123</postalCode>
					<country>US</country>
				</addr>
			</providerOrganization>
		</patientRole>
	</recordTarget>
	<author>
		<time value="20050329224411+0500"/>
		<assignedAuthor>
			<id extension="99999999" root="2.16.840.1.113883.4.6"/>
			<code code="207R00000X" codeSystem="2.16.840.1.113883.6.101" displayName="Allopathic &amp; Osteopathic Physicians; Internal Medicine"/>
			<addr use="WP">
				<streetAddressLine>1002 Healthcare Drive </streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:555-555-1002"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedAuthor>
	</author>
	<dataEnterer>
		<assignedEntity>
			<id root="2.16.840.1.113883.4.6" extension="999999943252"/>
			<addr use="WP">
				<streetAddressLine>1001 Village Avenue</streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:555-555-1002"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</dataEnterer>
	<informant>
		<assignedEntity>
			<id extension="KP00017" root="2.16.840.1.113883.19.5"/>
			<addr use="WP">
				<streetAddressLine>1001 Village Avenue</streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:555-555-1002"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</informant>
	<informant>
		<!-- classCode PRS represents a person with personal relationship with the patient. -->
		<relatedEntity classCode="PRS">
			<code code="SPS" displayName="SPOUSE" codeSystem="2.16.840.1.113883.1.11.19563" codeSystemName="Personal Relationship Role Type Value Set"/>
			<relatedPerson>
				<name>
					<given>Frank</given>
					<family>Jones</family>
				</name>
			</relatedPerson>
		</relatedEntity>
	</informant>
	<custodian>
		<assignedCustodian>
			<representedCustodianOrganization>
				<id extension="99999999" root="2.16.840.1.113883.4.6"/>
				<name>Community Health and Hospitals</name>
				<telecom value="tel:555-555-1002" use="WP"/>
				<addr use="WP">
					<streetAddressLine>1002 Healthcare Drive </streetAddressLine>
					<city>Portland</city>
					<state>OR</state>
					<postalCode>99123</postalCode>
					<country>US</country>
				</addr>
			</representedCustodianOrganization>
		</assignedCustodian>
	</custodian>
	<informationRecipient>
		<intendedRecipient>
			<informationRecipient>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</informationRecipient>
			<receivedOrganization>
				<name>Community Health and Hospitals</name>
			</receivedOrganization>
		</intendedRecipient>
	</informationRecipient>
	<legalAuthenticator>
		<time value="20090227130000+0500"/>
		<signatureCode code="S"/>
		<assignedEntity>
			<id extension="999999999" root="2.16.840.1.113883.4.6"/>
			<addr use="WP">
				<streetAddressLine>1001 Village Avenue</streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:555-555-1002"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</legalAuthenticator>
	<authenticator>
		<time value="20090227130000+0500"/>
		<signatureCode code="S"/>
		<assignedEntity>
			<id extension="999999999" root="2.16.840.1.113883.4.6"/>
			<addr use="WP">
				<streetAddressLine>1001 Village Avenue</streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:555-555-1002"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</authenticator>
	<participant typeCode="IND">
		<functionCode code="PCP" codeSystem="2.16.840.1.113883.5.88" codeSystemName="participationFunction" displayName="Primary Care Physician"/>
		<associatedEntity classCode="PROV">
			<associatedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</associatedPerson>
		</associatedEntity>
	</participant>
	<documentationOf typeCode="DOC">
		<serviceEvent classCode="PCPR">
			<code code="73761001" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT" displayName="Colonoscopy"/>
			<effectiveTime>
				<low value="201209091911-0400"/>
				<high value="201209161911-0400"/>
			</effectiveTime>
			<performer typeCode="SPRF">
				<functionCode code="PCP" codeSystem="2.16.840.1.113883.5.88" codeSystemName="ParticipationFunction" displayName="Primary Care Provider">
					<originalText>Primary Care Provider</originalText>
				</functionCode>
				<time>
					<low value="201209091911-0400"/>
					<high value="201209161911-0400"/>
				</time>
				<assignedEntity>
					<id extension="PseudoMD-1" root="2.16.840.1.113883.4.6"/>
					<code code="207R00000X" codeSystem="2.16.840.1.113883.6.101" displayName="Internal Medicine Physician"/>
					<addr use="WP">
						<streetAddressLine>1001 Village Avenue</streetAddressLine>
						<city>Portland</city>
						<state>OR</state>
						<postalCode>99123</postalCode>
						<country>US</country>
					</addr>
					<telecom value="tel:+1-555-555-5000" use="WP"/>
					<assignedPerson>
						<name>
							<prefix>Dr.</prefix>
							<given>Henry</given>
							<family>Seven</family>
						</name>
					</assignedPerson>
					<representedOrganization>
						<id root="2.16.840.1.113883.19.5.9999.1393"/>
						<name>Community Health and Hospitals</name>
						<telecom value="tel:+1-555-555-5000" use="WP"/>
						<addr use="WP">
							<streetAddressLine>1001 Village Avenue</streetAddressLine>
							<city>Portland</city>
							<state>OR</state>
							<postalCode>99123</postalCode>
							<country>US</country>
						</addr>
					</representedOrganization>
				</assignedEntity>
			</performer>
			<performer typeCode="PPRF">
				<functionCode code="PCP" codeSystem="2.16.840.1.113883.5.88" codeSystemName="ParticipationFunction" displayName="Primary Care Provider">
					<originalText>Primary Care Provider</originalText>
				</functionCode>
				<time>
					<low value="201209091911-0400"/>
					<high value="201209161911-0400"/>
				</time>
				<assignedEntity>
					<id extension="PseudoMD-3" root="2.16.840.1.113883.4.6"/>
					<code code="207RG0100X" displayName="Gastroenterology Physician" codeSystemName="Provider Codes" codeSystem="2.16.840.1.113883.6.101"/>
					<addr use="WP">
						<streetAddressLine>1001 Village Avenue</streetAddressLine>
						<city>Portland</city>
						<state>OR</state>
						<postalCode>99123</postalCode>
						<country>US</country>
					</addr>
					<telecom value="tel:+1-555-555-5000" use="HP"/>
					<assignedPerson>
						<name>
							<prefix>Dr.</prefix>
							<given>Henry</given>
							<family>Seven</family>
						</name>
					</assignedPerson>
					<representedOrganization>
						<id root="2.16.840.1.113883.19.5.9999.1393"/>
						<name>Community Health and Hospitals</name>
						<telecom value="tel:+1-555-555-5000" use="HP"/>
						<addr use="WP">
							<streetAddressLine>1001 Village Avenue</streetAddressLine>
							<city>Portland</city>
							<state>OR</state>
							<postalCode>99123</postalCode>
							<country>US</country>
						</addr>
					</representedOrganization>
				</assignedEntity>
			</performer>
		</serviceEvent>
	</documentationOf>
	<authorization>
		<consent classCode="CONS" moodCode="EVN">
			<id root="629deb70-5306-11df-9879-0800200c9a66"/>
			<code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="64293-4" displayName="Procedure consent"/>
			<statusCode code="completed"/>
		</consent>
	</authorization>
	<componentOf>
		<encompassingEncounter>
			<id extension="9937012" root="2.16.840.1.113883.19"/>
			<code codeSystem="2.16.840.1.113883.6.12" codeSystemName="CPT-4" code="99213"/>
			<effectiveTime>
				<low value="20090227130000+0500"/>
				<high value="20090227130000+0500"/>
			</effectiveTime>
			<location>
				<healthCareFacility>
					<id root="2.16.540.1.113883.19.2"/>
				</healthCareFacility>
			</location>
		</encompassingEncounter>
	</componentOf>
	<component>
    <!-- All sections are set to nullFlavor / text = No information, 
        as this is a header example, not a complete body example -->
		<structuredBody>
			<!-- Complications -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.37" extension="2015-08-01" />
					<code code="55109-3" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Complications" />
					<title>Complications</title>
					<text>No information</text>
				</section>
			</component>
			<!-- Proc Description -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.27"/>
					<code code="29554-3" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="PROCEDURE DESCRIPTION"/>
					<title>Procedure Description</title>
					<text>No information</text>
				</section>
			</component>
			<!-- Proc Indications -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.29" extension="2014-06-09" />
					<code code="59768-2" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="PROCEDURE INDICATIONS" />
					<title>Procedure Indications</title>
					<text>No information</text>
				</section>
			</component>
			<!-- Post-proc DX -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.36" extension="2015-08-01" />
					<code code="59769-0" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="POSTPROCEDURE DIAGNOSIS" />
					<title>Postprocedure Diagnosis</title>
					<text>No information</text>
				</section>
			</component>
			<!-- Assessment & Plan (or Assessment Section + Plan Section -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.9" extension="2014-06-09" />
					<code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="51847-2" displayName="Evaluation + Plan note" />
					<title>ASSESSMENT AND PLAN</title>
					<text>No information</text>
				</section>
			</component>
		</structuredBody>
	</component>
</ClinicalDocument>

```

