# Operative Note Complete Header Example - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Operative Note Complete Header Example**

## Example Binary: Operative Note Complete Header Example

This content is an example of the [Operative Note](StructureDefinition-OperativeNote.md) Logical Model and is not a FHIR Resource

```

<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<?xml-stylesheet type="text/xsl" href="CDA.xsl"?>
<!--
 Title:        Operative Note
 Based on:     C-CDA_R2_Operative_Note.xml
 
 Updated for C-CDA R3.0 with a focus on header elements
  - required/suggested sections are populated with nullFlavor="NI"
	  to demonstrate WHICH sections should be included, but they
		all contain "No information" as this is an example of the header
  
 ********************************************************
 Disclaimer: This sample file contains representative data elements to represent a Operative Note. 
 The file depicts a fictional character's health data. Any resemblance to a real person is coincidental. 
 To illustrate as many data elements as possible, the clinical scenario may not be plausible. 
 The data in this sample file is not intended to represent real patients, people or clinical events. 
 This sample is designed to be used in conjunction with the C-CDA Clinical Notes Implementation Guide.
 ********************************************************
 -->
<ClinicalDocument xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="urn:hl7-org:v3" xmlns:cda="urn:hl7-org:v3" xmlns:sdtc="urn:hl7-org:sdtc">
	<!-- ** CDA Header ** -->
	<realmCode code="US"/>
	<typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
	<!-- US General Header Template -->
	<templateId root="2.16.840.1.113883.10.20.22.1.1" extension="2024-05-01"/>
	<!-- Operative Note Template -->
	<templateId root="2.16.840.1.113883.10.20.22.1.7" extension="2024-05-01"/>
	<id extension="TT988" root="2.16.840.1.113883.19.5.99999.1"/>
	<sdtc:category code="11504-8" displayName="Surgical operation note" codeSystem="2.16.840.1.113883.6.1"/>
	<code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="11504-8" displayName="Surgical Operation Note"/>
	<title>Community Health and Hospitals: Operative Note</title>
	<effectiveTime value="201209161910-0400"/>
	<confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>
	<languageCode code="en-US"/>
	<setId extension="sTT988" root="2.16.840.1.113883.19.5.99999.19"/>
	<versionNumber value="1"/>
	<recordTarget>
		<patientRole>
			<id extension="998991" root="2.16.840.1.113883.19.5.99999.2"/>
			<!-- Fake ID using HL7 example OID. -->
			<id extension="111-00-2330" root="2.16.840.1.113883.4.1"/>
			<!-- Fake Social Security Number using the actual SSN OID. -->
			<addr use="HP">
				<!-- HP is "primary home" from codeSystem 2.16.840.1.113883.5.1119 -->
				<streetAddressLine>1357 Amber Drive</streetAddressLine>
				<city>Beaverton</city>
				<state>OR</state>
				<postalCode>97867</postalCode>
				<country>US</country>
				<!-- US is "United States" from ISO 3166-1 Country Codes: 1.0.3166.1 -->
			</addr>
			<telecom value="tel:(816)276-6909" use="HP"/>
			<!-- HP is "primary home" from HL7 AddressUse 2.16.840.1.113883.5.1119 -->
			<patient>
				<name use="L">
					<!-- L is "Legal" from HL7 EntityNameUse 2.16.840.1.113883.5.45 -->
					<given>Isabella</given>
					<given>Isa</given>
					<!-- CL is "Call me" from HL7 EntityNamePartQualifier 2.16.840.1.113883.5.43 -->
					<family>Jones</family>
				</name>
				<administrativeGenderCode code="F" codeSystem="2.16.840.1.113883.5.1" displayName="Female"/>
				<birthTime value="20050501"/>
				<maritalStatusCode code="M" displayName="Married" codeSystem="2.16.840.1.113883.5.2" codeSystemName="MaritalStatusCode"/>
				<religiousAffiliationCode code="1013" displayName="Christian (non-Catholic, non-specific)" codeSystemName="HL7 Religious Affiliation" codeSystem="2.16.840.1.113883.5.1076"/>
				<raceCode code="1002-5" displayName="American Indian or Alaska Native" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<sdtc:raceCode code="1966-1" displayName="Aleut" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<ethnicGroupCode code="2186-5" displayName="Not Hispanic or Latino" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<guardian>
					<code code="GRPRN" displayName="Grandparent" codeSystem="2.16.840.1.113883.5.111" codeSystemName="HL7 Role code"/>
					<addr use="HP">
						<!-- HP is "primary home" from codeSystem 2.16.840.1.113883.5.1119 -->
						<streetAddressLine>1357 Amber Drive</streetAddressLine>
						<city>Beaverton</city>
						<state>OR</state>
						<postalCode>97867</postalCode>
						<country>US</country>
						<!-- US is "United States" from ISO 3166-1 Country Codes: 1.0.3166.1 -->
					</addr>
					<telecom value="tel:(816)276-6909" use="HP"/>
					<guardianPerson>
						<name>
							<given>Ralph</given>
							<family>Jones</family>
						</name>
					</guardianPerson>
				</guardian>
				<birthplace>
					<place>
						<addr>
							<city>Beaverton</city>
							<state>OR</state>
							<postalCode>97867</postalCode>
							<country>US</country>
						</addr>
					</place>
				</birthplace>
				<languageCommunication>
					<languageCode code="en"/>
					<modeCode code="ESP" displayName="Expressed spoken" codeSystem="2.16.840.1.113883.5.60" codeSystemName="LanguageAbilityMode"/>
					<proficiencyLevelCode code="G" displayName="Good" codeSystem="2.16.840.1.113883.5.61" codeSystemName="LanguageAbilityProficiency"/>
					<preferenceInd value="true"/>
				</languageCommunication>
			</patient>
			<providerOrganization>
				<id extension="444444444" root="2.16.840.1.113883.4.6"/>
				<name>Community Health and Hospitals</name>
				<telecom use="WP" value="tel:555-555-5000"/>
				<addr use="WP">
					<streetAddressLine>1001 Village Avenue</streetAddressLine>
					<city>Portland</city>
					<state>OR</state>
					<postalCode>99123</postalCode>
					<country>US</country>
				</addr>
			</providerOrganization>
		</patientRole>
	</recordTarget>
	<author>
		<time value="20050329224411+0500"/>
		<assignedAuthor>
			<id extension="99999999" root="2.16.840.1.113883.4.6"/>
			<code code="200000000X" codeSystem="2.16.840.1.113883.6.101" displayName="Allopathic &amp; Osteopathic Physicians"/>
			<addr use="WP">
				<streetAddressLine>1002 Healthcare Drive </streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:555-555-1002"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedAuthor>
	</author>
	<dataEnterer>
		<assignedEntity>
			<id root="2.16.840.1.113883.4.6" extension="999999943252"/>
			<addr use="WP">
				<streetAddressLine>1001 Village Avenue</streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:555-555-1002"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</dataEnterer>
	<informant>
		<assignedEntity>
			<id extension="KP00017" root="2.16.840.1.113883.19.5"/>
			<addr use="WP">
				<streetAddressLine>1001 Village Avenue</streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:555-555-1002"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</informant>
	<informant>
		<relatedEntity classCode="PRS">
			<!-- classCode PRS represents a person with personal relationship with the patient. -->
			<code code="SPS" displayName="SPOUSE" codeSystem="2.16.840.1.113883.1.11.19563" codeSystemName="Personal Relationship Role Type Value Set"/>
			<relatedPerson>
				<name>
					<given>Frank</given>
					<family>Jones</family>
				</name>
			</relatedPerson>
		</relatedEntity>
	</informant>
	<custodian>
		<assignedCustodian>
			<representedCustodianOrganization>
				<id extension="99999999" root="2.16.840.1.113883.4.6"/>
				<name>Community Health and Hospitals</name>
				<telecom value="tel:555-555-1002" use="WP"/>
				<addr use="WP">
					<streetAddressLine>1002 Healthcare Drive </streetAddressLine>
					<city>Portland</city>
					<state>OR</state>
					<postalCode>99123</postalCode>
					<country>US</country>
				</addr>
			</representedCustodianOrganization>
		</assignedCustodian>
	</custodian>
	<informationRecipient>
		<intendedRecipient>
			<informationRecipient>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</informationRecipient>
			<receivedOrganization>
				<name>Community Health and Hospitals</name>
			</receivedOrganization>
		</intendedRecipient>
	</informationRecipient>
	<legalAuthenticator>
		<time value="20090227130000+0500"/>
		<signatureCode code="S"/>
		<assignedEntity>
			<id extension="999999999" root="2.16.840.1.113883.4.6"/>
			<addr use="WP">
				<streetAddressLine>1001 Village Avenue</streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:555-555-1002"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</legalAuthenticator>
	<authenticator>
		<time value="20090227130000+0500"/>
		<signatureCode code="S"/>
		<assignedEntity>
			<id extension="999999999" root="2.16.840.1.113883.4.6"/>
			<addr use="WP">
				<streetAddressLine>1001 Village Avenue</streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:555-555-1002"/>
			<assignedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</authenticator>
	<documentationOf typeCode="DOC">
		<serviceEvent classCode="PCPR">
			<code code="73761001" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT" displayName="Colonoscopy"/>
			<effectiveTime>
				<low value="201209091910-0400"/>
				<high value="201209161910-0400"/>
			</effectiveTime>
			<performer typeCode="PPRF">
				<functionCode code="PCP" codeSystem="2.16.840.1.113883.5.88" codeSystemName="ParticipationFunction" displayName="Primary Care Physician">
					<originalText>Primary Care Provider</originalText>
				</functionCode>
				<time>
					<low value="201209091910-0400"/>
					<high value="201209161910-0400"/>
				</time>
				<assignedEntity>
					<id extension="PseudoMD-3" root="2.16.840.1.113883.4.6"/>
					<code code="207RG0100X" displayName="Gastroenterology Physician" codeSystemName="Provider Codes" codeSystem="2.16.840.1.113883.6.101"/>
					<addr use="WP">
						<streetAddressLine>1001 Village Avenue</streetAddressLine>
						<city>Portland</city>
						<state>OR</state>
						<postalCode>99123</postalCode>
						<country>US</country>
					</addr>
					<telecom value="tel:+1-555-555-5000" use="HP"/>
					<assignedPerson>
						<name>
							<prefix>Dr.</prefix>
							<given>Henry</given>
							<family>Seven</family>
						</name>
					</assignedPerson>
					<representedOrganization>
						<id root="2.16.840.1.113883.19.5.9999.1393"/>
						<name>Community Health and Hospitals</name>
						<telecom value="tel:+1-555-555-5000" use="HP"/>
						<addr use="WP">
							<streetAddressLine>1001 Village Avenue</streetAddressLine>
							<city>Portland</city>
							<state>OR</state>
							<postalCode>99123</postalCode>
							<country>US</country>
						</addr>
					</representedOrganization>
				</assignedEntity>
			</performer>
		</serviceEvent>
	</documentationOf>
	<authorization typeCode="AUTH">
		<consent classCode="CONS" moodCode="EVN">
			<id root="629deb70-5306-11df-9879-0800200c9a66"/>
			<code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="64293-4" displayName="Procedure consent"/>
			<statusCode code="completed"/>
		</consent>
	</authorization>
	<component>
    <!-- All sections are set to nullFlavor / text = No information, 
        as this is a header example, not a complete body example -->
		<structuredBody>
			<!-- Anesthesia -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.25" extension="2014-06-09" />
					<code code="59774-0" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Anesthesia" />
					<title>Procedure Anesthesia</title>
					<text>No information</text>
				</section>
			</component>
			<!-- Complications -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.37" extension="2015-08-01" />
					<code code="55109-3" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Complications" />
					<title>Complications</title>
					<text>No information</text>
				</section>
			</component>		
			<!-- Preop Dx -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.34" extension="2015-08-01" />
					<code code="10219-4" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="PREOPERATIVE DIAGNOSIS" />
					<title>Preoperative Diagnosis</title>
					<text>No information</text>
				</section>
			</component>
			<!-- ProcEstBloodLoss -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.18.2.9"/>
					<code code="59770-8" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="PROCEDURE ESTIMATED BLOOD LOSS"/>
					<title>Procedure Estimated Blood Loss</title>
					<text>No information</text>
				</section>
			</component>
			<!-- ProcFindings -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.28" extension="2015-08-01" />
					<code code="59776-5" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="PROCEDURE FINDINGS" />
					<title>Procedure Findings</title>
					<text>No information</text>
				</section>
			</component>
			<!-- ProcSpecimensTaken -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.31"/>
					<code code="59773-2" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="PROCEDURE SPECIMENS TAKEN"/>
					<title>Procedure Specimens Taken</title>
					<text>No information</text>
				</section>
			</component>
			<!-- Proc Description -->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.27"/>
					<code code="29554-3" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="PROCEDURE DESCRIPTION"/>
					<title>Procedure Description</title>
					<text>No information</text>
				</section>
			</component>
			<!-- Postop Dx-->
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.35"/>
					<code code="10218-6" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="POSTOPERATIVE DIAGNOSIS"/>
					<title>Postoperative Diagnosis</title>
					<text>No information</text>
				</section>
			</component>
		</structuredBody>
	</component>
</ClinicalDocument>

```

