# Consultation Note Complete Header Example - Consolidated CDA (C-CDA) v5.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consultation Note Complete Header Example**

## Example Binary: Consultation Note Complete Header Example

This content is an example of the [Consultation Note](StructureDefinition-ConsultationNote.md) Logical Model and is not a FHIR Resource

```

<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<?xml-stylesheet type="text/xsl" href="CDA.xsl"?>
<!--
 Title:        Consultation Note

 Based on:     C-CDA_R2_Consultation_Note.xml
 Created by:   Lantana Consulting Group, LLC
 
 Updated for C-CDA R3.0 with a focus on header elements
  
 ********************************************************
 Disclaimer: This sample file contains representative data elements to represent a Consultation Note. 
 The file depicts a fictional character's health data. Any resemblance to a real person is coincidental. 
 To illustrate as many data elements as possible, the clinical scenario may not be plausible. 
 The data in this sample file is not intended to represent real patients, people or clinical events. 
 This sample is designed to be used in conjunction with the C-CDA Clinical Notes Implementation Guide.
 ********************************************************
 -->
<ClinicalDocument xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="urn:hl7-org:v3" xmlns:cda="urn:hl7-org:v3" xmlns:sdtc="urn:hl7-org:sdtc" >
	<!-- ** CDA Header ** -->
	<realmCode code="US"/>
	<typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
	<!-- Identifies document as conformant to US Realm Header (V2) Template -->
	<templateId root="2.16.840.1.113883.10.20.22.1.1" extension="2024-05-01"/>
	<!-- Consultation Note V2  -->
	<templateId root="2.16.840.1.113883.10.20.22.1.4" extension="2024-05-01"/>
	<id extension="TT988" root="2.16.840.1.113883.19.5.99999.1"/>
	<sdtc:category code="11488-4" displayName="Consult note" codeSystem="2.16.840.1.113883.6.1"/>
	<code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="11488-4" displayName="Consult Note"/>
	<title>Community Health Consult Note</title>
	<effectiveTime value="201308010500-0800"/>
	<confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>
	<languageCode code="en-US"/>
	<setId extension="sTT988" root="2.16.840.1.113883.19.5.99999.19"/>
	<versionNumber value="1"/>
	<recordTarget>
		<patientRole>
			<!-- Example Social Security Number using the actual SSN OID. -->
			<id extension="444-22-2222" root="2.16.840.1.113883.4.1"/>
			<!-- HP is "primary home" from codeSystem 2.16.840.1.113883.5.1119 -->
			<addr use="HP">
				<streetAddressLine>2222 Home Street</streetAddressLine>
				<city>Beaverton</city>
				<state>OR</state>
				<postalCode>97867</postalCode>
				<!-- US is "United States" from ISO 3166-1 Country Codes: 1.0.3166.1 -->
				<country>US</country>
			</addr>
			<!-- HP is "primary home" from HL7 AddressUse 2.16.840.1.113883.5.1119 -->
			<telecom value="tel:+1(555)555-2003" use="HP"/>
			<patient>
				<!-- The first name element represents what the patient is known as -->
				<name use="L">
					<given>Eve</given>
					<family qualifier="SP">Betterhalf</family>
				</name>
				<!-- The second name element represents another name associated with the patient -->
				<name use="SRCH">
					<given>Eve</given>
					<family qualifier="BR">Everywoman</family>
				</name>
				<administrativeGenderCode code="F" displayName="Female" codeSystem="2.16.840.1.113883.5.1" codeSystemName="AdministrativeGender"/>
				<!-- Date of birth need only be precise to the day -->
				<birthTime value="19750501"/>
				<maritalStatusCode code="M" displayName="Married" codeSystem="2.16.840.1.113883.5.2" codeSystemName="MaritalStatusCode"/>
				<religiousAffiliationCode code="1013" displayName="Christian (non-Catholic, non-specific)" codeSystem="2.16.840.1.113883.5.1076" codeSystemName="HL7 Religious Affiliation"/>
				<!-- CDC Race and Ethnicity code set contains the five minimum race and ethnicity 
					categories defined by OMB Standards -->
				<raceCode code="2106-3" displayName="White" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<!-- The raceCode extension is only used if raceCode is valued -->
				<sdtc:raceCode code="2076-8" displayName="Native Hawaiian or Other Pacific Islander" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<ethnicGroupCode code="2186-5" displayName="Not Hispanic or Latino" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC"/>
				<guardian>
					<code code="POWATT" displayName="Power of Attorney" codeSystem="2.16.840.1.113883.5.111" codeSystemName="RoleCode"/>
					<addr use="HP">
						<streetAddressLine>2222 Home Street</streetAddressLine>
						<city>Beaverton</city>
						<state>OR</state>
						<postalCode>97867</postalCode>
						<country>US</country>
					</addr>
					<telecom value="tel:+1(555)555-2008" use="MC"/>
					<guardianPerson>
						<name>
							<given>Boris</given>
							<given qualifier="CL">Bo</given>
							<family>Betterhalf</family>
						</name>
					</guardianPerson>
				</guardian>
				<birthplace>
					<place>
						<addr>
							<streetAddressLine>4444 Home Street</streetAddressLine>
							<city>Beaverton</city>
							<state>OR</state>
							<postalCode>97867</postalCode>
							<country>US</country>
						</addr>
					</place>
				</birthplace>
				<languageCommunication>
					<languageCode code="en"/>
					<modeCode code="ESP" displayName="Expressed spoken" codeSystem="2.16.840.1.113883.5.60" codeSystemName="LanguageAbilityMode"/>
					<proficiencyLevelCode code="G" displayName="Good" codeSystem="2.16.840.1.113883.5.61" codeSystemName="LanguageAbilityProficiency"/>
					<!-- Patient's preferred language -->
					<preferenceInd value="true"/>
				</languageCommunication>
			</patient>
			<providerOrganization>
				<!-- Organizations SHOULD have an NPI; this is a real root; fake extension -->
				<id extension="219BX" root="2.16.840.1.113883.4.6"/>
				<name>The DoctorsTogether Physician Group</name>
				<telecom use="WP" value="tel:+1(555)555-5000"/>
				<addr use="WP">
					<streetAddressLine>1007 Health Drive</streetAddressLine>
					<city>Portland</city>
					<state>OR</state>
					<postalCode>99123</postalCode>
					<country>US</country>
				</addr>
			</providerOrganization>
		</patientRole>
	</recordTarget>
	<author>
		<time value="201307311230-0800"/>
		<assignedAuthor>
			<id extension="555555555" root="2.16.840.1.113883.4.6"/>
			<code code="207QA0505X" displayName="Adult Medicine Physician" codeSystem="2.16.840.1.113883.6.101" codeSystemName="Healthcare Provider Taxonomy (HIPAA)"/>
			<addr use="WP">
				<streetAddressLine>1004 Healthcare Drive </streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:+1(555)-1004"/>
			<assignedPerson>
				<name>
					<given>Patricia</given>
					<given qualifier="CL">Patty</given>
					<family>Primary</family>
					<suffix qualifier="AC">M.D.</suffix>
				</name>
			</assignedPerson>
		</assignedAuthor>
	</author>
	<dataEnterer>
		<assignedEntity>
			<id extension="333777777" root="2.16.840.1.113883.4.6"/>
			<addr use="WP">
				<streetAddressLine>1007 Healthcare Drive</streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:+1(555)-1050"/>
			<assignedPerson>
				<name>
					<given>Ellen</given>
					<family>Enter</family>
				</name>
			</assignedPerson>
		</assignedEntity>
	</dataEnterer>
	<informant>
		<assignedEntity>
			<id extension="888888888" root="2.16.840.1.113883.19.5"/>
			<addr use="WP">
				<streetAddressLine>1007 Healthcare Drive</streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:+1(555)-1003"/>
			<assignedPerson>
				<name>
					<given>Harold</given>
					<family>Hippocrates</family>
					<suffix qualifier="AC">D.O.</suffix>
				</name>
			</assignedPerson>
		</assignedEntity>
	</informant>
	<custodian>
		<assignedCustodian>
			<representedCustodianOrganization>
				<id extension="321CX" root="2.16.840.1.113883.4.6"/>
				<name>Good Health HIE</name>
				<telecom use="WP" value="tel:+1(555)-1009"/>
				<addr use="WP">
					<streetAddressLine>1009 Healthcare Drive </streetAddressLine>
					<city>Portland</city>
					<state>OR</state>
					<postalCode>99123</postalCode>
					<country>US</country>
				</addr>
			</representedCustodianOrganization>
		</assignedCustodian>
	</custodian>
	<informationRecipient>
		<intendedRecipient>
			<informationRecipient>
				<name>
					<given>Sara</given>
					<family>Specialize</family>
					<suffix qualifier="AC">M.D.</suffix>
				</name>
			</informationRecipient>
			<receivedOrganization>
				<name>The DoctorsApart Physician Group</name>
			</receivedOrganization>
		</intendedRecipient>
	</informationRecipient>
	<legalAuthenticator>
		<time value="20130801223615-0800"/>
		<signatureCode code="S"/>
		<assignedEntity>
			<id extension="555555555" root="2.16.840.1.113883.4.6"/>
			<code code="207QA0505X" displayName="Adult Medicine Physician" codeSystem="2.16.840.1.113883.6.101" codeSystemName="Healthcare Provider Taxonomy (HIPAA)"/>
			<addr use="WP">
				<streetAddressLine>1004 Healthcare Drive </streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:+1(555)-1004"/>
			<assignedPerson>
				<name>
					<given>Patricia</given>
					<given qualifier="CL">Patty</given>
					<family>Primary</family>
					<suffix qualifier="AC">M.D.</suffix>
				</name>
			</assignedPerson>
		</assignedEntity>
	</legalAuthenticator>
	<authenticator>
		<time value="201308011030-0800"/>
		<signatureCode code="S"/>
		<assignedEntity>
			<id extension="555555555" root="2.16.840.1.113883.4.6"/>
			<code code="207QA0505X" displayName="Adult Medicine Physician" codeSystem="2.16.840.1.113883.6.101" codeSystemName="Healthcare Provider Taxonomy (HIPAA)"/>
			<addr use="WP">
				<streetAddressLine>1004 Healthcare Drive </streetAddressLine>
				<city>Portland</city>
				<state>OR</state>
				<postalCode>99123</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:+1(555)-1004"/>
			<assignedPerson>
				<name>
					<given>Patricia</given>
					<given qualifier="CL">Patty</given>
					<family>Primary</family>
					<suffix qualifier="AC">M.D.</suffix>
				</name>
			</assignedPerson>
		</assignedEntity>
	</authenticator>
	<!-- This participant represents the person to contact for questions about the consult summary -->
	<participant typeCode="CALLBCK">
		<time value="20050329224411+0500"/>
		<associatedEntity classCode="ASSIGNED">
			<id extension="99999999" root="2.16.840.1.113883.4.6"/>
			<code code="200000000X" codeSystem="2.16.840.1.113883.6.101" displayName="Allopathic &amp; Osteopathic Physicians"/>
			<addr use="WP">
				<streetAddressLine>1002 Healthcare Drive </streetAddressLine>
				<city>Ann Arbor</city>
				<state>MI</state>
				<postalCode>97857</postalCode>
				<country>US</country>
			</addr>
			<telecom use="WP" value="tel:555-555-1002"/>
			<associatedPerson>
				<name>
					<given>Henry</given>
					<family>Seven</family>
					<suffix>DO</suffix>
				</name>
			</associatedPerson>
		</associatedEntity>
	</participant>
	<!-- Describes prior orders that are fulfilled (in whole or part) by the service events described in the Consultation Note -->
	<inFulfillmentOf typeCode="FLFS">
		<order classCode="ACT" moodCode="RQO">
			<id root="2.16.840.1.113883.6.96" extension="1298989898"/>
			<code code="388975008" displayName="Weight Reduction Consultation" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
		</order>
	</inFulfillmentOf>
	<componentOf>
		<encompassingEncounter>
			<id extension="9937012" root="2.16.840.1.113883.19"/>
			<code codeSystem="2.16.840.1.113883.6.12" codeSystemName="CPT-4" code="99213"/>
			<effectiveTime>
				<low value="201307310900-0800"/>
				<high value="201307311030-0800"/>
			</effectiveTime>
			<location>
				<healthCareFacility>
					<id root="2.16.540.1.113883.19.2"/>
				</healthCareFacility>
			</location>
		</encompassingEncounter>
	</componentOf>
	<!-- 
*******************************************************
     CDA Body
*******************************************************
	-->
	<component>
    <structuredBody>
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.6.1" extension="2015-08-01"/>
					<code code="48765-2" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
					<title>ALLERGIES AND ADVERSE REACTIONS</title>
					<text>No information</text>
				</section>
			</component>
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.5.1" extension="2015-08-01"/>
					<code code="11450-4" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"
							displayName="PROBLEM LIST"/>
					<title>PROBLEMS</title>
					<text>No information</text>
				</section>
			</component>
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.1.1" extension="2014-06-09"/>
					<code code="10160-0" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"
							displayName="HISTORY OF MEDICATION USE"/>
					<title>MEDICATIONS</title>
					<text>No information</text>
				</section>
			</component>
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.9" extension="2014-06-09"/>
					<code code="51847-2" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"
							displayName="Evaluation + Plan note"/>
					<title>Assessment and Plan</title>
					<text>No information</text>
				</section>
			</component>
			<component>
				<section nullFlavor="NI">
					<templateId root="1.3.6.1.4.1.19376.1.5.3.1.3.4"/>
					<code code="10164-2" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"
							displayName="History of Present illness Narrative"/>
					<title>History of Present Illness</title>
					<text>No information</text>
				</section>
			</component>
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.3.1" extension="2015-08-01"/>
					<code code="30954-2" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"
							displayName="RESULTS"/>
					<title>RESULTS</title>
					<text>No information</text>
				</section>
			</component>
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.22.2.12" />
					<code code="29299-5" displayName="Reason for visit Narrative" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" />
					<title>Reason for Visit</title>
					<text>No information</text>
				</section>
			</component>
			<component>
				<section nullFlavor="NI">
					<templateId root="2.16.840.1.113883.10.20.2.10" extension="2015-08-01" />
					<code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="29545-1" displayName="Physical Findings" />
					<title>Physical Examination</title>
					<text>No information</text>
				</section>
			</component>
    </structuredBody>
	</component>
</ClinicalDocument>

```

