<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile CDAR2.ClinicalDocument
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:ClinicalDocument</sch:title>
    <sch:rule context="f:ClinicalDocument">
      <sch:assert test="count(f:realmCode) &gt;= 1">realmCode: minimum cardinality of 'realmCode' is 1</sch:assert>
      <sch:assert test="count(f:realmCode) &lt;= 1">realmCode: maximum cardinality of 'realmCode' is 1</sch:assert>
      <sch:assert test="count(f:title) &gt;= 1">title: minimum cardinality of 'title' is 1</sch:assert>
      <sch:assert test="count(f:languageCode) &gt;= 1">languageCode: minimum cardinality of 'languageCode' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:typeId</sch:title>
    <sch:rule context="f:ClinicalDocument/f:typeId">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:assigningAuthorityName) &lt;= 1">assigningAuthorityName: maximum cardinality of 'assigningAuthorityName' is 1</sch:assert>
      <sch:assert test="count(f:displayable) &lt;= 1">displayable: maximum cardinality of 'displayable' is 1</sch:assert>
      <sch:assert test="count(f:root) &gt;= 1">root: minimum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:root) &lt;= 1">root: maximum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:extension) &gt;= 1">extension: minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension) &lt;= 1">extension: maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:templateId</sch:title>
    <sch:rule context="f:ClinicalDocument/f:templateId">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:assigningAuthorityName) &lt;= 1">assigningAuthorityName: maximum cardinality of 'assigningAuthorityName' is 1</sch:assert>
      <sch:assert test="count(f:displayable) &lt;= 1">displayable: maximum cardinality of 'displayable' is 1</sch:assert>
      <sch:assert test="count(f:root) &gt;= 1">root: minimum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:root) &lt;= 1">root: maximum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:extension) &gt;= 1">extension: minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension) &lt;= 1">extension: maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:contextControlCode) &lt;= 1">contextControlCode: maximum cardinality of 'contextControlCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:patientRole) &gt;= 1">patientRole: minimum cardinality of 'patientRole' is 1</sch:assert>
      <sch:assert test="count(f:patientRole) &lt;= 1">patientRole: maximum cardinality of 'patientRole' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:addr) &gt;= 1">addr: minimum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &gt;= 1">telecom: minimum cardinality of 'telecom' is 1</sch:assert>
      <sch:assert test="count(f:patient) &gt;= 1">patient: minimum cardinality of 'patient' is 1</sch:assert>
      <sch:assert test="count(f:patient) &lt;= 1">patient: maximum cardinality of 'patient' is 1</sch:assert>
      <sch:assert test="count(f:providerOrganization) &lt;= 1">providerOrganization: maximum cardinality of 'providerOrganization' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:telecom</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:telecom">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:use) &lt;= 1">use: maximum cardinality of 'use' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
      <sch:assert test="count(f:sdtcDesc) &lt;= 1">sdtcDesc: maximum cardinality of 'sdtcDesc' is 1</sch:assert>
      <sch:assert test="count(f:administrativeGenderCode) &gt;= 1">administrativeGenderCode: minimum cardinality of 'administrativeGenderCode' is 1</sch:assert>
      <sch:assert test="count(f:administrativeGenderCode) &lt;= 1">administrativeGenderCode: maximum cardinality of 'administrativeGenderCode' is 1</sch:assert>
      <sch:assert test="count(f:birthTime) &gt;= 1">birthTime: minimum cardinality of 'birthTime' is 1</sch:assert>
      <sch:assert test="count(f:birthTime) &lt;= 1">birthTime: maximum cardinality of 'birthTime' is 1</sch:assert>
      <sch:assert test="count(f:sdtcDeceasedInd) &lt;= 1">sdtcDeceasedInd: maximum cardinality of 'sdtcDeceasedInd' is 1</sch:assert>
      <sch:assert test="count(f:sdtcDeceasedTime) &lt;= 1">sdtcDeceasedTime: maximum cardinality of 'sdtcDeceasedTime' is 1</sch:assert>
      <sch:assert test="count(f:sdtcMultipleBirthInd) &lt;= 1">sdtcMultipleBirthInd: maximum cardinality of 'sdtcMultipleBirthInd' is 1</sch:assert>
      <sch:assert test="count(f:sdtcMultipleBirthOrderNumber) &lt;= 1">sdtcMultipleBirthOrderNumber: maximum cardinality of 'sdtcMultipleBirthOrderNumber' is 1</sch:assert>
      <sch:assert test="count(f:maritalStatusCode) &lt;= 1">maritalStatusCode: maximum cardinality of 'maritalStatusCode' is 1</sch:assert>
      <sch:assert test="count(f:religiousAffiliationCode) &lt;= 1">religiousAffiliationCode: maximum cardinality of 'religiousAffiliationCode' is 1</sch:assert>
      <sch:assert test="count(f:raceCode) &gt;= 1">raceCode: minimum cardinality of 'raceCode' is 1</sch:assert>
      <sch:assert test="count(f:raceCode) &lt;= 1">raceCode: maximum cardinality of 'raceCode' is 1</sch:assert>
      <sch:assert test="count(f:ethnicGroupCode) &gt;= 1">ethnicGroupCode: minimum cardinality of 'ethnicGroupCode' is 1</sch:assert>
      <sch:assert test="count(f:ethnicGroupCode) &lt;= 1">ethnicGroupCode: maximum cardinality of 'ethnicGroupCode' is 1</sch:assert>
      <sch:assert test="count(f:birthplace) &lt;= 1">birthplace: maximum cardinality of 'birthplace' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:guardian</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:guardian">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:guardianPerson) &gt;= 1">guardianPerson: minimum cardinality of 'guardianPerson' is 1</sch:assert>
      <sch:assert test="count(f:guardianPerson) &lt;= 1">guardianPerson: maximum cardinality of 'guardianPerson' is 1</sch:assert>
      <sch:assert test="count(f:guardianOrganization) &lt;= 1">guardianOrganization: maximum cardinality of 'guardianOrganization' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:guardian/f:telecom</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:guardian/f:telecom">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:use) &lt;= 1">use: maximum cardinality of 'use' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:guardian/f:guardianPerson</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:guardian/f:guardianPerson">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:place) &gt;= 1">place: minimum cardinality of 'place' is 1</sch:assert>
      <sch:assert test="count(f:place) &lt;= 1">place: maximum cardinality of 'place' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:name) &lt;= 1">name: maximum cardinality of 'name' is 1</sch:assert>
      <sch:assert test="count(f:addr) &gt;= 1">addr: minimum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:addr) &lt;= 1">addr: maximum cardinality of 'addr' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:isNotOrdered) &lt;= 1">isNotOrdered: maximum cardinality of 'isNotOrdered' is 1</sch:assert>
      <sch:assert test="count(f:country) &lt;= 1">country: maximum cardinality of 'country' is 1</sch:assert>
      <sch:assert test="count(f:other) &lt;= 1">other: maximum cardinality of 'other' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:delimiter</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:delimiter">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:country</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:country">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:state</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:state">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:county</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:county">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:city</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:city">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:postalCode</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:postalCode">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:streetAddressLine</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:streetAddressLine">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:houseNumber</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:houseNumber">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:houseNumberNumeric</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:houseNumberNumeric">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:direction</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:direction">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:streetName</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:streetName">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:streetNameBase</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:streetNameBase">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:streetNameType</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:streetNameType">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:additionalLocator</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:additionalLocator">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:unitID</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:unitID">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:unitType</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:unitType">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:careOf</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:careOf">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:censusTract</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:censusTract">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryAddressLine</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryAddressLine">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryInstallationType</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryInstallationType">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryInstallationArea</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryInstallationArea">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryInstallationQualifier</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryInstallationQualifier">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryMode</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryMode">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryModeIdentifier</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:deliveryModeIdentifier">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:buildingNumberSuffix</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:buildingNumberSuffix">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:postBox</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:postBox">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:precinct</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:birthplace/f:place/f:addr/f:precinct">
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:languageCommunication</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:patient/f:languageCommunication">
      <sch:assert test="count(f:languageCode) &gt;= 1">languageCode: minimum cardinality of 'languageCode' is 1</sch:assert>
      <sch:assert test="count(f:languageCode) &lt;= 1">languageCode: maximum cardinality of 'languageCode' is 1</sch:assert>
      <sch:assert test="count(f:modeCode) &lt;= 1">modeCode: maximum cardinality of 'modeCode' is 1</sch:assert>
      <sch:assert test="count(f:proficiencyLevelCode) &lt;= 1">proficiencyLevelCode: maximum cardinality of 'proficiencyLevelCode' is 1</sch:assert>
      <sch:assert test="count(f:preferenceInd) &lt;= 1">preferenceInd: maximum cardinality of 'preferenceInd' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:providerOrganization</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:providerOrganization">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &gt;= 1">telecom: minimum cardinality of 'telecom' is 1</sch:assert>
      <sch:assert test="count(f:addr) &gt;= 1">addr: minimum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:standardIndustryClassCode) &lt;= 1">standardIndustryClassCode: maximum cardinality of 'standardIndustryClassCode' is 1</sch:assert>
      <sch:assert test="count(f:asOrganizationPartOf) &lt;= 1">asOrganizationPartOf: maximum cardinality of 'asOrganizationPartOf' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:providerOrganization/f:id</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:providerOrganization/f:id">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:assigningAuthorityName) &lt;= 1">assigningAuthorityName: maximum cardinality of 'assigningAuthorityName' is 1</sch:assert>
      <sch:assert test="count(f:displayable) &lt;= 1">displayable: maximum cardinality of 'displayable' is 1</sch:assert>
      <sch:assert test="count(f:root) &lt;= 1">root: maximum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:extension) &lt;= 1">extension: maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:recordTarget/f:patientRole/f:providerOrganization/f:telecom</sch:title>
    <sch:rule context="f:ClinicalDocument/f:recordTarget/f:patientRole/f:providerOrganization/f:telecom">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:use) &lt;= 1">use: maximum cardinality of 'use' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:author</sch:title>
    <sch:rule context="f:ClinicalDocument/f:author">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:contextControlCode) &lt;= 1">contextControlCode: maximum cardinality of 'contextControlCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:functionCode) &lt;= 1">functionCode: maximum cardinality of 'functionCode' is 1</sch:assert>
      <sch:assert test="count(f:time) &gt;= 1">time: minimum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:time) &lt;= 1">time: maximum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:assignedAuthor) &gt;= 1">assignedAuthor: minimum cardinality of 'assignedAuthor' is 1</sch:assert>
      <sch:assert test="count(f:assignedAuthor) &lt;= 1">assignedAuthor: maximum cardinality of 'assignedAuthor' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:author/f:assignedAuthor</sch:title>
    <sch:rule context="f:ClinicalDocument/f:author/f:assignedAuthor">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:addr) &gt;= 1">addr: minimum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &gt;= 1">telecom: minimum cardinality of 'telecom' is 1</sch:assert>
      <sch:assert test="count(f:assignedPerson) &lt;= 1">assignedPerson: maximum cardinality of 'assignedPerson' is 1</sch:assert>
      <sch:assert test="count(f:assignedAuthoringDevice) &lt;= 1">assignedAuthoringDevice: maximum cardinality of 'assignedAuthoringDevice' is 1</sch:assert>
      <sch:assert test="count(f:representedOrganization) &lt;= 1">representedOrganization: maximum cardinality of 'representedOrganization' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:author/f:assignedAuthor/f:id</sch:title>
    <sch:rule context="f:ClinicalDocument/f:author/f:assignedAuthor/f:id">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:assigningAuthorityName) &lt;= 1">assigningAuthorityName: maximum cardinality of 'assigningAuthorityName' is 1</sch:assert>
      <sch:assert test="count(f:displayable) &lt;= 1">displayable: maximum cardinality of 'displayable' is 1</sch:assert>
      <sch:assert test="count(f:root) &gt;= 1">root: minimum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:root) &lt;= 1">root: maximum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:extension) &lt;= 1">extension: maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:author/f:assignedAuthor/f:code</sch:title>
    <sch:rule context="f:ClinicalDocument/f:author/f:assignedAuthor/f:code">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:codeSystem) &lt;= 1">codeSystem: maximum cardinality of 'codeSystem' is 1</sch:assert>
      <sch:assert test="count(f:codeSystemName) &lt;= 1">codeSystemName: maximum cardinality of 'codeSystemName' is 1</sch:assert>
      <sch:assert test="count(f:codeSystemVersion) &lt;= 1">codeSystemVersion: maximum cardinality of 'codeSystemVersion' is 1</sch:assert>
      <sch:assert test="count(f:displayName) &lt;= 1">displayName: maximum cardinality of 'displayName' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSet) &lt;= 1">sdtcValueSet: maximum cardinality of 'sdtcValueSet' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSetVersion) &lt;= 1">sdtcValueSetVersion: maximum cardinality of 'sdtcValueSetVersion' is 1</sch:assert>
      <sch:assert test="count(f:originalText) &lt;= 1">originalText: maximum cardinality of 'originalText' is 1</sch:assert>
      <sch:assert test="count(f:qualifier) &lt;= 0">qualifier: maximum cardinality of 'qualifier' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:author/f:assignedAuthor/f:telecom</sch:title>
    <sch:rule context="f:ClinicalDocument/f:author/f:assignedAuthor/f:telecom">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:use) &lt;= 1">use: maximum cardinality of 'use' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:author/f:assignedAuthor/f:assignedPerson</sch:title>
    <sch:rule context="f:ClinicalDocument/f:author/f:assignedAuthor/f:assignedPerson">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:author/f:assignedAuthor/f:assignedAuthoringDevice</sch:title>
    <sch:rule context="f:ClinicalDocument/f:author/f:assignedAuthor/f:assignedAuthoringDevice">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:manufacturerModelName) &gt;= 1">manufacturerModelName: minimum cardinality of 'manufacturerModelName' is 1</sch:assert>
      <sch:assert test="count(f:manufacturerModelName) &lt;= 1">manufacturerModelName: maximum cardinality of 'manufacturerModelName' is 1</sch:assert>
      <sch:assert test="count(f:softwareName) &gt;= 1">softwareName: minimum cardinality of 'softwareName' is 1</sch:assert>
      <sch:assert test="count(f:softwareName) &lt;= 1">softwareName: maximum cardinality of 'softwareName' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:dataEnterer</sch:title>
    <sch:rule context="f:ClinicalDocument/f:dataEnterer">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:contextControlCode) &lt;= 1">contextControlCode: maximum cardinality of 'contextControlCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:time) &gt;= 1">time: minimum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:time) &lt;= 1">time: maximum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &gt;= 1">assignedEntity: minimum cardinality of 'assignedEntity' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &lt;= 1">assignedEntity: maximum cardinality of 'assignedEntity' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:dataEnterer/f:assignedEntity</sch:title>
    <sch:rule context="f:ClinicalDocument/f:dataEnterer/f:assignedEntity">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:addr) &gt;= 1">addr: minimum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &gt;= 1">telecom: minimum cardinality of 'telecom' is 1</sch:assert>
      <sch:assert test="count(f:assignedPerson) &gt;= 1">assignedPerson: minimum cardinality of 'assignedPerson' is 1</sch:assert>
      <sch:assert test="count(f:assignedPerson) &lt;= 1">assignedPerson: maximum cardinality of 'assignedPerson' is 1</sch:assert>
      <sch:assert test="count(f:representedOrganization) &lt;= 1">representedOrganization: maximum cardinality of 'representedOrganization' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:dataEnterer/f:assignedEntity/f:id</sch:title>
    <sch:rule context="f:ClinicalDocument/f:dataEnterer/f:assignedEntity/f:id">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:assigningAuthorityName) &lt;= 1">assigningAuthorityName: maximum cardinality of 'assigningAuthorityName' is 1</sch:assert>
      <sch:assert test="count(f:displayable) &lt;= 1">displayable: maximum cardinality of 'displayable' is 1</sch:assert>
      <sch:assert test="count(f:root) &lt;= 1">root: maximum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:extension) &lt;= 1">extension: maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:dataEnterer/f:assignedEntity/f:telecom</sch:title>
    <sch:rule context="f:ClinicalDocument/f:dataEnterer/f:assignedEntity/f:telecom">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:use) &lt;= 1">use: maximum cardinality of 'use' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:dataEnterer/f:assignedEntity/f:assignedPerson</sch:title>
    <sch:rule context="f:ClinicalDocument/f:dataEnterer/f:assignedEntity/f:assignedPerson">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:informant</sch:title>
    <sch:rule context="f:ClinicalDocument/f:informant">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:contextControlCode) &lt;= 1">contextControlCode: maximum cardinality of 'contextControlCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &gt;= 1">assignedEntity: minimum cardinality of 'assignedEntity' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &lt;= 1">assignedEntity: maximum cardinality of 'assignedEntity' is 1</sch:assert>
      <sch:assert test="count(f:relatedEntity) &lt;= 1">relatedEntity: maximum cardinality of 'relatedEntity' is 1</sch:assert>
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:contextControlCode) &lt;= 1">contextControlCode: maximum cardinality of 'contextControlCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &lt;= 1">assignedEntity: maximum cardinality of 'assignedEntity' is 1</sch:assert>
      <sch:assert test="count(f:relatedEntity) &gt;= 1">relatedEntity: minimum cardinality of 'relatedEntity' is 1</sch:assert>
      <sch:assert test="count(f:relatedEntity) &lt;= 1">relatedEntity: maximum cardinality of 'relatedEntity' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:informant/f:assignedEntity</sch:title>
    <sch:rule context="f:ClinicalDocument/f:informant/f:assignedEntity">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:addr) &gt;= 1">addr: minimum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:assignedPerson) &gt;= 1">assignedPerson: minimum cardinality of 'assignedPerson' is 1</sch:assert>
      <sch:assert test="count(f:assignedPerson) &lt;= 1">assignedPerson: maximum cardinality of 'assignedPerson' is 1</sch:assert>
      <sch:assert test="count(f:representedOrganization) &lt;= 1">representedOrganization: maximum cardinality of 'representedOrganization' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:informant/f:assignedEntity/f:assignedPerson</sch:title>
    <sch:rule context="f:ClinicalDocument/f:informant/f:assignedEntity/f:assignedPerson">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:custodian</sch:title>
    <sch:rule context="f:ClinicalDocument/f:custodian">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:assignedCustodian) &gt;= 1">assignedCustodian: minimum cardinality of 'assignedCustodian' is 1</sch:assert>
      <sch:assert test="count(f:assignedCustodian) &lt;= 1">assignedCustodian: maximum cardinality of 'assignedCustodian' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:custodian/f:assignedCustodian</sch:title>
    <sch:rule context="f:ClinicalDocument/f:custodian/f:assignedCustodian">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:representedCustodianOrganization) &gt;= 1">representedCustodianOrganization: minimum cardinality of 'representedCustodianOrganization' is 1</sch:assert>
      <sch:assert test="count(f:representedCustodianOrganization) &lt;= 1">representedCustodianOrganization: maximum cardinality of 'representedCustodianOrganization' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:custodian/f:assignedCustodian/f:representedCustodianOrganization</sch:title>
    <sch:rule context="f:ClinicalDocument/f:custodian/f:assignedCustodian/f:representedCustodianOrganization">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
      <sch:assert test="count(f:name) &lt;= 1">name: maximum cardinality of 'name' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &gt;= 1">telecom: minimum cardinality of 'telecom' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &lt;= 1">telecom: maximum cardinality of 'telecom' is 1</sch:assert>
      <sch:assert test="count(f:addr) &gt;= 1">addr: minimum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:addr) &lt;= 1">addr: maximum cardinality of 'addr' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:custodian/f:assignedCustodian/f:representedCustodianOrganization/f:id</sch:title>
    <sch:rule context="f:ClinicalDocument/f:custodian/f:assignedCustodian/f:representedCustodianOrganization/f:id">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:assigningAuthorityName) &lt;= 1">assigningAuthorityName: maximum cardinality of 'assigningAuthorityName' is 1</sch:assert>
      <sch:assert test="count(f:displayable) &lt;= 1">displayable: maximum cardinality of 'displayable' is 1</sch:assert>
      <sch:assert test="count(f:root) &lt;= 1">root: maximum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:extension) &lt;= 1">extension: maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:custodian/f:assignedCustodian/f:representedCustodianOrganization/f:telecom</sch:title>
    <sch:rule context="f:ClinicalDocument/f:custodian/f:assignedCustodian/f:representedCustodianOrganization/f:telecom">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:use) &lt;= 1">use: maximum cardinality of 'use' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:informationRecipient</sch:title>
    <sch:rule context="f:ClinicalDocument/f:informationRecipient">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:intendedRecipient) &gt;= 1">intendedRecipient: minimum cardinality of 'intendedRecipient' is 1</sch:assert>
      <sch:assert test="count(f:intendedRecipient) &lt;= 1">intendedRecipient: maximum cardinality of 'intendedRecipient' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:informationRecipient/f:intendedRecipient</sch:title>
    <sch:rule context="f:ClinicalDocument/f:informationRecipient/f:intendedRecipient">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:informationRecipient) &lt;= 1">informationRecipient: maximum cardinality of 'informationRecipient' is 1</sch:assert>
      <sch:assert test="count(f:receivedOrganization) &lt;= 1">receivedOrganization: maximum cardinality of 'receivedOrganization' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:informationRecipient/f:intendedRecipient/f:informationRecipient</sch:title>
    <sch:rule context="f:ClinicalDocument/f:informationRecipient/f:intendedRecipient/f:informationRecipient">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:informationRecipient/f:intendedRecipient/f:receivedOrganization</sch:title>
    <sch:rule context="f:ClinicalDocument/f:informationRecipient/f:intendedRecipient/f:receivedOrganization">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
      <sch:assert test="count(f:name) &lt;= 1">name: maximum cardinality of 'name' is 1</sch:assert>
      <sch:assert test="count(f:standardIndustryClassCode) &lt;= 1">standardIndustryClassCode: maximum cardinality of 'standardIndustryClassCode' is 1</sch:assert>
      <sch:assert test="count(f:asOrganizationPartOf) &lt;= 1">asOrganizationPartOf: maximum cardinality of 'asOrganizationPartOf' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:legalAuthenticator</sch:title>
    <sch:rule context="f:ClinicalDocument/f:legalAuthenticator">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:contextControlCode) &lt;= 1">contextControlCode: maximum cardinality of 'contextControlCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:time) &gt;= 1">time: minimum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:time) &lt;= 1">time: maximum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:signatureCode) &gt;= 1">signatureCode: minimum cardinality of 'signatureCode' is 1</sch:assert>
      <sch:assert test="count(f:signatureCode) &lt;= 1">signatureCode: maximum cardinality of 'signatureCode' is 1</sch:assert>
      <sch:assert test="count(f:sdtcSignatureText) &lt;= 1">sdtcSignatureText: maximum cardinality of 'sdtcSignatureText' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &gt;= 1">assignedEntity: minimum cardinality of 'assignedEntity' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &lt;= 1">assignedEntity: maximum cardinality of 'assignedEntity' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:legalAuthenticator/f:signatureCode</sch:title>
    <sch:rule context="f:ClinicalDocument/f:legalAuthenticator/f:signatureCode">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:codeSystem) &lt;= 0">codeSystem: maximum cardinality of 'codeSystem' is 0</sch:assert>
      <sch:assert test="count(f:codeSystemName) &lt;= 0">codeSystemName: maximum cardinality of 'codeSystemName' is 0</sch:assert>
      <sch:assert test="count(f:codeSystemVersion) &lt;= 0">codeSystemVersion: maximum cardinality of 'codeSystemVersion' is 0</sch:assert>
      <sch:assert test="count(f:displayName) &lt;= 0">displayName: maximum cardinality of 'displayName' is 0</sch:assert>
      <sch:assert test="count(f:sdtcValueSet) &lt;= 1">sdtcValueSet: maximum cardinality of 'sdtcValueSet' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSetVersion) &lt;= 1">sdtcValueSetVersion: maximum cardinality of 'sdtcValueSetVersion' is 1</sch:assert>
      <sch:assert test="count(f:originalText) &lt;= 0">originalText: maximum cardinality of 'originalText' is 0</sch:assert>
      <sch:assert test="count(f:qualifier) &lt;= 0">qualifier: maximum cardinality of 'qualifier' is 0</sch:assert>
      <sch:assert test="count(f:translation) &lt;= 0">translation: maximum cardinality of 'translation' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:legalAuthenticator/f:assignedEntity</sch:title>
    <sch:rule context="f:ClinicalDocument/f:legalAuthenticator/f:assignedEntity">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:addr) &gt;= 1">addr: minimum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &gt;= 1">telecom: minimum cardinality of 'telecom' is 1</sch:assert>
      <sch:assert test="count(f:assignedPerson) &gt;= 1">assignedPerson: minimum cardinality of 'assignedPerson' is 1</sch:assert>
      <sch:assert test="count(f:assignedPerson) &lt;= 1">assignedPerson: maximum cardinality of 'assignedPerson' is 1</sch:assert>
      <sch:assert test="count(f:representedOrganization) &lt;= 1">representedOrganization: maximum cardinality of 'representedOrganization' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:legalAuthenticator/f:assignedEntity/f:id</sch:title>
    <sch:rule context="f:ClinicalDocument/f:legalAuthenticator/f:assignedEntity/f:id">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:assigningAuthorityName) &lt;= 1">assigningAuthorityName: maximum cardinality of 'assigningAuthorityName' is 1</sch:assert>
      <sch:assert test="count(f:displayable) &lt;= 1">displayable: maximum cardinality of 'displayable' is 1</sch:assert>
      <sch:assert test="count(f:root) &lt;= 1">root: maximum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:extension) &lt;= 1">extension: maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:legalAuthenticator/f:assignedEntity/f:telecom</sch:title>
    <sch:rule context="f:ClinicalDocument/f:legalAuthenticator/f:assignedEntity/f:telecom">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:use) &lt;= 1">use: maximum cardinality of 'use' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:legalAuthenticator/f:assignedEntity/f:assignedPerson</sch:title>
    <sch:rule context="f:ClinicalDocument/f:legalAuthenticator/f:assignedEntity/f:assignedPerson">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:authenticator</sch:title>
    <sch:rule context="f:ClinicalDocument/f:authenticator">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:time) &gt;= 1">time: minimum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:time) &lt;= 1">time: maximum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:signatureCode) &gt;= 1">signatureCode: minimum cardinality of 'signatureCode' is 1</sch:assert>
      <sch:assert test="count(f:signatureCode) &lt;= 1">signatureCode: maximum cardinality of 'signatureCode' is 1</sch:assert>
      <sch:assert test="count(f:sdtcSignatureText) &lt;= 1">sdtcSignatureText: maximum cardinality of 'sdtcSignatureText' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &gt;= 1">assignedEntity: minimum cardinality of 'assignedEntity' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &lt;= 1">assignedEntity: maximum cardinality of 'assignedEntity' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:authenticator/f:signatureCode</sch:title>
    <sch:rule context="f:ClinicalDocument/f:authenticator/f:signatureCode">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:codeSystem) &lt;= 0">codeSystem: maximum cardinality of 'codeSystem' is 0</sch:assert>
      <sch:assert test="count(f:codeSystemName) &lt;= 0">codeSystemName: maximum cardinality of 'codeSystemName' is 0</sch:assert>
      <sch:assert test="count(f:codeSystemVersion) &lt;= 0">codeSystemVersion: maximum cardinality of 'codeSystemVersion' is 0</sch:assert>
      <sch:assert test="count(f:displayName) &lt;= 0">displayName: maximum cardinality of 'displayName' is 0</sch:assert>
      <sch:assert test="count(f:sdtcValueSet) &lt;= 1">sdtcValueSet: maximum cardinality of 'sdtcValueSet' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSetVersion) &lt;= 1">sdtcValueSetVersion: maximum cardinality of 'sdtcValueSetVersion' is 1</sch:assert>
      <sch:assert test="count(f:originalText) &lt;= 0">originalText: maximum cardinality of 'originalText' is 0</sch:assert>
      <sch:assert test="count(f:qualifier) &lt;= 0">qualifier: maximum cardinality of 'qualifier' is 0</sch:assert>
      <sch:assert test="count(f:translation) &lt;= 0">translation: maximum cardinality of 'translation' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:authenticator/f:assignedEntity</sch:title>
    <sch:rule context="f:ClinicalDocument/f:authenticator/f:assignedEntity">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:addr) &gt;= 1">addr: minimum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &gt;= 1">telecom: minimum cardinality of 'telecom' is 1</sch:assert>
      <sch:assert test="count(f:assignedPerson) &gt;= 1">assignedPerson: minimum cardinality of 'assignedPerson' is 1</sch:assert>
      <sch:assert test="count(f:assignedPerson) &lt;= 1">assignedPerson: maximum cardinality of 'assignedPerson' is 1</sch:assert>
      <sch:assert test="count(f:representedOrganization) &lt;= 1">representedOrganization: maximum cardinality of 'representedOrganization' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:authenticator/f:assignedEntity/f:id</sch:title>
    <sch:rule context="f:ClinicalDocument/f:authenticator/f:assignedEntity/f:id">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:assigningAuthorityName) &lt;= 1">assigningAuthorityName: maximum cardinality of 'assigningAuthorityName' is 1</sch:assert>
      <sch:assert test="count(f:displayable) &lt;= 1">displayable: maximum cardinality of 'displayable' is 1</sch:assert>
      <sch:assert test="count(f:root) &lt;= 1">root: maximum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:extension) &lt;= 1">extension: maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:authenticator/f:assignedEntity/f:code</sch:title>
    <sch:rule context="f:ClinicalDocument/f:authenticator/f:assignedEntity/f:code">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:codeSystem) &lt;= 1">codeSystem: maximum cardinality of 'codeSystem' is 1</sch:assert>
      <sch:assert test="count(f:codeSystemName) &lt;= 1">codeSystemName: maximum cardinality of 'codeSystemName' is 1</sch:assert>
      <sch:assert test="count(f:codeSystemVersion) &lt;= 1">codeSystemVersion: maximum cardinality of 'codeSystemVersion' is 1</sch:assert>
      <sch:assert test="count(f:displayName) &lt;= 1">displayName: maximum cardinality of 'displayName' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSet) &lt;= 1">sdtcValueSet: maximum cardinality of 'sdtcValueSet' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSetVersion) &lt;= 1">sdtcValueSetVersion: maximum cardinality of 'sdtcValueSetVersion' is 1</sch:assert>
      <sch:assert test="count(f:originalText) &lt;= 1">originalText: maximum cardinality of 'originalText' is 1</sch:assert>
      <sch:assert test="count(f:qualifier) &lt;= 0">qualifier: maximum cardinality of 'qualifier' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:authenticator/f:assignedEntity/f:telecom</sch:title>
    <sch:rule context="f:ClinicalDocument/f:authenticator/f:assignedEntity/f:telecom">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:use) &lt;= 1">use: maximum cardinality of 'use' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:authenticator/f:assignedEntity/f:assignedPerson</sch:title>
    <sch:rule context="f:ClinicalDocument/f:authenticator/f:assignedEntity/f:assignedPerson">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:participant</sch:title>
    <sch:rule context="f:ClinicalDocument/f:participant">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:contextControlCode) &lt;= 1">contextControlCode: maximum cardinality of 'contextControlCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:functionCode) &lt;= 1">functionCode: maximum cardinality of 'functionCode' is 1</sch:assert>
      <sch:assert test="count(f:time) &lt;= 1">time: maximum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:associatedEntity) &gt;= 1">associatedEntity: minimum cardinality of 'associatedEntity' is 1</sch:assert>
      <sch:assert test="count(f:associatedEntity) &lt;= 1">associatedEntity: maximum cardinality of 'associatedEntity' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:inFulfillmentOf</sch:title>
    <sch:rule context="f:ClinicalDocument/f:inFulfillmentOf">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:order) &gt;= 1">order: minimum cardinality of 'order' is 1</sch:assert>
      <sch:assert test="count(f:order) &lt;= 1">order: maximum cardinality of 'order' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:inFulfillmentOf/f:order</sch:title>
    <sch:rule context="f:ClinicalDocument/f:inFulfillmentOf/f:order">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:moodCode) &gt;= 1">moodCode: minimum cardinality of 'moodCode' is 1</sch:assert>
      <sch:assert test="count(f:moodCode) &lt;= 1">moodCode: maximum cardinality of 'moodCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:priorityCode) &lt;= 1">priorityCode: maximum cardinality of 'priorityCode' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:documentationOf</sch:title>
    <sch:rule context="f:ClinicalDocument/f:documentationOf">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:serviceEvent) &gt;= 1">serviceEvent: minimum cardinality of 'serviceEvent' is 1</sch:assert>
      <sch:assert test="count(f:serviceEvent) &lt;= 1">serviceEvent: maximum cardinality of 'serviceEvent' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:documentationOf/f:serviceEvent</sch:title>
    <sch:rule context="f:ClinicalDocument/f:documentationOf/f:serviceEvent">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:moodCode) &gt;= 1">moodCode: minimum cardinality of 'moodCode' is 1</sch:assert>
      <sch:assert test="count(f:moodCode) &lt;= 1">moodCode: maximum cardinality of 'moodCode' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:effectiveTime) &gt;= 1">effectiveTime: minimum cardinality of 'effectiveTime' is 1</sch:assert>
      <sch:assert test="count(f:effectiveTime) &lt;= 1">effectiveTime: maximum cardinality of 'effectiveTime' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:documentationOf/f:serviceEvent/f:effectiveTime</sch:title>
    <sch:rule context="f:ClinicalDocument/f:documentationOf/f:serviceEvent/f:effectiveTime">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:inclusive) &lt;= 1">inclusive: maximum cardinality of 'inclusive' is 1</sch:assert>
      <sch:assert test="count(f:operator) &lt;= 1">operator: maximum cardinality of 'operator' is 1</sch:assert>
      <sch:assert test="count(f:low) &gt;= 1">low: minimum cardinality of 'low' is 1</sch:assert>
      <sch:assert test="count(f:low) &lt;= 1">low: maximum cardinality of 'low' is 1</sch:assert>
      <sch:assert test="count(f:high) &lt;= 1">high: maximum cardinality of 'high' is 1</sch:assert>
      <sch:assert test="count(f:width) &lt;= 1">width: maximum cardinality of 'width' is 1</sch:assert>
      <sch:assert test="count(f:center) &lt;= 1">center: maximum cardinality of 'center' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:documentationOf/f:serviceEvent/f:performer</sch:title>
    <sch:rule context="f:ClinicalDocument/f:documentationOf/f:serviceEvent/f:performer">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &gt;= 1">typeCode: minimum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:functionCode) &lt;= 1">functionCode: maximum cardinality of 'functionCode' is 1</sch:assert>
      <sch:assert test="count(f:time) &lt;= 1">time: maximum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &gt;= 1">assignedEntity: minimum cardinality of 'assignedEntity' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &lt;= 1">assignedEntity: maximum cardinality of 'assignedEntity' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:documentationOf/f:serviceEvent/f:performer/f:functionCode</sch:title>
    <sch:rule context="f:ClinicalDocument/f:documentationOf/f:serviceEvent/f:performer/f:functionCode">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:codeSystem) &lt;= 1">codeSystem: maximum cardinality of 'codeSystem' is 1</sch:assert>
      <sch:assert test="count(f:codeSystemName) &lt;= 1">codeSystemName: maximum cardinality of 'codeSystemName' is 1</sch:assert>
      <sch:assert test="count(f:codeSystemVersion) &lt;= 1">codeSystemVersion: maximum cardinality of 'codeSystemVersion' is 1</sch:assert>
      <sch:assert test="count(f:displayName) &lt;= 1">displayName: maximum cardinality of 'displayName' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSet) &lt;= 1">sdtcValueSet: maximum cardinality of 'sdtcValueSet' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSetVersion) &lt;= 1">sdtcValueSetVersion: maximum cardinality of 'sdtcValueSetVersion' is 1</sch:assert>
      <sch:assert test="count(f:originalText) &lt;= 1">originalText: maximum cardinality of 'originalText' is 1</sch:assert>
      <sch:assert test="count(f:qualifier) &lt;= 0">qualifier: maximum cardinality of 'qualifier' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:documentationOf/f:serviceEvent/f:performer/f:assignedEntity</sch:title>
    <sch:rule context="f:ClinicalDocument/f:documentationOf/f:serviceEvent/f:performer/f:assignedEntity">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:assignedPerson) &lt;= 1">assignedPerson: maximum cardinality of 'assignedPerson' is 1</sch:assert>
      <sch:assert test="count(f:representedOrganization) &lt;= 1">representedOrganization: maximum cardinality of 'representedOrganization' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:documentationOf/f:serviceEvent/f:performer/f:assignedEntity/f:id</sch:title>
    <sch:rule context="f:ClinicalDocument/f:documentationOf/f:serviceEvent/f:performer/f:assignedEntity/f:id">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:assigningAuthorityName) &lt;= 1">assigningAuthorityName: maximum cardinality of 'assigningAuthorityName' is 1</sch:assert>
      <sch:assert test="count(f:displayable) &lt;= 1">displayable: maximum cardinality of 'displayable' is 1</sch:assert>
      <sch:assert test="count(f:root) &lt;= 1">root: maximum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:extension) &lt;= 1">extension: maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:authorization</sch:title>
    <sch:rule context="f:ClinicalDocument/f:authorization">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:consent) &gt;= 1">consent: minimum cardinality of 'consent' is 1</sch:assert>
      <sch:assert test="count(f:consent) &lt;= 1">consent: maximum cardinality of 'consent' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:authorization/f:consent</sch:title>
    <sch:rule context="f:ClinicalDocument/f:authorization/f:consent">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:moodCode) &gt;= 1">moodCode: minimum cardinality of 'moodCode' is 1</sch:assert>
      <sch:assert test="count(f:moodCode) &lt;= 1">moodCode: maximum cardinality of 'moodCode' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:statusCode) &gt;= 1">statusCode: minimum cardinality of 'statusCode' is 1</sch:assert>
      <sch:assert test="count(f:statusCode) &lt;= 1">statusCode: maximum cardinality of 'statusCode' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:authorization/f:consent/f:statusCode</sch:title>
    <sch:rule context="f:ClinicalDocument/f:authorization/f:consent/f:statusCode">
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:componentOf</sch:title>
    <sch:rule context="f:ClinicalDocument/f:componentOf">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:encompassingEncounter) &gt;= 1">encompassingEncounter: minimum cardinality of 'encompassingEncounter' is 1</sch:assert>
      <sch:assert test="count(f:encompassingEncounter) &lt;= 1">encompassingEncounter: maximum cardinality of 'encompassingEncounter' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:componentOf/f:encompassingEncounter</sch:title>
    <sch:rule context="f:ClinicalDocument/f:componentOf/f:encompassingEncounter">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:moodCode) &gt;= 1">moodCode: minimum cardinality of 'moodCode' is 1</sch:assert>
      <sch:assert test="count(f:moodCode) &lt;= 1">moodCode: maximum cardinality of 'moodCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:effectiveTime) &gt;= 1">effectiveTime: minimum cardinality of 'effectiveTime' is 1</sch:assert>
      <sch:assert test="count(f:effectiveTime) &lt;= 1">effectiveTime: maximum cardinality of 'effectiveTime' is 1</sch:assert>
      <sch:assert test="count(f:sdtcAdmissionReferralSourceCode) &lt;= 1">sdtcAdmissionReferralSourceCode: maximum cardinality of 'sdtcAdmissionReferralSourceCode' is 1</sch:assert>
      <sch:assert test="count(f:dischargeDispositionCode) &lt;= 1">dischargeDispositionCode: maximum cardinality of 'dischargeDispositionCode' is 1</sch:assert>
      <sch:assert test="count(f:responsibleParty) &lt;= 1">responsibleParty: maximum cardinality of 'responsibleParty' is 1</sch:assert>
      <sch:assert test="count(f:location) &lt;= 1">location: maximum cardinality of 'location' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:componentOf/f:encompassingEncounter/f:responsibleParty</sch:title>
    <sch:rule context="f:ClinicalDocument/f:componentOf/f:encompassingEncounter/f:responsibleParty">
      <sch:assert test="count(f:typeCode) &gt;= 1">typeCode: minimum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &gt;= 1">assignedEntity: minimum cardinality of 'assignedEntity' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &lt;= 1">assignedEntity: maximum cardinality of 'assignedEntity' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:componentOf/f:encompassingEncounter/f:location</sch:title>
    <sch:rule context="f:ClinicalDocument/f:componentOf/f:encompassingEncounter/f:location">
      <sch:assert test="count(f:typeCode) &gt;= 1">typeCode: minimum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:healthCareFacility) &gt;= 1">healthCareFacility: minimum cardinality of 'healthCareFacility' is 1</sch:assert>
      <sch:assert test="count(f:healthCareFacility) &lt;= 1">healthCareFacility: maximum cardinality of 'healthCareFacility' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
