<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile PN
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:PN</sch:title>
    <sch:rule context="f:PN">
      <sch:assert test="count(f:family) &gt;= 1">family: minimum cardinality of 'family' is 1</sch:assert>
      <sch:assert test="count(f:family) &lt;= 1">family: maximum cardinality of 'family' is 1</sch:assert>
      <sch:assert test="count(f:given) &gt;= 1">given: minimum cardinality of 'given' is 1</sch:assert>
      <sch:assert test="count(f:suffix) &lt;= 1">suffix: maximum cardinality of 'suffix' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:PN/f:family</sch:title>
    <sch:rule context="f:PN/f:family">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:charset) &lt;= 1">charset: maximum cardinality of 'charset' is 1</sch:assert>
      <sch:assert test="count(f:compression) &lt;= 0">compression: maximum cardinality of 'compression' is 0</sch:assert>
      <sch:assert test="count(f:integrityCheck) &lt;= 0">integrityCheck: maximum cardinality of 'integrityCheck' is 0</sch:assert>
      <sch:assert test="count(f:integrityCheckAlgorithm) &lt;= 0">integrityCheckAlgorithm: maximum cardinality of 'integrityCheckAlgorithm' is 0</sch:assert>
      <sch:assert test="count(f:language) &lt;= 1">language: maximum cardinality of 'language' is 1</sch:assert>
      <sch:assert test="count(f:mediaType) &lt;= 1">mediaType: maximum cardinality of 'mediaType' is 1</sch:assert>
      <sch:assert test="count(f:representation) &lt;= 1">representation: maximum cardinality of 'representation' is 1</sch:assert>
      <sch:assert test="count(f:data[x]) &lt;= 1">data[x]: maximum cardinality of 'data[x]' is 1</sch:assert>
      <sch:assert test="count(f:reference) &lt;= 0">reference: maximum cardinality of 'reference' is 0</sch:assert>
      <sch:assert test="count(f:thumbnail) &lt;= 0">thumbnail: maximum cardinality of 'thumbnail' is 0</sch:assert>
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
      <sch:assert test="count(f:qualifier) &lt;= 1">qualifier: maximum cardinality of 'qualifier' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:PN/f:given</sch:title>
    <sch:rule context="f:PN/f:given">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:charset) &lt;= 1">charset: maximum cardinality of 'charset' is 1</sch:assert>
      <sch:assert test="count(f:compression) &lt;= 0">compression: maximum cardinality of 'compression' is 0</sch:assert>
      <sch:assert test="count(f:integrityCheck) &lt;= 0">integrityCheck: maximum cardinality of 'integrityCheck' is 0</sch:assert>
      <sch:assert test="count(f:integrityCheckAlgorithm) &lt;= 0">integrityCheckAlgorithm: maximum cardinality of 'integrityCheckAlgorithm' is 0</sch:assert>
      <sch:assert test="count(f:language) &lt;= 1">language: maximum cardinality of 'language' is 1</sch:assert>
      <sch:assert test="count(f:mediaType) &lt;= 1">mediaType: maximum cardinality of 'mediaType' is 1</sch:assert>
      <sch:assert test="count(f:representation) &lt;= 1">representation: maximum cardinality of 'representation' is 1</sch:assert>
      <sch:assert test="count(f:data[x]) &lt;= 1">data[x]: maximum cardinality of 'data[x]' is 1</sch:assert>
      <sch:assert test="count(f:reference) &lt;= 0">reference: maximum cardinality of 'reference' is 0</sch:assert>
      <sch:assert test="count(f:thumbnail) &lt;= 0">thumbnail: maximum cardinality of 'thumbnail' is 0</sch:assert>
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
      <sch:assert test="count(f:qualifier) &lt;= 1">qualifier: maximum cardinality of 'qualifier' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:PN/f:prefix</sch:title>
    <sch:rule context="f:PN/f:prefix">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:charset) &lt;= 1">charset: maximum cardinality of 'charset' is 1</sch:assert>
      <sch:assert test="count(f:compression) &lt;= 0">compression: maximum cardinality of 'compression' is 0</sch:assert>
      <sch:assert test="count(f:integrityCheck) &lt;= 0">integrityCheck: maximum cardinality of 'integrityCheck' is 0</sch:assert>
      <sch:assert test="count(f:integrityCheckAlgorithm) &lt;= 0">integrityCheckAlgorithm: maximum cardinality of 'integrityCheckAlgorithm' is 0</sch:assert>
      <sch:assert test="count(f:language) &lt;= 1">language: maximum cardinality of 'language' is 1</sch:assert>
      <sch:assert test="count(f:mediaType) &lt;= 1">mediaType: maximum cardinality of 'mediaType' is 1</sch:assert>
      <sch:assert test="count(f:representation) &lt;= 1">representation: maximum cardinality of 'representation' is 1</sch:assert>
      <sch:assert test="count(f:data[x]) &lt;= 1">data[x]: maximum cardinality of 'data[x]' is 1</sch:assert>
      <sch:assert test="count(f:reference) &lt;= 0">reference: maximum cardinality of 'reference' is 0</sch:assert>
      <sch:assert test="count(f:thumbnail) &lt;= 0">thumbnail: maximum cardinality of 'thumbnail' is 0</sch:assert>
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
      <sch:assert test="count(f:qualifier) &lt;= 1">qualifier: maximum cardinality of 'qualifier' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:PN/f:suffix</sch:title>
    <sch:rule context="f:PN/f:suffix">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:charset) &lt;= 1">charset: maximum cardinality of 'charset' is 1</sch:assert>
      <sch:assert test="count(f:compression) &lt;= 0">compression: maximum cardinality of 'compression' is 0</sch:assert>
      <sch:assert test="count(f:integrityCheck) &lt;= 0">integrityCheck: maximum cardinality of 'integrityCheck' is 0</sch:assert>
      <sch:assert test="count(f:integrityCheckAlgorithm) &lt;= 0">integrityCheckAlgorithm: maximum cardinality of 'integrityCheckAlgorithm' is 0</sch:assert>
      <sch:assert test="count(f:language) &lt;= 1">language: maximum cardinality of 'language' is 1</sch:assert>
      <sch:assert test="count(f:mediaType) &lt;= 1">mediaType: maximum cardinality of 'mediaType' is 1</sch:assert>
      <sch:assert test="count(f:representation) &lt;= 1">representation: maximum cardinality of 'representation' is 1</sch:assert>
      <sch:assert test="count(f:data[x]) &lt;= 1">data[x]: maximum cardinality of 'data[x]' is 1</sch:assert>
      <sch:assert test="count(f:reference) &lt;= 0">reference: maximum cardinality of 'reference' is 0</sch:assert>
      <sch:assert test="count(f:thumbnail) &lt;= 0">thumbnail: maximum cardinality of 'thumbnail' is 0</sch:assert>
      <sch:assert test="count(f:partType) &lt;= 1">partType: maximum cardinality of 'partType' is 1</sch:assert>
      <sch:assert test="count(f:qualifier) &lt;= 1">qualifier: maximum cardinality of 'qualifier' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
